<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package all-cleaning-services
 */

get_header();
?>

<main id="primary" class="site-main singlepage">
    <div class="banner-head"></div>
    <div class="blog-div container-fluid p-5">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-12">
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <header class="entry-header pt-5">
                        <?php the_title('<h1 class="entry-title">', '</h1>'); ?>
                        <div class="archive-info mb-3">

                            <!-- // Output additional archive information, such as date, author, category, etc. -->
                            <span class="date">Published on: <span><i
                                        class="fa-solid fa-calendar-days me-2 icon"></i></span><?php the_time('F j, Y'); ?></span>
                            <!-- <span class="author">by</?php the_author(); ?></span> -->
                        </div>
                    </header>
                    <div class="row">
                        <div class="entry-content col-lg-9 col-md-8 col-12">

                            <div class="row">
                                <div class="col-lg-6 col-md-6 col-12 position-relative">
                                    <span class="categories">Cat: <?php the_category(', '); ?></span>
                                    <!-- /////////// -->
                                    <?php
									if (has_post_thumbnail()) {
									the_post_thumbnail('full'); // You can specify the image size here
									}
								?>
                                </div>
                                <div class="col-lg-6 col-md-6 col-12 paragraph">
                                    <?php
								// Exclude the featured image from the content
								echo get_the_content();
								?>
                                    <!-- <div class="pt-3"></div> -->

                                </div>
                            </div>
                            <!-- //////// comment box -->
                            <div class="pt-3">
                                <?php
								while ( have_posts() ) :
									the_post();
									//   get_template_part( 'template-parts/content', get_post_type() );
										// If comments are open or we have at least one comment, load up the comment template.
										if ( comments_open() || get_comments_number() ) :
											comments_template();
										endif;

									endwhile; // End of the loop.
							?>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-4 col-12 single_sidebar">
                            <?php
							  // The Loop
								  if ( have_posts() ) :
									while ( have_posts() ) : the_post();

								   // Your single post content here

									  endwhile;
								 endif;

								// Display the custom sidebar
								get_sidebar();
							
									 ?>
                        </div>
                    </div>
            </div>
        </div>
        <?php
			the_post_navigation(
					  array(
								 'prev_text' => '<span class="nav-subtitle">' . esc_html__( 'Previous:', 'all-cleaning-services' ) . '</span> <span class="">%title</span>',
								 'next_text' => '<span class="nav-subtitle">' . esc_html__( 'Next:', 'all-cleaning-services' ) . '</span> <span class="">%title</span>',
						)
					);
					?>
    </div>


    <footer class="entry-footer">
        <?php
					   // Output additional meta information, tags, categories, etc.
					?>
    </footer>
    </article><!-- #post-<?php the_ID(); ?> -->

    </div>
    </div>

</main><!-- #main -->


<?php
get_footer();