<?php
/**
 * Template for displaying search forms
 *
 * @package all-cleaning-services
 */

?>

<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
<input type="search" class="search-field" placeholder="<?php echo esc_attr_x( 'Search ...', 'placeholder', 'all-cleaning-services' ) ?>" value="<?php the_search_query() ?>" name="s" title="<?php echo esc_attr_x( 'Search for:', 'label', 'all-cleaning-services' ) ?>" />
    <button type="submit" class="search-submit" value="<?php echo esc_attr_x( 'Search', 'submit button', 'all-cleaning-services' ) ?>"><i class="fas fa-search"></i></button>
</form>