<?php
/**
 * Theme functions related to structure.
 *
 * This file contains structural hook functions.
 *
 * @package all-cleaning-services
 */

if ( ! function_exists( 'all_cleaning_services_doctype' ) ) :
	/**
	 * Doctype Declaration.
	 *
	 * @since 1.0.0
	 */
function all_cleaning_services_doctype() {
	?><!DOCTYPE html> <html <?php language_attributes(); ?>><?php
}
endif;

add_action( 'all_cleaning_services_action_doctype', 'all_cleaning_services_doctype', 10 );


if ( ! function_exists( 'all_cleaning_services_head' ) ) :
	/**
	 * Header Codes.
	 *
	 * @since 1.0.0
	 */
function all_cleaning_services_head() {
	?>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
	<link rel="pingback" href="<?php echo esc_url( get_bloginfo( 'pingback_url' ) ); ?>">
	<?php endif;
	
}
endif;
add_action( 'all_cleaning_services_action_head', 'all_cleaning_services_head', 10 );

if ( ! function_exists( 'all_cleaning_services_page_start' ) ) :
	/**
	 * Add Skip to content.
	 *
	 * @since 1.0.0
	 */
	function all_cleaning_services_page_start() {
	?><div id="page" class="site"><a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'all-cleaning-services' ); ?></a><?php
	}
endif;

add_action( 'all_cleaning_services_action_before', 'all_cleaning_services_page_start', 10 );

if ( ! function_exists( 'all_cleaning_services_header_start' ) ) :
	/**
	 * Header Start.
	 *
	 * @since 1.0.0
	 */
	function all_cleaning_services_header_start() {
	
	?>
		<header id="masthead" class="relative" role="banner"><?php
	}
endif;
add_action( 'all_cleaning_services_action_before_header', 'all_cleaning_services_header_start' );

if ( ! function_exists( 'all_cleaning_services_header_end' ) ) :
	/**
	 * Header Start.
	 *
	 * @since 1.0.0
	 */
	function all_cleaning_services_header_end() {

		?>
		</header> <!-- header ends here --><?php
	}
endif;
add_action( 'all_cleaning_services_action_header', 'all_cleaning_services_header_end', 15 );

if ( ! function_exists( 'all_cleaning_services_content_start' ) ) :
	/**
	 * Header End.
	 *
	 * @since 1.0.0
	 */
	function all_cleaning_services_content_start() { 
	?>
	<div id="content-page" class="site-content">
	<?php 

	}
endif;

add_action( 'all_cleaning_services_action_before_content', 'all_cleaning_services_content_start', 10 );

if ( ! function_exists( 'all_cleaning_services_footer_start' ) ) :
	/**
	 * Footer Start.
	 *
	 * @since 1.0.0
	 */
	function all_cleaning_services_footer_start() {
		if( !(is_home() || is_front_page()) ){
			echo '</div>';
		} ?>
		</div>
		<footer id="colophon" class="site-footer" role="contentinfo">
			<div class="footer-bgoverlay"></div> 
			<?php
	}
endif;
add_action( 'all_cleaning_services_action_before_footer', 'all_cleaning_services_footer_start' );

if ( ! function_exists( 'all_cleaning_services_footer_end' ) ) :
	/**
	 * Footer End.
	 *
	 * @since 1.0.0
	 */
	function all_cleaning_services_footer_end() {?>
		</footer><?php
	}
endif;
add_action( 'all_cleaning_services_action_after_footer', 'all_cleaning_services_footer_end' );
