<?php
/**
 * Custom theme functions.
 *
 * This file contains hook functions attached to theme hooks.
 *
 * @package all-cleaning-services
 */

if( ! function_exists( 'all_cleaning_services_site_branding' ) ) :
/**
* Site Branding
*
* @since 1.0.0
*/
function all_cleaning_services_site_branding() { ?>
<?php 
  $show_header_colors = all_cleaning_services_get_option( 'show_header_colors' ); 
  $show_contact = all_cleaning_services_get_option( 'show_header_contact_info' );
  $show_tagline = all_cleaning_services_get_option( 'show_header_tagline' );
  $mail        = all_cleaning_services_get_option( 'header_email' ); 
  $hphone_text  = all_cleaning_services_get_option( 'hphone_text' ); 
  $show_social  = all_cleaning_services_get_option( 'show_header_social_links' );
  $sitequote  = all_cleaning_services_get_option( 'site_quote' );
?>

    <div id="section-header" class="section-header">
      <div class=" p-0 <?php if(get_theme_mod('header_section_width','Full Width') == 'Full Width'){ ?>container-fluid  <?php } elseif(get_theme_mod('header_section_width','Full Width') == 'Box Width'){ ?> container <?php }?>"> 
        <div class="content-site">
             <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 mb-3">
                <div class="topheader">
                  <div class="row">
                        <div class="col-xl-8 col-lg-8 col-md-8 col-sm-12"> 
                          <p class="site-quote"><?php echo esc_html($sitequote);?></p>
                        </div>

                        <?php if( !empty ($show_contact) ) : ?>    
                          <div class="col-xl-2 col-lg-2 col-md-2 col-sm-12"> 
                            <div class="addicon">
                              <div class="row">

                                  <?php 
                                      if( !empty( $mail ) ) { ?>
                                      <div class="col-lg-12 col-md-12 p-0 d-flex">
                                        <i class="fa fa-envelope" aria-hidden="true"></i>
                                        <?php
                                            echo '<a href="' . esc_url('mailto: '. esc_attr( $mail )) .'">'. esc_html( $mail ) .'</a>';
                                        ?> 
                                      </div> 
                                  <?php } ?>

                              </div>
                            </div>
                          </div>
                        <?php endif; ?>
                        
                        <?php 
                        if ( $show_social ){ 
                        ?>
                          <div class="col-xl-2 col-lg-2 col-md-2 col col-sm-12 p-0 "> 
                            <div class="social-links">
                              <?php 
                                $social_link1 = all_cleaning_services_get_option( 'social_link_1','<i class="fa fa-phone-square" aria-hidden="true"></i>');
                                $social_link2 = all_cleaning_services_get_option( 'social_link_2','<i class="fa fa-phone-square" aria-hidden="true"></i>' );
                                $social_link3 = all_cleaning_services_get_option( 'social_link_3','<i class="fa fa-phone-square" aria-hidden="true"></i>' );
                                if ( ! empty( $social_link1 ) ) {
                                    echo '<a href="' . esc_url( $social_link1 ) . '" target="_blank"></a>';
                                }
                                if ( ! empty( $social_link2 ) ) {
                                  echo '<a href="' . esc_url( $social_link2 ) . '" target="_blank"></a>';
                                } 
                                if ( ! empty( $social_link3 ) ) {
                                  echo '<a href="' . esc_url( $social_link3 ) . '" target="_blank"></a>';
                                }
                              ?>
                            </div>
                          </div>
                        <?php }?>
                  </div>
                </div>
              </div>
      
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 stickyheader <?php echo esc_attr(sticky_header()); ?>">
              <div class="bottomheader">
                <div class="row ">
                  <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 pd-0">
                    <div class="site-branding">       
                      <?php 
                        if(has_custom_logo()){ ?>
                          <div class="site-logo">
                          <?php the_custom_logo(); ?> 
                          </div>
                          <?php } else { ?>
                          <div id="site-identity">
                            <h1 class="site-title">
                                <a class="" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">  <?php bloginfo( 'name' ); ?></a>
                            </h1>
                          </div><!-- #site-identity -->
                      <?php } ?>
                    </div> <!-- .site-branding -->
                  </div>
                  <div class="col-xl-9 col-lg-9 col-md-9 col-sm-9 pd-0">
                    <div class="col-xl-12 col-lg-12 col-md-12 col col-sm-12 navbox">    
                      <div class="header-nav">         
                        <nav id="site-navigation" class="main-navigation" role="navigation" aria-label="Primary Menu">
                            <button type="button" class="menu-toggle">
                                <span class="icon-bar"></span>
                                <span class="icon-bar"></span>
                                <span class="icon-bar"></span>
                            </button>

                            <?php
                              if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
                                wp_nav_menu ( array(
                                'menu_class' => 'mainmenu ht-clearfix',
                                'container'=> 'ul',
                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
                                'theme_location' => 'primary',  
                                )); 
                              } else {
                              wp_nav_menu ( array(
                              'menu_class' => 'mainmenu ht-clearfix',
                              'container'=> 'ul',
                              'theme_location' => 'primary',  
                                )); 
                              }
                            ?>
                          
                        </nav><!-- #site-navigation -->
                      </div>         
                  </div><!-- col 12 nav-->
                </div>
            </div>
          </div> 
        </div><!-- row -->
      </div><!-- col 12-->
    </div>
  </div>
<?php }
endif;
add_action( 'all_cleaning_services_action_header', 'all_cleaning_services_site_branding', 10 );


$show_footer_contact_info = all_cleaning_services_get_option( 'show_footer_contact_info' );
 
 
if ( ! function_exists( 'all_cleaning_services_footer_top_section' ) ) :

  /**
   * Top  Footer 
   *
   * @since 1.0.0
   */
  function all_cleaning_services_footer_top_section() {

      $footer_sidebar_data = all_cleaning_services_footer_sidebar_class();
      $footer_sidebar    = $footer_sidebar_data['active_sidebar'];
      $footer_class      = $footer_sidebar_data['class'];

      if ( empty( $footer_sidebar ) ) {
        return;
      }?>
      <?php 
          $all_cleaning_services_footer_img = get_theme_mod('all_cleaning_services_footer_img');
          if(!empty($all_cleaning_services_footer_img)){       
      ?>
      <div class="footer-bg" style="background-image:url('<?php echo esc_url(get_theme_mod( 'all_cleaning_services_footer_img' )); ?> ');"></div>
      <?php  }else{?>              
      <div class="footer-bg" style="background-image: url(<?php echo esc_url(get_template_directory_uri()."/assets/images/footer img.jpg")?>"></div>
      <?php }?>     

    <?php 
      $show_footer_newslatter  = all_cleaning_services_get_option( 'show_footer_newslatter' );
      $footernews_letter_text  = all_cleaning_services_get_option( 'footernews_letter_text' );
      $footernews_letter_button  = all_cleaning_services_get_option( 'footernews_letter_button' );
    ?>
      <?php 
         if ( $show_footer_newslatter ){ 
      ?>

        <div class="col-lg-6 offset-lg-3 col-md-10 col-12 offset-md-1 col-sm-12 searchbar">
          <div class="col-lg-10 offset-lg-1">
            <div class="row">
              <div class="col-lg-4 col-md-4 col-12 p-0">
                  <h4><?php echo ($footernews_letter_text);?></h4>
              </div>

              <div class="col-lg-8 col-md-8 col-12 d-flex colophon">  
                  <input type="email" id="email" size="30" required placeholder="Enter Your Email" />
                  <button onclick="searchEmail()">Search</button>
                  <p id="error" class="error"></p>
                  <p id="success" class="success"></p> 
              </div>

            </div>
          </div>
        </div>
      <?php }?>

      <!-- <div class="footer-bg"></div> -->
      <div class="footer-widgets-area "> <!-- widget area starting from here -->

        <div class="px-5 <?php if(get_theme_mod('footer_section_width','Box Width') == 'Box Width'){ ?>container <?php } elseif(get_theme_mod('footer_section_width','Box Width') == 'Full Width'){ ?> container-fluid <?php }?>"> 
          <div class="footerbox" style="text-align : <?php if(get_theme_mod('footer_box_align','Left') == 'Left'){ ?> Left <?php } elseif(get_theme_mod('footer_box_align','Center') == 'Center'){ ?> Center <?php } elseif(get_theme_mod('footer_box_align','Right') == 'Right'){ ?> right <?php } ?> ">

          <div class="<?php echo esc_attr( $footer_class ); ?>"> 
            
            <?php
              for ( $i = 1; $i <= 4 ; $i++ ) {
                if ( is_active_sidebar( 'footer-' . $i ) ) {
                ?>
                  <div class="hentry">
                    <?php dynamic_sidebar( 'footer-' . $i ); ?>
                  </div>
                  <?php
                }
              }
            ?>
            </div>
            </div>
          </div>
          
      </div> <!-- widget area starting from here -->
    <?php
 }
endif;

add_action( 'all_cleaning_services_action_footer', 'all_cleaning_services_footer_top_section', 10 );

if ( ! function_exists( 'all_cleaning_services_footer_section' ) ) :

  /**
   * Footer copyright
   *
   * @since 1.0.0
   */
  function all_cleaning_services_footer_section() { ?>
    <div class="site-info" style="text-align : <?php if(get_theme_mod('footer_copytext_align','Center') == 'Center'){ ?> Center <?php } elseif(get_theme_mod('footer_copytext_align','Left') == 'Left'){ ?> Left <?php } elseif(get_theme_mod('footer_copytext_align','Right') == 'Right'){ ?> right <?php } ?> ">    
        <?php 
            $copyright_footer = all_cleaning_services_get_option('copyright_text'); 
            if ( ! empty( $copyright_footer ) ) {
                $copyright_footer = wp_kses_data( $copyright_footer );
            }            
        ?>
        <div class="<?php if(get_theme_mod('footer_section_width','Box Width') == 'Box Width'){ ?>container  <?php } elseif(get_theme_mod('footer_section_width','Box Width') == 'Full Width'){ ?> container-fluid <?php }?>"> 
        
            
          <span class="copy-right" style="text-transform : <?php if(get_theme_mod('footer_copytext_case','Capitalize') == 'Capitalize'){ ?> Capitalize <?php } elseif(get_theme_mod('footer_copytext_case','Uppercase') == 'Uppercase'){ ?> Uppercase <?php } elseif(get_theme_mod('footer_copytext_case','Lowercase') == 'Lowercase'){ ?> Lowercase <?php } elseif(get_theme_mod('footer_copytext_case','None') == 'None'){ ?> none <?php } ?> "><?php echo esc_html($copyright_footer);?></span>
        </div><!-- .Container --> 
    </div> <!-- .site-info -->
    
  <?php }

endif;
add_action( 'all_cleaning_services_action_footer', 'all_cleaning_services_footer_section', 20 );

if ( ! function_exists( 'all_cleaning_services_footer_sidebar_class' ) ) :
  /**
   * Count the number of footer sidebars to enable dynamic classes for the footer
   *
   * @since all-cleaning-services 0.1
   */
  function all_cleaning_services_footer_sidebar_class() {
    $data = array();
    $active_sidebar = array();
      $count = 0;

      if ( is_active_sidebar( 'footer-1' ) ) {
        $active_sidebar[]   = 'footer-1';
          $count++;
      }

      if ( is_active_sidebar( 'footer-2' ) ){
        $active_sidebar[]   = 'footer-2';
          $count++;
      }

      if ( is_active_sidebar( 'footer-3' ) ){
        $active_sidebar[]   = 'footer-3';
          $count++;
      }

      if ( is_active_sidebar( 'footer-4' ) ){
        $active_sidebar[]   = 'footer-4';
          $count++;
      }

      $class = '';

      switch ( $count ) {
          case '1':
            $class = 'grid xl:grid-cols-4 lg:grid-cols-4 md:grid-cols-4 sm:grid-cols-12 gap-20';
            break;
          case '2':
            $class = 'grid xl:grid-cols-4 lg:grid-cols-4 md:grid-cols-4 sm:grid-cols-12 gap-20';
            break;
          case '3':
            $class = 'grid xl:grid-cols-4 lg:grid-cols-4 md:grid-cols-4 sm:grid-cols-12 gap-20';
            break;
            case '4':
            $class = 'grid xl:grid-cols-4 lg:grid-cols-4 md:grid-cols-4 sm:grid-cols-12 gap-20';
            break;
      }

    $data['active_sidebar'] = $active_sidebar;
    $data['class']        = $class;

      return $data;
  }
endif;

if ( ! function_exists( 'all_cleaning_services_excerpt_length' ) ) :

  /**
   * Implement excerpt length.
   *
   * @since 1.0.0
   *
   * @param int $length The number of words.
   * @return int Excerpt length.
   */
  function all_cleaning_services_excerpt_length( $length ) {

    if ( is_admin() ) {
      return $length;
    }

    $excerpt_length = all_cleaning_services_get_option( 'excerpt_length' );

    if ( absint( $excerpt_length ) > 0 ) {
      $length = absint( $excerpt_length );
    }

    return $length;
  }

endif;
add_filter( 'excerpt_length', 'all_cleaning_services_excerpt_length', 999 );


if( ! function_exists( 'all_cleaning_services_banner_header' ) ) :
    /**
     * Page Header
    */
    function all_cleaning_services_banner_header() { 

        $show_header_image  = all_cleaning_services_get_option( 'show_header_image' );
        $show_page_title    = all_cleaning_services_get_option( 'show_page_title' );

        if ( is_front_page() && ! is_home() )
            return;
        $header_image = get_header_image();
        if ( is_singular() ) :
            $header_image = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : $header_image;
        endif;
        ?>
    
        <!-- <div class="page-site-headerinn"> -->
          <div id="page-site-header">
              <div class="innerheader-overly1"></div>
              
            <div class="page-site-headerimg" class="<?php //echo esc_attr($show_header_image); ?> <?php echo esc_attr($show_page_title); ?>" style="background-image: url('<?php echo esc_url( $header_image ); ?>'); height: <?php echo esc_attr(get_theme_mod('featured_innerpagesett_post_image_height','500')) ?>px;">
            <div class="inner-imgtext">
             
                  <div class="col-xl-10 offset-xl-1 offset-lg-1 col-lg-10 col-md-12 col-sm-12 col-12 header-title ">
                    <header class="page-header <?php echo esc_attr(get_theme_mod('all_cleaning_services_featured_innerpagesett_onload_effects','wow zoomIn')); ?>" data-wow-duration="2s">
                        <div class="wrapper" style="text-align : <?php if(get_theme_mod('featured_innerpagesett_box_align','Center') == 'Center'){ ?> Center <?php } elseif(get_theme_mod('featured_innerpagesett_box_align','Left') == 'Left'){ ?> Left <?php } elseif(get_theme_mod('featured_innerpagesett_box_align','Right') == 'Right'){ ?> right <?php } ?> ">

                            <?php if( get_theme_mod('featured_innerpagesett_pagetitle_on_off',false) == true){ ?> 
                              <div style="text-transform : <?php if(get_theme_mod('featured_innerpagesett_title_case','Capitalize') == 'Capitalize'){ ?> Capitalize <?php } elseif(get_theme_mod('featured_innerpagesett_title_case','Uppercase') == 'Uppercase'){ ?> Uppercase <?php } elseif(get_theme_mod('featured_innerpagesett_title_case','Lowercase') == 'Lowercase'){ ?> Lowercase <?php } elseif(get_theme_mod('featured_innerpagesett_title_case','None') == 'None'){ ?> none <?php } ?>"> <?php all_cleaning_services_banner_title();?></div>
                            <?php } ?>  

                            <?php if(get_theme_mod('featured_innerpagesett_breadcrum_on_off',true) == true ){  ?>
                                <div class="breadcrumbbox" style="text-align : <?php if(get_theme_mod('featured_innerpagesett_box_align','Left') == 'Left'){ ?> Left <?php } elseif(get_theme_mod('featured_innerpagesett_box_align','Center') == 'Center'){ ?> Center <?php } elseif(get_theme_mod('featured_innerpagesett_box_align','Right') == 'Right'){ ?> right <?php } ?> ">                          
                                    <div class='button' style="text-transform : <?php if(get_theme_mod('featured_innerpagesett_title_case','Capitalize') == 'Capitalize'){ ?> Capitalize <?php } elseif(get_theme_mod('featured_innerpagesett_title_case','Uppercase') == 'Uppercase'){ ?> Uppercase <?php } elseif(get_theme_mod('featured_innerpagesett_title_case','Lowercase') == 'Lowercase'){ ?> Lowercase <?php } elseif(get_theme_mod('featured_innerpagesett_title_case','None') == 'None'){ ?> none <?php } ?>"><?php all_cleaning_services_breadcrumb(); ?></div>               
                                </div>
                            <?php } ?> 

                        </div><!-- .wrapper -->
                    </header>
                  </div>
                          
            </div>
          </div>
        <!-- </div> -->
        </div><!-- #page-site-header -->
        <?php echo '<div id="content" class= "wrapper section-gap">';
    }
endif;
add_action( 'all_cleaning_services_banner_header', 'all_cleaning_services_banner_header', 10 );

if( ! function_exists( 'all_cleaning_services_banner_title' ) ) :
/**
 * Page Header
*/
function all_cleaning_services_banner_title(){ 
    if ( ( is_front_page() && is_home() ) || is_home() ){ 
        $your_latest_posts_title = all_cleaning_services_get_option( 'your_latest_posts_title' );?>
        <h2 class="page-title"><?php echo esc_html($your_latest_posts_title); ?></h2><?php
    }

    if( is_singular() ) {
        the_title( '<h2 class="page-title">', '</h2>' );
    }       

    if( is_archive() ){
        the_archive_description( '<div class="archive-description">', '</div>' );
        the_archive_title( '<h2 class="page-title">', '</h2>' );
    }

    if( is_search() ){ ?>
        <h2 class="page-title"><?php printf( esc_html__( 'Search Results for: %s', 'all-cleaning-services' ), '<span>' . get_search_query() . '</span>' ); ?></h2>
    <?php }
    
    if( is_404() ) {
        echo '<h2 class="page-title">' . esc_html__( 'Error 404', 'all-cleaning-services' ) . '</h2>';
    }
}
endif;

/**
 * Breadcrumbs
 */
if (!function_exists('all_cleaning_services_breadcrumb')) {
    function all_cleaning_services_breadcrumb() {
        if ( is_front_page() ) {
            return;
        }
        echo '<span typeof="v:Breadcrumb" class="root"><a rel="v:url" property="v:title" href="';
        echo esc_url( home_url() );
        /* =====breadcrumb text====== */
        $breadcrumbhometxtbutton = get_theme_mod('all_cleaning_services_breadcrumbhometxt', 'Home'); 
        /* =====breadcrumb text====== */
        echo '">'.(sprintf( __( '$breadcrumbhometxtbutton', 'all-cleaning-services' )));
        echo '</a></span><span class="bread-arrow"> / </span>';
        if (is_single()) {
            $categories = get_the_category();
            if ( $categories ) {
                $level = 0;
                $hierarchy_arr = array();
                foreach ( $categories as $cat ) {
                    $anc = get_ancestors( $cat->term_id, 'category' );
                    $count_anc = count( $anc );
                    if (  0 < $count_anc && $level < $count_anc ) {
                        $level = $count_anc;
                        $hierarchy_arr = array_reverse( $anc );
                        array_push( $hierarchy_arr, $cat->term_id );
                    }
                }
                if ( empty( $hierarchy_arr ) ) {
                    $category = $categories[0];
                    echo '<span typeof="v:Breadcrumb"><a href="'. esc_url( get_category_link( $category->term_id ) ).'" rel="v:url" property="v:title">'.esc_html( $category->name ).'</a></span><span class="bread-arrow"><i class="fa fa-long-arrow-right" aria-hidden="true"></i></span>';
                } else {
                    foreach ( $hierarchy_arr as $cat_id ) {
                        $category = get_term_by( 'id', $cat_id, 'category' );
                        echo '<span typeof="v:Breadcrumb"><a href="'. esc_url( get_category_link( $category->term_id ) ).'" rel="v:url" property="v:title">'.esc_html( $category->name ).'</a></span><span class="bread-arrow"><i class="fa fa-long-arrow-right" aria-hidden="true"></i></span>';
                    }
                }
            }
            echo "<span><span class='treeEnd'>";
            the_title();
            echo "</span></span>";
        } elseif (is_page()) {
            $parent_id  = wp_get_post_parent_id( get_the_ID() );
            if ( $parent_id ) {
                $breadcrumbs = array();
                while ( $parent_id ) {
                    $page = get_page( $parent_id );
                    $breadcrumbs[] = '<span typeof="v:Breadcrumb"><a href="'.esc_url( get_permalink( $page->ID ) ).'" rel="v:url" property="v:title">'.esc_html( get_the_title($page->ID) ). '</a></span><span><i class="fa fa-long-arrow-right" aria-hidden="true"></i></span>';
                    $parent_id  = $page->post_parent;
                }
                $breadcrumbs = array_reverse( $breadcrumbs );
                foreach ( $breadcrumbs as $crumb ) { echo $crumb; }
            }
            echo "<span><span class='treeEnd'>";
            the_title();
            echo "</span></span>";
        } elseif (is_category()) {
            global $wp_query;
            $cat_obj = $wp_query->get_queried_object();
            $this_cat_id = $cat_obj->term_id;
            $hierarchy_arr = get_ancestors( $this_cat_id, 'category' );
            if ( $hierarchy_arr ) {
                $hierarchy_arr = array_reverse( $hierarchy_arr );
                foreach ( $hierarchy_arr as $cat_id ) {
                    $category = get_term_by( 'id', $cat_id, 'category' );
                    echo '<span typeof="v:Breadcrumb"><a href="'.esc_url( get_category_link( $category->term_id ) ).'" rel="v:url" property="v:title">'.esc_html( $category->name ).'</a></span><span><i class="fa fa-long-arrow-right" aria-hidden="true"></i></span>';
                }
            }
            echo "<span><span class='treeEnd'>";
            single_cat_title();
            echo "</span></span>";
        } elseif (is_author()) {
            echo "<span><span class='treeEnd'>";
            if(get_query_var('author_name')) :
                $curauth = get_user_by('slug', get_query_var('author_name'));
            else :
                $curauth = get_userdata(get_query_var('author'));
            endif;
            echo esc_html( $curauth->nickname );
            echo "</span></span>";
        } elseif (is_search()) {
            echo "<span><span class='treeEnd'>";
            the_search_query();
            echo "</span></span>";
        } elseif (is_tag()) {
            echo "<span><span class='treeEnd'>";
            single_tag_title();
            echo "</span></span>";
        }
    }
}

if ( ! function_exists( 'all_cleaning_services_posts_tags' ) ) :
    /**
     * Prints HTML with meta information for the current post-date/time and author.
     */
    function all_cleaning_services_posts_tags() {
        // Hide category and tag text for pages.
        if ( 'post' === get_post_type() && has_tag() ) { ?>
                <div class="tags-links">

                    <?php /* translators: used between list items, there is a space after the comma */
                    $tags = get_the_tags();
                    if ( $tags ) {

                        foreach ( $tags as $tag ) {
                            echo '<span><a href="' . esc_url( get_tag_link( $tag->term_id ) ) .'">' . esc_html( $tag->name ) . '</a></span>'; // WPCS: XSS OK.
                        }
                    } ?>
                </div><!-- .tags-links -->
        <?php } 
    }
endif;

/**
 * Render social links.
 *
 * @since 1.0
 */
function all_cleaning_services_render_social_links() {

        $social_link1 = all_cleaning_services_get_option( 'social_link_1' );
        $social_link2 = all_cleaning_services_get_option( 'social_link_2' );
        $social_link3 = all_cleaning_services_get_option( 'social_link_3' );
        
        if ( empty( $social_link1 ) && empty( $social_link2 ) && empty( $social_link3 ) ) {
                return;
        }

        echo '<div class="social-icons">';
        echo '<ul>';
        if ( ! empty( $social_link1 ) ) {
            echo '<li><a href="' . esc_url( $social_link1 ) . '" target="_blank"></a></li>';
        }
        if ( ! empty( $social_link2 ) ) {
            echo '<li><a href="' . esc_url( $social_link2 ) . '" target="_blank"></a></li>';
        }
        if ( ! empty( $social_link3 ) ) {
            echo '<li><a href="' . esc_url( $social_link3 ) . '" target="_blank"></a></li>';
        }
        echo '</ul>';
        echo '</div>';
}