<?php

/**
 * Header Theme Options
 *
 * @package all-cleaning-services
 */

$wp_customize->add_section('all_cleaning_services_header_section', array(

	'title'      => esc_html__('Header Section', 'all-cleaning-services'),
	'capability' => 'edit_theme_options',
	'panel' => 'all_cleaning_services_theme_section_panel'

));

/** Header Color section */
$wp_customize->add_section(
    'featured_header_color_section',
    array(
        'title'    => __( 'Header Section', 'all-cleaning-services' ),      
        'priority' => 1,
        'panel'      => 'all_cleaning_services_theme_section_panel',       	
    )
);

// ///////// Header Background Color
$wp_customize->add_setting('header_bg_color', array(
    'default'   => '#ffffff',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
));
  
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_bg_color', array(
    'section' => 'featured_header_color_section',
    'description' => __('Header Background Color', 'all-cleaning-services'),
)));

// ///////// Menu Color
$wp_customize->add_setting('header_menu_color', array(
    'default'   => '#000',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
));
  
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_menu_color', array(
    'section' => 'featured_header_color_section',
    'description' => __('Menu Color', 'all-cleaning-services'),
)));

// ///////// Sub-Menu Bg Color
$wp_customize->add_setting('header_submenu_bgcolor', array(
    'default'   => '#01549A',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
));
  
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_submenu_bgcolor', array(
    'section' => 'featured_header_color_section',
    'description' => __('Sub-Menu & Header Button Bg Color', 'all-cleaning-services'),
)));

//Image
$wp_customize->add_setting( 'all_cleaning_services_header_image1', array(  
        'sanitize_callback' => 'all_cleaning_services_sanitise_custom_url'
        ));
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'all_cleaning_services_header_image1', array(
            'label'      => __( 'Section Image', 'all-cleaning-services' ),
            'section'    => 'featured_header_color_section',
            'settings'   => 'all_cleaning_services_header_image1',
    )));