<?php
/**
 * Footer Theme Options
 *
 * @package all-cleaning-services
 */

$wp_customize->add_section( 'all_cleaning_services_footer_section' , array(
	'title'      => esc_html__( 'Footer Section', 'all-cleaning-services' ),
	'capability' => 'edit_theme_options',
	'panel' => 'all_cleaning_services_theme_section_panel'
) );

// /////////// LOGO
$wp_customize->add_setting('all_cleaning_services_footer_logo', array(
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_url',       
    'capability' => 'edit_theme_options',        
    'type' => 'theme_mod',
));

$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'all_cleaning_services_footer_logo', array(       
    'label'      => esc_html__('Logo Image', 'all-cleaning-services'),       
    'section'    => 'all_cleaning_services_footer_section',       
    'settings'   => 'all_cleaning_services_footer_logo',
)));

// ////////// Paragraph
$wp_customize->add_setting( 'all_cleaning_services_foot_paragraph' , array(
    'default'   => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod temp or incididunt ut labore et dolore magna aliqua.',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_paragraph', array(   
    'label'      => esc_html__( 'Paragraph', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_paragraph',   
    'type' => 'text',         
) ) );

// show Social Links
$wp_customize->add_setting( 
    'theme_options[show_footer_social_links]', 
    array(
        'default'           => $default['show_footer_social_links'],
        'sanitize_callback' => 'all_cleaning_services_sanitize_checkbox',
    ) 
);

$wp_customize->add_control(
    'theme_options[show_footer_social_links]',
    array(
        'label'       => __( 'Show Social Links', 'all-cleaning-services' ),
        'section'     => 'all_cleaning_services_footer_section',
        'type'        => 'checkbox',
    )
);

// ////////// Facebook Icon
$wp_customize->add_setting('all_cleaning_services_footfacebook_icon', array(
    'default'   => 'fa-facebook-f',
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_text',
));
$wp_customize->add_control(new Custom_Text_Control($wp_customize, 'all_cleaning_services_footfacebook_icon', array(
    'label'      => esc_html__('Facebook Icon', 'all-cleaning-services'),
    'section'    => 'all_cleaning_services_footer_section',
    'settings'   => 'all_cleaning_services_footfacebook_icon',
    'type' => 'text',
)));  


// ////////// Twitter Icon
$wp_customize->add_setting('all_cleaning_services_foottwitter_icon', array(
    'default'   => 'fa-twitter',
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_text',
));
$wp_customize->add_control(new Custom_Text_Control($wp_customize, 'all_cleaning_services_foottwitter_icon', array(
    'label'      => esc_html__('Twitter Icon', 'all-cleaning-services'),
    'section'    => 'all_cleaning_services_footer_section',
    'settings'   => 'all_cleaning_services_foottwitter_icon',
    'type' => 'text',
))); 

// ////////// Linkedin Icon
$wp_customize->add_setting('all_cleaning_services_footlinkedin_icon', array(
    'default'   => 'fa-linkedin-in',
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_text',
));
$wp_customize->add_control(new Custom_Text_Control($wp_customize, 'all_cleaning_services_footlinkedin_icon', array(
    'label'      => esc_html__('Linkedin Icon', 'all-cleaning-services'),
    'section'    => 'all_cleaning_services_footer_section',
    'settings'   => 'all_cleaning_services_footlinkedin_icon',
    'type' => 'text',
)));

// ////////// Instagram Icon
$wp_customize->add_setting('all_cleaning_services_footinstagram_icon', array(
    'default'   => 'fa-instagram',
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_text',
));
$wp_customize->add_control(new Custom_Text_Control($wp_customize, 'all_cleaning_services_footinstagram_icon', array(
    'label'      => esc_html__('Instagram Icon', 'all-cleaning-services'),
    'section'    => 'all_cleaning_services_footer_section',
    'settings'   => 'all_cleaning_services_footinstagram_icon',
    'type' => 'text',
)));

$wp_customize->add_control('all_cleaning_services_footer_separator2',array(
    'label' => __('Footer Menu 1','all-cleaning-services'),
    'section' => 'all_cleaning_services_footer_section'
));

// ////////// Title 2
$wp_customize->add_setting( 'all_cleaning_services_foot_title2' , array(
    'default'   => 'Quick Link',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_title2', array(   
    'label'      => esc_html__( 'Title 2', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_title2',   
    'type' => 'text',         
) ) );

// ////////// Navigation Submenu 1
$wp_customize->add_setting( 'all_cleaning_services_foot_navsubmenu1' , array(
    'default'   => 'Projects',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_navsubmenu1', array(   
    'label'      => esc_html__( 'Navigation Submenu 1', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_navsubmenu1',   
    'type' => 'text',         
) ) );

// ////////// Navigation Submenu 2
$wp_customize->add_setting( 'all_cleaning_services_foot_navsubmenu2' , array(
    'default'   => 'Contact Us',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_navsubmenu2', array(   
    'label'      => esc_html__( 'Navigation Submenu 2', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_navsubmenu2',   
    'type' => 'text',         
) ) );

// ////////// Navigation Submenu 3
$wp_customize->add_setting( 'all_cleaning_services_foot_navsubmenu3' , array(
    'default'   => 'Team',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_navsubmenu3', array(   
    'label'      => esc_html__( 'Navigation Submenu 3', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_navsubmenu3',   
    'type' => 'text',         
) ) );

// ////////// Navigation Submenu 4
$wp_customize->add_setting( 'all_cleaning_services_foot_navsubmenu4' , array(
    'default'   => 'Compnay History ',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_navsubmenu4', array(   
    'label'      => esc_html__( 'Navigation Submenu 4', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_navsubmenu4',   
    'type' => 'text',         
) ) );

// ////////// Navigation Submenu 5
$wp_customize->add_setting( 'all_cleaning_services_foot_navsubmenu5' , array(
    'default'   => 'Features',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_navsubmenu5', array(   
    'label'      => esc_html__( 'Navigation Submenu 5', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_navsubmenu5',   
    'type' => 'text',         
) ) );

$wp_customize->add_control('all_cleaning_services_footer_separator3',array(
    'label' => __('Footer Menu 2','all-cleaning-services'),
    'section' => 'all_cleaning_services_footer_section'
));

// ////////// Title 3
$wp_customize->add_setting( 'all_cleaning_services_foot_title3' , array(
    'default'   => 'Services',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_title3', array(   
    'label'      => esc_html__( 'Title 3', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_title3',   
    'type' => 'text',         
) ) );

// ////////// Our Services Submenu 1
$wp_customize->add_setting( 'all_cleaning_services_foot_sersubmenu1' , array(
    'default'   => 'House Cleaning',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_sersubmenu1', array(   
    'label'      => esc_html__( 'Our Services Submenu 1', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_sersubmenu1',   
    'type' => 'text',         
) ) );

// ////////// Our Services Submenu 2
$wp_customize->add_setting( 'all_cleaning_services_foot_sersubmenu2' , array(
    'default'   => 'Kitchen Cleaning',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_sersubmenu2', array(   
    'label'      => esc_html__( 'Our Services Submenu 2', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_sersubmenu2',   
    'type' => 'text',         
) ) );

// ////////// Our Services Submenu 3
$wp_customize->add_setting( 'all_cleaning_services_foot_sersubmenu3' , array(
    'default'   => 'Window Cleaning',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_sersubmenu3', array(   
    'label'      => esc_html__( 'Our Services Submenu 3', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_sersubmenu3',   
    'type' => 'text',         
) ) );

// ////////// Our Services Submenu 4
$wp_customize->add_setting( 'all_cleaning_services_foot_sersubmenu4' , array(
    'default'   => 'Office Cleaning',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_sersubmenu4', array(   
    'label'      => esc_html__( 'Our Services Submenu 4', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_sersubmenu4',   
    'type' => 'text',         
) ) );

// ////////// Our Services Submenu 5
$wp_customize->add_setting( 'all_cleaning_services_foot_sersubmenu5' , array(
    'default'   => 'Carpet Cleaning',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_sersubmenu5', array(   
    'label'      => esc_html__( 'Our Services Submenu 5', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_sersubmenu5',   
    'type' => 'text',         
) ) );

$wp_customize->add_control('all_cleaning_services_footer_separator4',array(
    'label' => __('Footer Menu 3','all-cleaning-services'),
    'section' => 'all_cleaning_services_footer_section'
));

// ////////// Title 4
$wp_customize->add_setting( 'all_cleaning_services_foot_title4' , array(
    'default'   => 'Company',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_title4', array(   
    'label'      => esc_html__( 'Title 4', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_title4',   
    'type' => 'text',         
) ) );

// ////////// Our Company Submenu 1
$wp_customize->add_setting( 'all_cleaning_services_foot_compsubmenu1' , array(
    'default'   => 'Terms & Condition',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_compsubmenu1', array(   
    'label'      => esc_html__( 'Our Company Submenu 1', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_compsubmenu1',   
    'type' => 'text',         
) ) );

// ////////// Our Company Submenu 2
$wp_customize->add_setting( 'all_cleaning_services_foot_compsubmenu2' , array(
    'default'   => 'Our History',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_compsubmenu2', array(   
    'label'      => esc_html__( 'Our Company Submenu 2', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_compsubmenu2',   
    'type' => 'text',         
) ) );

// ////////// Our Company Submenu 3
$wp_customize->add_setting( 'all_cleaning_services_foot_compsubmenu3' , array(
    'default'   => 'Our Gallery',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_compsubmenu3', array(   
    'label'      => esc_html__( 'Our Company Submenu 3', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_compsubmenu3',   
    'type' => 'text',         
) ) );

// ////////// Our Company Submenu 4
$wp_customize->add_setting( 'all_cleaning_services_foot_compsubmenu4' , array(
    'default'   => 'Privacy Policy',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_compsubmenu4', array(   
    'label'      => esc_html__( 'Our Company Submenu 4', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_compsubmenu4',   
    'type' => 'text',         
) ) );

// ////////// Our Company Submenu 5
$wp_customize->add_setting( 'all_cleaning_services_foot_compsubmenu5' , array(
    'default'   => 'Testimonial',   
    'sanitize_callback' => 'all_cleaning_services_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'all_cleaning_services_foot_compsubmenu5', array(   
    'label'      => esc_html__( 'Our Company Submenu 5', 'all-cleaning-services' ),   
    'section'    => 'all_cleaning_services_footer_section',   
    'settings'   => 'all_cleaning_services_foot_compsubmenu5',   
    'type' => 'text',         
) ) );

/** Footer Color section */
$wp_customize->add_section(
    'featured_footer_color_section',
    array(
        'title'    => __( 'Footer Color', 'all-cleaning-services' ),      
        'priority' => 2,
        'panel'      => 'all_cleaning_services_footer_panel',       	
    )
);

// ///////// Footer Background Color
$wp_customize->add_setting('footer_bg_color', array(
    'default'   => '#E9F5FF',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
));
  
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_bg_color', array(
    'section' => 'featured_footer_color_section',
    'description' => __('Footer Background Color', 'all-cleaning-services'),
)));

// ///////// Footer Heading Color
$wp_customize->add_setting('footer_heading_color', array(
    'default'   => '#000000',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
));
  
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_heading_color', array(
    'section' => 'featured_footer_color_section',
    'description' => __('Footer Heading Color', 'all-cleaning-services'),
)));

// ///////// Footer Text Color
$wp_customize->add_setting('footer_text_color', array(
    'default'   => '#000000',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
));
  
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_text_color', array(
    'section' => 'featured_footer_color_section',
    'description' => __('Footer Text Color', 'all-cleaning-services'),
)));

// ///////// Footer Social Icon Color
$wp_customize->add_setting('footer_socialicon_color', array(
    'default'   => '#000000',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
));
  
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_socialicon_color', array(
    'section' => 'featured_footer_color_section',
    'description' => __('Footer Social Icon Color', 'all-cleaning-services'),
)));