<?php 
/**
 * Home Section
 *
 * @package all-cleaning-services
 */

/** Slider Info section */
$wp_customize->add_section(
    'featured_slider_info_section',
    array(
        'title'    => __( 'Slider Info', 'all-cleaning-services' ),      
        'priority' => 1,
        'panel'      => 'all_cleaning_services_section_panel',       	
    )
);

// Enable Section
$wp_customize->add_setting(
    'slider_enable_section',
    array(
        'default' 			=> 'on',
        'sanitize_callback' => 'all_cleaning_services_sanitize_switch',

    )
);
$wp_customize->add_control(
    new all_cleaning_services_Toggle_Checkbox_Custom_control(
        $wp_customize,
        'slider_enable_section',
        array(
            'settings'      => 'slider_enable_section',
            'section'       => 'featured_slider_info_section',
            'label'         => __( 'Enable Section', 'all-cleaning-services' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'all-cleaning-services' ),
                'off' => __( 'No', 'all-cleaning-services' )
            ),
        )
    )
);

// /// effects
$wp_customize->add_setting('all_cleaning_services_featured_slider_onload_effects',array(
    'default' => 'Bounce In Up',
    'sanitize_callback' => 'all_cleaning_services_sanitize_choices',
));
$wp_customize->add_control('all_cleaning_services_featured_slider_onload_effects',array(
    'type' => 'select',
    'label' => __('Box Onload Transition Effects','all-cleaning-services'),
    'choices' => array (
        'wow bounceInLeft' => __('Bounce In Left','all-cleaning-services'),
        'wow bounceInRight' => __('Bounce In Right','all-cleaning-services'),
        'wow bounceInUp' => __('Bounce In Up','all-cleaning-services'),
        'wow bounceInDown' => __('Bounce In Down','all-cleaning-services'),
        'wow zoomIn' => __('Zoom In','all-cleaning-services'),
        'wow zoomOut' => __('Zoom Out','all-cleaning-services'),
        'wow fadeInDown' => __('Fade In Down','all-cleaning-services'),            
        'wow fadeInUp' => __('Fade In Up','all-cleaning-services'),
        'wow fadeInLeft' => __('Fade In Left','all-cleaning-services'),
        'wow fadeInRight' => __('Fade In Right','all-cleaning-services'),
        'flip-up' => __('Flip Up','all-cleaning-services')
    ),
    'section' => 'featured_slider_info_section',
)); 

// Items
// Number of Slider Items
$wp_customize->add_setting('number_of_featured_slider_items', array(
    'default'           => 3, // Set default number of items
    'sanitize_callback' => 'absint', // Ensure it's a valid integer
));

$wp_customize->add_control('number_of_featured_slider_items', array(
    'label'    => __('Number of Slider Items', 'all-cleaning-services'),
    'section'  => 'featured_slider_info_section', // The section where this control will appear
    'type'     => 'number',
    'input_attrs' => array(
        'min' => 1, // Minimum value
        'max' => 10, // Maximum value
        'step' => 1, // Increment step
    ),
));

//posts loop
$all_cleaning_services_slider_list = array();
$args = array('post_type' => 'post'); // Fetch posts, not pages
$all_cleaning_services_posts = get_posts( $args ); 
foreach($all_cleaning_services_posts as $all_cleaning_services_post) {
    $all_cleaning_services_slider_list[$all_cleaning_services_post->ID] = $all_cleaning_services_post->post_title; // Use post ID as key and title as value
}

for ( $count = 1; $count <= 4; $count++ ) {
    $wp_customize->add_setting( 'select_post_slider' . $count, array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_post_dropdown'
    ));
    $wp_customize->add_control( 'select_post_slider' . $count, array(
        'label'   => __( 'Select A Post Page', 'all-cleaning-services' ),
        'section' => 'featured_slider_info_section',
        'type'    => 'select', // Use 'select' for custom post list
        'choices' => $all_cleaning_services_slider_list // Populate choices with posts
    ));
}

$wp_customize->add_setting('all_cleaning_services_button_text', 
    array(
    'default'           => __('Read More', 'all-cleaning-services'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control('all_cleaning_services_button_text', 
    array(
    'label'       => __('Read More Button Text', 'all-cleaning-services'),
    'section'     => 'featured_slider_info_section',   
    'settings'    => 'all_cleaning_services_button_text',  
    'active_callback' => 'all_cleaning_services_featured_about_active',        
    'type'        => 'text'
    )
);

/** Slider Color section */

$wp_customize->add_section(
    'slider_text_colors_section',
    array(
        'title'    => __( 'Colors', 'all-cleaning-services' ),        
        'priority' => 2,
        'panel'      => 'all_cleaning_services_section_panel',  
    )
);

   // ///////// Title Text Color
    $wp_customize->add_setting('slider_title_color', array(
    'default'   => '#ffffff',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_title_color', array(
    'section' => 'slider_text_colors_section',
    'description' => __('Title Color', 'all-cleaning-services'),
    )));

     // ///////// Paragraph Text Color
    $wp_customize->add_setting('slider_paragraph_color', array(
    'default'   => '#ffffff',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_paragraph_color', array(
    'section' => 'slider_text_colors_section',
    'description' => __('Paragraph Text Color', 'all-cleaning-services'),
    )));

    // ///////// Button Color
  $wp_customize->add_setting('slider_readmore_color', array(
    'default'   => '#01549A',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_readmore_color', array(
    'section' => 'slider_text_colors_section',
    'description' => __('Button Bg-Color', 'all-cleaning-services'),
    )));

    // ///////// Button Text Color
  $wp_customize->add_setting('slider_readmoretxt_color', array(
    'default'   => '#ffffff',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_readmoretxt_color', array(
    'section' => 'slider_text_colors_section',
    'description' => __('Button Text Color', 'all-cleaning-services'),
    )));

    // ///////// Video Bg-Color
    $wp_customize->add_setting('slider_video_bg_color', array(
        'default'   => '#ffffff',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_video_bg_color', array(
        'section' => 'slider_text_colors_section',
        'description' => __('Video Bg-Color', 'all-cleaning-services'),
    )));
    
    // ///////// Video Border Color
    $wp_customize->add_setting('slider_border_color', array(
        'default'   => '#ffffff',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_border_color', array(
        'section' => 'slider_text_colors_section',
        'description' => __('Video Border Color', 'all-cleaning-services'),
    )));

    // ///////// Video Play Btn Color
    $wp_customize->add_setting('slider_playbtn_color', array(
        'default'   => '#01549A',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_playbtn_color', array(
        'section' => 'slider_text_colors_section',
        'description' => __('Video Play Btn Color', 'all-cleaning-services'),
    )));

    // ///////// Video Text Color
    $wp_customize->add_setting('slider_videotxt_color', array(
    'default'   => '#ffffff',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_videotxt_color', array(
    'section' => 'slider_text_colors_section',
    'description' => __('Video Text Color', 'all-cleaning-services'),
    )));

    // ///////// Indicator Bg-Color
    $wp_customize->add_setting('slider_indicator_color', array(
        'default'   => '#EFF8FF',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_indicator_color', array(
        'section' => 'slider_text_colors_section',
        'description' => __('Indicator Bg-Color', 'all-cleaning-services'),
    )));

    // ///////// Indicator Border Color
    $wp_customize->add_setting('slider_indicator_bordercolor', array(
        'default'   => '#fff',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_indicator_bordercolor', array(
        'section' => 'slider_text_colors_section',
        'description' => __('Indicator Border Color', 'all-cleaning-services'),
    )));

    // ///////// Indicator Icon Color
    $wp_customize->add_setting('slider_indicatoricon_color', array(
        'default'   => '#01549A',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'slider_indicatoricon_color', array(
        'section' => 'slider_text_colors_section',
        'description' => __('Indicator Icon Color', 'all-cleaning-services'),
    )));

    // ----------------------------------------------------------

    /** Slider Structure section */

	$wp_customize->add_section(
	    'slider_structure_section',
	    array(
	        'title'    => __( 'Structure', 'all-cleaning-services' ),        
	        'priority' => 3,
	        'panel'      => 'lvl_2_parent_panel',  
	    )
	);

    // Title case
	$wp_customize->add_setting('featured_slider_title_case',array(
        'default' => 'Uppercase',
        'sanitize_callback' => 'all_cleaning_services_sanitize_choices',
    ));
    $wp_customize->add_control('featured_slider_title_case',array(
        'type' => 'select',
        'label' => __('Title Case','all-cleaning-services'),
        'choices' => array (
            'Uppercase' => __('Uppercase','all-cleaning-services'),
            'Lowercase' => __('Lowercase','all-cleaning-services'),
            'Capitalize' => __('Capitalize','all-cleaning-services'),
            'None' => __('None','all-cleaning-services')
        ),
        'section' => 'slider_structure_section',
    ));

    
