<?php
/**
 * About Section options.
 *
 * @package all-cleaning-services
 */

$default = all_cleaning_services_get_default_theme_options();


/** About Info section */
$wp_customize->add_section(
    'featured_about_info_section',
    array(
        'title'    => __( 'About Info', 'all-cleaning-services' ),      
        'priority' => 1,
        'panel'      => 'all_cleaning_services_section_panel',       	
    )
);

// Enable Section
$wp_customize->add_setting(
    'about_enable_section',
    array(
        'default' 			=> 'on',
       'sanitize_callback' => 'all_cleaning_services_sanitize_switch',

    )
);
$wp_customize->add_control(
    new all_cleaning_services_Toggle_Checkbox_Custom_control(
        $wp_customize,
        'about_enable_section',
        array(
            'settings'      => 'about_enable_section',
            'section'       => 'featured_about_info_section',
            'label'         => __( 'Enable Section', 'all-cleaning-services' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'all-cleaning-services' ),
                'off' => __( 'No', 'all-cleaning-services' )
            ),
        )
    )
);


     // ///////// Background Color
     $wp_customize->add_setting('about_background_color', array(
        'default'   => '#ffffff',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'about_background_color', array(
        'section' => 'featured_about_info_section',
        'description' => __('Background Color', 'all-cleaning-services'),
    )));

    // /// effects
    $wp_customize->add_setting('all_cleaning_services_featured_about_onload_effects',array(
        'default' => 'zoom-in',
        'sanitize_callback' => 'all_cleaning_services_sanitize_choices',
    ));
    $wp_customize->add_control('all_cleaning_services_featured_about_onload_effects',array(
        'type' => 'select',
        'label' => __('Box Onload Transition Effects','all-cleaning-services'),
        'choices' => array (
            'wow bounceInLeft' => __('Bounce In Left','all-cleaning-services'),
            'wow bounceInRight' => __('Bounce In Right','all-cleaning-services'),
            'wow bounceInUp' => __('Bounce In Up','all-cleaning-services'),
            'wow bounceInDown' => __('Bounce In Down','all-cleaning-services'),
            'wow zoomIn' => __('Zoom In','all-cleaning-services'),
            'wow zoomOut' => __('Zoom Out','all-cleaning-services'),
            'wow fadeInDown' => __('Fade In Down','all-cleaning-services'),            
            'wow fadeInUp' => __('Fade In Up','all-cleaning-services'),
            'wow fadeInLeft' => __('Fade In Left','all-cleaning-services'),
            'wow fadeInRight' => __('Fade In Right','all-cleaning-services'),
            'flip-up' => __('Flip Up','all-cleaning-services')
        ),
        'section' => 'featured_about_info_section',
    )); 

    // Separator
    $wp_customize->add_setting('all_cleaning_services_setting_heading',array(
        'sanitize_callback'   => 'all_cleaning_services_sanitise_custom_text'
    ));
    $wp_customize->add_control('all_cleaning_services_setting_heading',array(
        'label' => __('Section Left Side','all-cleaning-services'),
        'section' => 'featured_about_info_section'
    ));

    // Card Number
    $wp_customize->add_setting('theme_options[featured_about_cardnum]', 
        array(
        'default'           => $default['featured_about_cardnum'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('theme_options[featured_about_cardnum]', 
        array(
        'label'       => __('Card Number', 'all-cleaning-services'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_cardnum]',  
        'active_callback' => 'all_cleaning_services_featured_about_active',        
        'type'        => 'text'
        )
    );

    // Card Text
    $wp_customize->add_setting('theme_options[featured_about_cardtext]', 
        array(
        'default'           => $default['featured_about_cardtext'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('theme_options[featured_about_cardtext]', 
        array(
        'label'       => __('Card Text', 'all-cleaning-services'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_cardtext]',  
        'active_callback' => 'all_cleaning_services_featured_about_active',        
        'type'        => 'text'
        )
    );

    // Separator
    $wp_customize->add_setting('all_cleaning_services_setting_details',array(
        'sanitize_callback'   => 'all_cleaning_services_sanitise_custom_text'
    ));
    $wp_customize->add_control('all_cleaning_services_setting_details',array(
        'label' => __('Section Right Side','all-cleaning-services'),
        'section' => 'featured_about_info_section'
    ));

    // Section Title
    $wp_customize->add_setting('theme_options[featured_about_title]', 
        array(
        'default'           => $default['featured_about_title'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('theme_options[featured_about_title]', 
        array(
        'label'       => __('Section Title', 'all-cleaning-services'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_title]',  
        'active_callback' => 'all_cleaning_services_featured_about_active',        
        'type'        => 'text'
        )
    );

    // Section Sub-Title
    $wp_customize->add_setting('theme_options[featured_about_subtitle]', 
        array(
        'default'           => $default['featured_about_subtitle'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('theme_options[featured_about_subtitle]', 
        array(
        'label'       => __('Section Sub-Title', 'all-cleaning-services'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_subtitle]',  
        'active_callback' => 'all_cleaning_services_featured_about_active',        
        'type'        => 'text'
        )
    );

    // Section Paragraph
    $wp_customize->add_setting('theme_options[featured_about_section_text]', 
        array(
        'default'           => $default['featured_about_section_text'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('theme_options[featured_about_section_text]', 
        array(
        'label'       => __('Section Paragraph', 'all-cleaning-services'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_section_text]',  
        'active_callback' => 'all_cleaning_services_featured_about_active',        
        'type'        => 'text'
        )
    );

    // Icon 1
    $wp_customize->add_setting('theme_options[featured_icon_about_li_icon1]', 
    array(
    'default'           => $default['featured_icon_about_li_icon1'],
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',	
    'sanitize_callback' => 'sanitize_text_field'
    )
    );
    $wp_customize->add_control('theme_options[featured_icon_about_li_icon1]', 
        array(
        'label'       		=> __('Plan Icon 1', 'all-cleaning-services'),
        'section'     		=> 'featured_about_info_section',   
        'settings'    		=> 'theme_options[featured_icon_about_li_icon1]',		
        'active_callback' 	=> 'all_cleaning_services_featured_about_active',			
        'type'        		=> 'text',
        )
    );

    // List Item 1
    $wp_customize->add_setting('theme_options[featured_about_li_text1]', 
        array(
        'default'           => $default['featured_about_li_text1'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('theme_options[featured_about_li_text1]', 
        array(
        'label'       => __('List Item 1', 'all-cleaning-services'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_li_text1]',  
        'active_callback' => 'all_cleaning_services_featured_about_active',        
        'type'        => 'text'
        )
    );

    // Icon 2
    $wp_customize->add_setting('theme_options[featured_icon_about_li_icon2]', 
    array(
    'default'           => $default['featured_icon_about_li_icon2'],
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',	
    'sanitize_callback' => 'sanitize_text_field'
    )
    );
    $wp_customize->add_control('theme_options[featured_icon_about_li_icon2]', 
        array(
        'label'       		=> __('Plan Icon 2', 'all-cleaning-services'),
        'section'     		=> 'featured_about_info_section',   
        'settings'    		=> 'theme_options[featured_icon_about_li_icon2]',		
        'active_callback' 	=> 'all_cleaning_services_featured_about_active',			
        'type'        		=> 'text',
        )
    );

    // List Item 2
    $wp_customize->add_setting('theme_options[featured_about_li_text2]', 
        array(
        'default'           => $default['featured_about_li_text2'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('theme_options[featured_about_li_text2]', 
        array(
        'label'       => __('List Item 2', 'all-cleaning-services'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_li_text2]',  
        'active_callback' => 'all_cleaning_services_featured_about_active',        
        'type'        => 'text'
        )
    );

    // Icon 3
    $wp_customize->add_setting('theme_options[featured_icon_about_li_icon3]', 
    array(
    'default'           => $default['featured_icon_about_li_icon3'],
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',	
    'sanitize_callback' => 'sanitize_text_field'
    )
    );
    $wp_customize->add_control('theme_options[featured_icon_about_li_icon3]', 
        array(
        'label'       		=> __('Plan Icon 3', 'all-cleaning-services'),
        'section'     		=> 'featured_about_info_section',   
        'settings'    		=> 'theme_options[featured_icon_about_li_icon3]',		
        'active_callback' 	=> 'all_cleaning_services_featured_about_active',			
        'type'        		=> 'text',
        )
    );

    // List Item 3
    $wp_customize->add_setting('theme_options[featured_about_li_text3]', 
        array(
        'default'           => $default['featured_about_li_text3'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('theme_options[featured_about_li_text3]', 
        array(
        'label'       => __('List Item 3', 'all-cleaning-services'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_li_text3]',  
        'active_callback' => 'all_cleaning_services_featured_about_active',        
        'type'        => 'text'
        )
    );

    // Feature Image 1
    $wp_customize->add_setting( 'all_cleaning_services_about_featureimg1', array(  
        // 'default' => '',     
        'sanitize_callback' => 'all_cleaning_services_sanitise_custom_url'
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'all_cleaning_services_about_featureimg1', array(
        'label' => __('Feature Image 1','all-cleaning-services'),
        'description'   => __( 'Size 32px x 32x', 'all-cleaning-services' ),
        'section' => 'featured_about_info_section',
        'settings'   => 'all_cleaning_services_about_featureimg1',
    )));

    // Feature Text 1
    $wp_customize->add_setting('theme_options[featured_about_feature1]', 
        array(
        'default'           => $default['featured_about_feature1'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('theme_options[featured_about_feature1]', 
        array(
        'label'       => __('Feature Text 1', 'all-cleaning-services'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_feature1]',  
        'active_callback' => 'all_cleaning_services_featured_about_active',        
        'type'        => 'text'
        )
    );

    // Feature Image 2
    $wp_customize->add_setting( 'all_cleaning_services_about_featureimg2', array(  
        // 'default' => '',     
        'sanitize_callback' => 'all_cleaning_services_sanitise_custom_url'
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'all_cleaning_services_about_featureimg2', array(
        'label' => __('Feature Image 2','all-cleaning-services'),
        'description'   => __( 'Size 32px x 32x', 'all-cleaning-services' ),
        'section' => 'featured_about_info_section',
        'settings'   => 'all_cleaning_services_about_featureimg2',
    )));

    // Feature Text 2
    $wp_customize->add_setting('theme_options[featured_about_feature2]', 
        array(
        'default'           => $default['featured_about_feature2'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('theme_options[featured_about_feature2]', 
        array(
        'label'       => __('Feature Text 2', 'all-cleaning-services'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_feature2]',  
        'active_callback' => 'all_cleaning_services_featured_about_active',        
        'type'        => 'text'
        )
    );

    // Button Text
    $wp_customize->add_setting('theme_options[featured_about_section_buttontext]', 
        array(
        'default'           => $default['featured_about_section_buttontext'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('theme_options[featured_about_section_buttontext]', 
        array(
        'label'       => __('Button Text', 'all-cleaning-services'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_section_buttontext]',  
        'active_callback' => 'all_cleaning_services_featured_about_active',        
        'type'        => 'text'
        )
    );

    // Button Icon
    $wp_customize->add_setting('theme_options[featured_iconbutnicn]', 
    array(
    'default'           => $default['featured_iconbutnicn'],
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',	
    'sanitize_callback' => 'sanitize_text_field'
    )
    );
    $wp_customize->add_control('theme_options[featured_iconbutnicn]', 
        array(
        'label'       		=> __('Button Icon', 'all-cleaning-services'),
        'section'     		=> 'featured_about_info_section',   
        'settings'    		=> 'theme_options[featured_iconbutnicn]',		
        'active_callback' 	=> 'all_cleaning_services_featured_about_active',			
        'type'        		=> 'text',
        )
    );

    // ///////// Button Bg Color
    $wp_customize->add_setting('about_button_bgcolor', array(
        'default'   => '#01549A',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'about_button_bgcolor', array(
        'section' => 'featured_about_info_section',
        'description' => __('Button Bg-Color', 'all-cleaning-services'),
    )));

    // ///////// Button Color
    $wp_customize->add_setting('about_button_color', array(
        'default'   => '#ffffff',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'about_button_color', array(
        'section' => 'featured_about_info_section',
        'description' => __('Button Color', 'all-cleaning-services'),
    )));

    /** about Colors Section */
    $wp_customize->add_section(
        'about_text_colors_section',
        array(
            'title'    => __( 'Colors', 'all-cleaning-services' ),        
            'priority' => 2,
            'panel'      => 'all_cleaning_services_about_panel3',  
        )
    );

    // ///////// Card Background Color
    $wp_customize->add_setting('about_card_bgcolor', array(
        'default'   => '#01549A',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'about_card_bgcolor', array(
        'section' => 'about_text_colors_section',
        'description' => __('Card Background Color', 'all-cleaning-services'),
    )));

    $wp_customize->add_control('all_cleaning_services_setting_colorleftside',array(
        'label' => __('Section Left Side','all-cleaning-services'),
        'section' => 'about_text_colors_section'
    ));

    // ///////// Card Number Color
    $wp_customize->add_setting('about_cardnumber_color', array(
        'default'   => '#FDC401',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'about_cardnumber_color', array(
        'section' => 'about_text_colors_section',
        'description' => __('Card Number Color', 'all-cleaning-services'),
    )));

    // ///////// Card Text Color
    $wp_customize->add_setting('about_cardtext_color', array(
        'default'   => '#ffffff',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'about_cardtext_color', array(
        'section' => 'about_text_colors_section',
        'description' => __('Card Text Color', 'all-cleaning-services'),
    )));

    $wp_customize->add_control('all_cleaning_services_setting_colorrightside',array(
        'label' => __('Section Right Side','all-cleaning-services'),
        'section' => 'about_text_colors_section'
    ));

    // ///////// Title Text Color
     $wp_customize->add_setting('about_title_color', array(
        'default'   => '#000000',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'about_title_color', array(
        'section' => 'about_text_colors_section',
        'description' => __('Title Color', 'all-cleaning-services'),
    )));

    // ///////// Sub-Title Text Color
    $wp_customize->add_setting('about_subtitle_color', array(
        'default'   => '#000000',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'about_subtitle_color', array(
        'section' => 'about_text_colors_section',
        'description' => __('Sub-Title Color', 'all-cleaning-services'),
    )));
    
    // ///////// Paragraph Text Color
    $wp_customize->add_setting('about_paragraph_color', array(
        'default'   => '#707070',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'about_paragraph_color', array(
        'section' => 'about_text_colors_section',
        'description' => __('Paragraph Color', 'all-cleaning-services'),
    )));

    // ///////// List Items Color
    $wp_customize->add_setting('about_listitem_color', array(
        'default'   => '#000000',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'about_listitem_color', array(
        'section' => 'about_text_colors_section',
        'description' => __('List Items Color', 'all-cleaning-services'),
    )));

    // ///////// List Icons Color
    $wp_customize->add_setting('about_listicon_color', array(
        'default'   => '#FDC401',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'about_listicon_color', array(
        'section' => 'about_text_colors_section',
        'description' => __('List Icons Color', 'all-cleaning-services'),
    )));

    // ///////// Features Color
    $wp_customize->add_setting('about_features_color', array(
        'default'   => '#000000',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'about_features_color', array(
        'section' => 'about_text_colors_section',
        'description' => __('Features Color', 'all-cleaning-services'),
    )));

    // ///////// Button Hover Bg Color
    $wp_customize->add_setting('about_buttonhov_bgcolor', array(
        'default'   => '#E9F5FF',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'about_buttonhov_bgcolor', array(
        'section' => 'about_text_colors_section',
        'description' => __('Button Hover Bg-Color', 'all-cleaning-services'),
    )));

    // ///////// Button Hover Color
    $wp_customize->add_setting('about_buttonhov_color', array(
        'default'   => '#01549A',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
      
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'about_buttonhov_color', array(
        'section' => 'about_text_colors_section',
        'description' => __('Button Hover Color', 'all-cleaning-services'),
    )));
    
    /** about Structure section */

        $wp_customize->add_section(
            'about_structure_section',
            array(
                'title'    => __( 'Structure', 'all-cleaning-services' ),        
                'priority' => 3,
                'panel'      => 'all_cleaning_services_about_panel3',  
            )
        );

        // Title Case
        $wp_customize->add_setting('featured_about_title_case',array(
            'default' => 'Uppercase',
            'sanitize_callback' => 'all_cleaning_services_sanitize_choices',
        ));
        $wp_customize->add_control('featured_about_title_case',array(
            'type' => 'select',
            'label' => __('Title Case','all-cleaning-services'),
            'choices' => array (
                'Uppercase' => __('Uppercase','all-cleaning-services'),
                'Lowercase' => __('Lowercase','all-cleaning-services'),
                'Capitalize' => __('Capitalize','all-cleaning-services'),
                'None' => __('None','all-cleaning-services')
            ),
            'section' => 'about_structure_section',
        ));

        // Sub Title Case
        $wp_customize->add_setting('featured_about_subtitle_case',array(
            'default' => 'Uppercase',
            'sanitize_callback' => 'all_cleaning_services_sanitize_choices',
        ));
        $wp_customize->add_control('featured_about_subtitle_case',array(
            'type' => 'select',
            'label' => __('Sub Title Case','all-cleaning-services'),
            'choices' => array (
                'Uppercase' => __('Uppercase','all-cleaning-services'),
                'Lowercase' => __('Lowercase','all-cleaning-services'),
                'Capitalize' => __('Capitalize','all-cleaning-services'),
                'None' => __('None','all-cleaning-services')
            ),
            'section' => 'about_structure_section',
        ));
