<?php
/**
 * Default theme options.
 *
 * @package all-cleaning-services  
 */

if ( ! function_exists( 'all_cleaning_services_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
function all_cleaning_services_get_default_theme_options() {

	$defaults = array();
	

    // Front Page Content
	$defaults['enable_frontpage_content'] 		= true;

	// Slider Section	
	$defaults['enable_featured_slider_section']		    	= true;
	//$defaults['show_slider_colors']		    			= false;	
	$defaults['featured_slider_content_type']		    	= 'featured_slider_page';
	$defaults['featured_slider_category_readmore_text']		= esc_html__('Read More','all-cleaning-services');
	$defaults['data_slick_speed']					    	= 1000;
	$defaults['data_slick_infinite']				    	= 1;
	$defaults['data_slick_dots']					    	= 1;
	$defaults['data_slick_autoplay']				    	= 1;
	$defaults['data_slick_draggable']				    	= 1;
	$defaults['data_slick_fade']					    	= 1;
	$defaults['number_of_featured_slider_items']	    	= 6;

	// About Section	
	$defaults['featured_about_cardnum']			        	= esc_html__( '100%', 'all-cleaning-services' );
	$defaults['featured_about_cardtext']			        = esc_html__( 'Satisfaction Gaurantee', 'all-cleaning-services' );
	$defaults['featured_about_title']			        	= esc_html__( 'WHO WE ARE', 'all-cleaning-services' );
	$defaults['featured_about_subtitle']			        = esc_html__( 'Professional Cleaning for a heathier home', 'all-cleaning-services' );
	$defaults['featured_about_section_text']			    = esc_html__( 'Nunc augue velit, consectetur vitaerum rutrum etrum, condimentum nectun enim. Nullam interdum nibh eu massatrum iaculistrum conguetru. Quisquet sodales lacinia metus id consectetur.', 'all-cleaning-services' );
	$defaults['featured_about_li_text1']			    	= esc_html__( '24/7 Emergency Cleaning Service.', 'all-cleaning-services' );
	$defaults['featured_about_li_text2']			    	= esc_html__( 'General Cleaning Maintenance.', 'all-cleaning-services' );
	$defaults['featured_about_li_text3']			    	= esc_html__( 'Certified Worker', 'all-cleaning-services' );
	$defaults['featured_icon_about_li_icon1']				= esc_html__( 'fas fa-check', 'all-cleaning-services' );
	$defaults['featured_icon_about_li_icon2']			    = esc_html__( 'fas fa-check', 'all-cleaning-services' );
	$defaults['featured_icon_about_li_icon3']			    = esc_html__( 'fas fa-check', 'all-cleaning-services' );
	$defaults['featured_about_feature1']			    	= esc_html__( 'Multi Surface Cleaning', 'all-cleaning-services' );
	$defaults['featured_about_feature2']			    	= esc_html__( 'Anti-Bacterial Cleaning', 'all-cleaning-services' );
	$defaults['featured_about_section_buttontext']	    	= esc_html__( 'Read More', 'all-cleaning-services' );
	$defaults['featured_iconbutnicn']	    				= esc_html__( 'fas fa-arrow-right', 'all-cleaning-services' );
    $default['about_enable_section']						= true;

	
	$defaults['show_footer_social_links'] 					 = true;

	// Pass through filter.
	$defaults = apply_filters( 'all_cleaning_services_filter_default_theme_options', $defaults );
	return $defaults;

	// Inner Blog Page	
	
	$defaults['featured_bloginn_botton_text']				= esc_html__( 'Read More', 'all-cleaning-services' );

}

endif;

/**
*  Get theme options
*/
if ( ! function_exists( 'all_cleaning_services_get_option' ) ) :

	/**
	 * Get theme option
	 *
	 * @since 1.0.0
	 *
	 * @param string $key Option key.
	 * @return mixed Option value.
	 */
	function all_cleaning_services_get_option( $key ) {

		$default_options = all_cleaning_services_get_default_theme_options();
		if ( empty( $key ) ) {
			return;
		}

		$theme_options = (array)get_theme_mod( 'theme_options' );
		$theme_options = wp_parse_args( $theme_options, $default_options );

		$value = null;

		if ( isset( $theme_options[ $key ] ) ) {
			$value = $theme_options[ $key ];
		}

		return $value;

	}

endif;