<?php
/**
 * all-cleaning-services Theme Customizer
 *
 * @package all-cleaning-services
 */

 // Custom Controls.
require get_template_directory() . '/inc/custom-control/custom-control.php';

// Sanitize callback.
require get_template_directory() . '/inc/customizer/sanitize-callback.php';

// Default
require get_template_directory() . '/inc/customizer/default.php';

// Load customize sanitize.
include get_template_directory() . '/inc/customizer/active-callback.php';


// Theme section.
// require get_template_directory() . '/inc/customizer/theme-section.php';

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function all_cleaning_services_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'all_cleaning_services_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'all_cleaning_services_customize_partial_blogdescription',
			)
		);
	}
	// Front Page Link
	require get_template_directory() . '/inc/customizer/home-section.php';

	// Section-Pro
	require get_template_directory() . '/inc/customizer/section-pro.php';

	// Theme Page Link
	require get_template_directory() . '/inc/customizer/theme-options.php';
}
add_action( 'customize_register', 'all_cleaning_services_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function all_cleaning_services_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function all_cleaning_services_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function all_cleaning_services_customize_preview_js() {
	wp_enqueue_script( 'all_cleaning_services-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), ALL_CLEANING_SERVICES_S_VERSION, true );
}
add_action( 'customize_preview_init', 'all_cleaning_services_customize_preview_js' );

/**
 *
 */
function all_cleaning_services_customize_backend_scripts() {

	wp_enqueue_style( 'all_cleaning_services-fontawesome-all', get_template_directory_uri() . '/assets/css/all.css' );

	wp_enqueue_style( 'all_cleaning_services-main-css', get_template_directory_uri() . '/src/output.css' );

	wp_enqueue_style( 'all_cleaning_services-admin-customizer-style', get_template_directory_uri() . '/inc/customizer/css/customizer-style.css' );
	
	wp_enqueue_script( 'all_cleaning_services-admin-customizer', get_template_directory_uri() . '/inc/customizer/js/customizer-script.js', array( 'jquery', 'customize-controls' ), '20151215', true );
	wp_enqueue_script( 'all_cleaning_services-admin-customizer-control', get_template_directory_uri() . '/inc/customizer/js/customize-controls.js', array( 'jquery', 'customize-controls' ), '', true );
}
add_action( 'customize_controls_enqueue_scripts', 'all_cleaning_services_customize_backend_scripts', 10 );

/**
 * Enqueue the stylesheet.
 */
function all_cleaning_services_customizer_stylesheet() {

    wp_register_style( 'all_cleaning_services-admin-css', get_template_directory_uri() . '/inc/customizer/css/customize-controls.css', NULL, NULL, 'all' );
    wp_enqueue_style( 'all_cleaning_services-admin-css' );
}
add_action( 'customize_controls_print_styles', 'all_cleaning_services_customizer_stylesheet' );

///////////////////////////// customize  color 

function all_cleaning_services_customize_css()
{
	$theme_options = get_theme_mod('theme_options');
    $slider_title_fontweight = isset($theme_options['slider_title_fontweight']) ? $theme_options['slider_title_fontweight'] : '700';
	
	$theme_options = get_theme_mod('theme_options');
    $about_title_fontweight = isset($theme_options['about_title_fontweight']) ? $theme_options['about_title_fontweight'] : '700';
?>
	<style type="text/css">
		/* ///////////////////////////  color.php /////////////////////////// */

		/* ---------------## Header Section Color Start ##------------- */
		#site-navigation{
			background-color: <?php echo esc_html(get_theme_mod('header_bg_color')); ?>;
		}
		
		#site-navigation ul li a{
			color: <?php echo esc_html(get_theme_mod('header_menu_color')); ?>;
		}

		#site-navigation .sub-menu li,#site-navigation .menu li:last-child{
			background: <?php echo esc_html(get_theme_mod('header_submenu_bgcolor')); ?>;
		}


		.sidebar-div .wp-block-heading, .single_sidebar label, .single_sidebar .wp-block-heading, .sidebar-div .widget-title{
            background: <?php echo esc_html(get_theme_mod('Search_background_color')); ?>;
        }
        .sidebar-div .wp-block-heading, .single_sidebar label, .single_sidebar .wp-block-heading, .sidebar-div .widget-title{
            color: <?php echo esc_html(get_theme_mod('Heading_text_color')); ?>;
        }
		a{
			color: <?php echo esc_html(get_theme_mod('Text_color')); ?>;
		}
		.widget ul li::before, .widget ol li footer .wp-block-latest-comments__comment-author::before {
			color: <?php echo esc_html(get_theme_mod('side_icon_color')); ?>;
		}
		/* ---------------## Header Section Color End ##------------- */

		/* ---------------## Slider Section Color Start ##------------- */
		#featured-slider h2.title{
			color: <?php echo esc_html(get_theme_mod('slider_title_color')); ?>;
		}

		#featured-slider .entry-header .title { 
			font-weight: <?php echo esc_attr($slider_title_fontweight); ?>;
		}
		
		#featured-slider .entry-content p{
			color: <?php echo esc_html(get_theme_mod('slider_paragraph_color')); ?>;
		}

		#featured-slider .read-more .btn{
			background: <?php echo esc_html(get_theme_mod('slider_readmore_color')); ?>;
		}

		#featured-slider .read-more .btn{
			color: <?php echo esc_html(get_theme_mod('slider_readmoretxt_color')); ?>;
		}
		
		#featured-slider .play-btn{
			background-color: <?php echo esc_html(get_theme_mod('slider_video_bg_color')); ?>;
		}

		#featured-slider .borderbtn{
			border-color: <?php echo esc_html(get_theme_mod('slider_border_color')); ?>;
		}
		
		#featured-slider .play-btn{
			color: <?php echo esc_html(get_theme_mod('slider_playbtn_color')); ?>;
		}

		#featured-slider .slick-next:before, #featured-slider .slick-prev:before{
			background-color: <?php echo esc_html(get_theme_mod('slider_indicator_color')); ?>;
		}

		#featured-slider .slick-next:before, #featured-slider .slick-prev:before{
			border-color:<?php echo esc_html(get_theme_mod('slider_indicator_bordercolor')); ?>;
		}
		
		#featured-slider .slick-next:before, #featured-slider .slick-prev:before{
			color: <?php echo esc_html(get_theme_mod('slider_indicatoricon_color')); ?>;
		}

		#featured-slider .playbtntxt,
		#featured-slider .playbtntxt a{
			color: <?php echo esc_html(get_theme_mod('slider_videotxt_color')); ?>;
		}
		/* ---------------## Slider Section Color End ##------------- */

		/* ---------------## What we Offer Section Color Start ##------------- */
		.featured-about{
			background: <?php echo esc_html(get_theme_mod('about_background_color')); ?>;
		}

		.featured-about .head-subtitle { 
			font-weight: <?php echo esc_attr($about_title_fontweight); ?>;
		}
		
		.featured-about .aboutbox{
			background: <?php echo esc_html(get_theme_mod('about_card_bgcolor')); ?>;
		}

		.featured-about .aboutbox .abtnum{
			Color: <?php echo esc_html(get_theme_mod('about_cardnumber_color')); ?>;
		}

		.featured-about .aboutbox .abttxt{
			Color: <?php echo esc_html(get_theme_mod('about_cardtext_color')); ?>;
		}
		
		.featured-about .head-title{
			color: <?php echo esc_html(get_theme_mod('about_title_color')); ?>;
		}

		.featured-about .head-subtitle{
			color: <?php echo esc_html(get_theme_mod('about_subtitle_color')); ?>;
		}
		
		.featured-about .abtpara{
			color: <?php echo esc_html(get_theme_mod('about_paragraph_color')); ?>;
		}

		.featured-about ul li{
			color: <?php echo esc_html(get_theme_mod('about_listitem_color')); ?>;
		}
		
		.featured-about ul li svg{
			color: <?php echo esc_html(get_theme_mod('about_listicon_color')); ?>;
		}
		
		.featured-about .d-flex .abtfeature1{
			color: <?php echo esc_html(get_theme_mod('about_features_color')); ?>;
		}
		
		.featured-about .abtbutton{
			background: <?php echo esc_html(get_theme_mod('about_button_bgcolor')); ?>;
			color: <?php echo esc_html(get_theme_mod('about_button_color')); ?>;
		}

		.featured-about .abtbutton:hover {
			color: <?php echo esc_html(get_theme_mod('about_buttonhov_color')); ?>;
		}
		
		.featured-about .abtbutton:hover:before,.featured-about .abtbutton:hover:after,.featured-about .abtbutton:after {
			background: <?php echo esc_html(get_theme_mod('about_buttonhov_bgcolor')); ?>;
		}
		/* ---------------## What we Offer Section Color End ##------------- */

		/* ---------------## Footer Section Color Start ##------------- */
		#colophon{
			background-color: <?php echo esc_html(get_theme_mod('footer_bg_color')); ?>;
		}
		
		#colophon .widget_nav_menu .widget-title{
			color: <?php echo esc_html(get_theme_mod('footer_heading_color')); ?>;
		}
		
		#colophon .footer-para,#colophon .menu-footer ul li,#colophon .menu-footer ul li a{
			color: <?php echo esc_html(get_theme_mod('footer_text_color')); ?>;
		}
		
		#colophon .footer_social_links a svg{
			color: <?php echo esc_html(get_theme_mod('footer_socialicon_color')); ?>;
		}
		/* ---------------## Footer Section Color End ##------------- */
	</style>
	
<?php
}
add_action('wp_head', 'all_cleaning_services_customize_css');


function total_dynamic_styles(){
    global $post;

    $custom_css = '';

    // Padding top
    $all_cleaning_services_featured_about_t_padding = get_theme_mod('all_cleaning_services_featured_about_t_padding', '3');
    if ( $all_cleaning_services_featured_about_t_padding != '' ) {
        $custom_css .= ' .featured-about {';
        $custom_css .= ' padding-top: ' . esc_attr($all_cleaning_services_featured_about_t_padding) . 'em;';
        $custom_css .= ' }';
    }

    // Padding bottom
    $all_cleaning_services_featured_about_b_padding = get_theme_mod('all_cleaning_services_featured_about_b_padding', '3');
    if ( $all_cleaning_services_featured_about_b_padding != '' ) {
        $custom_css .= ' .featured-about {';
        $custom_css .= ' padding-bottom: ' . esc_attr($all_cleaning_services_featured_about_b_padding) . 'em;';
        $custom_css .= ' }';
    }

    return $custom_css;   
}