<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package all-cleaning-services
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">

    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <?php wp_body_open(); ?>
    <div id="page" class="site header">
        <a class="skip-link screen-reader-text"
            href="#primaryid"><?php esc_html_e( 'Skip to content', 'all-cleaning-services' ); ?></a>
        <header id="masthead" class="site-header">

            <div class="container p-0">
			<nav id="site-navigation" class="main-navigation navbar navbar-expand-lg">
                <div class="sitenave">
                    <div class="site-branding">
                        <?php
					if (has_custom_logo()) {
						the_custom_logo();
					} else {
						if (is_front_page() && is_home()): ?>
                        <h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"
                                rel="home"><?php bloginfo('name'); ?></a></h1>
                        <?php else: ?>
                        <div class="business-box">
                            <div class="business-title-container">
                                <p class="site-title p-2 m-0"><a href="<?php echo esc_url(home_url('/')); ?>"
                                        rel="home"><?php bloginfo('name'); ?></a></p>
                            </div>
                        </div>
                        <?php endif; ?>

                        <?php
						$all_cleaning_services_description = get_bloginfo('description', 'display');
						if ($all_cleaning_services_description || is_customize_preview()): ?>
                        <p class="site-description">
                            <?php echo $all_cleaning_services_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                        </p>
                        <?php endif; 
					} ?>
                    </div>
                    <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
                        <i class="fa-solid fa-bars mobile-nav-icon bars"></i>
                        <i class="fa-solid fa-xmark mobile-nav-icon close"></i>
                    </button>
                </div>
                <?php
						wp_nav_menu(
							array(
								'theme_location' => 'menu-1',
								'menu_id'        => 'primary-menu',
							)
						);
					?>


            </nav><!-- #site-navigation -->
               
            </div>
        </header><!-- #masthead -->