<?php
/**
 * all-cleaning-services functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package all-cleaning-services
 */

if ( ! defined( 'ALL_CLEANING_SERVICES_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'ALL_CLEANING_SERVICES_S_VERSION', '1.0.0' );
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function all_cleaning_services_setup() {
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on all-cleaning-services, use a find and replace
		* to change 'all-cleaning-services' to the name of your theme in all the template files.
		*/
	load_theme_textdomain( 'all-cleaning-services', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support( 'title-tag' );

	/**
 * Enable support for Post Thumbnails on posts and pages.
 *
 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
 */
	add_theme_support('post-thumbnails');


	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'menu-1' => esc_html__( 'Primary', 'all-cleaning-services' ),
		)
	);

	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'all_cleaning_services_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action( 'after_setup_theme', 'all_cleaning_services_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function all_cleaning_services_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'all_cleaning_services_content_width', 640 );
}
add_action( 'after_setup_theme', 'all_cleaning_services_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function all_cleaning_services_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'all-cleaning-services' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'all-cleaning-services' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'all_cleaning_services_widgets_init' );

/**
 * Register custom fonts.
 */
function all_cleaning_services_fonts_url()
{
	$fonts_url = '';
	$fonts = array();
	$subsets = 'latin,latin-ext';

	/* translators: If there are characters in your language that are not supported by Lora, translate this to 'off'. Do not translate into your own language. */
	if ('off' !== _x('on', 'Lora: on or off', 'all-cleaning-services')) {
		$fonts[] = 'Lora:400,600,700';
	}

	if ('off' !== _x('on', 'Space Grotesk: on or off', 'all-cleaning-services')) {
		$fonts[] = 'Space Grotesk:300,400,500,600,700';
	}

	if ($fonts) {
		$fonts_url = add_query_arg(
			array(
				'family' => urlencode(implode('|', $fonts)),
				'subset' => urlencode($subsets),
			), 'https://fonts.googleapis.com/css');
	}

	return esc_url_raw($fonts_url);
}

/**
 * Function that returns if the menu is sticky
 */
if (!function_exists('sticky_header')):
    function sticky_header()
    {
        $is_sticky = get_theme_mod('all_cleaning_services_sticky_header', false);

        if ($is_sticky == false):
            return 'not-sticky';
        else:
            return 'is-sticky-on';
        endif;
    }
endif;

/**
 * Enqueue scripts and styles.
 */
function all_cleaning_services_scripts() {
	wp_enqueue_style( 'all_cleaning_services-style', get_stylesheet_uri(), array(), ALL_CLEANING_SERVICES_S_VERSION );
	wp_style_add_data( 'all_cleaning_services-style', 'rtl', 'replace' );

	wp_enqueue_style('all_cleaning_services-all.css', get_stylesheet_directory_uri() . "/assets/css/all.css", '', ALL_CLEANING_SERVICES_S_VERSION);
	wp_enqueue_style('all_cleaning_services-responsive.css', get_stylesheet_directory_uri() . "/assets/css/responsive.css", '', ALL_CLEANING_SERVICES_S_VERSION);
	wp_enqueue_style('all_cleaning_services-all.min.css', get_stylesheet_directory_uri() . "/assets/css/all.min.css", '', ALL_CLEANING_SERVICES_S_VERSION);
	wp_enqueue_style('all_cleaning_services-animate-3.5.2.css', get_stylesheet_directory_uri() . "/assets/css/animate-3.5.2.css", '', ALL_CLEANING_SERVICES_S_VERSION);
	wp_enqueue_style('all_cleaning_services-animate.css', get_stylesheet_directory_uri() . "/assets/css/animate.css", '', ALL_CLEANING_SERVICES_S_VERSION);
	wp_enqueue_style('all_cleaning_services-output.css', get_stylesheet_directory_uri() . "/assets/css/output.css", '', ALL_CLEANING_SERVICES_S_VERSION);
	wp_enqueue_style('all_cleaning_services-blocks.css', get_stylesheet_directory_uri() . "/assets/css/blocks.css", '', ALL_CLEANING_SERVICES_S_VERSION);
	wp_enqueue_style('all_cleaning_services-blocks.min.css', get_stylesheet_directory_uri() . "/assets/css/blocks.min.css", '', ALL_CLEANING_SERVICES_S_VERSION);
	wp_enqueue_style('all_cleaning_services-bootstrap.min.css', get_stylesheet_directory_uri() . "/assets/css/bootstrap.min.css", '', ALL_CLEANING_SERVICES_S_VERSION);
	wp_enqueue_style('all_cleaning_services-slick-theme.css', get_stylesheet_directory_uri() . "/assets/css/slick-theme.css", '', ALL_CLEANING_SERVICES_S_VERSION);
	wp_enqueue_style('all_cleaning_services-slick-theme.min.css', get_stylesheet_directory_uri() . "/assets/css/slick-theme.min.css", '', ALL_CLEANING_SERVICES_S_VERSION);
	wp_enqueue_style('all_cleaning_services-slick.css', get_stylesheet_directory_uri() . "/assets/css/slick.css", '', ALL_CLEANING_SERVICES_S_VERSION);
	wp_enqueue_style('all_cleaning_services-slick.min.css', get_stylesheet_directory_uri() . "/assets/css/slick.min.css", '', ALL_CLEANING_SERVICES_S_VERSION);
	wp_enqueue_style('all_cleaning_services-pe-customize-controls.css', get_stylesheet_directory_uri() . "/assets/css/pe-customize-controls.css", '', ALL_CLEANING_SERVICES_S_VERSION);
	wp_enqueue_style('all_cleaning_services-swiper-bundle.min.css', get_stylesheet_directory_uri() . "/assets/css/swiper-bundle.min.css", '', ALL_CLEANING_SERVICES_S_VERSION);


	wp_enqueue_script( 'all_cleaning_services-navigation', get_template_directory_uri() . '/js/navigation.js', array(), ALL_CLEANING_SERVICES_S_VERSION, true );
	wp_enqueue_script( 'all_cleaning_services-all.min.js', get_template_directory_uri() . '/assets/js/all.min.js', array(), ALL_CLEANING_SERVICES_S_VERSION, true );		
	wp_enqueue_script( 'all_cleaning_services-jquery.min.js', get_template_directory_uri() . '/assets/js/jquery.min.js', array(), ALL_CLEANING_SERVICES_S_VERSION, true );	
	wp_enqueue_script( 'all_cleaning_services-bootstrap.bundle.min.js', get_template_directory_uri() . '/assets/js/bootstrap.bundle.min.js', array(), ALL_CLEANING_SERVICES_S_VERSION, true );
	wp_enqueue_script( 'all_cleaning_services-custom.js', get_template_directory_uri() . '/assets/js/custom.js', array(), ALL_CLEANING_SERVICES_S_VERSION, true );
	wp_enqueue_script( 'all_cleaning_services-jquery.counterup.min.js', get_template_directory_uri() . '/assets/js/jquery.counterup.min.js', array(), ALL_CLEANING_SERVICES_S_VERSION, true );
	wp_enqueue_script( 'all_cleaning_services-jquery.matchHeight.js', get_template_directory_uri() . '/assets/js/jquery.matchHeight.js', array(), ALL_CLEANING_SERVICES_S_VERSION, true );
	wp_enqueue_script( 'all_cleaning_services-slick.js', get_template_directory_uri() . '/assets/js/slick.js', array(), ALL_CLEANING_SERVICES_S_VERSION, true );
	wp_enqueue_script( 'all_cleaning_services-slick.min.js', get_template_directory_uri() . '/assets/js/slick.min.js', array(), ALL_CLEANING_SERVICES_S_VERSION, true );
	wp_enqueue_script( 'all_cleaning_services-swiper-bundle.min.js', get_template_directory_uri() . '/assets/js/swiper-bundle.min.js', array(), ALL_CLEANING_SERVICES_S_VERSION, true );
	

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'all_cleaning_services_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';


/**
 * Custom functions that act independently of the theme templates.
 */
// require get_template_directory() . '/inc/extras.php';


/**
 * Load Hooks.
 */
require get_template_directory() . '/inc/hook/structure.php';
require get_template_directory() . '/inc/hook/custom.php'; 
require get_template_directory() . '/inc/hook/basic.php';
/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}


////////////////////////////////////////////////////////////////////////////////////////////////////////
// Integer sanitization
if ( ! function_exists( 'all_cleaning_services_sanitize_integer' ) ) {
    function all_cleaning_services_sanitize_integer( $input ) {
        return (int) $input;
    }
}

/***** Start Slider Button custome field *****/
// button
function all_cleaning_services_sliderBtntextCutomFieldHtml(){
    global $post;
    // get the saved value     
    
    $sliderbtntext = get_post_meta($post->ID, 'sliderbtntext', false);
    $sliderbtntext = !empty($sliderbtntext[0])?$sliderbtntext[0]:'';

    $sliderbtnurl = get_post_meta($post->ID, 'sliderbtnurl', false);
    $sliderbtnurl = !empty($sliderbtnurl[0])?$sliderbtnurl[0]:'';
   
    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'sliderbtn_text');
    echo '<table id="sliderbtntext" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-edit-large"></span></th>
    <td width="30%"><input type="text" name="sliderbtntext" width="100%" placeholder="Slider Button Text" value="'.$sliderbtntext.'" /></td>
    <td width="80%"><input type="text" name="sliderbtnurl" width="100%" placeholder="Slider Button Url" value="'.$sliderbtnurl.'" /></td>

    </tr>';

    echo '</table>';
    
}
// ////// Video 
function all_cleaning_services_sliderVideoCutomFieldHtml(){
    global $post;
    // get the saved value     
    
    $slidervideotext = get_post_meta($post->ID, 'slidervideotext', false);
    $slidervideotext = !empty($slidervideotext[0])?$slidervideotext[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'slider_text');
    echo '<table id="slidertext" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-edit-large"></span></th>
    <td width="100%"><input type="text" name="slidervideotext" width="50%" placeholder="Slider Text" value="'.$slidervideotext.'" /></td>

    </tr>';

    echo '</table>';
}

function all_cleaning_services_addsliderBtntextHook(){
   
    add_meta_box('all_cleaning_services-test-sliderbtntext', __('Add Slider Button ', 'all-cleaning-services'), 'all_cleaning_services_sliderVideoCutomFieldHtml', 'sliders', 'normal', 'high');
	add_meta_box('all_cleaning_services-test-slidertext', __('Add Video BtnText', 'all-cleaning-services'), 'all_cleaning_services_sliderVideoCutomFieldHtml', 'sliders', 'normal', 'high');
}

function all_cleaning_services_savesliderBtntextCutomData($post_id){
    // If it is our form has not been submitted, so we dont want to do anything
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;  

    if(empty($_POST['sliderbtntext']) &&  empty($_POST['sliderbtnurl']) &&empty($_POST['slidervideotext']) ){
        // echo 'empty --> '; exit;       
        return;
    }   

	$slidervideotext = $_POST['slidervideotext'];
    update_post_meta($post_id, 'slidervideotext', $slidervideotext);

    $sliderbtntext = $_POST['sliderbtntext'];
    update_post_meta($post_id, 'sliderbtntext', $sliderbtntext);

    $sliderbtnurl = $_POST['sliderbtnurl'];
    update_post_meta($post_id, 'sliderbtnurl', $sliderbtnurl);     
   
}
add_action('add_meta_boxes', 'all_cleaning_services_addsliderBtntextHook');
add_action('save_post', 'all_cleaning_services_savesliderBtntextCutomData');

/***** End Slider Button custome field *****/


// Section Pro
function all_cleaning_services_customizer_script() {
    wp_enqueue_script(
        'all_cleaning_services-customizer-script',
        get_template_directory_uri() . '/assets/js/customizer-button.js',
        ['customize-controls'],
        '1.0',
        true
    );
}
add_action( 'customize_controls_enqueue_scripts', 'all_cleaning_services_customizer_script' );