<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package all-cleaning-services
 */

?>
	<?php $footer_show_social  = all_cleaning_services_get_option( 'show_footer_social_links' ); ?>

	<footer id="colophon" class="site-footer">
		<div class="footer-widgets-area mt-4">
			<div class="row">
				<div class="col-lg-10 col-md-10 col-12 offset-lg-1 offset-md-1 offset-0">
					<div class="row">
						<div class="col-lg-3 col-md-12 col-12 mt-3">
							<div class="hentry">
								<div class="widget_nav_menu">
									<div class="site-branding">
										<?php $all_cleaning_services_image = get_theme_mod('all_cleaning_services_footer_logo');?>
											<?php if($all_cleaning_services_image == ''){?>
											<img  src="<?php echo esc_url(get_template_directory_uri()."/assets/images/logo.png");?>">
											<?php }else { ?>
											<img src="<?php echo esc_url(get_theme_mod('all_cleaning_services_footer_logo'));?>">
										<?php } ?>
									</div>
									<div class="py-2">
										<p class="footer-para"><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_paragraph', __('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod temp or incididunt ut labore et dolore magna aliqua.', 'all-cleaning-services')))?></p>
									</div>
									<?php 
        								if ( $footer_show_social ){ 
      								?>
										<div class="footer_social_links">
											<a href=""><i class="fa-brands <?php echo esc_html(get_theme_mod('all_cleaning_services_footfacebook_icon', __('fa-facebook', 'all-cleaning-services'))) ?>"></i></a>
											<a href=""><i class="fa-brands <?php echo esc_html(get_theme_mod('all_cleaning_services_foottwitter_icon', __('fa-twitter', 'all-cleaning-services'))) ?>"></i></a>
											<a href=""><i class="fa-brands <?php echo esc_html(get_theme_mod('all_cleaning_services_footlinkedin_icon', __('fa-linkedin-in', 'all-cleaning-services'))) ?>"></i></a>
											<a href=""><i class="fa-brands <?php echo esc_html(get_theme_mod('all_cleaning_services_footinstagram_icon', __('fa-instagram', 'all-cleaning-services'))) ?>"></i></a>
										</div>
									<?php }?>
								</div>
							</div>
						</div>
						<div class="col-lg-8 offset-lg-1 col-md-9 col-12">
							<div class="row">
								<div class="col-lg-4 col-md-12 col-12 mt-3">
									<div class="hentry">
										<div class="widget_nav_menu">
											<h2 class="widget-title"><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_title2', __('Quick Link', 'all-cleaning-services')))?></h2>
											<div class="menu-footer">
												<ul class="menu m-0 p-0">
													<li>
														<i class="fa-solid fa-minus me-3"></i>
														<a href=""><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_navsubmenu1', __('Projects', 'all-cleaning-services')))?></a>
													</li>
													<li>
														<i class="fa-solid fa-minus me-3"></i>
														<a href=""><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_navsubmenu2', __('Contact Us', 'all-cleaning-services')))?></a>
													</li>
													<li>
														<i class="fa-solid fa-minus me-3"></i>
														<a href=""><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_navsubmenu3', __('Team', 'all-cleaning-services')))?></a>
													</li>
													<li>
														<i class="fa-solid fa-minus me-3"></i>
														<a href=""><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_navsubmenu4', __('Compnay History ', 'all-cleaning-services')))?></a>
													</li>
													<li>
														<i class="fa-solid fa-minus me-3"></i>
														<a href=""><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_navsubmenu5', __('Features', 'all-cleaning-services')))?></a>
													</li>
												</ul>
											</div>
										</div>
									</div>
								</div>
								<div class="col-lg-4 col-md-12 col-12 mt-3">
									<div class="hentry">
										<div class="widget_nav_menu">
											<h2 class="widget-title"><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_title3', __('Services', 'all-cleaning-services')))?></h2>
											<div class="menu-footer">
												<ul class="menu m-0 p-0">
													<li>
														<i class="fa-solid fa-minus me-3"></i>
														<a href=""><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_sersubmenu1', __('House Cleaning', 'all-cleaning-services')))?></a>
													</li>
													<li>
														<i class="fa-solid fa-minus me-3"></i>
														<a href=""><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_sersubmenu2', __('Kitchen Cleaning', 'all-cleaning-services')))?></a>
													</li>
													<li>
														<i class="fa-solid fa-minus me-3"></i>
														<a href=""><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_sersubmenu3', __('Window Cleaning', 'all-cleaning-services')))?></a>
													</li>
													<li>
														<i class="fa-solid fa-minus me-3"></i>
														<a href=""><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_sersubmenu4', __('Office Cleaning', 'all-cleaning-services')))?></a>
													</li>
													<li>
														<i class="fa-solid fa-minus me-3"></i>
														<a href=""><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_sersubmenu5', __('Carpet Cleaning', 'all-cleaning-services')))?></a>
													</li>
												</ul>
											</div>
										</div>
									</div>
								</div>
								<div class="col-lg-4 col-md-12 col-12 mt-3">
									<div class="hentry">
										<div class="widget_nav_menu">
											<h2 class="widget-title"><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_title4', __('Company', 'all-cleaning-services')))?></h2>
											<div class="menu-footer">
												<ul class="menu m-0 p-0">
													<li>
														<i class="fa-solid fa-minus me-3"></i>
														<a href=""><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_compsubmenu1', __('Terms & Condition', 'all-cleaning-services')))?></a>
													</li>
													<li>
														<i class="fa-solid fa-minus me-3"></i>
														<a href=""><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_compsubmenu2', __('Our History', 'all-cleaning-services')))?></a>
													</li>
													<li>
														<i class="fa-solid fa-minus me-3"></i>
														<a href=""><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_compsubmenu3', __('Our Gallery', 'all-cleaning-services')))?></a>
													</li>
													<li>
														<i class="fa-solid fa-minus me-3"></i>
														<a href=""><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_compsubmenu4', __('Privacy Policy', 'all-cleaning-services')))?></a>
													</li>
													<li>
														<i class="fa-solid fa-minus me-3"></i>
														<a href=""><?php echo esc_html(get_theme_mod('all_cleaning_services_foot_compsubmenu5', __('Testimonial', 'all-cleaning-services')))?></a>
													</li>
												</ul>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="site-info mt-4">
						<a href="<?php echo esc_url( __( 'https://wordpress.org/', 'all-cleaning-services' ) ); ?>">
							<?php
							/* translators: %s: CMS name, i.e. WordPress. */
							printf( esc_html__( 'Proudly powered by %s', 'all-cleaning-services' ), 'WordPress' );
							?>
						</a>
						<span class="sep"> | </span>
							<?php
							/* translators: 1: Theme name, 2: Theme author. */
							printf( esc_html__( 'Theme: %1$s by %2$s.', 'all-cleaning-services' ), 'All Cleaning Services', 'WebNotick' );
							?>
					</div><!-- .site-info -->
				</div>
			</div>
		</div>
		<!-- Scroll to Top Button -->
		<?php if(get_theme_mod('featured_scrooltopbtn_on_off',true) == true ){  ?>
			<div class="scroll-to-top">
				<a href="#" id="scroll-to-top">
					<img  src="<?php echo esc_url(get_template_directory_uri()."/assets/images/dustgif.gif");?>">
				</a>
			</div>
        <?php } ?>
	</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
