<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Agency Eye Pro
 */
$agency_eye_categories = get_the_category();
if ($agency_eye_categories) {
	$agency_eye_category = $agency_eye_categories[mt_rand(0, count($agency_eye_categories) - 1)];
} else {
	$agency_eye_category = '';
}
?>
<div class="col-lg-4 mb-4 js-scroll fade-in-bottom">
	<article id="post-<?php the_ID(); ?>" <?php post_class('agency-eye-list-item'); ?>>
		<div class="ax-single-blog-post">
			<?php if (has_post_thumbnail()) : ?>
				<div class="ay-grid-img">
					<a href="<?php the_permalink(); ?>">
						<?php the_post_thumbnail(); ?>
					</a>
					<a class="bcategrory" href="<?php echo esc_url(get_category_link($agency_eye_category)); ?>"><?php echo esc_html($agency_eye_category->name); ?></a>
				</div>
			<?php endif; ?>
			<div class="ax-single-blog-post-details">
				<div class="grid-meta">
					<?php if (!has_post_thumbnail()) : ?>
						<div class="ax-single-blog-post-categories grid-meta-cat">
							<a class="blog-categrory" href="<?php echo esc_url(get_category_link($agency_eye_category)); ?>"><?php echo esc_html($agency_eye_category->name); ?></a>
						</div>
					<?php endif; ?>
					<div class="ax-single-blog-post-author-section grid-meta-item">
						<div class="ax-blog-post-author-detalis">
							<div class="ax-blog-post-author-img">
								<a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php echo wp_kses_post(get_avatar(get_the_author_meta('ID'))); ?></a>
								<a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>" class="ax-blog-post-author-name"><?php echo esc_html(get_the_author_meta('display_name')); ?></a>
							</div>
							<div class="ax-single-blog-post-pub-date">
								<p><?php echo esc_html(get_the_date(get_option('date_format'))); ?></p>
							</div>
						</div>
					</div>
				</div>

				<h2 class="ax-single-blog-post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>

				<div class="ax-single-blog-post-dres">
					<?php the_excerpt(); ?>
					<a class="agency-eye-readmore" href="<?php the_permalink(); ?>"><?php esc_html_e('Read More ', 'agency-eye'); ?> <i class="fas fa-angle-right"></i></a>
				</div>
			</div>
		</div>

	</article><!-- #post-<?php the_ID(); ?> -->
</div>