<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Agency Eye
 */

?>

<footer id="colophon" class="site-footer">
	<div class="container">
		<div class="site-info text-center">
			<a href="<?php echo esc_url(__('https://wordpress.org/', 'agency-eye')); ?>">
				<?php
				/* translators: %s: CMS name, i.e. WordPress. */
				printf(esc_html__('Proudly powered by %s', 'agency-eye'), 'WordPress');
				?>
			</a>
			<span class="sep"> | </span>
			<?php
			/* translators: 1: Theme name, 2: Theme author. */
			printf(esc_html__('%1$s by %2$s.', 'agency-eye'), '<a href="https://wpthemespace.com/product/agency-eye/">Agency Eye</a>', 'Wp Theme Space');
			?>

		</div><!-- .site-info -->
		<?php
		wp_nav_menu(array(
			'theme_location' => 'footer-menu',
			'menu_id'        => 'footer-menu',
			'depth'              => 1,
			'fallback_cb'     => '__return_false',
		));
		?>
	</div><!-- .container -->
</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>