<?php

/**
 * The file for header all actions
 *
 *
 * @package Agency Eye
 */

function agency_eye_header_menu_output()
{
?>
	<nav id="site-navigation" class="main-navigation">
		<?php
		wp_nav_menu(array(
			'theme_location' => 'main-menu',
			'menu_id'        => 'agency-eye-menu',
			'menu_class'        => 'agency-eye-menu',
		));
		?>
	</nav><!-- #site-navigation -->
<?php
}
add_action('agency_eye_main_menu', 'agency_eye_header_menu_output');


function agency_eye_header_logo_output()
{
	$agency_eye_site_tagline_show = get_theme_mod('agency_eye_site_tagline_show');

?>

	<?php if (has_custom_logo()) : ?>
		<div class="site-branding brand-logo">
			<?php
			the_custom_logo();
			?>
		</div>
	<?php else: ?>
		<?php
		if (display_header_text() == true || (display_header_text() == true && is_customize_preview())) : ?>
			<div class="site-branding brand-text">
				<?php if (display_header_text() == true || (display_header_text() == true && is_customize_preview())) : ?>
					<h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
					<?php
					$agency_eye_description = get_bloginfo('description', 'display');
					if (($agency_eye_description || is_customize_preview()) && empty($agency_eye_site_tagline_show)) :
					?>
						<p class="site-description"><?php echo $agency_eye_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
													?></p>
					<?php endif; ?>
				<?php endif; ?>

			</div><!-- .site-branding -->
		<?php endif; ?>
	<?php endif; ?>

<?php
}
add_action('agency_eye_header_logo', 'agency_eye_header_logo_output');




// header style one
function agency_eye_header_style_one()
{
?>
	<div class="pxm-style1">
		<div class="navigation">
			<div class="d-flex">
				<div class="pxms1-logo">
					<?php do_action('agency_eye_header_logo'); ?>
				</div>
				<div class="pxms1-menu ms-auto">
					<?php do_action('agency_eye_main_menu'); ?>
				</div>
			</div>
		</div>
	</div>


<?php
}
add_action('agency_eye_header_style_one', 'agency_eye_header_style_one');

// header style one
function agency_eye_header_style_two()
{

?>
	<div class="agency-eye-logo-section">
		<div class="container">
			<div class="head-logo-sec">
				<?php do_action('agency_eye_header_logo'); ?>
			</div>
		</div>
	</div>

	<div class="menu-bar text-center">
		<div class="container">
			<div class="agency-eye-container menu-inner">
				<?php do_action('agency_eye_main_menu'); ?>
			</div>
		</div>
	</div>
<?php
}
add_action('agency_eye_header_style_two', 'agency_eye_header_style_two');


// Agency Eye mobile menu
function agency_eye_mobile_menu_output()
{
?>
	<div class="mobile-menu-bar">
		<div class="container">
			<nav id="mobile-navigation" class="mobile-navigation">
				<button id="mmenu-btn" class="menu-btn" aria-expanded="false">
					<span class="mopen"><?php esc_html_e('Menu', 'agency-eye'); ?></span>
					<span class="mclose"><?php esc_html_e('Close', 'agency-eye'); ?></span>
				</button>
				<?php
				wp_nav_menu(array(
					'theme_location' => 'main-menu',
					'menu_id'        => 'wsm-menu',
					'menu_class'        => 'wsm-menu',
				));
				?>
			</nav><!-- #site-navigation -->
		</div>
	</div>

<?php
}
add_action('agency_eye_mobile_menu', 'agency_eye_mobile_menu_output');
