<?php

/**
 * Agency Eye Theme Customizer
 *
 * @package Agency Eye
 */



/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function agency_eye_customize_register($wp_customize)
{
    $wp_customize->get_setting('blogname')->transport         = 'postMessage';
    $wp_customize->get_setting('blogdescription')->transport  = 'postMessage';
    $wp_customize->get_setting('header_textcolor')->transport = 'postMessage';

    //select sanitization function
    function agency_eye_sanitize_select($input, $setting)
    {
        $input = sanitize_key($input);
        $choices = $setting->manager->get_control($setting->id)->choices;
        return (array_key_exists($input, $choices) ? $input : $setting->default);
    }
    function agency_eye_sanitize_image($file, $setting)
    {
        $mimes = array(
            'jpg|jpeg|jpe' => 'image/jpeg',
            'gif'          => 'image/gif',
            'png'          => 'image/png',
            'bmp'          => 'image/bmp',
            'tif|tiff'     => 'image/tiff',
            'ico'          => 'image/x-icon'
        );
        //check file type from file name
        $file_ext = wp_check_filetype($file, $mimes);
        //if file has a valid mime type return it, otherwise return default
        return ($file_ext['ext'] ? $file : $setting->default);
    }

    $wp_customize->add_setting('agency_eye_site_tagline_show', array(
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'default'       =>  '',
        'sanitize_callback' => 'absint',
        'transport'     => 'refresh',
    ));
    $wp_customize->add_control('agency_eye_site_tagline_show', array(
        'label'      => __('Hide Site Tagline Only? ', 'agency-eye'),
        'section'    => 'title_tagline',
        'settings'   => 'agency_eye_site_tagline_show',
        'type'       => 'checkbox',

    ));

    $wp_customize->add_panel('agency_eye_settings', array(
        'priority'       => 50,
        'title'          => __('Agency Eye Theme settings', 'agency-eye'),
        'description'    => __('All Agency Eye theme settings', 'agency-eye'),
    ));
    $wp_customize->add_section('agency_eye_header', array(
        'title' => __('Agency Eye Header Settings', 'agency-eye'),
        'capability'     => 'edit_theme_options',
        'description'     => __('Agency Eye theme header settings', 'agency-eye'),
        'panel'    => 'agency_eye_settings',

    ));
    $wp_customize->add_setting('agency_eye_main_menu_style', array(
        'default'        => 'style1',
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'agency_eye_sanitize_select',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('agency_eye_main_menu_style', array(
        'label'      => __('Main Menu Style', 'agency-eye'),
        'description' => __('You can set the menu style one or two. ', 'agency-eye'),
        'section'    => 'agency_eye_header',
        'settings'   => 'agency_eye_main_menu_style',
        'type'       => 'select',
        'choices'    => array(
            'style1' => __('Style One', 'agency-eye'),
            'style2' => __('Style Two', 'agency-eye'),
        ),
    ));

    //Agency Eye Home intro
    $wp_customize->add_section('agency_eye_hbanner', array(
        'title' => __('Home Intro Settings', 'agency-eye'),
        'capability'     => 'edit_theme_options',
        'description'     => __('Portfoli profile Intro Settings', 'agency-eye'),
        'panel'    => 'agency_eye_settings',

    ));
    $wp_customize->add_setting('agency_eye_hbanner_show', array(
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'default'       =>  1,
        'sanitize_callback' => 'absint',
        'transport'     => 'refresh',
    ));
    $wp_customize->add_control('agency_eye_hbanner_show', array(
        'label'      => __('Show Home Banner? ', 'agency-eye'),
        'section'    => 'agency_eye_hbanner',
        'settings'   => 'agency_eye_hbanner_show',
        'type'       => 'checkbox',

    ));
    $wp_customize->add_setting('agency_eye_hbanner_img', array(
        'capability'        => 'edit_theme_options',
        'default'           => get_template_directory_uri() . '/assets/img/banner.jpg',
        'sanitize_callback' => 'agency_eye_sanitize_image',
    ));
    $wp_customize->add_control(new WP_Customize_Image_Control(
        $wp_customize,
        'agency_eye_hbanner_img',
        array(
            'label'    => __('Upload Banner Image', 'agency-eye'),
            'description'    => __('Image size should be 450px width & 460px height for better view.', 'agency-eye'),
            'section'  => 'agency_eye_hbanner',
            'settings' => 'agency_eye_hbanner_img',
        )
    ));
    $wp_customize->add_setting('agency_eye_hbanner_subtitle', array(
        'default' => '',
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'sanitize_text_field',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('agency_eye_hbanner_subtitle', array(
        'label'      => __('Intro Subtitle', 'agency-eye'),
        'section'    => 'agency_eye_hbanner',
        'settings'   => 'agency_eye_hbanner_subtitle',
        'type'       => 'text',
    ));
    $wp_customize->add_setting('agency_eye_hbanner_title', array(
        'default' => __('Dependable Digital', 'agency-eye'),
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'sanitize_text_field',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('agency_eye_hbanner_title', array(
        'label'      => __('Intro Title', 'agency-eye'),
        'section'    => 'agency_eye_hbanner',
        'settings'   => 'agency_eye_hbanner_title',
        'type'       => 'text',
    ));
    $wp_customize->add_setting('agency_eye_color_title', array(
        'default' => __('Agency at Your Service!', 'agency-eye'),
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'sanitize_text_field',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('agency_eye_color_title', array(
        'label'      => __('Intro Color Title', 'agency-eye'),
        'section'    => 'agency_eye_hbanner',
        'settings'   => 'agency_eye_color_title',
        'type'       => 'text',
    ));

    $wp_customize->add_setting('agency_eye_hbanner_desc', array(
        'default' => '',
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'wp_kses_post',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('agency_eye_hbanner_desc', array(
        'label'      => __('Intro Description', 'agency-eye'),
        'section'    => 'agency_eye_hbanner',
        'settings'   => 'agency_eye_hbanner_desc',
        'type'       => 'textarea',
    ));
    $wp_customize->add_setting('agency_eye_btn_text_one', array(
        'default' => __('Our Services', 'agency-eye'),
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'sanitize_text_field',
        'transport' => 'postMessage',
    ));
    $wp_customize->add_control('agency_eye_btn_text_one', array(
        'label'      => __('Button one text', 'agency-eye'),
        'section'    => 'agency_eye_hbanner',
        'settings'   => 'agency_eye_btn_text_one',
        'type'       => 'text',
    ));

    $wp_customize->add_setting('agency_eye_btn_url_one', array(
        'default' => '#',
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'esc_url_raw',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('agency_eye_btn_url_one', array(
        'label'      => __('Button one url', 'agency-eye'),
        'description'      => __('Keep url empty for hide this button', 'agency-eye'),
        'section'    => 'agency_eye_hbanner',
        'settings'   => 'agency_eye_btn_url_one',
        'type'       => 'url',
    ));


    //Agency Eye blog settings
    $wp_customize->add_section('agency_eye_blog', array(
        'title' => __('Agency Eye Blog Settings', 'agency-eye'),
        'capability'     => 'edit_theme_options',
        'description'     => __('Agency Eye theme blog settings', 'agency-eye'),
        'panel'    => 'agency_eye_settings',

    ));
    $wp_customize->add_setting('agency_eye_blog_container', array(
        'default'        => 'container',
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'agency_eye_sanitize_select',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('agency_eye_blog_container', array(
        'label'      => __('Container type', 'agency-eye'),
        'description' => __('You can set standard container or full width container. ', 'agency-eye'),
        'section'    => 'agency_eye_blog',
        'settings'   => 'agency_eye_blog_container',
        'type'       => 'select',
        'choices'    => array(
            'container' => __('Standard Container', 'agency-eye'),
            'container-fluid' => __('Full width Container', 'agency-eye'),
        ),
    ));
    $wp_customize->add_setting('agency_eye_blog_layout', array(
        'default'        => 'fullwidth',
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'agency_eye_sanitize_select',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('agency_eye_blog_layout', array(
        'label'      => __('Select Blog Layout', 'agency-eye'),
        'description' => __('Right and Left sidebar only show when sidebar widget is available. ', 'agency-eye'),
        'section'    => 'agency_eye_blog',
        'settings'   => 'agency_eye_blog_layout',
        'type'       => 'select',
        'choices'    => array(
            'rightside' => __('Right Sidebar', 'agency-eye'),
            'leftside' => __('Left Sidebar', 'agency-eye'),
            'fullwidth' => __('No Sidebar', 'agency-eye'),
        ),
    ));
    $wp_customize->add_setting('agency_eye_blog_style', array(
        'default'        => 'grid',
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'agency_eye_sanitize_select',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('agency_eye_blog_style', array(
        'label'      => __('Select Blog Style', 'agency-eye'),
        'section'    => 'agency_eye_blog',
        'settings'   => 'agency_eye_blog_style',
        'type'       => 'select',
        'choices'    => array(
            'grid' => __('Grid Style', 'agency-eye'),
            'classic' => __('Classic Style', 'agency-eye'),
        ),
    ));
    //Agency Eye page settings
    $wp_customize->add_section('agency_eye_page', array(
        'title' => __('Agency Eye Page Settings', 'agency-eye'),
        'capability'     => 'edit_theme_options',
        'description'     => __('Agency Eye theme blog settings', 'agency-eye'),
        'panel'    => 'agency_eye_settings',

    ));
    $wp_customize->add_setting('agency_eye_page_container', array(
        'default'        => 'container',
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'agency_eye_sanitize_select',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('agency_eye_page_container', array(
        'label'      => __('Page Container type', 'agency-eye'),
        'description' => __('You can set standard container or full width container for page. ', 'agency-eye'),
        'section'    => 'agency_eye_page',
        'settings'   => 'agency_eye_page_container',
        'type'       => 'select',
        'choices'    => array(
            'container' => __('Standard Container', 'agency-eye'),
            'container-fluid' => __('Full width Container', 'agency-eye'),
        ),
    ));
    $wp_customize->add_setting('agency_eye_page_header', array(
        'default'        => 'show',
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'agency_eye_sanitize_select',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('agency_eye_page_header', array(
        'label'      => __('Show Page header', 'agency-eye'),
        'section'    => 'agency_eye_page',
        'settings'   => 'agency_eye_page_header',
        'type'       => 'select',
        'choices'    => array(
            'show' => __('Show all pages', 'agency-eye'),
            'hide-home' => __('Hide Only Front Page', 'agency-eye'),
            'hide' => __('Hide All Pages', 'agency-eye'),
        ),
    ));




    if (isset($wp_customize->selective_refresh)) {
        $wp_customize->selective_refresh->add_partial(
            'blogname',
            array(
                'selector'        => '.site-title a',
                'render_callback' => 'agency_eye_customize_partial_blogname',
            )
        );
        $wp_customize->selective_refresh->add_partial(
            'blogdescription',
            array(
                'selector'        => '.site-description',
                'render_callback' => 'agency_eye_customize_partial_blogdescription',
            )
        );
    }
}
add_action('customize_register', 'agency_eye_customize_register');

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function agency_eye_customize_partial_blogname()
{
    bloginfo('name');
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function agency_eye_customize_partial_blogdescription()
{
    bloginfo('description');
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function agency_eye_customize_preview_js()
{
    wp_enqueue_script('agency-eye-customizer', get_template_directory_uri() . '/assets/js/customizer.js', array('customize-preview'), AGENCY_EYE_VERSION, true);
}
add_action('customize_preview_init', 'agency_eye_customize_preview_js');
