<?php

/**
 * About setup
 *
 * @package Agency Eye
 */

require_once trailingslashit(get_template_directory()) . 'inc/about/class.about.php';

if (!function_exists('agency_eye_about_setup')) :

	/**
	 * About setup.
	 *
	 * @since 1.0.0
	 */
	function agency_eye_about_setup()
	{
		$theme = wp_get_theme();
		$xtheme_name = $theme->get('Name');

		$config = array(
			// Menu name under Appearance.
			'menu_name'               => sprintf(esc_html__('%s Info', 'agency-eye'), $xtheme_name),
			// Page title.
			'page_name'               => sprintf(esc_html__('%s Info', 'agency-eye'), $xtheme_name),
			/* translators: Main welcome title */
			'welcome_title'         => sprintf(esc_html__('Welcome to %s! - Version ', 'agency-eye'), $theme['Name']),
			// Main welcome content
			// Welcome content.
			'welcome_content' => sprintf(esc_html__('%1$s is now installed and ready to use. We want to make sure you have the best experience using the theme and that is why we gathered here all the necessary information for you. Thanks for using our theme!', 'agency-eye'), $theme['Name']),

			// Tabs.
			'tabs' => array(
				'getting_started' => esc_html__('Getting Started', 'agency-eye'),
				'recommended_actions' => esc_html__('Recommended Actions', 'agency-eye'),
				'useful_plugins'  => esc_html__('Useful Plugins', 'agency-eye'),
				'free_pro'  => esc_html__('Free Vs Pro', 'agency-eye'),
			),

			// Quick links.
			'quick_links' => array(
				'xmagazine_url' => array(
					'text'   => esc_html__('UPGRADE Agency Eye Pro', 'agency-eye'),
					'url'    => 'https://wpthemespace.com/product/agency-eye-pro/?add-to-cart=11430',
					'button' => 'danger',
				),
				'update_url' => array(
					'text'   => esc_html__('PortfoliX PRO Video', 'agency-eye'),
					'url'    => 'https://www.youtube.com/watch?v=pNlm-ArOHTM&t=18s',
					'button' => 'danger',
				),
			),

			// Getting started.
			'getting_started' => array(
				'one' => array(
					'title'       => esc_html__('Demo Content', 'agency-eye'),
					'icon'        => 'dashicons dashicons-layout',
					'description' => sprintf(esc_html__('Demo content is pro feature. To import sample demo content, %1$s plugin should be installed and activated. After plugin is activated, visit Import Demo Data menu under Appearance.', 'agency-eye'), esc_html__('One Click Demo Import', 'agency-eye')),
					'button_text' => esc_html__('UPGRADE For  Demo Content', 'agency-eye'),
					'button_url'  => 'https://wpthemespace.com/product/agency-eye-pro/?add-to-cart=11430',
					'button_type' => 'primary',
					'is_new_tab'  => true,
				),

				'two' => array(
					'title'       => esc_html__('Theme Options', 'agency-eye'),
					'icon'        => 'dashicons dashicons-admin-customizer',
					'description' => esc_html__('Theme uses Customizer API for theme options. Using the Customizer you can easily customize different aspects of the theme.', 'agency-eye'),
					'button_text' => esc_html__('Customize', 'agency-eye'),
					'button_url'  => wp_customize_url(),
					'button_type' => 'primary',
				),
				'three' => array(
					'title'       => esc_html__('Show Video', 'agency-eye'),
					'icon'        => 'dashicons dashicons-layout',
					'description' => sprintf(esc_html__('You may show Agency Eye short video for better understanding', 'agency-eye'), esc_html__('One Click Demo Import', 'agency-eye')),
					'button_text' => esc_html__('Show PortfoliX video', 'agency-eye'),
					'button_url'  => 'https://www.youtube.com/watch?v=pNlm-ArOHTM&t=18s',
					'button_type' => 'primary',
					'is_new_tab'  => true,
				),
				'five' => array(
					'title'       => esc_html__('Set Widgets', 'agency-eye'),
					'icon'        => 'dashicons dashicons-tagcloud',
					'description' => esc_html__('Set widgets in your sidebar, Offcanvas as well as footer.', 'agency-eye'),
					'button_text' => esc_html__('Add Widgets', 'agency-eye'),
					'button_url'  => admin_url() . '/widgets.php',
					'button_type' => 'link',
					'is_new_tab'  => true,
				),
				'six' => array(
					'title'       => esc_html__('Theme Preview', 'agency-eye'),
					'icon'        => 'dashicons dashicons-welcome-view-site',
					'description' => esc_html__('You can check out the theme demos for reference to find out what you can achieve using the theme and how it can be customized. Theme demo only work in pro theme', 'agency-eye'),
					'button_text' => esc_html__('View Demo', 'agency-eye'),
					'button_url'  => 'https://wpthemespace.com/product/agency-eye-pro/#demos',
					'button_type' => 'link',
					'is_new_tab'  => true,
				),
				'seven' => array(
					'title'       => esc_html__('Contact Support', 'agency-eye'),
					'icon'        => 'dashicons dashicons-sos',
					'description' => esc_html__('Got theme support question or found bug or got some feedbacks? Best place to ask your query is the dedicated Support forum for the theme.', 'agency-eye'),
					'button_text' => esc_html__('Contact Support', 'agency-eye'),
					'button_url'  => 'https://wpthemespace.com/support/',
					'button_type' => 'link',
					'is_new_tab'  => true,
				),
			),

			'useful_plugins'        => array(
				'description' => esc_html__('Theme supports some helpful WordPress plugins to enhance your site. But, please enable only those plugins which you need in your site. For example, enable WooCommerce only if you are using e-commerce.', 'agency-eye'),
				'already_activated_message' => esc_html__('Already activated', 'agency-eye'),
				'version_label' => esc_html__('Version: ', 'agency-eye'),
				'install_label' => esc_html__('Install and Activate', 'agency-eye'),
				'activate_label' => esc_html__('Activate', 'agency-eye'),
				'deactivate_label' => esc_html__('Deactivate', 'agency-eye'),
				'content'                   => array(
					array(
						'slug' => 'magical-addons-for-elementor',
						'icon' => 'svg',
					),
					array(
						'slug' => 'magical-products-display'
					),
					array(
						'slug' => 'magical-posts-display'
					),
					array(
						'slug' => 'click-to-top'
					),
					array(
						'slug' => 'gallery-box',
						'icon' => 'svg',
					),
					array(
						'slug' => 'magical-blocks'
					),
					array(
						'slug' => 'easy-share-solution',
						'icon' => 'svg',
					),
					array(
						'slug' => 'wp-edit-password-protected',
						'icon' => 'svg',
					),
				),
			),
			// Required actions array.
			'recommended_actions'        => array(
				'install_label' => esc_html__('Install and Activate', 'agency-eye'),
				'activate_label' => esc_html__('Activate', 'agency-eye'),
				'deactivate_label' => esc_html__('Deactivate', 'agency-eye'),
				'content'            => array(
					'magical-blocks' => array(
						'title'       => __('Magical Addons', 'agency-eye'),
						'description' => __('Now you can add or update your site elements very easily by Magical Products Display. Supercharge your Elementor block with highly customizable Magical Blocks For WooCommerce.', 'agency-eye'),
						'plugin_slug' => 'magical-addons-for-elementor',
						'id' => 'magical-addons-for-elementor'
					),
					'go-pro' => array(
						'title'       => '<a target="_blank" class="activate-now button button-danger" href="https://wpthemespace.com/product/agency-eye-pro/?add-to-cart=11430">' . __('UPGRADE Agency Eye Pro', 'agency-eye') . '</a>',
						'description' => __('You will get more frequent updates and quicker support with the Pro version.', 'agency-eye'),
						//'plugin_slug' => 'x-instafeed',
						'id' => 'go-pro'
					),

				),
			),
			// Free vs pro array.
			'free_pro'                => array(
				'free_theme_name'     => $xtheme_name,
				'pro_theme_name'      => $xtheme_name . __(' Pro', 'agency-eye'),
				'pro_theme_link'      => 'https://wpthemespace.com/product/agency-eye-pro/',
				/* translators: View link */
				'get_pro_theme_label' => sprintf(__('Get %s', 'agency-eye'), 'Agency Eye Pro'),
				'features'            => array(
					array(
						'title'       => esc_html__('Daring Design for Devoted Readers', 'agency-eye'),
						'description' => esc_html__('Agency Eye\'s design helps you stand out from the crowd and create an experience that your readers will love and talk about. With a flexible home page you have the chance to easily showcase appealing content with ease.', 'agency-eye'),
						'is_in_lite'  => 'true',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Mobile-Ready For All Devices', 'agency-eye'),
						'description' => esc_html__('Agency Eye makes room for your readers to enjoy your articles on the go, no matter the device their using. We shaped everything to look amazing to your audience.', 'agency-eye'),
						'is_in_lite'  => 'true',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Home slider', 'agency-eye'),
						'description' => esc_html__('Agency Eye gives you extra slider feature. You can create awesome home slider in this theme.', 'agency-eye'),
						'is_in_lite'  => 'true',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Widgetized Sidebars To Keep Attention', 'agency-eye'),
						'description' => esc_html__('Agency Eye comes with a widget-based flexible system which allows you to add your favorite widgets over the Sidebar as well as on offcanvas too.', 'agency-eye'),
						'is_in_lite'  => 'true',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Auto Set-up Feature', 'agency-eye'),
						'description' => esc_html__('You can import demo site only one click so you can setup your site like demo very easily.', 'agency-eye'),
						'is_in_lite'  => 'ture',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Multiple Header Layout', 'agency-eye'),
						'description' => esc_html__('Agency Eye gives you extra ways to showcase your header with miltiple layout option you can change it on the basis of your requirement', 'agency-eye'),
						'is_in_lite'  => 'true',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('One Click Demo install', 'agency-eye'),
						'description' => esc_html__('You can import demo site only one click so you can setup your site like demo very easily.', 'agency-eye'),
						'is_in_lite'  => 'ture',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Extra Drag and drop support', 'agency-eye'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Advanced Portfolio Filter', 'agency-eye'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Testimonial Carousel', 'agency-eye'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Diffrent Style Blog', 'agency-eye'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Flexible Home Page Design', 'agency-eye'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Pro Service Section', 'agency-eye'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Animation Home Text', 'agency-eye'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Advance Customizer Options', 'agency-eye'),
						'description' => esc_html__('Advance control for each element gives you different way of customization and maintained you site as you like and makes you feel different.', 'agency-eye'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Advance Pagination', 'agency-eye'),
						'description' => esc_html__('Multiple Option of pagination via customizer can be obtained on your site like Infinite scroll, Ajax Button On Click, Number as well as classical option are available.', 'agency-eye'),
						'is_in_lite'  => 'ture',
						'is_in_pro'   => 'true',
					),

					array(
						'title'       => esc_html__('Premium Support and Assistance', 'agency-eye'),
						'description' => esc_html__('We offer ongoing customer support to help you get things done in due time. This way, you save energy and time, and focus on what brings you happiness. We know our products inside-out and we can lend a hand to help you save resources of all kinds.', 'agency-eye'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('No Credit Footer Link', 'agency-eye'),
						'description' => esc_html__('You can easily remove the Theme: Agency Eye by Agency Eye copyright from the footer area and make the theme yours from start to finish.', 'agency-eye'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
				),
			),

		);

		agency_eye_About::init($config);
	}

endif;

add_action('after_setup_theme', 'agency_eye_about_setup');

/**
 * Pro notice text
 *
 */
function agency_eye_pnotice_output()
{

?>
	<div class="mgadin-hero">
		<div class="mge-info-content">
			<div class="mge-info-hello">
				<?php
				$current_theme = wp_get_theme();
				$current_theme_name = $current_theme->get('Name');
				$current_user = wp_get_current_user();

				$demo_link = esc_url('https://wpthemespace.com/product/agency-eye-pro/');
				$pro_link = esc_url('https://wpthemespace.com/product/agency-eye-pro/?add-to-cart=11430');

				esc_html_e('Hello, ', 'agency-eye');
				echo esc_html($current_user->display_name);
				?>

				<?php esc_html_e('👋🏻', 'agency-eye'); ?>
			</div>
			<div class="mge-info-desc">

				<div><?php printf(esc_html__('You are currently using the free version of the %s theme. But guess what? The Agency Eye Pro version is now available with lots of pro feature!! Simply activate the theme and follow the auto-setup, and your site will be ready with a ton of advanced features. Now you can create your agency\'s website like a pro with just a few clicks!!!! So why late get pro now?', 'agency-eye'), $current_theme_name); ?></div>

				<div class="mge-offer"><?php printf(esc_html__('Don\'t miss out on these incredible features - upgrade to Agency Eye Pro now! ', 'agency-eye'), $current_theme_name); ?></div>
			</div>
			<div class="mge-info-actions">
				<a href="<?php echo esc_url($pro_link); ?>" target="_blank" class="button button-primary upgrade-btn">
					<?php esc_html_e('Upgrade Pro', 'agency-eye'); ?>
				</a>
				<a href="<?php echo esc_url($demo_link); ?>" target="_blank" class="button button-primary demo-btn">
					<?php esc_html_e('Agency Eye Pro Details', 'agency-eye'); ?>
				</a>
				<button class="button button-info btnend"><?php esc_html_e('Dismiss this notice', 'agency-eye') ?></button>
			</div>

		</div>

	</div>
<?php
}


//Admin notice 
function agency_eye_new_optins_texts()
{
	$hide_date = get_option('agency_eye_text_info');
	if (!empty($hide_date)) {
		$clickhide = round((time() - strtotime($hide_date)) / 24 / 60 / 60);
		if ($clickhide < 28) {
			return;
		}
	}
?>
	<div class="mgadin-notice notice notice-success mgadin-theme-dashboard mgadin-theme-dashboard-notice mge is-dismissible meis-dismissible">
		<?php agency_eye_pnotice_output(); ?>
	</div>
<?php

}
add_action('admin_notices', 'agency_eye_new_optins_texts');


function agency_eye_new_optins_texts_init()
{

	if (isset($_GET['xbnotice']) && $_GET['xbnotice'] == 1) {
		update_option('agency_eye_text_info', current_time('mysql'));
	}
}
add_action('init', 'agency_eye_new_optins_texts_init');
