<?php
/*
*
* Home intro section
*
*
*/



function agency_eye_hbanner_section_output()
{
  $agency_eye_hbanner_show = get_theme_mod('agency_eye_hbanner_show', 1);
  if (empty($agency_eye_hbanner_show)) {
    return;
  }
  $agency_eye_dfimgh = get_template_directory_uri() . '/assets/img/banner.jpg';
  $agency_eye_hbanner_img = get_theme_mod('agency_eye_hbanner_img', $agency_eye_dfimgh);
  $agency_eye_hbanner_subtitle = get_theme_mod('agency_eye_hbanner_subtitle');
  $agency_eye_hbanner_title = get_theme_mod('agency_eye_hbanner_title', __('Dependable Digital', 'agency-eye'));
  $agency_eye_color_title = get_theme_mod('agency_eye_color_title', __('Agency at Your Service!', 'agency-eye'));
  $agency_eye_hbanner_desc = get_theme_mod('agency_eye_hbanner_desc');
  $agency_eye_btn_text_one = get_theme_mod('agency_eye_btn_text_one', __('Our Services', 'agency-eye'));
  $agency_eye_btn_url_one = get_theme_mod('agency_eye_btn_url_one', '#');

?>
  <!-- home -->
  <section class="aghome" id="home">
    <div id="ax-praticals"></div>
    <div class="ax-home-single-slide-all-content">
      <?php if ($agency_eye_hbanner_img) : ?>
        <div class="ax-home-bg">
          <img src="<?php echo esc_url($agency_eye_hbanner_img); ?>" alt="<?php esc_attr($agency_eye_hbanner_title); ?>">
        </div>
      <?php endif; ?>
      <div class="ax-home-details">
        <div class="container">
          <?php if ($agency_eye_hbanner_subtitle) : ?>
            <div class="ax-home-subtitle">
              <p><?php echo esc_html($agency_eye_hbanner_subtitle); ?></p>
            </div>
          <?php endif; ?>
          <?php if ($agency_eye_hbanner_title || $agency_eye_color_title) : ?>
            <div class="ax-home-title">
              <?php if ($agency_eye_hbanner_title) : ?>
                <h1><?php echo esc_html($agency_eye_hbanner_title); ?>
                </h1>
              <?php endif; ?>
              <?php if ($agency_eye_color_title) : ?>
                <h1 class="ax-section-title"><?php echo esc_html($agency_eye_color_title); ?>
                <?php endif; ?>
            </div>
          <?php endif; ?>
          <?php if ($agency_eye_hbanner_desc) : ?>
            <div class="ax-home-dres">
              <p><?php echo wp_kses_post($agency_eye_hbanner_desc); ?></p>
            </div>
          <?php endif; ?>
          <?php if ($agency_eye_btn_url_one) : ?>
            <div class="ax-home-btn">
              <a href="<?php echo esc_url($agency_eye_btn_url_one); ?>" class="ax-home-first-btn"><?php echo esc_html($agency_eye_btn_text_one); ?></a>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </section>

<?php
}
add_action('agency_eye_hbanner', 'agency_eye_hbanner_section_output');
