<?php
/**
 * Advance Automobile: Block Patterns
 *
 * @package  Advance Automobile
 * @since   1.0.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	register_block_pattern_category(
		'advance-automobile',
		array( 'label' => __( ' Advance Automobile', 'advance-automobile' ) )
	);
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {
	register_block_pattern(
		'advance-automobile/banner-section',
		array(
			'title'      => __( 'Banner Section', 'advance-automobile' ),
			'categories' => array( 'advance-automobile' ),
			'content'    => "<!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/theme-block-pattern/images/banner.png\",\"id\":418,\"dimRatio\":40,\"overlayColor\":\"white\",\"focalPoint\":{\"x\":\"0.16\",\"y\":\"0.56\"},\"align\":\"full\",\"className\":\"banner-section\"} -->\n<div class=\"wp-block-cover alignfull banner-section\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-white-background-color has-background-dim-40 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-418\" alt=\"\" src=\"" . esc_url(get_template_directory_uri()) . "/theme-block-pattern/images/banner.png\" style=\"object-position:16% 56%\" data-object-fit=\"cover\" data-object-position=\"16% 56%\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"66.66%\",\"className\":\"banner-section-content mx-md-5 px-md-5\"} -->\n<div class=\"wp-block-column banner-section-content mx-md-5 px-md-5\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1,\"style\":{\"color\":{\"text\":\"var(--secondary-color)\"},\"typography\":{\"fontSize\":\"30px\"}}} -->\n<h1 class=\"has-text-color\" style=\"color:var(--secondary-color);font-size:30px\">LOREM IPSUM IS SIMPLY DUMMY</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"var(--secondary-color)\"},\"typography\":{\"fontSize\":\"14px\"}},\"className\":\"mt-md-2\"} -->\n<p class=\"mt-md-2 has-text-color\" style=\"color:var(--secondary-color);font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"white\",\"style\":{\"color\":{\"background\":\"var(--primary-color)\"},\"border\":{\"radius\":\"5px\"},\"typography\":{\"fontSize\":\"12px\"}},\"className\":\"banner-section-btn mt-md-1\"} -->\n<div class=\"wp-block-button has-custom-font-size banner-section-btn mt-md-1\" style=\"font-size:12px\"><a class=\"wp-block-button__link has-white-color has-text-color has-background\" style=\"border-radius:5px;background-color:var(--primary-color)\">READ MORE</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'advance-automobile/contact-section',
		array(
			'title'      => __( 'contact-section', 'advance-automobile' ),
			'categories' => array( 'advance-automobile' ),
			'content'    => "<!-- wp:columns {\"className\":\"contact-section position-relative\"} -->\n<div class=\"wp-block-columns contact-section position-relative\"><!-- wp:column {\"verticalAlignment\":\"center\",\"style\":{\"color\":{\"background\":\"var(--primary-color)\"}},\"className\":\"contact-box\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center contact-box has-background\" style=\"background-color:var(--primary-color)\"><!-- wp:columns {\"className\":\"contact-box-content my-0\"} -->\n<div class=\"wp-block-columns contact-box-content my-0\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"33.33%\",\"className\":\"contact-icon-col\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center contact-icon-col\" style=\"flex-basis:33.33%\"><!-- wp:image {\"id\":642,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"" . esc_url(get_template_directory_uri()) . "/theme-block-pattern/images/Icon1.png\" alt=\"\" class=\"wp-image-642\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"103%\",\"className\":\"contact pt-lg-0 pt-md-2\"} -->\n<div class=\"wp-block-column contact pt-lg-0 pt-md-2\" style=\"flex-basis:103%\"><!-- wp:paragraph {\"align\":\"left\",\"textColor\":\"white\"} -->\n<p class=\"has-white-color has-text-color\"><strong>Lorem Ipsum</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"textColor\":\"white\",\"className\":\"contact-text my-0\"} -->\n<p class=\"contact-text my-0 has-white-color has-text-color\">09 Lorem ipsum united kingdom</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"style\":{\"color\":{\"background\":\"var(--secondary-color)\"}},\"className\":\"contact-box\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center contact-box has-background\" style=\"background-color:var(--secondary-color)\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"className\":\"contact-box-content my-0\"} -->\n<div class=\"wp-block-columns are-vertically-aligned-center contact-box-content my-0\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"30%\",\"className\":\"contact-icon-col\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center contact-icon-col\" style=\"flex-basis:30%\"><!-- wp:image {\"id\":499,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"" . esc_url(get_template_directory_uri()) . "/theme-block-pattern/images/Icon2.png\" alt=\"\" class=\"wp-image-499\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"103%\",\"className\":\"contact pt-lg-0 pt-md-2\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center contact pt-lg-0 pt-md-2\" style=\"flex-basis:103%\"><!-- wp:paragraph {\"textColor\":\"white\"} -->\n<p class=\"has-white-color has-text-color\"><strong>Lorem Ipsum</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"textColor\":\"white\",\"className\":\"contact-text my-0\"} -->\n<p class=\"contact-text my-0 has-white-color has-text-color\" id=\"contact-text-my-0\">Monday - Friday 7:30am-5:30pm</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"style\":{\"color\":{\"background\":\"var(--primary-color)\"}},\"className\":\"contact-box\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center contact-box has-background\" style=\"background-color:var(--primary-color)\"><!-- wp:columns {\"className\":\"contact-box-content my-0\"} -->\n<div class=\"wp-block-columns contact-box-content my-0\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"30%\",\"className\":\"contact-icon-col\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center contact-icon-col\" style=\"flex-basis:30%\"><!-- wp:image {\"id\":502,\"width\":47,\"height\":47,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"" . esc_url(get_template_directory_uri()) . "/theme-block-pattern/images/Icon3.png\" alt=\"\" class=\"wp-image-502\" width=\"47\" height=\"47\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"103%\",\"className\":\"contact pt-lg-0 pt-md-2\"} -->\n<div class=\"wp-block-column contact pt-lg-0 pt-md-2\" style=\"flex-basis:103%\"><!-- wp:paragraph {\"textColor\":\"white\"} -->\n<p class=\"has-white-color has-text-color\"><strong>Lorem Ipsum</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"textColor\":\"white\",\"className\":\"contact-text my-0\"} -->\n<p class=\"contact-text my-0 has-white-color has-text-color\">+011234567892 +02125469875</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->",
		)
	);

	register_block_pattern(
		'advance-automobile/service-section',
		array(
			'title'      => __( 'service-section', 'advance-automobile' ),
			'categories' => array( 'advance-automobile' ),
			'content'    => "<!-- wp:group {\"className\":\"service-section\"} -->\n<div class=\"wp-block-group service-section\"><!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"typography\":{\"fontSize\":\"32px\"},\"color\":{\"text\":\"var(--secondary-color)\"}},\"className\":\"pb-md-4 mt-md-5\"} -->\n<h2 class=\"has-text-align-center pb-md-4 mt-md-5 has-text-color\" style=\"color:var(--secondary-color);font-size:32px\">Our Services</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns {\"style\":{\"color\":{\"background\":\"#f9fefa\"}}} -->\n<div class=\"wp-block-columns has-background\" style=\"background-color:#f9fefa\"><!-- wp:column {\"className\":\"px-md-5 mx-md-3\"} -->\n<div class=\"wp-block-column px-md-5 mx-md-3\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"22px\"},\"color\":{\"text\":\"var(--primary-color)\"}}} -->\n<h3 class=\"has-text-color\" style=\"color:var(--primary-color);font-size:22px\">LOREM IPSUM IS SIMPLY DUMMY</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#2f3637\"}},\"className\":\"mt-md-3\"} -->\n<p class=\"mt-md-3 has-text-color\" style=\"color:#2f3637\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"white\",\"style\":{\"color\":{\"background\":\"var(--primary-color)\"},\"border\":{\"radius\":\"5px\"},\"typography\":{\"fontSize\":\"12px\"}},\"className\":\"service-section-btn mt-md-2\"} -->\n<div class=\"wp-block-button has-custom-font-size service-section-btn mt-md-2\" style=\"font-size:12px\"><a class=\"wp-block-button__link has-white-color has-text-color has-background\" style=\"border-radius:5px;background-color:var(--primary-color)\">EXLORE MORE</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":434,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"" . esc_url(get_template_directory_uri()) . "/theme-block-pattern/images/service.png\" alt=\"\" class=\"wp-image-434\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->",
		)
	);
}