<?php
/**
 * The template part for displaying grid post
 *
 * @package Advance Automobile
 * @subpackage advance-automobile
 * @since advance-automobile 1.0
 */
?>
<?php 
  $archive_year  = get_the_time('Y'); 
  $archive_month = get_the_time('m'); 
  $archive_day   = get_the_time('d'); 
?>
<div class="col-lg-4 col-md-4">
  <article class="page-box grid-box p-4 mb-4">
    <?php if( get_theme_mod( 'advance_automobile_show_image_grid_post',true) != '') { ?>
      <div class="box-img mb-3">
        <?php the_post_thumbnail(); ?>
      </div>
    <?php } ?>
    <div class="new-text">
      <?php if( get_theme_mod( 'advance_automobile_grid_post_date',true) != '' || get_theme_mod( 'advance_automobile_grid_post_author',true) != '' || get_theme_mod( 'advance_automobile_grid_post_comment',true) != '' || get_theme_mod( 'advance_automobile_grid_post_time',true) != '') { ?>
        <div class="metabox">
          <?php if( get_theme_mod( 'advance_automobile_grid_post_date',true) != '') { ?>
            <span class="entry-date me-1"><i class="<?php echo esc_attr(get_theme_mod('advance_automobile_grid_post_date_icon','fa fa-calendar')); ?> me-2"></i><a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day)); ?>"><?php echo esc_html( get_the_date() ); ?><span class="screen-reader-text"><?php echo esc_html( get_the_date() ); ?></span></a></span><span class="ms-1"><?php echo esc_html( get_theme_mod('advance_automobile_metabox_separator_grid_post','|') ); ?></span>
          <?php } ?>
          <?php if( get_theme_mod( 'advance_automobile_grid_post_author',true) != '') { ?>
            <span class="entry-author mx-1"><i class="<?php echo esc_attr(get_theme_mod('advance_automobile_grid_post_author_icon','fa fa-user')); ?> me-2"></i><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' )) ); ?>"><?php the_author(); ?><span class="screen-reader-text"><?php the_author(); ?></span></a></span><span class="ms-1"><?php echo esc_html( get_theme_mod('advance_automobile_metabox_separator_grid_post','|') ); ?></span>
          <?php } ?>
          <?php if( get_theme_mod( 'advance_automobile_grid_post_comment',true) != '') { ?>
            <span class="entry-comments mx-1"><i class="<?php echo esc_attr(get_theme_mod('advance_automobile_grid_post_comment_icon','fas fa-comments')); ?> me-2"></i><?php comments_number( __('0 Comments','advance-automobile'), __('0 Comments','advance-automobile'), __('% Comments','advance-automobile') ); ?></span><span class="ms-1"><?php echo esc_html( get_theme_mod('advance_automobile_metabox_separator_grid_post','|') ); ?></span>
          <?php } ?>
          <?php if( get_theme_mod( 'advance_automobile_grid_post_time',true) != '') { ?>
            <span class="entry-time mx-1"><i class="<?php echo esc_attr(get_theme_mod('advance_automobile_grid_post_time_icon','fas fa-clock')); ?> me-2"></i><?php echo esc_html( get_the_time() ); ?></span>
          <?php }?>
        </div>
      <?php }?>
      <h2 class="text-uppercase"><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo the_title_attribute(); ?>"><?php the_title(); ?><span class="screen-reader-text"><?php the_title(); ?></span></a></h2>
      <div class="entry-content">
          <p><?php $advance_automobile_grid_post_description = get_theme_mod('advance_automobile_grid_post_description_option', 'Excerpt Content');
		        if ( $advance_automobile_grid_post_description == 'Full Content' ) {
			        the_content();
		        }
            if ( $advance_automobile_grid_post_description == 'Excerpt Content' ) {
              if ( get_the_excerpt() ) {$advance_automobile_excerpt = get_the_excerpt();
                echo esc_html(advance_automobile_string_limit_words($advance_automobile_excerpt,esc_attr( get_theme_mod('advance_automobile_grid_excerpt_number', '20') )
                  ));
                echo esc_html( get_theme_mod('advance_automobile_grid_post_suffix_option', '...') );
              }}
            ?>
          </p>
      </div>
      <?php if( get_theme_mod('advance_automobile_button_text','Read More') != ''){ ?>
        <div class="read-more-btn mt-3">
          <a href="<?php the_permalink(); ?>" class="py-3 px-4"><?php echo esc_html(get_theme_mod('advance_automobile_button_text','Read More'));?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('advance_automobile_button_text','Read More'));?></span></a>
        </div>
      <?php } ?>
    </div>
    <div class="clearfix"></div>
  </article>
</div>