<?php
/**
 * Advance Automobile Theme Customizer
 *
 * @package Advance Automobile
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

function advance_automobile_customize_register($wp_customize) {

	load_template( trailingslashit( get_template_directory() ) . '/inc/icon-changer.php' );

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.logo .site-title a',
	 	'render_callback' => 'advance_automobile_customize_partial_blogname',
	));

	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => 'p.site-description',
		'render_callback' => 'advance_automobile_customize_partial_blogdescription',
	));

	//add home page setting pannel
	$wp_customize->add_panel('advance_automobile_panel_id', array(
		'priority'       => 12,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Theme Settings', 'advance-automobile'),
		'description'    => __('Description of what this panel does.', 'advance-automobile'),
	));	

	// font array
	$advance_automobile_font_array = array(
        '' => 'No Fonts',
        'Abril Fatface' => 'Abril Fatface',
        'Acme' => 'Acme',
        'Anton' => 'Anton',
        'Architects Daughter' => 'Architects Daughter',
        'Arimo' => 'Arimo',
        'Arsenal' => 'Arsenal', 
        'Arvo' => 'Arvo',
        'Alegreya' => 'Alegreya',
        'Alfa Slab One' => 'Alfa Slab One',
        'Averia Serif Libre' => 'Averia Serif Libre',
        'Bangers' => 'Bangers', 
        'Boogaloo' => 'Boogaloo',
        'Bad Script' => 'Bad Script',
        'Bitter' => 'Bitter',
        'Bree Serif' => 'Bree Serif',
        'BenchNine' => 'BenchNine', 
        'Cabin' => 'Cabin', 
        'Cardo' => 'Cardo',
        'Courgette' => 'Courgette',
        'Coming+Soon' => 'Coming+Soon',
        'Cherry Swash' => 'Cherry Swash',
        'Cormorant Garamond' => 'Cormorant Garamond',
        'Crimson Text' => 'Crimson Text',
        'Cuprum' => 'Cuprum', 
        'Cookie' => 'Cookie', 
        'Chewy' => 'Chewy', 
        'Days One' => 'Days One', 
        'Dosis' => 'Dosis',
        'Droid Sans' => 'Droid Sans',
        'Economica' => 'Economica',
        'Fredoka One' => 'Fredoka One',
        'Fjalla One' => 'Fjalla One',
        'Francois One' => 'Francois One',
        'Frank Ruhl Libre' => 'Frank Ruhl Libre',
        'Gloria Hallelujah' => 'Gloria Hallelujah',
        'Great Vibes' => 'Great Vibes',
        'Handlee' => 'Handlee', 
        'Hammersmith One' => 'Hammersmith One',
        'Inconsolata' => 'Inconsolata', 
        'Indie Flower' => 'Indie Flower', 
        'IM Fell English SC' => 'IM Fell English SC', 
        'Julius Sans One' => 'Julius Sans One',
        'Josefin Slab' => 'Josefin Slab', 
        'Josefin Sans' => 'Josefin Sans', 
        'Kanit' => 'Kanit', 
        'Lobster' => 'Lobster', 
        'Lato' => 'Lato',
        'Lora' => 'Lora', 
        'Libre Baskerville' =>'Libre Baskerville',
        'Lobster Two' => 'Lobster Two',
        'Merriweather' =>'Merriweather', 
        'Monda' => 'Monda',
        'Montserrat' => 'Montserrat',
        'Muli' => 'Muli', 
        'Marck Script' => 'Marck Script',
        'Noto Serif' => 'Noto Serif',
        'Noto Sans' => 'Noto Sans',
        'Open Sans' => 'Open Sans', 
        'Overpass' => 'Overpass',
        'Overpass Mono' => 'Overpass Mono',
        'Oxygen' => 'Oxygen', 
        'Orbitron' => 'Orbitron', 
        'Patua One' => 'Patua One', 
        'Pacifico' => 'Pacifico',
        'Padauk' => 'Padauk', 
        'Playball' => 'Playball',
        'Playfair Display' => 'Playfair Display', 
        'PT Sans' => 'PT Sans',
        'Philosopher' => 'Philosopher',
        'Permanent Marker' => 'Permanent Marker',
        'Poiret One' => 'Poiret One', 
        'Poppins' => 'Poppins',
        'Quicksand' => 'Quicksand', 
        'Quattrocento Sans' => 'Quattrocento Sans', 
        'Raleway' => 'Raleway', 
        'Rubik' => 'Rubik', 
        'Rokkitt' => 'Rokkitt', 
        'Roboto' => 'Roboto',
        'Roboto Condensed' => 'Roboto Condensed',
        'Russo One' => 'Russo One', 
        'Righteous' => 'Righteous', 
        'Slabo' => 'Slabo', 
        'Satisfy' => 'Satisfy',
        'Source Sans Pro' => 'Source Sans Pro', 
        'Shadows Into Light Two' =>'Shadows Into Light Two', 
        'Shadows Into Light' => 'Shadows Into Light', 
        'Sacramento' => 'Sacramento', 
        'Shrikhand' => 'Shrikhand', 
        'Tangerine' => 'Tangerine',
        'Unica One' => 'Unica One',
        'Ubuntu' => 'Ubuntu', 
        'VT323' => 'VT323', 
        'Varela Round' => 'Varela Round', 
        'Vampiro One' => 'Vampiro One',
        'Vollkorn' => 'Vollkorn',
        'Volkhov' => 'Volkhov', 
        'Yanone Kaffeesatz' => 'Yanone Kaffeesatz'
    );

	//Typography
	$wp_customize->add_section( 'advance_automobile_typography', array(
    	'title'      => __( 'Typography', 'advance-automobile' ),
		'priority'   => 30,
		'panel' => 'advance_automobile_panel_id'
	) );

	$wp_customize->add_setting('advance_automobile_typography_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_typography_premium_info',array(
		'type'=> 'hidden',
		'description' => "<p>". esc_html__('Upgrade to premium for more features.','advance-automobile') ."</p><a target='_blank' href='". esc_url(ADVANCE_AUTOMOBILE_BUY_NOW) ." '>". esc_html__('Upgrade to Pro','advance-automobile') ."</a>",
		'section'=> 'advance_automobile_typography'
	));
	
	// This is Paragraph Color picker setting
	$wp_customize->add_setting( 'advance_automobile_paragraph_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_paragraph_color', array(
		'label' => __('Paragraph Color', 'advance-automobile'),
		'section' => 'advance_automobile_typography',
		'settings' => 'advance_automobile_paragraph_color',
	)));

	//This is Paragraph FontFamily picker setting
	$wp_customize->add_setting('advance_automobile_paragraph_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control(
	    'advance_automobile_paragraph_font_family', array(
	    'section'  => 'advance_automobile_typography',
	    'label'    => __( 'Paragraph Fonts','advance-automobile'),
	    'type'     => 'select',
	    'choices'  => $advance_automobile_font_array,
	));

	$wp_customize->add_setting('advance_automobile_paragraph_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_paragraph_font_size',array(
		'label'	=> __('Paragraph Font Size','advance-automobile'),
		'section'	=> 'advance_automobile_typography',
		'setting'	=> 'advance_automobile_paragraph_font_size',
		'type'	=> 'text'
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'advance_automobile_atag_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_atag_color', array(
		'label' => __('"a" Tag Color', 'advance-automobile'),
		'section' => 'advance_automobile_typography',
		'settings' => 'advance_automobile_atag_color',
	)));

	//This is "a" Tag FontFamily picker setting
	$wp_customize->add_setting('advance_automobile_atag_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control(
	    'advance_automobile_atag_font_family', array(
	    'section'  => 'advance_automobile_typography',
	    'label'    => __( '"a" Tag Fonts','advance-automobile'),
	    'type'     => 'select',
	    'choices'  => $advance_automobile_font_array,
	));

	// This is "a" Tag Color picker setting
	$wp_customize->add_setting( 'advance_automobile_li_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_li_color', array(
		'label' => __('"li" Tag Color', 'advance-automobile'),
		'section' => 'advance_automobile_typography',
		'settings' => 'advance_automobile_li_color',
	)));

	//This is "li" Tag FontFamily picker setting
	$wp_customize->add_setting('advance_automobile_li_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control(
	    'advance_automobile_li_font_family', array(
	    'section'  => 'advance_automobile_typography',
	    'label'    => __( '"li" Tag Fonts','advance-automobile'),
	    'type'     => 'select',
	    'choices'  => $advance_automobile_font_array,
	));

	// This is H1 Color picker setting
	$wp_customize->add_setting( 'advance_automobile_h1_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_h1_color', array(
		'label' => __('H1 Color', 'advance-automobile'),
		'section' => 'advance_automobile_typography',
		'settings' => 'advance_automobile_h1_color',
	)));

	//This is H1 FontFamily picker setting
	$wp_customize->add_setting('advance_automobile_h1_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control(
	    'advance_automobile_h1_font_family', array(
	    'section'  => 'advance_automobile_typography',
	    'label'    => __( 'H1 Fonts','advance-automobile'),
	    'type'     => 'select',
	    'choices'  => $advance_automobile_font_array,
	));

	//This is H1 FontSize setting
	$wp_customize->add_setting('advance_automobile_h1_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_h1_font_size',array(
		'label'	=> __('H1 Font Size','advance-automobile'),
		'section'	=> 'advance_automobile_typography',
		'setting'	=> 'advance_automobile_h1_font_size',
		'type'	=> 'text'
	));

	// This is H2 Color picker setting
	$wp_customize->add_setting( 'advance_automobile_h2_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_h2_color', array(
		'label' => __('h2 Color', 'advance-automobile'),
		'section' => 'advance_automobile_typography',
		'settings' => 'advance_automobile_h2_color',
	)));

	//This is H2 FontFamily picker setting
	$wp_customize->add_setting('advance_automobile_h2_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control(
	    'advance_automobile_h2_font_family', array(
	    'section'  => 'advance_automobile_typography',
	    'label'    => __( 'h2 Fonts','advance-automobile'),
	    'type'     => 'select',
	    'choices'  => $advance_automobile_font_array,
	));

	//This is H2 FontSize setting
	$wp_customize->add_setting('advance_automobile_h2_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_h2_font_size',array(
		'label'	=> __('h2 Font Size','advance-automobile'),
		'section'	=> 'advance_automobile_typography',
		'setting'	=> 'advance_automobile_h2_font_size',
		'type'	=> 'text'
	));

	// This is H3 Color picker setting
	$wp_customize->add_setting( 'advance_automobile_h3_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_h3_color', array(
		'label' => __('h3 Color', 'advance-automobile'),
		'section' => 'advance_automobile_typography',
		'settings' => 'advance_automobile_h3_color',
	)));

	//This is H3 FontFamily picker setting
	$wp_customize->add_setting('advance_automobile_h3_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control(
	    'advance_automobile_h3_font_family', array(
	    'section'  => 'advance_automobile_typography',
	    'label'    => __( 'h3 Fonts','advance-automobile'),
	    'type'     => 'select',
	    'choices'  => $advance_automobile_font_array,
	));

	//This is H3 FontSize setting
	$wp_customize->add_setting('advance_automobile_h3_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_h3_font_size',array(
		'label'	=> __('h3 Font Size','advance-automobile'),
		'section'	=> 'advance_automobile_typography',
		'setting'	=> 'advance_automobile_h3_font_size',
		'type'	=> 'text'
	));

	// This is H4 Color picker setting
	$wp_customize->add_setting( 'advance_automobile_h4_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_h4_color', array(
		'label' => __('h4 Color', 'advance-automobile'),
		'section' => 'advance_automobile_typography',
		'settings' => 'advance_automobile_h4_color',
	)));

	//This is H4 FontFamily picker setting
	$wp_customize->add_setting('advance_automobile_h4_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control(
	    'advance_automobile_h4_font_family', array(
	    'section'  => 'advance_automobile_typography',
	    'label'    => __( 'h4 Fonts','advance-automobile'),
	    'type'     => 'select',
	    'choices'  => $advance_automobile_font_array,
	));

	//This is H4 FontSize setting
	$wp_customize->add_setting('advance_automobile_h4_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_h4_font_size',array(
		'label'	=> __('h4 Font Size','advance-automobile'),
		'section'	=> 'advance_automobile_typography',
		'setting'	=> 'advance_automobile_h4_font_size',
		'type'	=> 'text'
	));

	// This is H5 Color picker setting
	$wp_customize->add_setting( 'advance_automobile_h5_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_h5_color', array(
		'label' => __('h5 Color', 'advance-automobile'),
		'section' => 'advance_automobile_typography',
		'settings' => 'advance_automobile_h5_color',
	)));

	//This is H5 FontFamily picker setting
	$wp_customize->add_setting('advance_automobile_h5_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control(
	    'advance_automobile_h5_font_family', array(
	    'section'  => 'advance_automobile_typography',
	    'label'    => __( 'h5 Fonts','advance-automobile'),
	    'type'     => 'select',
	    'choices'  => $advance_automobile_font_array,
	));

	//This is H5 FontSize setting
	$wp_customize->add_setting('advance_automobile_h5_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_h5_font_size',array(
		'label'	=> __('h5 Font Size','advance-automobile'),
		'section'	=> 'advance_automobile_typography',
		'setting'	=> 'advance_automobile_h5_font_size',
		'type'	=> 'text'
	));

	// This is H6 Color picker setting
	$wp_customize->add_setting( 'advance_automobile_h6_color', array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_h6_color', array(
		'label' => __('h6 Color', 'advance-automobile'),
		'section' => 'advance_automobile_typography',
		'settings' => 'advance_automobile_h6_color',
	)));

	//This is H6 FontFamily picker setting
	$wp_customize->add_setting('advance_automobile_h6_font_family',array(
	  'default' => '',
	  'capability' => 'edit_theme_options',
	  'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control(
	    'advance_automobile_h6_font_family', array(
	    'section'  => 'advance_automobile_typography',
	    'label'    => __( 'h6 Fonts','advance-automobile'),
	    'type'     => 'select',
	    'choices'  => $advance_automobile_font_array,
	));

	//This is H6 FontSize setting
	$wp_customize->add_setting('advance_automobile_h6_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_h6_font_size',array(
		'label'	=> __('h6 Font Size','advance-automobile'),
		'section'	=> 'advance_automobile_typography',
		'setting'	=> 'advance_automobile_h6_font_size',
		'type'	=> 'text'
	));

  	$wp_customize->add_setting('advance_automobile_background_skin_mode',array(
        'default' => 'Transparent Background',
        'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control('advance_automobile_background_skin_mode',array(
        'type' => 'select',
        'label' => __('Background Type','advance-automobile'),
        'section' => 'background_image',
        'choices' => array(
            'With Background' => __('With Background','advance-automobile'),
            'Transparent Background' => __('Transparent Background','advance-automobile'),
        ),
	) );

	// woocommerce section
	$wp_customize->add_section('advance_automobile_woocommerce_settings', array(
		'title'    => __('WooCommerce Settings', 'advance-automobile'),
		'priority' => null,
		'panel'    => 'woocommerce',
	));

	$wp_customize->add_setting( 'advance_automobile_shop_page_sidebar',array(
		'default' => false,
		'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ) );
    $wp_customize->add_control('advance_automobile_shop_page_sidebar',array(
    	'type' => 'checkbox',
       	'label' => __('Show / Hide Shop Page Sidebar','advance-automobile'),
		'section' => 'advance_automobile_woocommerce_settings'
    ));

    // shop page sidebar alignment
    $wp_customize->add_setting('advance_automobile_shop_page_layout', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'advance_automobile_sanitize_choices',
	));
	$wp_customize->add_control('advance_automobile_shop_page_layout',array(
		'type'           => 'radio',
		'label'          => __('Shop Page layout', 'advance-automobile'),
		'section'        => 'advance_automobile_woocommerce_settings',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'advance-automobile'),
			'Right Sidebar' => __('Right Sidebar', 'advance-automobile'),
		),
	));

	$wp_customize->add_setting( 'advance_automobile_wocommerce_single_page_sidebar',array(
		'default' => false,
		'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ) );
    $wp_customize->add_control('advance_automobile_wocommerce_single_page_sidebar',array(
    	'type' => 'checkbox',
       	'label' => __('Show / Hide Single Product Page Sidebar','advance-automobile'),
		'section' => 'advance_automobile_woocommerce_settings'
    ));

    // single product page sidebar alignment
    $wp_customize->add_setting('advance_automobile_single_product_page_layout', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'advance_automobile_sanitize_choices',
	));
	$wp_customize->add_control('advance_automobile_single_product_page_layout',array(
		'type'           => 'radio',
		'label'          => __('Single product Page layout', 'advance-automobile'),
		'section'        => 'advance_automobile_woocommerce_settings',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'advance-automobile'),
			'Right Sidebar' => __('Right Sidebar', 'advance-automobile'),
		),
	));

	$wp_customize->add_setting('advance_automobile_show_related_products',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_show_related_products',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Related Product','advance-automobile'),
       'section' => 'advance_automobile_woocommerce_settings',
    ));

	$wp_customize->add_setting('advance_automobile_show_wooproducts_border',array(
       'default' => false,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_show_wooproducts_border',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Product Border','advance-automobile'),
       'section' => 'advance_automobile_woocommerce_settings',
    ));

    $wp_customize->add_setting( 'advance_automobile_wooproducts_per_columns' , array(
		'default'           => 4,
		'transport'         => 'refresh',
		'sanitize_callback' => 'advance_automobile_sanitize_choices',
	) );
	$wp_customize->add_control( 'advance_automobile_wooproducts_per_columns', array(
		'label'    => __( 'Display Product Per Columns', 'advance-automobile' ),
		'section'  => 'advance_automobile_woocommerce_settings',
		'type'     => 'select',
		'choices'  => array(
			'2' => '2',
			'3' => '3',
			'4' => '4',
			'5' => '5',
		),
	)  );

	$wp_customize->add_setting('advance_automobile_wooproducts_per_page',array(
		'default'	=> 9,
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));	
	$wp_customize->add_control('advance_automobile_wooproducts_per_page',array(
		'label'	=> __('Display Product Per Page','advance-automobile'),
		'section'	=> 'advance_automobile_woocommerce_settings',
		'type'		=> 'number'
	));

	$wp_customize->add_setting( 'advance_automobile_top_bottom_wooproducts_padding',array(
		'default' => 0,
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control( 'advance_automobile_top_bottom_wooproducts_padding',	array(
		'label' => esc_html__( 'Top Bottom Product Padding','advance-automobile' ),
		'section' => 'advance_automobile_woocommerce_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
		'type'		=> 'number'
	));

	$wp_customize->add_setting( 'advance_automobile_left_right_wooproducts_padding',array(
		'default' => 0,
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control( 'advance_automobile_left_right_wooproducts_padding',	array(
		'label' => esc_html__( 'Right Left Product Padding','advance-automobile' ),
		'section' => 'advance_automobile_woocommerce_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
		'type'		=> 'number'
	));

	$wp_customize->add_setting( 'advance_automobile_wooproducts_border_radius',array(
		'default' => 0,
		'sanitize_callback'	=> 'advance_automobile_sanitize_number_range',
	));
	$wp_customize->add_control('advance_automobile_wooproducts_border_radius',array(
		'label' => esc_html__( 'Product Border Radius','advance-automobile' ),
		'section' => 'advance_automobile_woocommerce_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
		'type' => 'range'
	));

	$wp_customize->add_setting( 'advance_automobile_wooproducts_box_shadow',array(
		'default' => 0,
		'sanitize_callback'	=> 'advance_automobile_sanitize_number_range',
	));
	$wp_customize->add_control('advance_automobile_wooproducts_box_shadow',array(
		'label' => esc_html__( 'Product Box Shadow','advance-automobile' ),
		'section' => 'advance_automobile_woocommerce_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
		'type'		=> 'range'
	));

	$wp_customize->add_setting('advance_automobile_products_navigation',array(
       'default' => 'Yes',
       'sanitize_callback'	=> 'advance_automobile_sanitize_choices'
    ));
    $wp_customize->add_control('advance_automobile_products_navigation',array(
       'type' => 'radio',
       'label' => __('Woocommerce Products Navigation','advance-automobile'),
       'choices' => array(
            'Yes' => __('Yes','advance-automobile'),
            'No' => __('No','advance-automobile'),
        ),
       'section' => 'advance_automobile_woocommerce_settings',
    ));

	$wp_customize->add_setting( 'advance_automobile_top_bottom_product_button_padding',array(
		'default' => 10,
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control('advance_automobile_top_bottom_product_button_padding',	array(
		'label' => esc_html__( 'Product Button Top Bottom Padding','advance-automobile' ),
		'section' => 'advance_automobile_woocommerce_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
		'type'		=> 'number',
	));

	$wp_customize->add_setting( 'advance_automobile_left_right_product_button_padding',array(
		'default' => 16,
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control('advance_automobile_left_right_product_button_padding',array(
		'label' => esc_html__( 'Product Button Right Left Padding','advance-automobile' ),
		'section' => 'advance_automobile_woocommerce_settings',
		'type'		=> 'number',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	));

	$wp_customize->add_setting( 'advance_automobile_product_button_border_radius',array(
		'default' => 0,
		'sanitize_callback'	=> 'advance_automobile_sanitize_number_range',
	));
	$wp_customize->add_control('advance_automobile_product_button_border_radius',array(
		'label' => esc_html__( 'Product Button Border Radius','advance-automobile' ),
		'section' => 'advance_automobile_woocommerce_settings',
		'type'		=> 'range',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
	));

	$wp_customize->add_setting('advance_automobile_align_product_sale',array(
        'default' => 'Right',
        'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control('advance_automobile_align_product_sale',array(
        'type' => 'radio',
        'label' => __('Product Sale Button Alignment','advance-automobile'),
        'section' => 'advance_automobile_woocommerce_settings',
        'choices' => array(
            'Right' => __('Right','advance-automobile'),
            'Left' => __('Left','advance-automobile'),
        ),
	) );

	$wp_customize->add_setting( 'advance_automobile_border_radius_product_sale',array(
		'default' => 0,
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control('advance_automobile_border_radius_product_sale', array(
        'label'  => __('Product Sale Button Border Radius','advance-automobile'),
        'section'  => 'advance_automobile_woocommerce_settings',
        'type'        => 'number',
        'input_attrs' => array(
        	'step'=> 1,
            'min' => 0,
            'max' => 50,
        )
    ) );

	$wp_customize->add_setting('advance_automobile_product_sale_font_size',array(
		'default'=> 14,
		'sanitize_callback'	=> 'advance_automobile_sanitize_float'
	));
	$wp_customize->add_control('advance_automobile_product_sale_font_size',array(
		'label'	=> __('Product Sale Button Font Size','advance-automobile'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'advance_automobile_woocommerce_settings',
		'type'=> 'number'
	));

	// sale button padding
	$wp_customize->add_setting( 'advance_automobile_sale_padding_top',array(
		'default' => 0,
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control( 'advance_automobile_sale_padding_top',	array(
		'label' => esc_html__( ' Product Sale Top Bottom Padding','advance-automobile' ),
		'section' => 'advance_automobile_woocommerce_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
		'type'		=> 'number'
	));

	$wp_customize->add_setting( 'advance_automobile_sale_padding_left',array(
		'default' => 0,
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control( 'advance_automobile_sale_padding_left',	array(
		'label' => esc_html__( ' Product Sale Left Right Padding','advance-automobile' ),
		'section' => 'advance_automobile_woocommerce_settings',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
		'type'		=> 'number'
	));

	// Add the Theme Color Option section.
	$wp_customize->add_section( 'advance_automobile_theme_color_option', array( 
		'panel' => 'advance_automobile_panel_id', 
		'title' => esc_html__( 'Theme Color Option', 'advance-automobile' ) )
	);

	$wp_customize->add_setting('advance_automobile_theme_color_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_theme_color_premium_info',array(
		'type'=> 'hidden',
		'description' => "<p>". esc_html__('Upgrade to premium for more features.','advance-automobile') ."</p><a target='_blank' href='". esc_url(ADVANCE_AUTOMOBILE_BUY_NOW) ." '>". esc_html__('Upgrade to Pro','advance-automobile') ."</a>",
		'section'=> 'advance_automobile_theme_color_option'
	));

  	$wp_customize->add_setting( 'advance_automobile_theme_color_first', array(
	    'default' => '#1a8129',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_theme_color_first', array(
  		'label' => __( 'First Color Option', 'advance-automobile' ),
  		'description' => __('One can change complete theme color on just one click.', 'advance-automobile'),
	    'section' => 'advance_automobile_theme_color_option',
	    'settings' => 'advance_automobile_theme_color_first',
  	)));

  	$wp_customize->add_setting( 'advance_automobile_theme_color_second', array(
	    'default' => '#06393a',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_theme_color_second', array(
  		'label' => __( 'Second Color Option', 'advance-automobile' ),
  		'description' => __('One can change complete theme color on just one click.', 'advance-automobile'),
	    'section' => 'advance_automobile_theme_color_option',
	    'settings' => 'advance_automobile_theme_color_second',
  	)));

	//Top Bar
	$wp_customize->add_section('advance_automobile_topbar',array(
		'title'	=> __('Topbar Section','advance-automobile'),
		'description'	=> __('Add topbar content','advance-automobile'),
		'priority'	=> null,
		'panel' => 'advance_automobile_panel_id',
	));

	$wp_customize->add_setting('advance_automobile_topbar_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_topbar_premium_info',array(
		'type'=> 'hidden',
		'description' => "<p>". esc_html__('Upgrade to premium for more features.','advance-automobile') ."</p><a target='_blank' href='". esc_url(ADVANCE_AUTOMOBILE_BUY_NOW) ." '>". esc_html__('Upgrade to Pro','advance-automobile') ."</a>",
		'section'=> 'advance_automobile_topbar'
	));

	//Show /Hide Topbar
	$wp_customize->add_setting( 'advance_automobile_display_topbar',array(
		'default' => true,
      	'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ) );
    $wp_customize->add_control('advance_automobile_display_topbar',array(
    	'type' => 'checkbox',
        'label' => __( 'Topbar','advance-automobile' ),
        'section' => 'advance_automobile_topbar'
    ));

    $wp_customize->add_setting('advance_automobile_search_option',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_search_option',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Search','advance-automobile'),
       'section' => 'advance_automobile_topbar'
    ));

	$wp_customize->add_setting('advance_automobile_search_icon',array(
		'default'	=> 'fas fa-search',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_search_icon',array(
		'label'	=> __('Search Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_topbar',
		'type'		=> 'icon'
	)));

    //Sticky Header
	$wp_customize->add_setting( 'advance_automobile_sticky_header',array(
		'default' => false,
      	'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ) );
    $wp_customize->add_control('advance_automobile_sticky_header',array(
    	'type' => 'checkbox',
        'label' => __( 'Sticky Header','advance-automobile' ),
        'section' => 'advance_automobile_topbar'
    ));

    $wp_customize->add_setting( 'advance_automobile_sticky_header_padding_settings', array(
		'default'=> '',
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	) );
	$wp_customize->add_control( 'advance_automobile_sticky_header_padding_settings', array(
		'label'       => esc_html__( 'Sticky Header Padding','advance-automobile' ),
		'section'     => 'advance_automobile_topbar',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('advance_automobile_mail_icon',array(
		'default'	=> 'fas fa-envelope',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_mail_icon',array(
		'label'	=> __('Mail Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_topbar',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('advance_automobile_mail1',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_email',
	));
	$wp_customize->add_control('advance_automobile_mail1',array(
		'label'	=> __('Mail Address','advance-automobile'),
		'section'	=> 'advance_automobile_topbar',
		'type'	=> 'text'
	));

	$wp_customize->add_setting('advance_automobile_book1',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('advance_automobile_book1',array(
		'label'	=> __('Button text','advance-automobile'),
		'section'	=> 'advance_automobile_topbar',
		'type'	=> 'text'
	));

	$wp_customize->add_setting('advance_automobile_book',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('advance_automobile_book',array(
		'label'	=> __('Add Link','advance-automobile'),
		'section'	=> 'advance_automobile_topbar',
		'setting'	=> 'advance_automobile_book',
		'type'	=> 'url'
	));

	//Social Icons
	$wp_customize->add_section('advance_automobile_social_icons',array(
		'title'	=> __('Social Icons Section','advance-automobile'),
		'description'	=> __('Add topbar content','advance-automobile'),
		'priority'	=> null,
		'panel' => 'advance_automobile_panel_id',
	));

	$wp_customize->add_setting('advance_automobile_social_icons_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_social_icons_premium_info',array(
		'type'=> 'hidden',
		'description' => "<p>". esc_html__('Upgrade to premium for more features.','advance-automobile') ."</p><a target='_blank' href='". esc_url(ADVANCE_AUTOMOBILE_BUY_NOW) ." '>". esc_html__('Upgrade to Pro','advance-automobile') ."</a>",
		'section'=> 'advance_automobile_social_icons'
	));

	$wp_customize->add_setting('advance_automobile_facebook_icon',array(
		'default'	=> 'fab fa-facebook-f',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_facebook_icon',array(
		'label'	=> __('Facebook Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_social_icons',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('advance_automobile_facebook_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('advance_automobile_facebook_url',array(
		'label'	=> __('Add Facebook link','advance-automobile'),
		'section'	=> 'advance_automobile_social_icons',
		'setting'	=> 'advance_automobile_facebook_url',
		'type'	=> 'url'
	));

	$wp_customize->add_setting('advance_automobile_twitter_icon',array(
		'default'	=> 'fab fa-twitter',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_twitter_icon',array(
		'label'	=> __('Twitter Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_social_icons',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('advance_automobile_twitter_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('advance_automobile_twitter_url',array(
		'label'	=> __('Add Twitter link','advance-automobile'),
		'section'	=> 'advance_automobile_social_icons',
		'setting'	=> 'advance_automobile_twitter_url',
		'type'	=> 'url'
	));

	$wp_customize->add_setting('advance_automobile_youtube_icon',array(
		'default'	=> 'fab fa-youtube',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_youtube_icon',array(
		'label'	=> __('Youtube Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_social_icons',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('advance_automobile_youtube_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('advance_automobile_youtube_url',array(
		'label'	=> __('Add Youtube link','advance-automobile'),
		'section'	=> 'advance_automobile_social_icons',
		'setting'	=> 'advance_automobile_youtube_url',
		'type'	=> 'url'
	));

	$wp_customize->add_setting('advance_automobile_linkedin_icon',array(
		'default'	=> 'fab fa-linkedin-in',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_linkedin_icon',array(
		'label'	=> __('Linkedin Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_social_icons',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('advance_automobile_linkedin_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('advance_automobile_linkedin_url',array(
		'label'	=> __('Add Linkedin link','advance-automobile'),
		'section'	=> 'advance_automobile_social_icons',
		'setting'	=> 'advance_automobile_linkedin_url',
		'type'	=> 'url'
	));

	// navigation menu 
	$wp_customize->add_section( 'advance_automobile_menu_settings' , array(
    	'title'      => __( 'Menus Settings', 'advance-automobile' ),
		'priority'   => null,
		'panel' => 'advance_automobile_panel_id'
	) );

	$wp_customize->add_setting('advance_automobile_menu_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_menu_premium_info',array(
		'type'=> 'hidden',
		'description' => "<p>". esc_html__('Upgrade to premium for more features.','advance-automobile') ."</p><a target='_blank' href='". esc_url(ADVANCE_AUTOMOBILE_BUY_NOW) ." '>". esc_html__('Upgrade to Pro','advance-automobile') ."</a>",
		'section'=> 'advance_automobile_menu_settings'
	));

	$wp_customize->add_setting('advance_automobile_menu_text_tranform_option',array(
        'default' => 'Uppercase',
        'sanitize_callback' => 'advance_automobile_sanitize_choices'
    ));
    $wp_customize->add_control('advance_automobile_menu_text_tranform_option',array(
        'type' => 'radio',
        'label' => __('Menus Text Transform','advance-automobile'),
        'section' => 'advance_automobile_menu_settings',
        'choices' => array(
            'Uppercase' => __('Uppercase','advance-automobile'),
            'Capitalize' => __('Capitalize','advance-automobile'),
            'Lowercase' => __('Lowercase','advance-automobile'),
        ),
	) );

	$wp_customize->add_setting('advance_automobile_menu_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control('advance_automobile_menu_font_size',array(
		'label'	=> __('Menus Font Size','advance-automobile'),
		'section'=> 'advance_automobile_menu_settings',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'type'=> 'number'
	));

	$wp_customize->add_setting('advance_automobile_menu_weight',array(
		'default'=> '',
		'sanitize_callback'	=> 'advance_automobile_sanitize_choices',
	));
	$wp_customize->add_control('advance_automobile_menu_weight',array(
		'label'	=> __('Menus Font Weight ','advance-automobile'),
		'section'=> 'advance_automobile_menu_settings',
		'type' => 'select',
		'choices' => array(
            '100' => __('100','advance-automobile'),
            '200' => __('200','advance-automobile'),
            '300' => __('300','advance-automobile'),
            '400' => __('400','advance-automobile'),
            '500' => __('500','advance-automobile'),
            '600' => __('600','advance-automobile'),
            '700' => __('700','advance-automobile'),
            '800' => __('800','advance-automobile'),
            '900' => __('900','advance-automobile'),
        ),
	));

	$wp_customize->add_setting('advance_automobile_menu_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control('advance_automobile_menu_padding',array(
		'label'	=> __('Menus Padding','advance-automobile'),
		'section'=> 'advance_automobile_menu_settings',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'type'=> 'number'
	));

	$wp_customize->add_setting('advance_automobile_menus_item_style',array(
		'default' => '',
		'transport' => 'refresh',
		'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control('advance_automobile_menus_item_style',array(
		'type' => 'select',
		'section' => 'advance_automobile_menu_settings',
		'label' => __('Menu Hover Effect','advance-automobile'),
		'choices' => array(
			'None' => __('None','advance-automobile'),
			'Zoom In' => __('Zoom In','advance-automobile'),
		),
	) );

	$wp_customize->add_setting( 'advance_automobile_menu_color_settings', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_menu_color_settings', array(
  		'label' => __('Menu Color', 'advance-automobile'),
	    'section' => 'advance_automobile_menu_settings',
	    'settings' => 'advance_automobile_menu_color_settings',
  	)));

  	$wp_customize->add_setting( 'advance_automobile_menu_hover_color_settings', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_menu_hover_color_settings', array(
  		'label' => __('Menu Hover Color', 'advance-automobile'),
	    'section' => 'advance_automobile_menu_settings',
	    'settings' => 'advance_automobile_menu_hover_color_settings',
  	)));
  
  	$wp_customize->add_setting( 'advance_automobile_submenu_color_settings', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_submenu_color_settings', array(
  		'label' => __('Sub-menu Color', 'advance-automobile'),
	    'section' => 'advance_automobile_menu_settings',
	    'settings' => 'advance_automobile_submenu_color_settings',
  	)));

  	$wp_customize->add_setting( 'advance_automobile_submenu_hover_color_settings', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_submenu_hover_color_settings', array(
  		'label' => __('Sub-menu Hover Color', 'advance-automobile'),
	    'section' => 'advance_automobile_menu_settings',
	    'settings' => 'advance_automobile_submenu_hover_color_settings',
  	)));
	
	//Slider
	$wp_customize->add_section( 'advance_automobile_slider' , array(
    	'title'      => __( 'Slider Settings', 'advance-automobile' ),
		'priority'   => null,
		'panel' => 'advance_automobile_panel_id'
	) );

	$wp_customize->add_setting('advance_automobile_slider_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_slider_premium_info',array(
		'type'=> 'hidden',
		'label'	=> __('Premium Features','advance-automobile'),
		'description' => "<ul><li>". esc_html__('You can change how many slides there are.','advance-automobile') ."</li><li>". esc_html__('You can change the font family and the colours of headings and subheadings.','advance-automobile') ."</li><li>". esc_html__('And so on...','advance-automobile') ."</li></ul><a target='_blank' href='". esc_url(ADVANCE_AUTOMOBILE_BUY_NOW) ." '>". esc_html__('Upgrade to Pro','advance-automobile') ."</a>",
		'section'=> 'advance_automobile_slider'
	));

	$wp_customize->add_setting('advance_automobile_slider_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_slider_hide',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide slider','advance-automobile'),
       'section' => 'advance_automobile_slider'
    ));

    $wp_customize->add_setting('advance_automobile_slider_title_Show_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_slider_title_Show_hide',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Slider Title','advance-automobile'),
       'section' => 'advance_automobile_slider'
    ));

    $wp_customize->add_setting('advance_automobile_slider_content_Show_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_slider_content_Show_hide',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Slider Content','advance-automobile'),
       'section' => 'advance_automobile_slider'
    ));

    $wp_customize->add_setting('advance_automobile_slider_button_show_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_slider_button_show_hide',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Slider Button','advance-automobile'),
       'section' => 'advance_automobile_slider'
    ));

	for ( $count = 1; $count <= 4; $count++ ) {

		$wp_customize->add_setting( 'advance_automobile_slider_page' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'advance_automobile_sanitize_dropdown_pages'
		) );
		$wp_customize->add_control( 'advance_automobile_slider_page' . $count, array(
			'label'    => __( 'Select Slide Image Page', 'advance-automobile' ),
			'description'	=> __('Size of image should be 1600 x 633','advance-automobile'),
			'section'  => 'advance_automobile_slider',
			'type'     => 'dropdown-pages'
		) );
	}

	$wp_customize->add_setting('advance_automobile_slider_overlay',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_slider_overlay',array(
       'type' => 'checkbox',
       'label' => __('Home Page Slider Overlay','advance-automobile'),
		'description'    => __('This option will add colors over the slider.','advance-automobile'),
       'section' => 'advance_automobile_slider'
    ));

    $wp_customize->add_setting('advance_automobile_slider_image_overlay_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'advance_automobile_slider_image_overlay_color', array(
		'label'    => __('Home Page Slider Overlay Color', 'advance-automobile'),
		'section'  => 'advance_automobile_slider',
		'description'    => __('It will add the color overlay of the slider. To make it transparent, use the below option.','advance-automobile'),
		'settings' => 'advance_automobile_slider_image_overlay_color',
	)));

    //Slider excerpt
	$wp_customize->add_setting( 'advance_automobile_slider_excerpt_length', array(
		'default'              => 20,
		'sanitize_callback'	=> 'absint',
	) );
	$wp_customize->add_control( 'advance_automobile_slider_excerpt_length', array(
		'label'       => esc_html__( 'Slider Excerpt length','advance-automobile' ),
		'section'     => 'advance_automobile_slider',
		'type'        => 'number',
		'settings'    => 'advance_automobile_slider_excerpt_length',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	//Opacity
	$wp_customize->add_setting('advance_automobile_slider_image_opacity',array(
      'default'              => 1,
      'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control( 'advance_automobile_slider_image_opacity', array(
	'label'       => esc_html__( 'Slider Image Opacity','advance-automobile' ),
	'section'     => 'advance_automobile_slider',
	'type'        => 'select',
	'settings'    => 'advance_automobile_slider_image_opacity',
	'choices' => array(
		'0' =>  esc_attr__('0','advance-automobile'),
		'0.1' =>  esc_attr__('0.1','advance-automobile'),
		'0.2' =>  esc_attr__('0.2','advance-automobile'),
		'0.3' =>  esc_attr__('0.3','advance-automobile'),
		'0.4' =>  esc_attr__('0.4','advance-automobile'),
		'0.5' =>  esc_attr__('0.5','advance-automobile'),
		'0.6' =>  esc_attr__('0.6','advance-automobile'),
		'0.7' =>  esc_attr__('0.7','advance-automobile'),
		'0.8' =>  esc_attr__('0.8','advance-automobile'),
		'0.9' =>  esc_attr__('0.9','advance-automobile')
	),
	));

	$wp_customize->add_setting( 'advance_automobile_slider_speed_option',array(
		'default' => 3000,
		'sanitize_callback'    => 'advance_automobile_sanitize_number_range',
	));
	$wp_customize->add_control( 'advance_automobile_slider_speed_option',array(
		'label' => esc_html__( 'Slider Speed Option','advance-automobile' ),
		'section' => 'advance_automobile_slider',
		'type'        => 'range',
		'input_attrs' => array(
			'min' => 1000,
			'max' => 5000,
			'step' => 500,
		),
	));

	$wp_customize->add_setting('advance_automobile_slider_image_height',array(
		'default'=> __('','advance-automobile'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_slider_image_height',array(
		'label'	=> __('Slider Image Height','advance-automobile'),
		'section'=> 'advance_automobile_slider',
		'type'=> 'text'
	));

	$wp_customize->add_setting('advance_automobile_slider_button',array(
		'default'=> __('Read More','advance-automobile'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_slider_button',array(
		'label'	=> __('Slider Button Text','advance-automobile'),
		'section'=> 'advance_automobile_slider',
		'type'=> 'text'
	));

	$wp_customize->add_setting('advance_automobile_slider_button_url',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('advance_automobile_slider_button_url',array(
		'label'	=> esc_html__('Add Button Link','advance-automobile'),
		'section'=> 'advance_automobile_slider',
		'type'=> 'url'
	));

	$wp_customize->add_setting('advance_automobile_slider_btn_bg_color', array(
		'default'           => 'var(--primary-color)',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'advance_automobile_slider_btn_bg_color', array(
		'label'    => __('Slider Button Background Color', 'advance-automobile'),
		'section'  => 'advance_automobile_slider',
	)));

	$wp_customize->add_setting('advance_automobile_top_bottom_slider_content_space',array(
		'default'=> '',
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control('advance_automobile_top_bottom_slider_content_space',array(
		'label'	=> __('Top Bottom Slider Content Space','advance-automobile'),
		'section'=> 'advance_automobile_slider',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'type'=> 'number'
	));

	$wp_customize->add_setting('advance_automobile_left_right_slider_content_space',array(
		'default'=> '',
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control('advance_automobile_left_right_slider_content_space',array(
		'label'	=> __('Left Right Slider Content Space','advance-automobile'),
		'section'=> 'advance_automobile_slider',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'type'=> 'number'
	));
	
	//contact details
	$wp_customize->add_section('advance_automobile_contact_details',array(
		'title'	=> __('Contact details','advance-automobile'),
		'description'	=> __('Add Contact Details here','advance-automobile'),
		'priority'	=> null,
		'panel' => 'advance_automobile_panel_id',
	));

	$wp_customize->add_setting('advance_automobile_contact_details_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_contact_details_premium_info',array(
		'type'=> 'hidden',
		'label'	=> __('Premium Features','advance-automobile'),
		'description' => "<ul><li>". esc_html__('For more settings and features, please explore our premium theme.','advance-automobile') ."</li></ul><a target='_blank' href='". esc_url(ADVANCE_AUTOMOBILE_BUY_NOW) ." '>". esc_html__('Upgrade to Pro','advance-automobile') ."</a>",
		'section'=> 'advance_automobile_contact_details'
	));

	$wp_customize->add_setting('advance_automobile_address',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('advance_automobile_address',array(
		'label'	=> __('Address Text','advance-automobile'),
		'section'	=> 'advance_automobile_contact_details',
		'type'	=> 'text'
	));

	$wp_customize->add_setting('advance_automobile_address1',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('advance_automobile_address1',array(
		'label'	=> __('Address ','advance-automobile'),
		'section'	=> 'advance_automobile_contact_details',
		'type'	=> 'text'
	));

	$wp_customize->add_setting('advance_automobile_time',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('advance_automobile_time',array(
		'label'	=> __('Timing Text','advance-automobile'),
		'section'	=> 'advance_automobile_contact_details',
		'type'	=> 'text'
	));

	$wp_customize->add_setting('advance_automobile_time1',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('advance_automobile_time1',array(
		'label'	=> __('Open at','advance-automobile'),
		'section'	=> 'advance_automobile_contact_details',
		'type'	=> 'text'
	));
	
	$wp_customize->add_setting('advance_automobile_call',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('advance_automobile_call',array(
		'label'	=> __('Call Text','advance-automobile'),
		'section'	=> 'advance_automobile_contact_details',
		'type'	=> 'text'
	));

	$wp_customize->add_setting('advance_automobile_call1',array(
		'default'	=> '',
		'sanitize_callback'	=> 'advance_automobile_sanitize_phone_number',
	));
	$wp_customize->add_control('advance_automobile_call1',array(
		'label'	=> __('Phone Number','advance-automobile'),
		'section'	=> 'advance_automobile_contact_details',
		'type'	=> 'text'
	));

	//Our Services
  	$wp_customize->add_section('advance_automobile_category_section',array(
	    'title' => __('Our Services','advance-automobile'),
	    'description' => '',
	    'priority'  => null,
	    'panel' => 'advance_automobile_panel_id',
	)); 

	$wp_customize->add_setting('advance_automobile_services_sec_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_services_sec_premium_info',array(
		'type'=> 'hidden',
		'label'	=> __('Premium Features','advance-automobile'),
		'description' => "<ul><li>". esc_html__('Includes settings to set section title.','advance-automobile') ."</li><li>". esc_html__('Contains settings for the background colour.','advance-automobile') ."</li><li>". esc_html__('Contains options for background images.','advance-automobile') ."</li><li>". esc_html__('You can change the font family and colours of heading.','advance-automobile') ."</li><li>". esc_html__('And so on...','advance-automobile') ."</li></ul><a target='_blank' href='". esc_url(ADVANCE_AUTOMOBILE_BUY_NOW) ." '>". esc_html__('Upgrade to Pro','advance-automobile') ."</a>",
		'section'=> 'advance_automobile_category_section'
	));

	$wp_customize->add_setting('advance_automobile_our_services_title',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('advance_automobile_our_services_title',array(
		'label'	=> __('Section Title','advance-automobile'),
		'section'	=> 'advance_automobile_category_section',
		'setting'	=> 'advance_automobile_our_services_title',
		'type'		=> 'text'
	));

	// category 
	$categories = get_categories();
	$cats = array();
	$i = 0;
	$cat_post[]= 'select';
	foreach($categories as $category){
		if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cat_post[$category->slug] = $category->name;
	}

    $wp_customize->add_setting('advance_automobile_category3',array(
	    'default' => 'select',
	    'sanitize_callback' => 'advance_automobile_sanitize_choices',
  	));
  	$wp_customize->add_control('advance_automobile_category3',array(
	    'type'    => 'select',
	    'choices' => $cat_post,
	    'label' => __('Select Category to display Latest Post','advance-automobile'),
	    'description'	=> __('Size of image should be 570 x 380','advance-automobile'),
	    'section' => 'advance_automobile_category_section',
	));

	$wp_customize->add_setting( 'advance_automobile_category_button_text', array(
		'default'   => __('EXPLORE MORE','advance-automobile' ),
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'advance_automobile_category_button_text', array(
		'label'    => __( 'Category Post Button text','advance-automobile' ),
		'section'  => 'advance_automobile_category_section',
		'type'     => 'text',
		'settings' => 'advance_automobile_category_button_text'
	) );

	//Blog Post
	$wp_customize->add_section('advance_automobile_blog_post',array(
		'title'	=> __('Blog Page Settings','advance-automobile'),
		'panel' => 'advance_automobile_panel_id',
	));	

	$wp_customize->add_setting('advance_automobile_blog_post_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_blog_post_premium_info',array(
		'type'=> 'hidden',
		'description' => "<p>". esc_html__('Upgrade to premium for more features.','advance-automobile') ."</p><a target='_blank' href='". esc_url(ADVANCE_AUTOMOBILE_BUY_NOW) ." '>". esc_html__('Upgrade to Pro','advance-automobile') ."</a>",
		'section'=> 'advance_automobile_blog_post'
	));

	$wp_customize->selective_refresh->add_partial( 'advance_automobile_date_hide', array(
		'selector' => '.our-services .page-box',
		'render_callback' => 'advance_automobile_customize_partial_advance_automobile_date_hide',
	));

	$wp_customize->add_setting('advance_automobile_date_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_date_hide',array(
       'type' => 'checkbox',
       'label' => __('Post Date','advance-automobile'),
       'section' => 'advance_automobile_blog_post'
    ));

	$wp_customize->add_setting('advance_automobile_date_icon',array(
		'default'	=> 'fa fa-calendar',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_date_icon',array(
		'label'	=> __('Post Date Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_blog_post',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('advance_automobile_author_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_author_hide',array(
       'type' => 'checkbox',
       'label' => __('Author','advance-automobile'),
       'section' => 'advance_automobile_blog_post'
    ));

	$wp_customize->add_setting('advance_automobile_author_icon',array(
		'default'	=> 'fa fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_author_icon',array(
		'label'	=> __('Author Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_blog_post',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('advance_automobile_comment_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_comment_hide',array(
       'type' => 'checkbox',
       'label' => __('Comments','advance-automobile'),
       'section' => 'advance_automobile_blog_post'
    ));

	$wp_customize->add_setting('advance_automobile_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_comment_icon',array(
		'label'	=> __('Comments Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_blog_post',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('advance_automobile_time_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_time_hide',array(
       'type' => 'checkbox',
       'label' => __('Time','advance-automobile'),
       'section' => 'advance_automobile_blog_post'
    ));

	$wp_customize->add_setting('advance_automobile_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_time_icon',array(
		'label'	=> __('Time Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_blog_post',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('advance_automobile_show_post_category',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_show_post_category',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Category','advance-automobile'),
       'section' => 'advance_automobile_blog_post'
    ));

    $wp_customize->add_setting('advance_automobile_show_featured_image_post',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_show_featured_image_post',array(
       'type' => 'checkbox',
       'label' => __('Blog Post Image','advance-automobile'),
       'section' => 'advance_automobile_blog_post'
    ));

    $wp_customize->add_setting( 'advance_automobile_featured_img_border_radius', array(
		'default'=> 0,
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	) );
	$wp_customize->add_control( 'advance_automobile_featured_img_border_radius', array(
		'label'       => esc_html__( 'Blog Post Image Border Radius','advance-automobile' ),
		'section'     => 'advance_automobile_blog_post',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 100,
		),
	) );

	$wp_customize->add_setting( 'advance_automobile_featured_img_shadow',array(
		'default' => 0,
		'sanitize_callback'    => 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control('advance_automobile_featured_img_shadow',array(
		'label' => esc_html__( 'Blog Post Image Shadow','advance-automobile' ),
		'section' => 'advance_automobile_blog_post',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
		'type' => 'number'
	));

	// Image Dimension Option
	$wp_customize->add_setting('advance_automobile_blog_image_dimension', array(
		'default'           => 'default',
		'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control('advance_automobile_blog_image_dimension', array(
		'type'    => 'radio',
		'label'   => __('Blog Post Featured Image Dimension', 'advance-automobile'),
		'section' => 'advance_automobile_blog_post',
		'choices' => array(
			'default' => __('Default', 'advance-automobile'),
			'custom'  => __('Custom Image Size', 'advance-automobile'),
		),
	));

	// Custom Width 
	$wp_customize->add_setting('advance_automobile_feature_image_custom_width', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_feature_image_custom_width', array(
		'label'       => __('Featured Image Custom Width', 'advance-automobile'),
		'section'     => 'advance_automobile_blog_post',
		'description' => __('Measurement is in pixel.', 'advance-automobile'),
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 800,
			'step' => 1,
		),
		'type'             => 'number',
		'active_callback'  => 'advance_automobile_blog_image_dimension'
	));

	// Custom Height 
	$wp_customize->add_setting('advance_automobile_feature_image_custom_height', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_feature_image_custom_height', array(
		'label'       => __('Featured Image Custom Height', 'advance-automobile'),
		'section'     => 'advance_automobile_blog_post',
		'description' => __('Measurement is in pixel.', 'advance-automobile'),
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 500,
			'step' => 1,
		),
		'type'             => 'number',
		'active_callback'  => 'advance_automobile_blog_image_dimension'
	));

	$wp_customize->add_setting('advance_automobile_show_first_caps',array(
        'default' => false,
        'sanitize_callback' => 'advance_automobile_sanitize_checkbox',
    ));
	$wp_customize->add_control( 'advance_automobile_show_first_caps',array(
		'label' => esc_html__('First Cap (First Capital Letter)', 'advance-automobile'),
		'type' => 'checkbox',
		'section' => 'advance_automobile_blog_post',
	));

	$wp_customize->add_setting('advance_automobile_blog_post_description_option',array(
    	'default'   => 'Excerpt Content', 
        'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control('advance_automobile_blog_post_description_option',array(
        'type' => 'radio',
        'label' => __('Post Description Length','advance-automobile'),
        'section' => 'advance_automobile_blog_post',
        'choices' => array(
            'No Content' => __('No Content','advance-automobile'),
            'Excerpt Content' => __('Excerpt Content','advance-automobile'),
            'Full Content' => __('Full Content','advance-automobile'),
        ),
	) );

    $wp_customize->add_setting( 'advance_automobile_excerpt_number', array(
		'default'              => 20,
		'sanitize_callback'	=> 'absint',
	) );
	$wp_customize->add_control( 'advance_automobile_excerpt_number', array(
		'label'       => esc_html__( 'Excerpt length','advance-automobile' ),
		'section'     => 'advance_automobile_blog_post',
		'type'        => 'number',
		'settings'    => 'advance_automobile_excerpt_number',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting( 'advance_automobile_post_suffix_option', array(
		'default'   => __('...','advance-automobile'), 
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'advance_automobile_post_suffix_option', array(
		'label'       => esc_html__( 'Post Excerpt Indicator Option','advance-automobile' ),
		'section'     => 'advance_automobile_blog_post',
		'type'        => 'text',
		'settings'    => 'advance_automobile_post_suffix_option',
	) );

	$wp_customize->add_setting( 'advance_automobile_metabox_separator_blog_post', array(
		'default'   => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'advance_automobile_metabox_separator_blog_post', array(
		'label'       => esc_html__( 'Meta Box Separator','advance-automobile' ),
		'input_attrs' => array(
            'placeholder' => __( 'Add Meta Separator. e.g.: "|", "/", etc.', 'advance-automobile' ),
        ),
		'section'     => 'advance_automobile_blog_post',
		'type'        => 'text',
		'settings'    => 'advance_automobile_metabox_separator_blog_post',
	) );

	$wp_customize->add_setting('advance_automobile_display_blog_page_post',array(
        'default' => 'In Box',
        'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control('advance_automobile_display_blog_page_post',array(
        'type' => 'radio',
        'label' => __('Display Blog Page Post :','advance-automobile'),
        'section' => 'advance_automobile_blog_post',
        'choices' => array(
            'In Box' => __('In Box','advance-automobile'),
            'Without Box' => __('Without Box','advance-automobile'),
        ),
	) );

	$wp_customize->add_setting('advance_automobile_blog_post_alignment',array(
	    'default' => 'Left',
	    'transport' => 'refresh',
	    'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control('advance_automobile_blog_post_alignment',array(
	    'type' => 'select',
	    'label' => __('Blog Page Post Alignment','advance-automobile'),
	    'section' => 'advance_automobile_blog_post',
	    'choices' => array(
	    	'Left' => __('Left','advance-automobile'),
	        'Center' => __('Center','advance-automobile'),
	        'Right' => __('Right','advance-automobile')
	    ),
	) );

	$wp_customize->add_setting('advance_automobile_blog_post_pagination',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_blog_post_pagination',array(
       'type' => 'checkbox',
       'label' => __('Pagination in Blog Page','advance-automobile'),
       'section' => 'advance_automobile_blog_post'
    ));

	$wp_customize->add_setting( 'advance_automobile_pagination_settings', array(
        'default'			=> 'Numeric Pagination',
        'sanitize_callback'	=> 'advance_automobile_sanitize_choices'
    ));
    $wp_customize->add_control( 'advance_automobile_pagination_settings', array(
        'section' => 'advance_automobile_blog_post',
        'type' => 'radio',
        'label' => __( 'Post Pagination', 'advance-automobile' ),
        'choices'		=> array(
            'Numeric Pagination'  => __( 'Numeric Pagination', 'advance-automobile' ),
            'next-prev' => __( 'Next / Previous', 'advance-automobile' ),
    )));

    $wp_customize->add_setting('advance_automobile_pagination_alignment',array(
	    'default' => 'Left',
	    'transport' => 'refresh',
	    'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control('advance_automobile_pagination_alignment',array(
	    'type' => 'select',
	    'label' => __('Pagination Alignment','advance-automobile'),
	    'section' => 'advance_automobile_blog_post',
	    'choices' => array(
	    	'Left' => __('Left','advance-automobile'),
	        'Center' => __('Center','advance-automobile'),
	        'Right' => __('Right','advance-automobile')
	    ),
	) );

	// Button
	$wp_customize->add_section( 'advance_automobile_theme_button', array(
		'title' => __('Button Option','advance-automobile'),
		'panel' => 'advance_automobile_panel_id',
	));

	$wp_customize->add_setting('advance_automobile_button_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_button_premium_info',array(
		'type'=> 'hidden',
		'description' => "<p>". esc_html__('Upgrade to premium for more features.','advance-automobile') ."</p><a target='_blank' href='". esc_url(ADVANCE_AUTOMOBILE_BUY_NOW) ." '>". esc_html__('Upgrade to Pro','advance-automobile') ."</a>",
		'section'=> 'advance_automobile_theme_button'
	));

	$wp_customize->selective_refresh->add_partial( 'advance_automobile_button_text', array(
		'selector' => '.page-box .new-text .read-more-btn',
		'render_callback' => 'advance_automobile_customize_partial_advance_automobile_button_text',
	));

	$wp_customize->add_setting('advance_automobile_button_text',array(
		'default'=> __('Read More','advance-automobile'), 
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_button_text',array(
		'label'	=> __('Add Button Text','advance-automobile'),
		'section'=> 'advance_automobile_theme_button',
		'type'=> 'text'
	));

	$wp_customize->add_setting('advance_automobile_button_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'advance_automobile_sanitize_float'
	));
	$wp_customize->add_control('advance_automobile_button_font_size',array(
		'label'	=> __('Button Font Size','advance-automobile'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'advance_automobile_theme_button',
		'type'=> 'number'
	));

	$wp_customize->add_setting('advance_automobile_btn_font_weight',array(
		'default'=> '',
		'sanitize_callback'	=> 'advance_automobile_sanitize_choices',
	));
	$wp_customize->add_control('advance_automobile_btn_font_weight',array(
		'label'	=> __('Button Font Weight','advance-automobile'),
		'section'=> 'advance_automobile_theme_button',
		'type' => 'select',
		'choices' => array(
            '100' => __('100','advance-automobile'),
            '200' => __('200','advance-automobile'),
            '300' => __('300','advance-automobile'),
            '400' => __('400','advance-automobile'),
            '500' => __('500','advance-automobile'),
            '600' => __('600','advance-automobile'),
            '700' => __('700','advance-automobile'),
            '800' => __('800','advance-automobile'),
            '900' => __('900','advance-automobile'),
        ),
	));

	// button letter spacing
	$wp_customize->add_setting( 'advance_automobile_button_letter_spacing',array(
		'default' => '',
		'sanitize_callback' => 'advance_automobile_sanitize_float'
	));
	$wp_customize->add_control('advance_automobile_button_letter_spacing', array(
		'label'  =>  esc_html__('Button Letter Spacing','advance-automobile'),
		'type'=> 'number',
		'section'  => 'advance_automobile_theme_button',
		'input_attrs' => array(
			'step' => 1,
			'min' => 0,
			'max' => 50,
		)
	));

	$wp_customize->add_setting('advance_automobile_button_text_transform',array(
		'default' => 'Uppercase',
		'sanitize_callback' => 'advance_automobile_sanitize_choices'
 	));
 	$wp_customize->add_control('advance_automobile_button_text_transform',array(
		'type' => 'radio',
		'label' => __('Button Text Transform','advance-automobile'),
		'section' => 'advance_automobile_theme_button',
		'choices' => array(
		   'Uppercase' => __('Uppercase','advance-automobile'),
		   'Lowercase' => __('Lowercase','advance-automobile'),
		   'Capitalize' => __('Capitalize','advance-automobile'),
		),
	) );

	$wp_customize->add_setting('advance_automobile_button_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control('advance_automobile_button_padding_top_bottom',array(
		'label'	=> __('Top and Bottom Padding','advance-automobile'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'advance_automobile_theme_button',
		'type'=> 'number'
	));

	$wp_customize->add_setting('advance_automobile_button_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control('advance_automobile_button_padding_left_right',array(
		'label'	=> __('Left and Right Padding','advance-automobile'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'advance_automobile_theme_button',
		'type'=> 'number'
	));

	$wp_customize->add_setting( 'advance_automobile_button_border_radius', array(
		'default'=> '',
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	) );
	$wp_customize->add_control( 'advance_automobile_button_border_radius', array(
		'label'       => esc_html__( 'Button Border Radius','advance-automobile' ),
		'section'     => 'advance_automobile_theme_button',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	//Single Post Settings
	$wp_customize->add_section('advance_automobile_single_post',array(
		'title'	=> __('Single Post Settings','advance-automobile'),
		'panel' => 'advance_automobile_panel_id',
	));	

	$wp_customize->add_setting('advance_automobile_single_post_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_single_post_premium_info',array(
		'type'=> 'hidden',
		'description' => "<p>". esc_html__('Upgrade to premium for more features.','advance-automobile') ."</p><a target='_blank' href='". esc_url(ADVANCE_AUTOMOBILE_BUY_NOW) ." '>". esc_html__('Upgrade to Pro','advance-automobile') ."</a>",
		'section'=> 'advance_automobile_single_post'
	));

	$wp_customize->selective_refresh->add_partial( 'advance_automobile_single_post_date_hide', array(
		'selector' => '.single-post .page-box-single',
		'render_callback' => 'advance_automobile_customize_partial_advance_automobile_single_post_date_hide',
	));

	$wp_customize->add_setting('advance_automobile_single_post_date_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_single_post_date_hide',array(
       'type' => 'checkbox',
       'label' => __('Single Post Date','advance-automobile'),
       'section' => 'advance_automobile_single_post'
    ));

	$wp_customize->add_setting('advance_automobile_single_post_date_icon',array(
		'default'	=> 'fa fa-calendar',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_single_post_date_icon',array(
		'label'	=> __('Single Post Date Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_single_post',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('advance_automobile_single_post_author_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_single_post_author_hide',array(
       'type' => 'checkbox',
       'label' => __('Single Post Author','advance-automobile'),
       'section' => 'advance_automobile_single_post'
    ));

	$wp_customize->add_setting('advance_automobile_single_post_author_icon',array(
		'default'	=> 'fa fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_single_post_author_icon',array(
		'label'	=> __('Single Post Author Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_single_post',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('advance_automobile_single_post_comment_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_single_post_comment_hide',array(
       'type' => 'checkbox',
       'label' => __('Single Post Comments','advance-automobile'),
       'section' => 'advance_automobile_single_post'
    ));

	$wp_customize->add_setting('advance_automobile_single_post_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_single_post_comment_icon',array(
		'label'	=> __('Single Post Comments Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_single_post',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('advance_automobile_single_post_time_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_single_post_time_hide',array(
       'type' => 'checkbox',
       'label' => __('Single Post Time','advance-automobile'),
       'section' => 'advance_automobile_single_post'
    ));

	$wp_customize->add_setting('advance_automobile_single_post_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_single_post_time_icon',array(
		'label'	=> __('Single Post Time Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_single_post',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('advance_automobile_tags_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_tags_hide',array(
       'type' => 'checkbox',
       'label' => __('Single Post Tags','advance-automobile'),
       'section' => 'advance_automobile_single_post'
    ));

    $wp_customize->add_setting('advance_automobile_show_featured_image_single_post',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_show_featured_image_single_post',array(
       'type' => 'checkbox',
       'label' => __('Single Post Image','advance-automobile'),
       'section' => 'advance_automobile_single_post'
    ));

    $wp_customize->add_setting( 'advance_automobile_single_img_border_radius', array(
		'default'=> 0,
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	) );
	$wp_customize->add_control( 'advance_automobile_single_img_border_radius', array(
		'label'       => esc_html__( 'Single Post Image Border Radius','advance-automobile' ),
		'section'     => 'advance_automobile_single_post',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 100,
		),
	) );

	$wp_customize->add_setting( 'advance_automobile_single_img_shadow',array(
		'default' => 0,
		'sanitize_callback'    => 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control('advance_automobile_single_img_shadow',array(
		'label' => esc_html__( 'Single Post Image Shadow','advance-automobile' ),
		'section' => 'advance_automobile_single_post',
		'input_attrs' => array(
			'min' => 0,
			'max' => 50,
			'step' => 1,
		),
		'type' => 'number'
	));

	$wp_customize->add_setting('advance_automobile_single_post_first_caps',array(
        'default' => false,
        'sanitize_callback' => 'advance_automobile_sanitize_checkbox',
    ));
	$wp_customize->add_control( 'advance_automobile_single_post_first_caps',array(
		'label' => esc_html__('First Cap (First Capital Letter)', 'advance-automobile'),
		'type' => 'checkbox',
		'section' => 'advance_automobile_single_post',
	));

    $wp_customize->add_setting('advance_automobile_show_single_post_pagination',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_show_single_post_pagination',array(
       'type' => 'checkbox',
       'label' => __('Single Post Pagination','advance-automobile'),
       'section' => 'advance_automobile_single_post'
    ));

    $wp_customize->add_setting( 'advance_automobile_post_comment',array(
		'default' => true,
		'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
		) );
	$wp_customize->add_control('advance_automobile_post_comment',array(
		'type' => 'checkbox',
		'label' => __('Single Post Comment Box','advance-automobile'),
		'section' => 'advance_automobile_single_post'
	));

	$wp_customize->add_setting( 'advance_automobile_single_post_breadcrumb',array(
		'default' => false,
		'transport' => 'refresh',
      	'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ) );
    $wp_customize->add_control('advance_automobile_single_post_breadcrumb',array(
    	'type' => 'checkbox',
        'label' => __( 'Show / Hide Single Post Breadcrumb','advance-automobile' ),
        'section' => 'advance_automobile_single_post'
    ));

    $wp_customize->add_setting('advance_automobile_category_show_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_category_show_hide',array(
       'type' => 'checkbox',
       'label' => __('Single Post Category','advance-automobile'),
       'section' => 'advance_automobile_single_post'
    ));

    $wp_customize->add_setting('advance_automobile_title_comment_form',array(
       'default' => __('Leave a Reply','advance-automobile'),
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('advance_automobile_title_comment_form',array(
       'type' => 'text',
       'label' => __('Comment Form Heading Text','advance-automobile'),
       'section' => 'advance_automobile_single_post'
    ));

    $wp_customize->add_setting('advance_automobile_comment_form_button_content',array(
       'default' => __('Post Comment','advance-automobile'),
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('advance_automobile_comment_form_button_content',array(
       'type' => 'text',
       'label' => __('Comment Form Button Text','advance-automobile'),
       'section' => 'advance_automobile_single_post'
    ));

    //Comment Textarea Width
    $wp_customize->add_setting( 'advance_automobile_comment_width', array(
		'default'=> '100',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(
	    'advance_automobile_comment_width', array(
		'label'  => __('Comment Textarea Width','advance-automobile'),
		'section'  => 'advance_automobile_single_post',
		'description' => __('Measurement is in %.','advance-automobile'),
		'input_attrs' => array(
		   'step'=> 1,
		   'min' => 0,
		   'max' => 100,
		),
		'type'		=> 'number'
    ));

    $wp_customize->add_setting( 'advance_automobile_single_post_meta_seperator', array(
		'default'   => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'advance_automobile_single_post_meta_seperator', array(
		'label'       => esc_html__( 'Single Post Meta Box Seperator','advance-automobile' ),
		'section'     => 'advance_automobile_single_post',
		'description' => __('Here you can add the seperator for meta box. e.g. "|",  ",", "/", etc. ','advance-automobile'),
		'type'        => 'text',
		'settings'    => 'advance_automobile_single_post_meta_seperator',
	) );

	//Grid Post Settings
	$wp_customize->add_section('advance_automobile_grid_post',array(
		'title'	=> __('Grid Post Settings','advance-automobile'),
		'panel' => 'advance_automobile_panel_id',
	));	

	$wp_customize->add_setting('advance_automobile_grid_post_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_grid_post_premium_info',array(
		'type'=> 'hidden',
		'description' => "<p>". esc_html__('Upgrade to premium for more features.','advance-automobile') ."</p><a target='_blank' href='". esc_url(ADVANCE_AUTOMOBILE_BUY_NOW) ." '>". esc_html__('Upgrade to Pro','advance-automobile') ."</a>",
		'section'=> 'advance_automobile_grid_post'
	));

	$wp_customize->add_setting('advance_automobile_grid_post_date',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_grid_post_date',array(
       'type' => 'checkbox',
       'label' => __('Post Date','advance-automobile'),
       'section' => 'advance_automobile_grid_post'
    ));

	$wp_customize->add_setting('advance_automobile_grid_post_date_icon',array(
		'default'	=> 'fa fa-calendar',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_grid_post_date_icon',array(
		'label'	=> __('Date Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_grid_post',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('advance_automobile_grid_post_author',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_grid_post_author',array(
       'type' => 'checkbox',
       'label' => __('Post Author','advance-automobile'),
       'section' => 'advance_automobile_grid_post'
    ));

	$wp_customize->add_setting('advance_automobile_grid_post_author_icon',array(
		'default'	=> 'fa fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_grid_post_author_icon',array(
		'label'	=> __('Author Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_grid_post',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('advance_automobile_grid_post_comment',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_grid_post_comment',array(
       'type' => 'checkbox',
       'label' => __('Post Comment','advance-automobile'),
       'section' => 'advance_automobile_grid_post'
    ));

	$wp_customize->add_setting('advance_automobile_grid_post_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_grid_post_comment_icon',array(
		'label'	=> __('Comment Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_grid_post',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('advance_automobile_grid_post_time',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_grid_post_time',array(
       'type' => 'checkbox',
       'label' => __('Post Time','advance-automobile'),
       'section' => 'advance_automobile_grid_post'
    ));

	$wp_customize->add_setting('advance_automobile_grid_post_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_grid_post_time_icon',array(
		'label'	=> __('Time Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_grid_post',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('advance_automobile_grid_post_alignment',array(
	    'default' => 'Left',
	    'transport' => 'refresh',
	    'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control('advance_automobile_grid_post_alignment',array(
	    'type' => 'select',
	    'label' => __('Grid Post Alignment','advance-automobile'),
	    'section' => 'advance_automobile_grid_post',
	    'choices' => array(
	    	'Left' => __('Left','advance-automobile'),
	        'Center' => __('Center','advance-automobile'),
	        'Right' => __('Right','advance-automobile')
	    ),
	) );

	$wp_customize->add_setting('advance_automobile_grid_post_description_option',array(
    	'default'   => 'Excerpt Content',
        'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control('advance_automobile_grid_post_description_option',array(
        'type' => 'radio',
        'label' => __('Post Description Length','advance-automobile'),
        'section' => 'advance_automobile_grid_post',
        'choices' => array(
            'No Content' => __('No Content','advance-automobile'),
            'Excerpt Content' => __('Excerpt Content','advance-automobile'),
            'Full Content' => __('Full Content','advance-automobile'),
        ),
	) );

	$wp_customize->add_setting( 'advance_automobile_grid_excerpt_number', array(
		'default'              => 20,
		'sanitize_callback'	=> 'absint',
	) );
	$wp_customize->add_control( 'advance_automobile_grid_excerpt_number', array(
		'label'       => esc_html__( 'Excerpt length','advance-automobile' ),
		'section'     => 'advance_automobile_grid_post',
		'type'        => 'number',
		'settings'    => 'advance_automobile_grid_excerpt_number',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting( 'advance_automobile_grid_post_suffix_option', array(
		'default'   => __('...','advance-automobile'),
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'advance_automobile_grid_post_suffix_option', array(
		'label'       => esc_html__( 'Excerpt Indicator Option','advance-automobile' ),
		'section'     => 'advance_automobile_grid_post',
		'type'        => 'text',
		'settings'    => 'advance_automobile_grid_post_suffix_option',
	) );

	$wp_customize->add_setting( 'advance_automobile_metabox_separator_grid_post', array(
		'default'   => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'advance_automobile_metabox_separator_grid_post', array(
		'label'       => esc_html__( 'Meta Box Separator','advance-automobile' ),
		'input_attrs' => array(
            'placeholder' => __( 'Add Meta Separator. e.g.: "|", "/", etc.', 'advance-automobile' ),
        ),
		'section'     => 'advance_automobile_grid_post',
		'type'        => 'text',
		'settings'    => 'advance_automobile_metabox_separator_grid_post',
	) );

    $wp_customize->add_setting('advance_automobile_show_image_grid_post',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_show_image_grid_post',array(
       'type' => 'checkbox',
       'label' => __('Grid Post Image','advance-automobile'),
       'section' => 'advance_automobile_grid_post'
    ));

    $wp_customize->add_setting( 'advance_automobile_img_border_radius_grid_post', array(
		'default'=> 0,
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	) );
	$wp_customize->add_control( 'advance_automobile_img_border_radius_grid_post', array(
		'label'       => esc_html__( 'Grid Post Image Border Radius','advance-automobile' ),
		'section'     => 'advance_automobile_grid_post',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 100,
		),
	) );

	$wp_customize->add_setting('advance_automobile_display_grid_page_post',array(
        'default' => 'In Box',
        'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control('advance_automobile_display_grid_page_post',array(
        'type' => 'radio',
        'label' => __('Display Grid Post Box :','advance-automobile'),
        'section' => 'advance_automobile_grid_post',
        'choices' => array(
            'In Box' => __('In Box','advance-automobile'),
            'Without Box' => __('Without Box','advance-automobile'),
        ),
	) );

	//Related Post Settings
	$wp_customize->add_section('advance_automobile_related_post',array(
		'title'	=> __('Related Post Settings','advance-automobile'),
		'panel' => 'advance_automobile_panel_id',
	));	

	$wp_customize->add_setting('advance_automobile_related_post_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_related_post_premium_info',array(
		'type'=> 'hidden',
		'description' => "<p>". esc_html__('Upgrade to premium for more features.','advance-automobile') ."</p><a target='_blank' href='". esc_url(ADVANCE_AUTOMOBILE_BUY_NOW) ." '>". esc_html__('Upgrade to Pro','advance-automobile') ."</a>",
		'section'=> 'advance_automobile_related_post'
	));

	$wp_customize->selective_refresh->add_partial( 'advance_automobile_show_related_post', array(
		'selector' => '.related-posts',
		'render_callback' => 'advance_automobile_customize_partial_advance_automobile_show_related_post',
	));

	$wp_customize->add_setting( 'advance_automobile_show_related_post',array(
		'default' => true,
      	'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ) );
    $wp_customize->add_control('advance_automobile_show_related_post',array(
    	'type' => 'checkbox',
        'label' => __( 'Related Post','advance-automobile' ),
        'section' => 'advance_automobile_related_post'
    ));

    $wp_customize->add_setting('advance_automobile_related_posts_taxanomies_options',array(
        'default' => 'categories',
        'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control('advance_automobile_related_posts_taxanomies_options',array(
        'type' => 'radio',
        'label' => __('Related Post Taxonomies','advance-automobile'),
        'section' => 'advance_automobile_related_post',
        'choices' => array(
            'categories' => __('Categories','advance-automobile'),
            'tags' => __('Tags','advance-automobile'),
        ),
	) );

	$wp_customize->add_setting('advance_automobile_related_post_title',array(
		'default'=> __('Related Posts','advance-automobile'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_related_post_title',array(
		'label'	=> __('Related Post Title','advance-automobile'),
		'section'=> 'advance_automobile_related_post',
		'type'=> 'text'
	));

    $wp_customize->add_setting('advance_automobile_show_featured_image_related_post',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_show_featured_image_related_post',array(
       'type' => 'checkbox',
       'label' => __('Related Post Image','advance-automobile'),
       'section' => 'advance_automobile_related_post'
    ));

   	$wp_customize->add_setting('advance_automobile_related_posts_number',array(
		'default'=> 3,
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control('advance_automobile_related_posts_number',array(
		'label'	=> __('Related Post Number','advance-automobile'),
		'section'=> 'advance_automobile_related_post',
		'type'=> 'number',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
	));

	$wp_customize->add_setting('advance_automobile_related_post_excerpt_number',array(
		'default'=> 20,
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control('advance_automobile_related_post_excerpt_number',array(
		'label'	=> __('Related Post Content Limit','advance-automobile'),
		'section'=> 'advance_automobile_related_post',
		'type'=> 'number',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
	));

	$wp_customize->add_setting('advance_automobile_related_post_date_hide',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_related_post_date_hide',array(
       'type' => 'checkbox',
       'label' => __('Post Date','advance-automobile'),
       'section' => 'advance_automobile_related_post'
    ));

	$wp_customize->add_setting('advance_automobile_related_post_date_icon',array(
		'default'	=> 'fa fa-calendar',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_related_post_date_icon',array(
		'label'	=> __('Post Date Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_related_post',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('advance_automobile_related_button_text',array(
		'default'=> esc_html__('Read More','advance-automobile'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_related_button_text',array(
		'label'	=> esc_html__('Add Button Text','advance-automobile'),
		'input_attrs' => array(
        'placeholder' => esc_html__( 'Read More', 'advance-automobile' ),
        ),
		'section'=> 'advance_automobile_related_post',
		'type'=> 'text'
	));

	//Layouts
	$wp_customize->add_section('advance_automobile_left_right', array(
		'title'    => __('Layout Settings', 'advance-automobile'),
		'priority' => null,
		'panel'    => 'advance_automobile_panel_id',
	));

	$wp_customize->add_setting('advance_automobile_left_right_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_left_right_premium_info',array(
		'type'=> 'hidden',
		'description' => "<p>". esc_html__('Upgrade to premium for more features.','advance-automobile') ."</p><a target='_blank' href='". esc_url(ADVANCE_AUTOMOBILE_BUY_NOW) ." '>". esc_html__('Upgrade to Pro','advance-automobile') ."</a>",
		'section'=> 'advance_automobile_left_right'
	));

	$wp_customize->add_setting('advance_automobile_theme_options',array(
        'default' => 'Default',
        'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control('advance_automobile_theme_options',array(
        'type' => 'radio',
        'label' => __('Container Box','advance-automobile'),
        'description' => __('Here you can change the Width layout. ','advance-automobile'),
        'section' => 'advance_automobile_left_right',
        'choices' => array(
            'Default' => __('Default','advance-automobile'),
            'Container' => __('Container','advance-automobile'),
            'Box Container' => __('Box Container','advance-automobile'),
        ),
	) );

	$wp_customize->add_setting('advance_automobile_preloader_option',array(
       'default' => false,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_preloader_option',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Preloader','advance-automobile'),
       'section' => 'advance_automobile_left_right'
    ));

    $wp_customize->add_setting('advance_automobile_preloader_type_options', array(
		'default'           => 'Preloader 1',
		'sanitize_callback' => 'advance_automobile_sanitize_choices',
	));
	$wp_customize->add_control('advance_automobile_preloader_type_options',array(
		'type'           => 'radio',
		'label'          => __('Preloader Type', 'advance-automobile'),
		'section'        => 'advance_automobile_left_right',
		'choices'        => array(
			'Preloader 1'  => __('Preloader 1', 'advance-automobile'),
			'Preloader 2' => __('Preloader 2', 'advance-automobile'),
		),
	));

	$wp_customize->add_setting('advance_automobile_preloader_bg_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'advance_automobile_preloader_bg_image',array(
        'label' => __('Preloader Background Image','advance-automobile'),
        'section' => 'advance_automobile_left_right'
	)));

    $wp_customize->add_setting( 'advance_automobile_loader_background_color_first', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_loader_background_color_first', array(
  		'label' => __('Background Color for Preloader', 'advance-automobile'),
	    'section' => 'advance_automobile_left_right',
	    'settings' => 'advance_automobile_loader_background_color_first',
  	)));

  	$wp_customize->add_setting( 'advance_automobile_breadcrumb_color', array(
	    'default' => '#fff',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_breadcrumb_color', array(
  		'label' => __('Breadcrumb Color', 'advance-automobile'),
	    'section' => 'advance_automobile_left_right',
	    'settings' => 'advance_automobile_breadcrumb_color',
  	)));

  	$wp_customize->add_setting( 'advance_automobile_breadcrumb_bg_color', array(
	    'default' => 'var(--secondary-color)',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_breadcrumb_bg_color', array(
  		'label' => __('Breadcrumb Background Color', 'advance-automobile'),
	    'section' => 'advance_automobile_left_right',
	    'settings' => 'advance_automobile_breadcrumb_bg_color',
  	)));

	$wp_customize->add_setting( 'advance_automobile_single_page_breadcrumb',array(
		'default' => false,
      	'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ) );
    $wp_customize->add_control('advance_automobile_single_page_breadcrumb',array(
    	'type' => 'checkbox',
        'label' => __( 'Show / Hide Single Page Breadcrumb','advance-automobile' ),
        'section' => 'advance_automobile_left_right'
    ));

	$wp_customize->add_setting('advance_automobile_layout_options', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'advance_automobile_sanitize_choices',
	));
	$wp_customize->add_control('advance_automobile_layout_options',array(
		'type'           => 'radio',
		'label'          => __('Blog Page Layouts', 'advance-automobile'),
		'section'        => 'advance_automobile_left_right',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'advance-automobile'),
			'Right Sidebar' => __('Right Sidebar', 'advance-automobile'),
			'One Column'    => __('One Column', 'advance-automobile'),
			'Three Columns' => __('Three Columns', 'advance-automobile'),
			'Four Columns'  => __('Four Columns', 'advance-automobile'),
			'Grid Layout'   => __('Grid Layout', 'advance-automobile')
		),
	));

	$wp_customize->add_setting('advance_automobile_single_post_sidebar_layout', array(
		'default'           => 'Right Sidebar', 
		'sanitize_callback' => 'advance_automobile_sanitize_choices',
	));
	$wp_customize->add_control('advance_automobile_single_post_sidebar_layout',array(
		'type'           => 'radio',
		'label'          => __('Single Post Layouts', 'advance-automobile'),
		'section'        => 'advance_automobile_left_right',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'advance-automobile'),
			'Right Sidebar' => __('Right Sidebar', 'advance-automobile'),
			'One Column'    => __('One Column', 'advance-automobile'),
		),
	));

	$wp_customize->add_setting('advance_automobile_single_page_sidebar_layout', array(
		'default'           => 'One Column',
		'sanitize_callback' => 'advance_automobile_sanitize_choices',
	));
	$wp_customize->add_control('advance_automobile_single_page_sidebar_layout',array(
		'type'           => 'radio',
		'label'          => __('Single Page Layouts', 'advance-automobile'),
		'section'        => 'advance_automobile_left_right',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'advance-automobile'),
			'Right Sidebar' => __('Right Sidebar', 'advance-automobile'),
			'One Column'    => __('One Column', 'advance-automobile'),
		),
	));


	//no Result Found
	$wp_customize->add_section('advance_automobile_noresult_found',array(
		'title'	=> __('No Result Found','advance-automobile'),
		'panel' => 'advance_automobile_panel_id',
	));	

	$wp_customize->add_setting('advance_automobile_noresult_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_noresult_premium_info',array(
		'type'=> 'hidden',
		'description' => "<p>". esc_html__('Upgrade to premium for more features.','advance-automobile') ."</p><a target='_blank' href='". esc_url(ADVANCE_AUTOMOBILE_BUY_NOW) ." '>". esc_html__('Upgrade to Pro','advance-automobile') ."</a>",
		'section'=> 'advance_automobile_noresult_found'
	));

	$wp_customize->add_setting('advance_automobile_nosearch_found_title',array(
		'default'=> __('Nothing Found','advance-automobile'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_nosearch_found_title',array(
		'label'	=> __('No Result Found Title','advance-automobile'),
		'section'=> 'advance_automobile_noresult_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('advance_automobile_nosearch_found_content',array(
		'default'=> __('Sorry, but nothing matched your search terms. Please try again with some different keywords.','advance-automobile'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_nosearch_found_content',array(
		'label'	=> __('No Result Found Content','advance-automobile'),
		'section'=> 'advance_automobile_noresult_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('advance_automobile_show_noresult_search',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_show_noresult_search',array(
       'type' => 'checkbox',
       'label' => __('No Result search','advance-automobile'),
       'section' => 'advance_automobile_noresult_found'
    ));

	//404 Page Setting
	$wp_customize->add_section('advance_automobile_404_page_setting',array(
		'title'	=> __('404 Page','advance-automobile'),
		'panel' => 'advance_automobile_panel_id',
	));	

	$wp_customize->add_setting('advance_automobile_404_page_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_404_page_premium_info',array(
		'type'=> 'hidden',
		'description' => "<p>". esc_html__('Upgrade to premium for more features.','advance-automobile') ."</p><a target='_blank' href='". esc_url(ADVANCE_AUTOMOBILE_BUY_NOW) ." '>". esc_html__('Upgrade to Pro','advance-automobile') ."</a>",
		'section'=> 'advance_automobile_404_page_setting'
	));

	$wp_customize->add_setting('advance_automobile_title_404_page',array(
		'default'=> __('404 Not Found','advance-automobile'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_title_404_page',array(
		'label'	=> __('404 Page Title','advance-automobile'),
		'section'=> 'advance_automobile_404_page_setting',
		'type'=> 'text'
	));

	$wp_customize->add_setting('advance_automobile_content_404_page',array(
		'default'=>  __('Looks like you have taken a wrong turn&hellip. Dont worry&hellip it happens to the best of us.','advance-automobile'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_content_404_page',array(
		'label'	=> __('404 Page Content','advance-automobile'),
		'section'=> 'advance_automobile_404_page_setting',
		'type'=> 'text'
	));

	$wp_customize->add_setting('advance_automobile_button_404_page',array(
		'default'=> __('Back to Home Page','advance-automobile'), 
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_button_404_page',array(
		'label'	=> __('404 Page Button','advance-automobile'),
		'section'=> 'advance_automobile_404_page_setting',
		'type'=> 'text'
	));

	//Responsive Media Settings
	$wp_customize->add_section('advance_automobile_responsive_setting',array(
		'title'	=> __('Responsive Settings','advance-automobile'),
		'panel' => 'advance_automobile_panel_id',
	));

	$wp_customize->add_setting('advance_automobile_responsive_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_responsive_premium_info',array(
		'type'=> 'hidden',
		'description' => "<p>". esc_html__('Upgrade to premium for more features.','advance-automobile') ."</p><a target='_blank' href='". esc_url(ADVANCE_AUTOMOBILE_BUY_NOW) ." '>". esc_html__('Upgrade to Pro','advance-automobile') ."</a>",
		'section'=> 'advance_automobile_responsive_setting'
	));

	$wp_customize->add_setting( 'advance_automobile_toggle_button_bg_color_settings', array(
	    'default' => 'var(--secondary-color)',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'advance_automobile_toggle_button_bg_color_settings', array(
  		'label' => __('Toggle Button Bg Color', 'advance-automobile'),
	    'section' => 'advance_automobile_responsive_setting',
	    'settings' => 'advance_automobile_toggle_button_bg_color_settings',
  	)));

	$wp_customize->add_setting('advance_automobile_open_menu_icon',array(
		'default'	=> 'fas fa-bars',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_open_menu_icon',array(
		'label'	=> __('Open Menu Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_responsive_setting',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('advance_automobile_close_menu_icon',array(
		'default'	=> 'far fa-times-circle',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_close_menu_icon',array(
		'label'	=> __('Close Menu Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_responsive_setting',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('advance_automobile_mobile_search_option',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_mobile_search_option',array(
       'type' => 'checkbox',
       'label' => __('Search','advance-automobile'),
       'section' => 'advance_automobile_responsive_setting'
    ));

    $wp_customize->add_setting('advance_automobile_responsive_sticky_header',array(
       'default' => false,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_responsive_sticky_header',array(
       'type' => 'checkbox',
       'label' => __('Sticky Header','advance-automobile'),
       'section' => 'advance_automobile_responsive_setting'
    ));

    $wp_customize->add_setting('advance_automobile_responsive_slider',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_responsive_slider',array(
       'type' => 'checkbox',
       'label' => __('Slider','advance-automobile'),
       'section' => 'advance_automobile_responsive_setting'
    ));

    $wp_customize->add_setting('advance_automobile_responsive_scroll',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_responsive_scroll',array(
       'type' => 'checkbox',
       'label' => __('Scroll To Top','advance-automobile'),
       'section' => 'advance_automobile_responsive_setting'
    ));

    $wp_customize->add_setting('advance_automobile_responsive_sidebar',array(
       'default' => true,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_responsive_sidebar',array(
       'type' => 'checkbox',
       'label' => __('Sidebar','advance-automobile'),
       'section' => 'advance_automobile_responsive_setting'
    ));

    $wp_customize->add_setting('advance_automobile_responsive_preloader',array(
       'default' => false,
       'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
    ));
    $wp_customize->add_control('advance_automobile_responsive_preloader',array(
       'type' => 'checkbox',
       'label' => __('Preloader','advance-automobile'),
       'section' => 'advance_automobile_responsive_setting'
    ));

	//footer
	$wp_customize->add_section('advance_automobile_footer_section', array(
		'title'       => __('Footer Text', 'advance-automobile'),
		'priority'    => null,
		'panel'       => 'advance_automobile_panel_id',
	));

	$wp_customize->add_setting('advance_automobile_footer_premium_info',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('advance_automobile_footer_premium_info',array(
		'type'=> 'hidden',
		'description' => "<p>". esc_html__('Upgrade to premium for more features.','advance-automobile') ."</p><a target='_blank' href='". esc_url(ADVANCE_AUTOMOBILE_BUY_NOW) ." '>". esc_html__('Upgrade to Pro','advance-automobile') ."</a>",
		'section'=> 'advance_automobile_footer_section'
	));

	$wp_customize->selective_refresh->add_partial( 'advance_automobile_show_hide_footer', array(
		'selector' => '#footer',
		'render_callback' => 'advance_automobile_customize_partial_advance_automobile_show_hide_footer',
	));

	$wp_customize->add_setting('advance_automobile_show_hide_footer',array(
		'default' => true,
		'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
	));
	$wp_customize->add_control('advance_automobile_show_hide_footer',array(
     	'type' => 'checkbox',
        'label' => __('Show / Hide Footer','advance-automobile'),
        'section' => 'advance_automobile_footer_section',
	));

	$wp_customize->add_setting('advance_automobile_footer_widget_areas',array(
        'default'           => 4,
        'sanitize_callback' => 'advance_automobile_sanitize_choices',
    ));
    $wp_customize->add_control('advance_automobile_footer_widget_areas',array(
        'type'        => 'select',
        'label'       => __('Footer widget area', 'advance-automobile'),
        'section'     => 'advance_automobile_footer_section',
        'description' => __('Select the number of widget areas you want in the footer. After that, go to Appearance > Widgets and add your widgets.', 'advance-automobile'),
        'choices' => array(
            '1'     => __('One', 'advance-automobile'),
            '2'     => __('Two', 'advance-automobile'),
            '3'     => __('Three', 'advance-automobile'),
            '4'     => __('Four', 'advance-automobile')
        ),
    ));

    $wp_customize->add_setting('advance_automobile_footer_widget_bg_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'advance_automobile_footer_widget_bg_color', array(
		'label'    => __('Footer Widget Background Color', 'advance-automobile'),
		'section'  => 'advance_automobile_footer_section',
	)));

	$wp_customize->add_setting('advance_automobile_footer_widget_bg_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'advance_automobile_footer_widget_bg_image',array(
        'label' => __('Footer Widget Background Image','advance-automobile'),
        'section' => 'advance_automobile_footer_section'
	)));

	$wp_customize->add_setting('advance_automobile_footer_heading',array(
	    'default' => 'Left',
	    'transport' => 'refresh',
	    'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control('advance_automobile_footer_heading',array(
	    'type' => 'select',
	    'label' => __('Footer Heading Alignment','advance-automobile'),
	    'section' => 'advance_automobile_footer_section',
	    'choices' => array(
	    	'Left' => __('Left','advance-automobile'),
	        'Center' => __('Center','advance-automobile'),
	        'Right' => __('Right','advance-automobile')
	    ),
	) );

	$wp_customize->add_setting('advance_automobile_footer_content',array(
	    'default' => 'Left',
	    'transport' => 'refresh',
	    'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control('advance_automobile_footer_content',array(
	    'type' => 'select',
	    'label' => __('Footer Content Alignment','advance-automobile'),
	    'section' => 'advance_automobile_footer_section',
	    'choices' => array(
	    	'Left' => __('Left','advance-automobile'),
	        'Center' => __('Center','advance-automobile'),
	        'Right' => __('Right','advance-automobile')
	    ),
	) );

	$wp_customize->add_setting('advance_automobile_footer_font_size',array(
		'default'=> 24,
		'sanitize_callback'	=> 'advance_automobile_sanitize_float'
	));
	$wp_customize->add_control('advance_automobile_footer_font_size',array(
		'label'	=> __('Footer Heading Font Size','advance-automobile'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'advance_automobile_footer_section',
		'type'=> 'number'
	));

	$wp_customize->add_setting('advance_automobile_footer_heading_font_weight',array(
        'default' => '600',
        'sanitize_callback' => 'advance_automobile_sanitize_choices'
    ));
    $wp_customize->add_control('advance_automobile_footer_heading_font_weight',array(
        'type' => 'select',
        'label' => __('Footer Heading Font Weight','advance-automobile'),
        'section' => 'advance_automobile_footer_section',
        'choices' => array(
            '100' => __('100','advance-automobile'),
            '200' => __('200','advance-automobile'),
            '300' => __('300','advance-automobile'),
            '400' => __('400','advance-automobile'),
            '500' => __('500','advance-automobile'),
            '600' => __('600','advance-automobile'),
            '700' => __('700','advance-automobile'),
            '800' => __('800','advance-automobile'),
            '900' => __('900','advance-automobile'),
        ),
	) );

	$wp_customize->add_setting('advance_automobile_footer_text_tranform',array(
		'default' => 'Capitalize',
		'sanitize_callback' => 'advance_automobile_sanitize_choices'
 	));
 	$wp_customize->add_control('advance_automobile_footer_text_tranform',array(
		'type' => 'radio',
		'label' => __('Footer Heading Text Transform','advance-automobile'),
		'section' => 'advance_automobile_footer_section',
		'choices' => array(
		   'Uppercase' => __('Uppercase','advance-automobile'),
		   'Lowercase' => __('Lowercase','advance-automobile'),
		   'Capitalize' => __('Capitalize','advance-automobile'),
		),
	) );

	$wp_customize->selective_refresh->add_partial('advance_automobile_show_hide_copyright', array(
		'selector' => '.copyright p',
		'render_callback' => 'advance_automobile_customize_partial_advance_automobile_show_hide_copyright',
	));

	$wp_customize->add_setting('advance_automobile_show_hide_copyright',array(
		'default' => true,
		'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
	));
	$wp_customize->add_control('advance_automobile_show_hide_copyright',array(
     	'type' => 'checkbox',
        'label' => __('Show / Hide Copyright','advance-automobile'),
        'section' => 'advance_automobile_footer_section',
	));

	$wp_customize->add_setting('advance_automobile_footer_copy', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('advance_automobile_footer_copy', array(
		'label'   => __('Copyright Text', 'advance-automobile'),
		'section' => 'advance_automobile_footer_section',
		'type'    => 'text',
	));

	//copyright text bg-color
	$wp_customize->add_setting('advance_automobile_copyright_bg_color_settings', array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_hex_color',
		));
		$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'advance_automobile_copyright_bg_color_settings', array(
			'label'    => __('Copyright Background Color', 'advance-automobile'),
			'section'  => 'advance_automobile_footer_section',
	)));

	$wp_customize->add_setting('advance_automobile_copyright_content_align',array(
        'default' => 'center',
        'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control('advance_automobile_copyright_content_align',array(
        'type' => 'select',
        'label' => __('Copyright Text Alignment ','advance-automobile'),
        'section' => 'advance_automobile_footer_section',
        'choices' => array(
            'left' => __('Left','advance-automobile'),
            'right' => __('Right','advance-automobile'),
            'center' => __('Center','advance-automobile'),
        ),
	) );

	$wp_customize->add_setting('advance_automobile_footer_content_font_size',array(
		'default'=> 16,
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control('advance_automobile_footer_content_font_size',array(
		'label' => esc_html__( 'Copyright Font Size','advance-automobile' ),
		'section'=> 'advance_automobile_footer_section',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
        'type' => 'number',
	));

	$wp_customize->add_setting('advance_automobile_copyright_padding',array(
		'default'=> 15,
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control('advance_automobile_copyright_padding',array(
		'label'	=> __('Copyright Padding','advance-automobile'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'advance_automobile_footer_section',
		'type'=> 'number'
	));

	$wp_customize->add_setting('advance_automobile_footer_text_color', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'advance_automobile_footer_text_color', array(
		'label'    => __('Copyright Text Color', 'advance-automobile'),
		'section'  => 'advance_automobile_footer_section',
	)));

	$wp_customize->add_setting('advance_automobile_footer_text_bg_color', array(
		'default'           => 'var(--primary-color)',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'advance_automobile_footer_text_bg_color', array(
		'label'    => __('Copyright Background Color', 'advance-automobile'),
		'section'  => 'advance_automobile_footer_section',
	)));

	$wp_customize->selective_refresh->add_partial( 'advance_automobile_enable_disable_scroll', array(
		'selector' => '#scroll-top i',
		'render_callback' => 'advance_automobile_customize_partial_advance_automobile_enable_disable_scroll',
	));

	$wp_customize->add_setting('advance_automobile_enable_disable_scroll',array(
        'default' => true,
        'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
	));
	$wp_customize->add_control('advance_automobile_enable_disable_scroll',array(
     	'type' => 'checkbox',
      	'label' => __('Show / Hide Scroll Top Button','advance-automobile'),
      	'section' => 'advance_automobile_footer_section',
	));

	$wp_customize->add_setting('advance_automobile_back_to_top_icon',array(
		'default'	=> 'fas fa-chevron-up',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
        $wp_customize,'advance_automobile_back_to_top_icon',array(
		'label'	=> __('Scroll Back to Top Icon','advance-automobile'),
		'transport' => 'refresh',
		'section'	=> 'advance_automobile_footer_section',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('advance_automobile_back_to_top_bg_color', array(
		'default'           => 'var(--primary-color)',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'advance_automobile_back_to_top_bg_color', array(
		'label'    => __('Back to Top Background Color', 'advance-automobile'),
		'section'  => 'advance_automobile_footer_section',
	)));

    $wp_customize->add_setting('advance_automobile_back_to_top_bg_hover_color', array(
		'default'           => 'var(--primary-color)',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'advance_automobile_back_to_top_bg_hover_color', array(
		'label'    => __('Back to Top Background Hover Color', 'advance-automobile'),
		'section'  => 'advance_automobile_footer_section',
	)));

	$wp_customize->add_setting('advance_automobile_scroll_setting',array(
        'default' => 'Right',
        'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control('advance_automobile_scroll_setting',array(
        'type' => 'select',
        'label' => __('Scroll Back to Top Position','advance-automobile'),
        'section' => 'advance_automobile_footer_section',
        'choices' => array(
            'Left' => __('Left','advance-automobile'),
            'Right' => __('Right','advance-automobile'),
            'Center' => __('Center','advance-automobile'),
        ),
	) );

	$wp_customize->add_setting('advance_automobile_scroll_font_size_icon',array(
		'default'=> 20,
		'sanitize_callback'	=> 'advance_automobile_sanitize_float',
	));
	$wp_customize->add_control('advance_automobile_scroll_font_size_icon',array(
		'label'	=> __('Scroll Icon Font Size','advance-automobile'),
		'section'=> 'advance_automobile_footer_section',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
        'type' => 'number',
	)	);

	//Footer Social Icon
	$wp_customize->add_section( 'advance_automobile_footer_social_icon' , array(
    	'title'      => __( 'Footer Social Icon Settings', 'advance-automobile' ),
		'panel' => 'advance_automobile_panel_id'
	) );

	$wp_customize->add_setting('advance_automobile_show_hide_footer_social_icon',array(
		'default' => false,
		'sanitize_callback'	=> 'advance_automobile_sanitize_checkbox'
	));
	$wp_customize->add_control('advance_automobile_show_hide_footer_social_icon',array(
     	'type' => 'checkbox',
      	'label' => __('Show / Hide Footer Social Icon','advance-automobile'),
      	'section' => 'advance_automobile_footer_social_icon',
	));

	for ( $advance_automobile_j = 1; $advance_automobile_j <= 5; $advance_automobile_j++ ) {
		$wp_customize->add_setting('advance_automobile_social_icon_url' .$advance_automobile_j,array(
			'default'	=> '',
			'sanitize_callback'	=> 'esc_url_raw'
		));	
		$wp_customize->add_control('advance_automobile_social_icon_url' .$advance_automobile_j,array(
			'label'	=> __('Add Social link','advance-automobile'),
			'section'	=> 'advance_automobile_footer_social_icon',
			'setting'	=> 'advance_automobile_social_icon_url' .$advance_automobile_j,
			'type'	=> 'url'
		));

		$wp_customize->add_setting('advance_automobile_select_social_icon' .$advance_automobile_j,array(
			'default'	=> '',
			'sanitize_callback'	=> 'sanitize_text_field'
		));
		$wp_customize->add_control(new Advance_Automobile_Icon_Changer(
	        $wp_customize,'advance_automobile_select_social_icon' .$advance_automobile_j,array(
			'label'	=> __('Add Social Icon','advance-automobile'),
			'transport' => 'refresh',
			'section'	=> 'advance_automobile_footer_social_icon',
			'type'		=> 'icon'
		)));
	}

	$wp_customize->add_setting('advance_automobile_align_footer_social_icon',array(
        'default' => 'center',
        'sanitize_callback' => 'advance_automobile_sanitize_choices'
	));
	$wp_customize->add_control('advance_automobile_align_footer_social_icon',array(
        'type' => 'select',
        'label' => __('Social Icon Alignment ','advance-automobile'),
        'section' => 'advance_automobile_footer_social_icon',
        'choices' => array(
            'left' => __('Left','advance-automobile'),
            'right' => __('Right','advance-automobile'),
            'center' => __('Center','advance-automobile'),
        ),
	) );

	$wp_customize->add_setting('advance_automobile_footer_icon_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'advance_automobile_sanitize_float'
	));
	$wp_customize->add_control('advance_automobile_footer_icon_font_size',array(
		'label'	=> __('Footer Icon Font Size','advance-automobile'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'advance_automobile_footer_social_icon',
		'type'=> 'number'
	));

	$wp_customize->add_setting('advance_automobile_footer_icon_color', array(
		'default'           => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'advance_automobile_footer_icon_color', array(
		'label'    => __('Icon Color', 'advance-automobile'),
		'section'  => 'advance_automobile_footer_social_icon',
	)));
	
}
add_action('customize_register', 'advance_automobile_customize_register');

// logo resize
load_template( trailingslashit( get_template_directory() ) . '/inc/logo/logo-resizer.php' );

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Advance_Automobile_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if (is_null($instance)) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action('customize_register', array($this, 'sections'));

		// Register scripts and styles for the conadvance_automobile_Customizetrols.
		add_action('customize_controls_enqueue_scripts', array($this, 'enqueue_control_scripts'), 0);
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections($manager) {

		// Load custom sections.
		load_template(trailingslashit(get_template_directory()).'/inc/section-pro.php');

		// Register custom section types.
		$manager->register_section_type('Advance_Automobile_Customize_Section_Pro');

		// Register sections.
		$manager->add_section(
			new Advance_Automobile_Customize_Section_Pro(
				$manager,
				'advance_automobile_example_1',
				array(
					'priority' => 9,
					'title'    => esc_html__('Advance Automobile', 'advance-automobile'),
					'pro_text' => esc_html__('Get Pro', 'advance-automobile'),
					'pro_url'  => esc_url('https://www.themescaliber.com/products/car-automobile-wordPress-theme'),
				)
			)
		);

		$manager->add_section(
			new Advance_Automobile_Customize_Section_Pro(
				$manager,
				'advance_automobile_doc_link',
				array(
					'priority' => 10,
					'title'    => esc_html__('Guide', 'advance-automobile'),
					'pro_text' => esc_html__('Documentation', 'advance-automobile'),
					'pro_url'  => esc_url('https://preview.themescaliber.com/doc/free-advance-automobile/'),
				)
			)
		);

		$manager->add_section(
			new Advance_Automobile_Customize_Section_Pro(
				$manager,
				'advance_automobile_demo_link',
				array(
					'priority' => 11,
					'title'    => esc_html__('Live Demo', 'advance-automobile'),
					'pro_text' => esc_html__('Preview', 'advance-automobile'),
					'pro_url'  => esc_url('https://preview.themescaliber.com/advance-automobile-pro/'),
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script('advance-automobile-customize-controls', trailingslashit(esc_url(get_template_directory_uri())).'/js/customize-controls.js', array('customize-controls'));
		wp_enqueue_style('advance-automobile-customize-controls', trailingslashit(esc_url(get_template_directory_uri())).'/css/customize-controls.css');
	}
}

// Doing this customizer thang!
Advance_Automobile_Customize::get_instance();