<div class="theme-import">
	<?php 
    // Check if the demo import has been completed
    $advance_automobile_demo_import_completed = get_option('advance_automobile_demo_import_completed', false);

    // If the demo import is completed, display the "View Site" button
        if ($advance_automobile_demo_import_completed) {
        echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'advance-automobile') . '</p>';
        echo '<span><a href="' . esc_url(home_url()) . '"  class= "run-import view-site" target="_blank">' . esc_html__('VIEW SITE', 'advance-automobile') . '</a></span>';
        }


    if (isset($_POST['submit'])) {

    // --- Menu ---
    $advance_automobile_primary_menu_name = 'Main Menu';
    $advance_automobile_primary_menu_location = 'primary';
    $advance_automobile_primary_menu_exists = wp_get_nav_menu_object($advance_automobile_primary_menu_name);

    if (!$advance_automobile_primary_menu_exists) {
        // Create the left menu
        $advance_automobile_primary_menu_id = wp_create_nav_menu($advance_automobile_primary_menu_name);

        // Create and assign the Home page
        $advance_automobile_home_page_id = wp_insert_post(array(
            'post_type'     => 'page',
            'post_title'    => 'Home',
            'post_content'  => '',
            'post_status'   => 'publish',
            'post_author'   => 1,
            'post_name'     => 'home'
        ));
        // Assign template and set as front page
        add_post_meta($advance_automobile_home_page_id, '_wp_page_template', 'page-template/custom-front-page.php');
        update_option('page_on_front', $advance_automobile_home_page_id);
        update_option('show_on_front', 'page');

        // Add Home page to the left menu
        wp_update_nav_menu_item($advance_automobile_primary_menu_id, 0, array(
            'menu-item-title'     => __('Home', 'advance-automobile'),
            'menu-item-classes'   => 'home',
            'menu-item-url'       => home_url('/'),
            'menu-item-status'    => 'publish',
            'menu-item-object-id' => $advance_automobile_home_page_id,
            'menu-item-object'    => 'page',
            'menu-item-type'      => 'post_type',
        ));

        // Create and assign the About Us page
        $advance_automobile_about_us_page_id = wp_insert_post(array(
            'post_type'     => 'page',
            'post_title'    => 'About Us',
            'post_content'  => 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.',
            'post_status'   => 'publish',
            'post_author'   => 1,
            'post_name'     => 'about-us'
        ));

        // Add About Us page to the left menu
        wp_update_nav_menu_item($advance_automobile_primary_menu_id, 0, array(
            'menu-item-title'     => __('About Us', 'advance-automobile'),
            'menu-item-classes'   => 'about-us',
            'menu-item-url'       => home_url('/about-us/'),
            'menu-item-status'    => 'publish',
            'menu-item-object-id' => $advance_automobile_about_us_page_id,
            'menu-item-object'    => 'page',
            'menu-item-type'      => 'post_type',
        ));

        // Assign left menu to its location
        $advance_automobile_locations = get_theme_mod('nav_menu_locations', array());
        $advance_automobile_locations[$advance_automobile_primary_menu_location] = $advance_automobile_primary_menu_id;
        set_theme_mod('nav_menu_locations', $advance_automobile_locations);
    }  

   // Set the demo import completion flag
    		update_option('advance_automobile_demo_import_completed', true);
    		// Display success message and "View Site" button
    		echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'advance-automobile') . '</p>';
    		echo '<span><a href="' . esc_url(home_url()) . '" class="run-import site-btn" target="_blank">' . esc_html__('VIEW SITE', 'advance-automobile') . '</a></span>';

    //end

    // Social Icons
    set_theme_mod( 'advance_automobile_facebook_url', '#' );
    set_theme_mod( 'advance_automobile_twitter_url', '#' );    
    set_theme_mod( 'advance_automobile_youtube_url', '#' );
    set_theme_mod( 'advance_automobile_linkedin_url', '#' );

    // Topbar Section
    set_theme_mod( 'advance_automobile_mail1', 'support@example.com' );
    set_theme_mod( 'advance_automobile_book1', 'BOOK NOW' );
    set_theme_mod( 'advance_automobile_book', '#' );

    // Contact details
    set_theme_mod( 'advance_automobile_address', 'Lorem Ipsum' );
    set_theme_mod( 'advance_automobile_address1', '09 Lorem ipsum United Kingdom' );
    set_theme_mod( 'advance_automobile_time', 'Lorem Ipsum' );
    set_theme_mod( 'advance_automobile_time1', 'Monday - Friday: 7.30am - 5.30pm' );
    set_theme_mod( 'advance_automobile_call', 'Lorem Ipsum' );
    set_theme_mod( 'advance_automobile_call1', '+01234-5678-90 / +09876-543-21' );

    // Slider
    for($advance_automobile_i=1;$advance_automobile_i<=4;$advance_automobile_i++){
       $advance_automobile_slider_title = 'LOREM IPSUM IS SIMPLY DUMMY';
       $advance_automobile_slider_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.';
          // Create post object
       $advance_automobile_my_post = array(
       'post_title'    => wp_strip_all_tags( $advance_automobile_slider_title ),
       'post_content'  => $advance_automobile_slider_content,
       'post_status'   => 'publish',
       'post_type'     => 'page',
       );

       // Insert the post into the database
       $advance_automobile_post_id = wp_insert_post( $advance_automobile_my_post );

       if ($advance_automobile_post_id) {
         // Set the theme mod for the slider page
         set_theme_mod('advance_automobile_slider_page' . $advance_automobile_i, $advance_automobile_post_id);

          $advance_automobile_image_url = get_template_directory_uri().'/images/slider'.$advance_automobile_i.'.png';

        $advance_automobile_image_id = media_sideload_image($advance_automobile_image_url, $advance_automobile_post_id, null, 'id');

            if (!is_wp_error($advance_automobile_image_id)) {
                // Set the downloaded image as the post's featured image
                set_post_thumbnail($advance_automobile_post_id, $advance_automobile_image_id);
            }
        }
    }

    // How it works Section
    set_theme_mod( 'advance_automobile_our_services_title', 'Our Services' );

    // Post Category
    set_theme_mod( 'advance_automobile_category3', 'category1' );
    // Define post category names and post titles
    $advance_education_category_names = array('category1', 'category2', 'category3');
    $advance_education_title_array = array(
        array("Service Title 1", "Service Title 2", "Service Title 3"),
        array("Service Title 1", "Service Title 2", "Service Title 3"),
        array("Service Title 1", "Service Title 2", "Service Title 3")
    );

        foreach ($advance_education_category_names as $advance_education_index => $advance_education_category_name) {
            // Create or retrieve the post category term ID
            $advance_education_term = term_exists($advance_education_category_name, 'category');
            if ($advance_education_term === 0 || $advance_education_term === null) {
                // If the term does not exist, create it
                $advance_education_term = wp_insert_term($advance_education_category_name, 'category');
            }
            if (is_wp_error($advance_education_term)) {
                error_log('Error creating category: ' . $advance_education_term->get_error_message());
                continue; // Skip to the next iteration if category creation fails
            }

            for ($advance_education_i = 0; $advance_education_i < 3; $advance_education_i++) {
                // Create post content
                $advance_education_title = $advance_education_title_array[$advance_education_index][$advance_education_i];
                $advance_education_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eius- mod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in repre- henderit in voluptate.';

                // Create post post object
                $advance_education_my_post = array(
                    'post_title'    => wp_strip_all_tags($advance_education_title),
                    'post_content'  => $advance_education_content,
                    'post_status'   => 'publish',
                    'post_type'     => 'post', // Post type set to 'post'
                );

                // Insert the post into the database
                $advance_education_post_id = wp_insert_post($advance_education_my_post);

                if (is_wp_error($advance_education_post_id)) {
                    error_log('Error creating post: ' . $advance_education_post_id->get_error_message());
                    continue; // Skip to the next post if creation fails
                }

                // Assign the category to the post
                wp_set_post_categories($advance_education_post_id, array((int)$advance_education_term['term_id']));

                // Handle the featured image using media_sideload_image
                $advance_education_image_url = get_template_directory_uri() . '/images/image' . ($advance_education_i + 1) . '.png';
                $advance_education_image_id = media_sideload_image($advance_education_image_url, $advance_education_post_id, null, 'id');

                if (is_wp_error($advance_education_image_id)) {
                    error_log('Error downloading image: ' . $advance_education_image_id->get_error_message());
                    continue; // Skip to the next post if image download fails
                }
                // Assign featured image to post
                set_post_thumbnail($advance_education_post_id, $advance_education_image_id);
            }
        }
        
           
    }
    
    ?>

	    <p class="note"><?php esc_html_e( 'Please Note: If your website is live and already contains data, we recommend creating a backup first. Running this importer will replace your current settings with the custom values from the demo.', 'advance-automobile' ); ?></p>
        <form action="<?php echo esc_url(home_url()); ?>/wp-admin/themes.php?page=advance_automobile_guide" method="POST" onsubmit="return validate(this);">
        <?php if (!get_option('advance_automobile_demo_import_completed')) : ?>
            <button type="submit" name="submit" class="run-import">
                    <?php esc_html_e('Run Importer','advance-automobile'); ?>
                    <span id="spinner" style="display: none;">
                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/spinner.gif" alt="Loading..." style="width:34px; height:34px; vertical-align: middle;" />
                    </span>
            </button>
        <?php endif; ?>
        </form>
        <script type="text/javascript">
            function validate(valid) {
                if(confirm("Do you really want to import the theme demo content?")){
                    document.getElementById('spinner').style.display = 'inline-block';
                }
                else {
                    return false;
                }
            }
        </script>
	
    
</div>
