<?php
//about theme info
add_action( 'admin_menu', 'advance_automobile_gettingstarted' );
function advance_automobile_gettingstarted() {    	
	add_theme_page( esc_html__('Theme Demo Content', 'advance-automobile'), esc_html__('Theme Demo Content', 'advance-automobile'), 'edit_theme_options', 'advance_automobile_guide', 'advance_automobile_mostrar_guide');   
}

// Add a Custom CSS file to WP Admin Area
function advance_automobile_admin_theme_style() {
   wp_enqueue_style('advance-automobile-custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/admin/admin.css');
   wp_enqueue_script('tabs', esc_url(get_template_directory_uri()) . '/inc/admin/js/tab.js');

   // Admin notice code START
	wp_register_script('advance-automobile-notice', esc_url(get_template_directory_uri()) . '/inc/admin/js/notice.js', array('jquery'), time(), true);
	wp_enqueue_script('advance-automobile-notice');
	// Admin notice code END
}
add_action('admin_enqueue_scripts', 'advance_automobile_admin_theme_style');

//guidline for about theme
function advance_automobile_mostrar_guide() { 
	//custom function about theme customizer
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( 'advance-automobile' );
?>

<div class="wrapper-info">  
	<div id="tc-header">
		<div class="tc-container  main-header">
			<a class="tc-logo">
				<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/admin/images/logo.png" alt="" />
			</a>
			<span class="tc-header-action">
			<a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e('Customize', 'advance-automobile'); ?></a>
			<a href="<?php echo esc_url( ADVANCE_AUTOMOBILE_FREE_DOC ); ?>" target="_blank"> <?php esc_html_e( 'Documentation', 'advance-automobile' ); ?></a>
			<a href="<?php echo esc_url( 'https://www.themescaliber.com/products/car-automobile-wordPress-theme'); ?>" target="_blank"> <?php esc_html_e( 'Get Premium', 'advance-automobile' ); ?></a>
			<a href="<?php echo esc_url( 'https://www.themescaliber.com/products/wordpress-theme-bundle' ); ?>" class="bundle_btn" target="_blank"> <?php esc_html_e( 'Bundle of 220+ Themes at $99', 'advance-automobile' ); ?></a>
			</span>
		</div>
	</div>
	<div class="tc-container tab-sec">
		<div class="tc-tabs">
			<ul>
				<li class="tablinks home active" onclick="advance_automobile_openCity(event, 'tc_demo')">
					<a href="#">
						<?php esc_html_e( 'Theme Demo Import', 'advance-automobile' ); ?>
					</a>
				</li>
				<li class="tablinks" onclick="advance_automobile_openCity(event, 'tc_index')">
					<a href="#">
						<?php esc_html_e( 'Free Theme Information', 'advance-automobile' ); ?>
					</a>
				</li>
				<li class="tablinks" onclick="advance_automobile_openCity(event, 'tc_pro')">
					<a href="#">
						<?php esc_html_e( 'Premium Theme Information', 'advance-automobile' ); ?>
					</a>
				</li>
				<li class="tablinks" onclick="advance_automobile_openCity(event, 'tc_create')">
					<a href="#">
						<?php esc_html_e( 'Theme Support', 'advance-automobile' ); ?>
					</a>
				</li>
			</ul>
		</div><!-- END .tc-tabs -->
	</div>

	<div class="tc-container">
		<div class="tc-section">
			<div  id="tc_demo" class="tabcontent">
				<h2><?php esc_html_e( 'Welcome to Advance Automobile', 'advance-automobile' ); ?> <span class="version">Version: <?php echo esc_html($theme['Version']);?></span></h2>
				<hr>
				<div class="demo">
					<h4><?php esc_html_e( 'Click the "Run Importer" button below to load demo content for Advance Automobile', 'advance-automobile' ); ?></h4>
					<?php /* Demo Import */ require get_parent_theme_file_path( '/inc/admin/demo-import.php' );?>
				</div>
			</div><!-- END .tc-section -->
		</div>
	</div>

	<div class="tc-container">
		<div class="tc-section">
			<div  id="tc_index" class="tabcontent">
				<h2><?php esc_html_e( 'Welcome to Advance Automobile Theme', 'advance-automobile' ); ?> <span class="version">Version: <?php echo esc_html($theme['Version']);?></span></h2>
				<hr>
				<div class="info-link">
					<a href="<?php echo esc_url( ADVANCE_AUTOMOBILE_FREE_DOC ); ?>" target="_blank"> <?php esc_html_e( 'Documentation', 'advance-automobile' ); ?></a>
					<a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e('Customizing', 'advance-automobile'); ?></a>
					<a class="get-pro" href="<?php echo esc_url( ADVANCE_AUTOMOBILE_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Get Pro', 'advance-automobile'); ?></a>
				</div>
				<div class="col-tc-6">
					<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/admin/images/screenshot.jpg" alt="" />
				</div>
				<div class="col-tc-6">
				<P><?php esc_html_e( 'Advance Automobile is a stylish, versatile, modern, and resourceful theme for car showrooms, automobile garages, second-hand car selling companies, car dealerships, rental cars, brake shops, road trip accessories, bike overhauling, bike rentals, oil change services, car listings, auto listings, lift trucks, service stations, tire stores, wheel alignment services, auto service applications, auto mechanics, automotive workshops, vehicle sales, car repair, car services, automotive parts, car rentals, auto leasing, vehicle maintenance, green fuel initiatives, automobile accessories, car perfumes, car mats, wheel shops, garages, automobile mechanicals, car AMC services, motorcycles, bicycles, auto painting, auto centers, tow trucking services, spare parts, battery reconditioning, auto-body stores, car repairing centers, car wash centers, agricultural vehicles, heavy vehicles, motorbike showrooms, bike garages, tyre services, car servicing, cab services, and other automotive-related businesses. It gives the perfect skin for automotive sector websites whether it is a blog, portfolio, or any other platform. Highly customizable, it features easily changeable elements, custom-menu options, and SEO-optimized clean code for better rankings. Fully responsive, retina-ready, and translation-ready, it supports multiple languages including Arabic, Chinese, French, German, Spanish, Italian, Japanese, Russian, and Turkish. Fully compatible with WooCommerce for automotive product sales, Contact Form 7 for inquiries and bookings, YITH WooCommerce Wishlist, and YITH WooCommerce Compare, Advance Automobile provides a comprehensive and professional solution for automotive businesses.', 'advance-automobile' ); ?></P>
				</div>
			</div>
		</div><!-- END .tc-section -->
	</div>

	<div class="tc-container">
		<div class="tc-section">
			<div id="tc_pro" class="tabcontent">
				<h3><?php esc_html_e( 'Advance Automobile Theme Information', 'advance-automobile' ); ?></h3>
				<hr>
				<div class="info-link-pro">
					<a href="<?php echo esc_url( ADVANCE_AUTOMOBILE_BUY_NOW ); ?>" target="_blank"> <?php esc_html_e( 'Buy Now', 'advance-automobile' ); ?></a>
					<a href="<?php echo esc_url( ADVANCE_AUTOMOBILE_LIVE_DEMO ); ?>" target="_blank"> <?php esc_html_e( 'Live Demo', 'advance-automobile' ); ?></a>
					<a href="<?php echo esc_url( ADVANCE_AUTOMOBILE_PRO_DOC ); ?>" target="_blank"> <?php esc_html_e( 'Pro Documentation', 'advance-automobile' ); ?></a>
				</div>
				<div class="pro-image">
					<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/admin/images/responsiveimg.jpg" alt="" />
				</div>
			<div class="col-pro-5">
				<h4><?php esc_html_e( 'Advance Automobile Pro Theme', 'advance-automobile' ); ?></h4>
				<P><?php esc_html_e( 'Buying this automobile WordPress theme will be the best decision for your automobile website. It is smart, resourceful, eye-catching and bold. It can serve for car dealers, car showrooms, automobile garage, car rentals, cab service, bike showroom and similar businesses. It is a responsive theme with mobile first approach, multi-browser compatible, translation ready and supports RTL writing. It supports various post formats like gallery, testimonial section, video on homepage, subscription form and others. Though this automobile WordPress theme has sufficient inner pages predesigned like about us, contact us, blog etc., but if you want you can design them on your own with the help of page builder. You can change the layout of the theme from boxed to full width to full screen. Add sidebars on one or both side and use it to display ads to get extra earning. Choose from the unlimited colours and Google fonts to change the look of the website.', 'advance-automobile' ); ?></P>	
			</div>
			<div class="col-pro-6">				
				<h4><?php esc_html_e( 'Theme Features', 'advance-automobile' ); ?></h4>
				<ul>
					<li><?php esc_html_e( 'Theme Options using Customizer API', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Responsive design', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Favicon, Logo, title, and tagline customization', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Advanced Color options', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( '100+ Font Family Options', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Background Image Option', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Simple Menu Option', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Additional section for products', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Enable-Disable options on All sections', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Home Page setting for different sections', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Advance Slider with unlimited slides', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Partner Section', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Promotional Banner Section for Products', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Separate Newsletter Section', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Text and call to action button for each slide', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Pagination option', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Custom CSS option', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Translations Ready', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Custom Backgrounds, Colors, Headers, Logo & Menu', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Customizable Home Page', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Full-Width Template', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Footer Widgets & Editor Style', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Banner & Post Type Plugin Functionality', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Testimonial Post type', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Woo Commerce Compatible', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Multiple Inner Page Templates', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Product Sliders', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Testimonial Slider', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Contact page template', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Contact Widget', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Advance Social Media Feature', 'advance-automobile' ); ?></li>
					<li><?php esc_html_e( 'Testimonial Listing With Shortcode', 'advance-automobile' ); ?></li>
				</ul>				
			</div>	
		</div><!-- END .tc-section -->
	</div>

	<div class="tc-container">
		<div class="tc-section">
			<div id="tc_create" class="tabcontent">
				<div class="tab-cont">
					<h4><?php esc_html_e( 'Need Support?', 'advance-automobile' ); ?></h4>				
					<div class="info-link-support">
						<P><?php esc_html_e( 'Our team is obliged to help you in every way possible whenever you face any type of difficulties and doubts.', 'advance-automobile' ); ?></P>
						<a href="<?php echo esc_url( ADVANCE_AUTOMOBILE_SUPPORT ); ?>" target="_blank"> <?php esc_html_e( 'Support Forum', 'advance-automobile' ); ?></a>
					</div>
				</div>
				<div class="tab-cont">	
					<h4><?php esc_html_e('Reviews', 'advance-automobile'); ?></h4>				
					<div class="info-link-support">
						<P><?php esc_html_e( 'It is commendable to have such a theme inculcated with amazing features and robust functionalities. I feel grateful to recommend this theme to one and all.', 'advance-automobile' ); ?></P>
						<a href="<?php echo esc_url( ADVANCE_AUTOMOBILE_REVIEW ); ?>" target="_blank"><?php esc_html_e('Reviews', 'advance-automobile'); ?></a>
					</div>
				</div>

				<div class="tc-section large-section">
					<h2>Let‘s customize your website</h2>
					<p>There are many changes you can make to customize your website. Explore customization options and make it unique.</p>
					<div class="tc-buttons">
						<a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>" class="tc-btn primary large-button"><?php esc_html_e('Start Customizing', 'advance-automobile'); ?></a>
					</div><!-- END .tc-buttons -->
				</div>
			</div>
		</div><!-- END .tc-section -->
	</div>
</div>
<?php } ?>