<?php
/**
 * Sample implementation of the Custom Header feature
 *
 * @link https://developer.wordpress.org/block-editor/developers/block-api/block-patterns/
 *
 * @package Ada_Pearl
 */

/**
 * Create custom block patterns to complement the theme.
 */
function ada_pearl_register_block_patterns() {

	if ( class_exists( 'WP_Block_Patterns_Registry' ) ) {

		register_block_pattern_category(
			__( 'banners', 'ada-pearl' ),
			array(
				'label' => __( 'Banners', 'ada-pearl' )
			)
		);

		register_block_pattern_category(
			__( 'call-to-actions', 'ada-pearl' ),
			array(
				'label' => __( 'Call To Actions', 'ada-pearl' )
			)
		);

		register_block_pattern_category(
			__( 'meet-the-team', 'ada-pearl' ),
			array(
				'label' => __( 'Meet The Team', 'ada-pearl' )
			)
		);

		register_block_pattern_category(
			__( 'pricing-plans', 'ada-pearl' ),
			array(
				'label' => __( 'Pricing Plans', 'ada-pearl' )
			)
		);

		register_block_pattern_category(
			__( 'portfolio', 'ada-pearl' ),
			array(
				'label' => __( 'Portfolio', 'ada-pearl' )
			)
		);

		register_block_pattern_category(
			__( 'services', 'ada-pearl' ),
			array(
				'label' => __( 'Services', 'ada-pearl' )
			)
		);

		register_block_pattern(
			'ada/banner',
			array(
				'title'       => __( 'Basic Banner', 'ada-pearl' ),
				'description' => __( 'A Basic Banner', 'ada-pearl' ),
				'content'     => "<!-- wp:cover {\"url\":\"" . esc_url( get_template_directory_uri() ) . "/images/the-garden-at-bougival-1884.jpg\",\"id\":19,\"overlayColor\":\"black\",\"minHeight\":400,\"contentPosition\":\"center center\",\"align\":\"full\",\"className\":\"banner\"} -->\n<div class=\"wp-block-cover alignfull has-black-background-color has-background-dim is-position-center-center banner\" style=\"background-image:url(" . esc_url( get_template_directory_uri() ) . "/images/the-garden-at-bougival-1884.jpg);min-height:400px\"><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"level\":1} -->\n<h1>Page Title</h1>\n<!-- /wp:heading --></div></div>\n<!-- /wp:cover -->",
				'categories'  => array( 'banners' ),
			)
		);

		register_block_pattern(
			'ada/banner-description',
			array(
				'title'       => __( 'Banner with description', 'ada-pearl' ),
				'description' => __( 'A Banner with a description', 'ada-pearl' ),
				'content'     => "<!-- wp:cover {\"url\":\"" . esc_url( get_template_directory_uri() ) . "/images/the-garden-at-bougival-1884.jpg\",\"id\":19,\"overlayColor\":\"black\",\"contentPosition\":\"center center\",\"align\":\"full\",\"className\":\"banner-description\"} -->\n<div class=\"wp-block-cover alignfull has-black-background-color has-background-dim is-position-center-center banner-description\" style=\"background-image:url(" . esc_url( get_template_directory_uri() ) . "/images/the-garden-at-bougival-1884.jpg)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"level\":1} -->\n<h1>Page Title</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Vestibulum quis turpis non nulla commodo mattis a et justo. Suspendisse nulla sapien, scelerisque vel varius id, auctor vitae lacus. Nulla vehicula libero eu consequat mattis. Vestibulum posuere, ante eget commodo convallis, risus felis pellentesque lacus, at vehicula arcu nulla ac arcu. Nulla tincidunt nibh in massa euismod sodales. In pellentesque metus dolor, condimentum cursus elit posuere sit amet. Nullam nec facilisis metus.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->",
				'categories'  => array( 'banners' ),
			)
		);

		register_block_pattern(
			'ada/banner-description-button',
			array(
				'title'       => __( 'Banner with description and button', 'ada-pearl' ),
				'description' => __( 'A Banner with a description and button', 'ada-pearl' ),
				'content'     => "<!-- wp:cover {\"url\":\"" . esc_url( get_template_directory_uri() ) . "/images/the-garden-at-bougival-1884.jpg\",\"id\":19,\"overlayColor\":\"black\",\"contentPosition\":\"center center\",\"align\":\"full\",\"className\":\"banner-description-button\"} -->\n<div class=\"wp-block-cover alignfull has-black-background-color has-background-dim is-position-center-center banner-description-button\" style=\"background-image:url(" . esc_url( get_template_directory_uri() ) . "/images/the-garden-at-bougival-1884.jpg)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"level\":1,\"style\":{\"typography\":{\"fontSize\":42}}} -->\n<h1 style=\"font-size:42px\">Page Title</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Vestibulum quis turpis non nulla commodo mattis a et justo. Suspendisse nulla sapien, scelerisque vel varius id, auctor vitae lacus. Nulla vehicula libero eu consequat mattis. Vestibulum posuere, ante eget commodo convallis, risus felis pellentesque lacus, at vehicula arcu nulla ac arcu. Nulla tincidunt nibh in massa euismod sodales. In pellentesque metus dolor, condimentum cursus elit posuere sit amet. Nullam nec facilisis metus.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":0,\"textColor\":\"white\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-white-color has-text-color no-border-radius\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:cover -->",
				'categories'  => array( 'banners' ),
			)
		);

		register_block_pattern(
			'ada/call-to-action',
			array(
				'title'       => __( 'Basic Call To Action', 'ada-pearl' ),
				'description' => __( 'Basic Call To Action block with title, description and button', 'ada-pearl' ),
				'content'     => "<!-- wp:group {\"align\":\"full\",\"className\":\"call-to-action\",\"backgroundColor\":\"vivid-red\",\"textColor\":\"white\"} -->\n<div class=\"wp-block-group alignfull call-to-action has-white-color has-vivid-red-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading {\"align\":\"left\",\"style\":{\"typography\":{\"fontSize\":32}}} -->\n<h2 class=\"has-text-align-left\" style=\"font-size:32px\">Call To Action</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">Vivamus ullamcorper neque et metus ultricies, at convallis ex convallis. Pellentesque sem sapien, suscipit sed euismod vel, interdum ultricies nulla. Fusce maximus est ut neque euismod semper. Nulla massa urna, aliquam sed mi ac, pellentesque efficitur purus.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":0,\"textColor\":\"white\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-white-color has-text-color no-border-radius\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:group -->",
				'categories'  => array( 'call-to-actions' ),
			)
		);

		register_block_pattern(
			'ada/cover-call-to-action',
			array(
				'title'       => __( 'Cover Call To Action', 'ada-pearl' ),
				'description' => __( 'Cover Call To Action block with title, description and button', 'ada-pearl' ),
				'content'     => "<!-- wp:cover {\"url\":\"" . esc_url( get_template_directory_uri() ) . "/images/the-garden-at-bougival-1884.jpg\",\"id\":19,\"hasParallax\":true,\"align\":\"full\",\"className\":\"cover-call-to-action\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim has-parallax cover-call-to-action\" style=\"background-image:url(" . esc_url( get_template_directory_uri() ) . "/images/the-garden-at-bougival-1884.jpg)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"style\":{\"typography\":{\"fontSize\":32}}} -->\n<h2 style=\"font-size:32px\">Call To Action</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Vivamus ullamcorper neque et metus ultricies, at convallis ex convallis. Pellentesque sem sapien, suscipit sed euismod vel, interdum ultricies nulla. Fusce maximus est ut neque euismod semper. Nulla massa urna, aliquam sed mi ac, pellentesque efficitur purus.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":0,\"textColor\":\"white\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-white-color has-text-color no-border-radius\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:cover -->",
				'categories'  => array( 'call-to-actions' ),
			)
		);

		register_block_pattern(
			'ada/meet-the-team-2-1',
			array(
				'title'       => __( 'Meet The Team (2 x 1)', 'ada-pearl' ),
				'description' => __( 'A Meet the Team block with 2 team members', 'ada-pearl' ),
				'content'     => "<!-- wp:group {\"className\":\"meet-the-team meet-the-team-2-1\"} -->\n<div class=\"wp-block-group meet-the-team meet-the-team-2-1\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":32}}} -->\n<h2 class=\"has-text-align-center\" style=\"font-size:32px\">Meet The Team</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"color\":{\"background\":\"#e0e0e0\"}}} -->\n<div class=\"wp-block-group has-background\" style=\"background-color:#e0e0e0\"><div class=\"wp-block-group__inner-container\"><!-- wp:image {\"id\":103,\"sizeSlug\":\"large\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-large is-style-default\"><img src=\"" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg\" alt=\"\" class=\"wp-image-103\"/><figcaption><strong>Team Member Name</strong> <br><em>Job Title</em></figcaption></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam augue magna, ornare vitae sapien id, tincidunt vehicula mi. Proin viverra eros feugiat, molestie ante sed, pellentesque quam. Mauris mollis leo at libero pulvinar convallis. Phasellus mollis sagittis nisi, ut consequat neque fringilla vitae.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Pellentesque sed augue erat. Proin nec tincidunt nibh. Nunc hendrerit tempor justo ac placerat. Sed ac eros orci. Mauris ut sem quis diam finibus ultricies. Nam tincidunt tempus sollicitudin. Vestibulum efficitur congue odio ac tempus.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"color\":{\"background\":\"#e0e0e0\"}}} -->\n<div class=\"wp-block-group has-background\" style=\"background-color:#e0e0e0\"><div class=\"wp-block-group__inner-container\"><!-- wp:image {\"id\":103,\"sizeSlug\":\"large\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-large is-style-default\"><img src=\"" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg\" alt=\"\" class=\"wp-image-103\"/><figcaption><strong>Team Member Name</strong> <br><em>Job Title</em></figcaption></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam augue magna, ornare vitae sapien id, tincidunt vehicula mi. Proin viverra eros feugiat, molestie ante sed, pellentesque quam. Mauris mollis leo at libero pulvinar convallis. Phasellus mollis sagittis nisi, ut consequat neque fringilla vitae.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:group -->",
				'categories'  => array( 'meet-the-team' ),
			)
		);

		register_block_pattern(
			'ada/meet-the-team-2-2',
			array(
				'title'       => __( 'Meet The Team (2 x 2)', 'ada-pearl' ),
				'description' => __( 'A Meet the Team block with 4 team members', 'ada-pearl' ),
				'content'     => "<!-- wp:group {\"className\":\"meet-the-team meet-the-team-2-2\"} -->\n<div class=\"wp-block-group meet-the-team meet-the-team-2-2\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":32}}} -->\n<h2 class=\"has-text-align-center\" style=\"font-size:32px\">Meet The Team</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"color\":{\"background\":\"#e0e0e0\"}}} -->\n<div class=\"wp-block-group has-background\" style=\"background-color:#e0e0e0\"><div class=\"wp-block-group__inner-container\"><!-- wp:image {\"id\":103,\"sizeSlug\":\"large\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-large is-style-default\"><img src=\"" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg\" alt=\"\" class=\"wp-image-103\"/><figcaption><strong>Team Member Name</strong> <br><em>Job Title</em></figcaption></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam augue magna, ornare vitae sapien id, tincidunt vehicula mi. Proin viverra eros feugiat, molestie ante sed, pellentesque quam. Mauris mollis leo at libero pulvinar convallis. Phasellus mollis sagittis nisi, ut consequat neque fringilla vitae.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Pellentesque sed augue erat. Proin nec tincidunt nibh. Nunc hendrerit tempor justo ac placerat. Sed ac eros orci. Mauris ut sem quis diam finibus ultricies. Nam tincidunt tempus sollicitudin. Vestibulum efficitur congue odio ac tempus.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"color\":{\"background\":\"#e0e0e0\"}}} -->\n<div class=\"wp-block-group has-background\" style=\"background-color:#e0e0e0\"><div class=\"wp-block-group__inner-container\"><!-- wp:image {\"id\":103,\"sizeSlug\":\"large\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-large is-style-default\"><img src=\"" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg\" alt=\"\" class=\"wp-image-103\"/><figcaption><strong>Team Member Name</strong> <br><em>Job Title</em></figcaption></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam augue magna, ornare vitae sapien id, tincidunt vehicula mi. Proin viverra eros feugiat, molestie ante sed, pellentesque quam. Mauris mollis leo at libero pulvinar convallis. Phasellus mollis sagittis nisi, ut consequat neque fringilla vitae.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"color\":{\"background\":\"#e0e0e0\"}}} -->\n<div class=\"wp-block-group has-background\" style=\"background-color:#e0e0e0\"><div class=\"wp-block-group__inner-container\"><!-- wp:image {\"id\":103,\"sizeSlug\":\"large\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-large is-style-default\"><img src=\"" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg\" alt=\"\" class=\"wp-image-103\"/><figcaption><strong>Team Member Name</strong> <br><em>Job Title</em></figcaption></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam augue magna, ornare vitae sapien id, tincidunt vehicula mi. Proin viverra eros feugiat, molestie ante sed, pellentesque quam. Mauris mollis leo at libero pulvinar convallis.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Pellentesque sed augue erat. Proin nec tincidunt nibh. Nunc hendrerit tempor justo ac placerat. Sed ac eros orci. Mauris ut sem quis diam finibus ultricies. Nam tincidunt tempus sollicitudin. Vestibulum efficitur congue odio ac tempus.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"color\":{\"background\":\"#e0e0e0\"}}} -->\n<div class=\"wp-block-group has-background\" style=\"background-color:#e0e0e0\"><div class=\"wp-block-group__inner-container\"><!-- wp:image {\"id\":103,\"sizeSlug\":\"large\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-large is-style-default\"><img src=\"" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg\" alt=\"\" class=\"wp-image-103\"/><figcaption><strong>Team Member Name</strong> <br><em>Job Title</em></figcaption></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam augue magna, ornare vitae sapien id, tincidunt vehicula mi. Proin viverra eros feugiat, molestie ante sed, pellentesque quam. </p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:group -->",
				'categories'  => array( 'meet-the-team' ),
			)
		);

		register_block_pattern(
			'ada/pricing-plans-2-1',
			array(
				'title'       => __( 'Pricing Plans (2 x 1)', 'ada-pearl' ),
				'description' => __( 'A Pricing plan block with 2 pricing options', 'ada-pearl' ),
				'content'     => "<!-- wp:group {\"align\":\"full\",\"className\":\"pricing-plans pricing-plans-2-1\",\"backgroundColor\":\"vivid-red\",\"textColor\":\"white\"} -->\n<div class=\"wp-block-group alignfull pricing-plans pricing-plans-2-1 has-white-color has-vivid-red-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":32}}} -->\n<h2 class=\"has-text-align-center\" style=\"font-size:32px\">Pricing Plans</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse potenti. Aenean enim massa, hendrerit sed finibus id, ullamcorper id ante. Nam quis sodales sem. Praesent ut orci molestie, tincidunt urna eget, consectetur leo. Duis vel facilisis turpis. Nulla ut feugiat magna, vel porta erat. Fusce arcu turpis, dapibus sit amet tempor non, porta in neque.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"backgroundColor\":\"white\",\"textColor\":\"black\"} -->\n<div class=\"wp-block-group has-black-color has-white-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading {\"align\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":28}}} -->\n<h3 class=\"has-text-align-center\" style=\"font-size:28px\">Plan #1</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"normal\"} -->\n<p class=\"has-text-align-center has-normal-font-size\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam euismod nisl in justo consequat, sed efficitur mauris molestie. Integer in iaculis nisl. Aliquam laoreet arcu nec risus ultrices finibus.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse potenti. Aenean enim massa, hendrerit sed finibus id, ullamcorper id ante</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"align\":\"center\",\"level\":4,\"fontSize\":\"medium\"} -->\n<h4 class=\"has-text-align-center has-medium-font-size\">£10 Monthly</h4>\n<!-- /wp:heading -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":0,\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link no-border-radius\">Buy</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"backgroundColor\":\"white\",\"textColor\":\"black\"} -->\n<div class=\"wp-block-group has-black-color has-white-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading {\"align\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":28}}} -->\n<h3 class=\"has-text-align-center\" style=\"font-size:28px\">Plan #2</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"normal\"} -->\n<p class=\"has-text-align-center has-normal-font-size\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse potenti. Aenean enim massa, hendrerit sed finibus id, ullamcorper id ante. Nam quis sodales sem. Praesent ut orci molestie, tincidunt urna eget, consectetur leo. Duis vel facilisis turpis. Nulla ut feugiat magna, vel porta erat. Fusce arcu turpis, dapibus sit amet tempor non, porta in neque. Nam aliquet arcu vel fermentum aliquet. Aenean tristique sed eros vitae varius. Sed ut sodales diam. Curabitur tristique metus ac erat sagittis tincidunt.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"align\":\"center\",\"level\":4,\"fontSize\":\"medium\"} -->\n<h4 class=\"has-text-align-center has-medium-font-size\">£15 Monthly</h4>\n<!-- /wp:heading -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":0,\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link no-border-radius\">Buy</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:group -->",
				'categories'  => array( 'pricing-plans' ),
			)
		);

		register_block_pattern(
			'ada/pricing-plans-2-2',
			array(
				'title'       => __( 'Pricing Plans (2 x 2)', 'ada-pearl' ),
				'description' => __( 'A Pricing Plan block with 4 pricing options', 'ada-pearl' ),
				'content'     => "<!-- wp:group {\"align\":\"full\",\"className\":\"pricing-plans pricing-plans-2-2\",\"backgroundColor\":\"vivid-red\",\"textColor\":\"white\"} -->\n<div class=\"wp-block-group alignfull pricing-plans pricing-plans-2-2 has-white-color has-vivid-red-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":32}}} -->\n<h2 class=\"has-text-align-center\" style=\"font-size:32px\">Pricing Plans</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse potenti. Aenean enim massa, hendrerit sed finibus id, ullamcorper id ante. Nam quis sodales sem. Praesent ut orci molestie, tincidunt urna eget, consectetur leo. Duis vel facilisis turpis. Nulla ut feugiat magna, vel porta erat. Fusce arcu turpis, dapibus sit amet tempor non, porta in neque.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"backgroundColor\":\"white\",\"textColor\":\"black\"} -->\n<div class=\"wp-block-group has-black-color has-white-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading {\"align\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":28}}} -->\n<h3 class=\"has-text-align-center\" style=\"font-size:28px\">Plan #1</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"normal\"} -->\n<p class=\"has-text-align-center has-normal-font-size\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam euismod nisl in justo consequat, sed efficitur mauris molestie. Integer in iaculis nisl. Aliquam laoreet arcu nec risus ultrices finibus.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse potenti. Aenean enim massa, hendrerit sed finibus id, ullamcorper id ante</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"align\":\"center\",\"level\":4,\"fontSize\":\"medium\"} -->\n<h4 class=\"has-text-align-center has-medium-font-size\">£10 Monthly</h4>\n<!-- /wp:heading -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":0,\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link no-border-radius\">Buy</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"backgroundColor\":\"white\",\"textColor\":\"black\"} -->\n<div class=\"wp-block-group has-black-color has-white-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading {\"align\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":28}}} -->\n<h3 class=\"has-text-align-center\" style=\"font-size:28px\">Plan #2</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"normal\"} -->\n<p class=\"has-text-align-center has-normal-font-size\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse potenti. Aenean enim massa, hendrerit sed finibus id, ullamcorper id ante. Nam quis sodales sem. Praesent ut orci molestie, tincidunt urna eget, consectetur leo. Duis vel facilisis turpis. Nulla ut feugiat magna, vel porta erat. Fusce arcu turpis, dapibus sit amet tempor non, porta in neque. Nam aliquet arcu vel fermentum aliquet. Aenean tristique sed eros vitae varius. Sed ut sodales diam. Curabitur tristique metus ac erat sagittis tincidunt.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"align\":\"center\",\"level\":4,\"fontSize\":\"medium\"} -->\n<h4 class=\"has-text-align-center has-medium-font-size\">£15 Monthly</h4>\n<!-- /wp:heading -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":0,\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link no-border-radius\">Buy</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"backgroundColor\":\"white\",\"textColor\":\"black\"} -->\n<div class=\"wp-block-group has-black-color has-white-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading {\"align\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":28}}} -->\n<h3 class=\"has-text-align-center\" style=\"font-size:28px\">Plan #3</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"normal\"} -->\n<p class=\"has-text-align-center has-normal-font-size\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam euismod nisl in justo consequat, sed efficitur mauris molestie. Integer in iaculis nisl. Aliquam laoreet arcu nec risus ultrices finibus.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"align\":\"center\",\"level\":4,\"fontSize\":\"medium\"} -->\n<h4 class=\"has-text-align-center has-medium-font-size\">£20 Monthly</h4>\n<!-- /wp:heading -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":0,\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link no-border-radius\">Buy</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"backgroundColor\":\"white\",\"textColor\":\"black\"} -->\n<div class=\"wp-block-group has-black-color has-white-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading {\"align\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":28}}} -->\n<h3 class=\"has-text-align-center\" style=\"font-size:28px\">Plan #4</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"normal\"} -->\n<p class=\"has-text-align-center has-normal-font-size\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse potenti. Aenean enim massa, hendrerit sed finibus id, ullamcorper id ante. Nam quis sodales sem. Praesent ut orci molestie, tincidunt urna eget, consectetur leo. Duis vel facilisis turpis. Nulla ut feugiat magna, vel porta erat. Fusce arcu turpis, dapibus sit amet tempor non, porta in neque. Nam aliquet arcu vel fermentum aliquet. Aenean tristique sed eros vitae varius. Sed ut sodales diam. Curabitur tristique metus ac erat sagittis tincidunt.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam euismod nisl in justo consequat, sed efficitur mauris molestie. Integer in iaculis nisl. Aliquam laoreet arcu nec risus ultrices finibus.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"align\":\"center\",\"level\":4,\"fontSize\":\"medium\"} -->\n<h4 class=\"has-text-align-center has-medium-font-size\">£25 Monthly</h4>\n<!-- /wp:heading -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":0,\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link no-border-radius\">Buy</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:group -->",
				'categories'  => array( 'pricing-plans' ),
			)
		);

		register_block_pattern(
			'ada/portfolio-4-1',
			array(
				'title'       => __( 'Portfolio (4 x 1)', 'ada-pearl' ),
				'description' => __( 'A Portfolio block with 4 items', 'ada-pearl' ),
				'content'     => "<!-- wp:group {\"align\":\"full\",\"className\":\"portfolio\"} -->\n<div class=\"wp-block-group alignfull portfolio\"><div class=\"wp-block-group__inner-container\"><!-- wp:columns {\"align\":\"full\"} -->\n<div class=\"wp-block-columns alignfull\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:cover {\"url\":\"" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg\",\"id\":103} -->\n<div class=\"wp-block-cover has-background-dim\" style=\"background-image:url(" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"center\",\"placeholder\":\"Write title…\",\"fontSize\":\"large\"} -->\n<p class=\"has-text-align-center has-large-font-size\">Project Name #1</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-center has-small-font-size\">Vestibulum quis dui non quam auctor euismod. Fusce accumsan vulputate lectus at lacinia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":0,\"textColor\":\"white\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-white-color has-text-color no-border-radius\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:cover --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:cover {\"url\":\"" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg\",\"id\":102} -->\n<div class=\"wp-block-cover has-background-dim\" style=\"background-image:url(" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"center\",\"placeholder\":\"Write title…\",\"fontSize\":\"large\"} -->\n<p class=\"has-text-align-center has-large-font-size\">Project Name #2</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-center has-small-font-size\">Donec congue, dui vitae viverra feugiat, ipsum ipsum gravida ante, in vehicula lorem justo a elit.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":0,\"textColor\":\"white\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-white-color has-text-color no-border-radius\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:cover --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:cover {\"url\":\"" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg\",\"id\":101} -->\n<div class=\"wp-block-cover has-background-dim\" style=\"background-image:url(" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"center\",\"placeholder\":\"Write title…\",\"fontSize\":\"large\"} -->\n<p class=\"has-text-align-center has-large-font-size\">Project Name #3</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-center has-small-font-size\">Vestibulum quis dui non quam auctor euismod. Fusce accumsan vulputate lectus at lacinia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":0,\"textColor\":\"white\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-white-color has-text-color no-border-radius\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:cover --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:cover {\"url\":\"" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg\",\"id\":100} -->\n<div class=\"wp-block-cover has-background-dim\" style=\"background-image:url(" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"center\",\"placeholder\":\"Write title…\",\"fontSize\":\"large\"} -->\n<p class=\"has-text-align-center has-large-font-size\">Project Name #4</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-center has-small-font-size\">Donec congue, dui vitae viverra feugiat, ipsum ipsum gravida ante, in vehicula lorem justo a elit.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":0,\"textColor\":\"white\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-white-color has-text-color no-border-radius\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:cover --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:group -->",
				'categories'  => array( 'portfolio' ),
			)
		);

		register_block_pattern(
			'ada/services-2-items',
			array(
				'title'       => __( 'Services (2 Items)', 'ada-pearl' ),
				'description' => __( 'A Services block with a main header and 2 services', 'ada-pearl' ),
				'content'     => "<!-- wp:heading {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":32}}} -->\n<h2 class=\"has-text-align-center\" style=\"font-size:32px\">Services</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#e8e8e8\"}}} -->\n<div class=\"wp-block-group alignwide has-background\" style=\"background-color:#e8e8e8\"><div class=\"wp-block-group__inner-container\"><!-- wp:media-text {\"mediaPosition\":\"right\",\"mediaId\":19,\"mediaLink\":\"http://underscores.test/home/5f651f4e15930/\",\"mediaType\":\"image\",\"mediaWidth\":36,\"verticalAlignment\":\"center\",\"imageFill\":true} -->\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile is-vertically-aligned-center is-image-fill\" style=\"grid-template-columns:auto 36%\"><figure class=\"wp-block-media-text__media\" style=\"background-image:url(" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg);background-position:50% 50%\"><img src=\"" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg\" alt=\"\" class=\"wp-image-19\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"style\":{\"typography\":{\"fontSize\":32}}} -->\n<h2 style=\"font-size:32px\">Title #1</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Curabitur placerat posuere gravida. Donec facilisis dolor risus, id posuere urna ullamcorper vitae. Cras porta posuere lacus non scelerisque. Duis faucibus magna et ipsum hendrerit sagittis. Praesent nunc odio, tincidunt nec hendrerit vitae, pretium sit amet libero. Praesent vitae enim faucibus, ultricies mi a, sagittis augue. In ultrices lobortis eros, faucibus egestas sem sollicitudin in. Aenean venenatis facilisis nisl ac tristique. Etiam nec malesuada libero.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quisque non leo eu purus rhoncus maximus ut non nunc. Nulla sit amet bibendum metus. Morbi elit metus, interdum eleifend eros ac, tristique suscipit orci. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":0,\"textColor\":\"black\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-black-color has-text-color no-border-radius\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:media-text --></div></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#e8e8e8\"}}} -->\n<div class=\"wp-block-group alignwide has-background\" style=\"background-color:#e8e8e8\"><div class=\"wp-block-group__inner-container\"><!-- wp:media-text {\"mediaId\":19,\"mediaLink\":\"http://underscores.test/home/5f651f4e15930/\",\"mediaType\":\"image\",\"mediaWidth\":36,\"verticalAlignment\":\"center\",\"imageFill\":true} -->\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile is-vertically-aligned-center is-image-fill\" style=\"grid-template-columns:36% auto\"><figure class=\"wp-block-media-text__media\" style=\"background-image:url(" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg);background-position:50% 50%\"><img src=\"" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg\" alt=\"\" class=\"wp-image-19\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"style\":{\"typography\":{\"fontSize\":32}}} -->\n<h2 style=\"font-size:32px\">Title #2</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Curabitur placerat posuere gravida. Donec facilisis dolor risus, id posuere urna ullamcorper vitae. Cras porta posuere lacus non scelerisque. Duis faucibus magna et ipsum hendrerit sagittis. Praesent nunc odio, tincidunt nec hendrerit vitae, pretium sit amet libero. Praesent vitae enim faucibus, ultricies mi a, sagittis augue. In ultrices lobortis eros, faucibus egestas sem sollicitudin in. Aenean venenatis facilisis nisl ac tristique. Etiam nec malesuada libero.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quisque non leo eu purus rhoncus maximus ut non nunc. Nulla sit amet bibendum metus. Morbi elit metus, interdum eleifend eros ac, tristique suscipit orci. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nulla laoreet, magna a vestibulum rhoncus, tortor nisl commodo massa, vitae aliquet libero elit ac dui. Nam efficitur dapibus mauris, ut eleifend est rhoncus eget. Nam convallis aliquam risus nec maximus. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":0,\"textColor\":\"black\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-black-color has-text-color no-border-radius\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:media-text --></div></div>\n<!-- /wp:group -->",
				'categories'  => array( 'services' ),
			)
		);

		register_block_pattern(
			'ada/services-3-items',
			array(
				'title'       => __( 'Services (3 Items)', 'ada-pearl' ),
				'description' => __( 'A Services block with a main header and 3 services', 'ada-pearl' ),
				'content'     => "<!-- wp:heading {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":32}}} -->\n<h2 class=\"has-text-align-center\" style=\"font-size:32px\">Services</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#e8e8e8\"}}} -->\n<div class=\"wp-block-group alignwide has-background\" style=\"background-color:#e8e8e8\"><div class=\"wp-block-group__inner-container\"><!-- wp:media-text {\"mediaPosition\":\"right\",\"mediaId\":19,\"mediaLink\":\"http://underscores.test/home/5f651f4e15930/\",\"mediaType\":\"image\",\"mediaWidth\":36,\"verticalAlignment\":\"center\",\"imageFill\":true} -->\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile is-vertically-aligned-center is-image-fill\" style=\"grid-template-columns:auto 36%\"><figure class=\"wp-block-media-text__media\" style=\"background-image:url(" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg);background-position:50% 50%\"><img src=\"" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg\" alt=\"\" class=\"wp-image-19\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"style\":{\"typography\":{\"fontSize\":32}}} -->\n<h2 style=\"font-size:32px\">Title #1</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Curabitur placerat posuere gravida. Donec facilisis dolor risus, id posuere urna ullamcorper vitae. Cras porta posuere lacus non scelerisque. Duis faucibus magna et ipsum hendrerit sagittis. Praesent nunc odio, tincidunt nec hendrerit vitae, pretium sit amet libero. Praesent vitae enim faucibus, ultricies mi a, sagittis augue. In ultrices lobortis eros, faucibus egestas sem sollicitudin in. Aenean venenatis facilisis nisl ac tristique. Etiam nec malesuada libero.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quisque non leo eu purus rhoncus maximus ut non nunc. Nulla sit amet bibendum metus. Morbi elit metus, interdum eleifend eros ac, tristique suscipit orci. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":0,\"textColor\":\"black\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-black-color has-text-color no-border-radius\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:media-text --></div></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#e8e8e8\"}}} -->\n<div class=\"wp-block-group alignwide has-background\" style=\"background-color:#e8e8e8\"><div class=\"wp-block-group__inner-container\"><!-- wp:media-text {\"mediaId\":19,\"mediaLink\":\"http://underscores.test/home/5f651f4e15930/\",\"mediaType\":\"image\",\"mediaWidth\":36,\"verticalAlignment\":\"center\",\"imageFill\":true} -->\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile is-vertically-aligned-center is-image-fill\" style=\"grid-template-columns:36% auto\"><figure class=\"wp-block-media-text__media\" style=\"background-image:url(" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg);background-position:50% 50%\"><img src=\"" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg\" alt=\"\" class=\"wp-image-19\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"style\":{\"typography\":{\"fontSize\":32}}} -->\n<h2 style=\"font-size:32px\">Title #2</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Curabitur placerat posuere gravida. Donec facilisis dolor risus, id posuere urna ullamcorper vitae. Cras porta posuere lacus non scelerisque. Duis faucibus magna et ipsum hendrerit sagittis. Praesent nunc odio, tincidunt nec hendrerit vitae, pretium sit amet libero. Praesent vitae enim faucibus, ultricies mi a, sagittis augue. In ultrices lobortis eros, faucibus egestas sem sollicitudin in. Aenean venenatis facilisis nisl ac tristique. Etiam nec malesuada libero.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quisque non leo eu purus rhoncus maximus ut non nunc. Nulla sit amet bibendum metus. Morbi elit metus, interdum eleifend eros ac, tristique suscipit orci. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nulla laoreet, magna a vestibulum rhoncus, tortor nisl commodo massa, vitae aliquet libero elit ac dui. Nam efficitur dapibus mauris, ut eleifend est rhoncus eget. Nam convallis aliquam risus nec maximus. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":0,\"textColor\":\"black\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-black-color has-text-color no-border-radius\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:media-text --></div></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#e8e8e8\"}}} -->\n<div class=\"wp-block-group alignwide has-background\" style=\"background-color:#e8e8e8\"><div class=\"wp-block-group__inner-container\"><!-- wp:media-text {\"mediaPosition\":\"right\",\"mediaId\":19,\"mediaLink\":\"http://underscores.test/home/5f651f4e15930/\",\"mediaType\":\"image\",\"mediaWidth\":36,\"verticalAlignment\":\"center\",\"imageFill\":true} -->\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile is-vertically-aligned-center is-image-fill\" style=\"grid-template-columns:auto 36%\"><figure class=\"wp-block-media-text__media\" style=\"background-image:url(" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg);background-position:50% 50%\"><img src=\"" . esc_url( get_template_directory_uri() ) . "/images/young-woman-in-mauve.jpg\" alt=\"\" class=\"wp-image-19\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"style\":{\"typography\":{\"fontSize\":32}}} -->\n<h2 style=\"font-size:32px\">Title #3</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Curabitur placerat posuere gravida. Donec facilisis dolor risus, id posuere urna ullamcorper vitae. Cras porta posuere lacus non scelerisque. Duis faucibus magna et ipsum hendrerit sagittis. Praesent nunc odio, tincidunt nec hendrerit vitae, pretium sit amet libero. Praesent vitae enim faucibus, ultricies mi a, sagittis augue. In ultrices lobortis eros, faucibus egestas sem sollicitudin in. Aenean venenatis facilisis nisl ac tristique. Etiam nec malesuada libero.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quisque non leo eu purus rhoncus maximus ut non nunc. Nulla sit amet bibendum metus. Morbi elit metus, interdum eleifend eros ac, tristique suscipit orci. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":0,\"textColor\":\"black\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-black-color has-text-color no-border-radius\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:media-text --></div></div>\n<!-- /wp:group -->",
				'categories'  => array( 'services' ),
			)
		);

	}

}
add_action( 'init', 'ada_pearl_register_block_patterns' );
