<?php
/**
 * Title: Two Columns with Text and Image
 * Slug: acai/two-columns-text-image
 * Categories: acai_images, acai_sections, featured
 */
?>
<!-- wp:group {"metadata":{"name":"Two Columns with Text and Image"},"align":"wide","layout":{"type":"default"}} -->
<div class="wp-block-group alignwide">
    <!-- wp:spacer {"height":"var:preset|spacing|70"} -->
    <div style="height:var(--wp--preset--spacing--70)" aria-hidden="true" class="wp-block-spacer"></div>
    <!-- /wp:spacer -->

    <!-- wp:columns {"verticalAlignment":null,"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|50"}}}} -->
    <div class="wp-block-columns">
        <!-- wp:column {"verticalAlignment":"center","style":{"spacing":{"blockGap":"var:preset|spacing|40"}}} -->
        <div class="wp-block-column is-vertically-aligned-center">
            <!-- wp:heading {"acaiAnimationType":"fade-in-left"} -->
            <h2 class="wp-block-heading"><?php esc_html_e( 'Transform Your Home with Expert Renovation Solutions', 'acai' ); ?></h2>
            <!-- /wp:heading -->

            <!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"300"}},"acaiAnimationType":"fade-in-left","acaiAnimationDelay":0.1} -->
            <p style="font-style:normal;font-weight:300"><?php esc_html_e( "Bring new life to your space with professional home renovation services tailored to your needs. Whether it's a modern kitchen upgrade, a stylish bathroom makeover, or a full home transformation, we deliver quality craftsmanship and attention to detail that exceeds expectations, on time and within budget.", "acai" ); ?></p>
            <!-- /wp:paragraph -->

            <!-- wp:list {"className":"is-style-star","style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-1"}}}},"textColor":"accent-1","acaiAnimationType":"fade-in-left","acaiAnimationDelay":0.2} -->
            <ul class="wp-block-list is-style-star has-accent-1-color has-text-color has-link-color">
                <!-- wp:list-item -->
                <li><mark style="background-color:rgba(0, 0, 0, 0)" class="has-inline-color has-contrast-color"><?php esc_html_e( 'Custom renovations designed around you', 'acai' ); ?></mark></li>
                <!-- /wp:list-item -->

                <!-- wp:list-item -->
                <li><mark style="background-color:rgba(0, 0, 0, 0)" class="has-inline-color has-contrast-color"><?php esc_html_e( 'High-quality finishes and trusted materials', 'acai' ); ?></mark></li>
                <!-- /wp:list-item -->

                <!-- wp:list-item -->
                <li><mark style="background-color:rgba(0, 0, 0, 0)" class="has-inline-color has-contrast-color"><?php esc_html_e( 'Stress-free process from concept to completion', 'acai' ); ?></mark></li>
                <!-- /wp:list-item -->
            </ul>
            <!-- /wp:list -->
        </div>
        <!-- /wp:column -->

        <!-- wp:column -->
        <div class="wp-block-column">
            <!-- wp:image {"sizeSlug":"full","linkDestination":"none","style":{"border":{"radius":"9px"}},"acaiAnimationType":"fade-in-right"} -->
            <figure class="wp-block-image size-full has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/home-interior.jpg') ); ?>" alt="" style="border-radius:9px" /></figure>
            <!-- /wp:image -->
        </div>
        <!-- /wp:column -->
    </div>
    <!-- /wp:columns -->

    <!-- wp:spacer {"height":"var:preset|spacing|70"} -->
    <div style="height:var(--wp--preset--spacing--70)" aria-hidden="true" class="wp-block-spacer"></div>
    <!-- /wp:spacer -->
</div>
<!-- /wp:group -->