<?php
/**
 * Title: Sidebar
 * Slug: acai/part-sidebar
 * Categories: acai_parts
 * Template Types: sidebar
 */
?>
<!-- wp:group {"metadata":{"name":"Sidebar Group"},"style":{"spacing":{"blockGap":"var:preset|spacing|50","padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}},"border":{"radius":"9px"}},"backgroundColor":"base","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-base-background-color has-background" style="border-radius:9px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">

	<!-- wp:group {"metadata":{"name":"Search"},"layout":{"type":"constrained"}} -->
	<div class="wp-block-group">
		<!-- wp:search {"label":"Search","showLabel":false,"placeholder":"Search...","buttonText":"Search","buttonPosition":"button-inside","buttonUseIcon":true,"style":{"border":{"radius":"9px"}}} /-->
	</div>
	<!-- /wp:group -->

	<!-- wp:group {"metadata":{"name":"Latest Posts"},"style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}},"textColor":"contrast-3","layout":{"type":"constrained"}} -->
	<div class="wp-block-group has-contrast-3-color has-text-color has-link-color">
		<!-- wp:heading {"level":3} -->
		<h3 class="wp-block-heading"><?php esc_html_e( 'Latest Posts', 'acai' ); ?></h3>
		<!-- /wp:heading -->

		<!-- wp:latest-posts {"className":"is-style-links-underline-on-hover"} /-->
	</div>
	<!-- /wp:group -->

	<!-- wp:group {"metadata":{"name":"Latest Comments"},"style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}},"textColor":"contrast-3","layout":{"type":"constrained"}} -->
	<div class="wp-block-group has-contrast-3-color has-text-color has-link-color">
		<!-- wp:heading {"level":3} -->
		<h3 class="wp-block-heading"><?php esc_html_e( 'Latest Comments', 'acai' ); ?></h3>
		<!-- /wp:heading -->

		<!-- wp:latest-comments {"displayAvatar":false,"displayDate":false,"className":"is-style-links-underline-on-hover"} /-->
	</div>
	<!-- /wp:group -->

	<!-- wp:group {"metadata":{"name":"Popular Categories"},"style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}},"textColor":"contrast-3","layout":{"type":"constrained"}} -->
	<div class="wp-block-group has-contrast-3-color has-text-color has-link-color">
		<!-- wp:heading {"level":3} -->
		<h3 class="wp-block-heading"><?php esc_html_e( 'Popular Categories', 'acai' ); ?></h3>
		<!-- /wp:heading -->

		<!-- wp:categories {"showPostCounts":true,"className":"is-style-links-underline-on-hover"} /-->
	</div>
	<!-- /wp:group -->

	<!-- wp:group {"metadata":{"name":"Popular Tags"},"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-1"}}}},"textColor":"contrast-3","layout":{"type":"constrained"}} -->
	<div class="wp-block-group has-contrast-3-color has-text-color has-link-color">
		<!-- wp:heading {"level":3} -->
		<h3 class="wp-block-heading"><?php esc_html_e( 'Popular Tags', 'acai' ); ?></h3>
		<!-- /wp:heading -->

		<!-- wp:tag-cloud {"className":"is-style-links-underline-on-hover"} /-->
	</div>
	<!-- /wp:group -->

	<!-- wp:group {"metadata":{"name":"Calendar"},"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-1"}}}},"textColor":"contrast-3","layout":{"type":"constrained"}} -->
	<div class="wp-block-group has-contrast-3-color has-text-color has-link-color">
		<!-- wp:heading {"level":3} -->
		<h3 class="wp-block-heading"><?php esc_html_e( 'Calendar', 'acai' ); ?></h3>
		<!-- /wp:heading -->

		<!-- wp:calendar {"className":"is-style-links-underline-on-hover"} /-->
	</div>
	<!-- /wp:group -->
</div>
<!-- /wp:group -->
