<?php
/**
 * Title: Header - Hero Cover
 * Slug: acai/part-header-hero
 * Categories: acai_parts, header
 * Block Types: core/template-part/header
 * Template Types: header
 */
?>
<!-- wp:cover {"url":"<?php echo esc_url( get_theme_file_uri('assets/images/abstract-blocks.jpg') ); ?>","dimRatio":90,"isUserOverlayColor":true,"gradient":"dark-accent-2-dark","metadata":{"categories":["acai_parts"],"patternName":"acai/part-header-hero","name":"Header with Hero Cover"},"align":"full","style":{"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover alignfull" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><img class="wp-block-cover__image-background" alt="" src="<?php echo esc_url( get_theme_file_uri('assets/images/abstract-blocks.jpg') ); ?>" data-object-fit="cover"/><span aria-hidden="true" class="wp-block-cover__background has-background-dim-90 has-background-dim wp-block-cover__gradient-background has-background-gradient has-dark-accent-2-dark-gradient-background"></span>
	<div class="wp-block-cover__inner-container">
		<!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"var:preset|spacing|30","padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}},"layout":{"type":"flex","justifyContent":"space-between","flexWrap":"nowrap"}} -->
		<div class="wp-block-group alignwide" style="padding-top:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30)">
			<!-- wp:group {"style":{"layout":{"selfStretch":"fit","flexSize":null},"spacing":{"blockGap":"3.6vw"}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"left"}} -->
			<div class="wp-block-group">
				<!-- wp:group {"layout":{"type":"flex","justifyContent":"left","flexWrap":"wrap"}} -->
				<div class="wp-block-group">
					<!-- wp:site-logo {"width":42,"style":{"layout":{"selfStretch":"fit","flexSize":null}}} /-->

					<!-- wp:site-title {"className":"is-style-links-plain"} /-->
				</div>
				<!-- /wp:group -->

				<!-- wp:navigation {"icon":"menu","overlayBackgroundColor":"base-2","overlayTextColor":"contrast","metadata":{"ignoredHookedBlocks":["woocommerce/customer-account","woocommerce/mini-cart"]},"style":{"spacing":{"blockGap":"var:preset|spacing|30"},"layout":{"selfStretch":"fit","flexSize":null}},"fontSize":"medium","layout":{"type":"flex","setCascadingProperties":true}} /-->
			</div>
			<!-- /wp:group -->

			<!-- wp:group {"style":{"spacing":{"blockGap":"1.6vw"}},"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"right"}} -->
			<div class="wp-block-group">
				<!-- wp:social-links {"iconColor":"base","iconColorValue":"#ffffff","size":"has-normal-icon-size","className":"is-style-logos-only","style":{"spacing":{"blockGap":{"top":"0","left":"1.6vw"}}}} -->
				<ul class="wp-block-social-links has-normal-icon-size has-icon-color is-style-logos-only">
					<!-- wp:social-link {"url":"#","service":"instagram"} /-->

					<!-- wp:social-link {"url":"#","service":"whatsapp"} /-->

					<!-- wp:social-link {"url":"#","service":"facebook"} /-->
				</ul>
				<!-- /wp:social-links -->

				<!-- wp:buttons -->
				<div class="wp-block-buttons">
					<!-- wp:button {"textColor":"base","className":"is-style-outline","style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"fontSize":"small"} -->
					<div class="wp-block-button is-style-outline"><a class="wp-block-button__link has-base-color has-text-color has-link-color has-small-font-size has-custom-font-size wp-element-button"><?php esc_html_e( 'Contact', 'acai' ); ?></a></div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:group -->

		<!-- wp:spacer {"height":"3vw"} -->
		<div style="height:3vw" aria-hidden="true" class="wp-block-spacer"></div>
		<!-- /wp:spacer -->

		<!-- wp:columns {"verticalAlignment":"center","align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|70"}}}} -->
		<div class="wp-block-columns alignwide are-vertically-aligned-center">
			<!-- wp:column {"verticalAlignment":"center","width":"50%"} -->
			<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:50%">
				<!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"default"}} -->
				<div class="wp-block-group">
					<!-- wp:spacer {"height":"var:preset|spacing|30"} -->
					<div style="height:var(--wp--preset--spacing--30)" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->

					<!-- wp:paragraph {"acaiAnimationType":"fade-in-up-right","acaiAnimationDuration":1} -->
					<p><?php esc_html_e( 'Business + Blog + Shop + Portfolio', 'acai' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:heading {"fontSize":"xx-large","acaiAnimationType":"fade-in-up-left","acaiAnimationDuration":1} -->
					<h2 class="wp-block-heading has-xx-large-font-size"><?php esc_html_e( 'Your Website', 'acai' ); ?></h2>
					<!-- /wp:heading -->

					<!-- wp:spacer {"height":"var:preset|spacing|30"} -->
					<div style="height:var(--wp--preset--spacing--30)" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->

					<!-- wp:paragraph {"acaiAnimationType":"fade-in-down-right","acaiAnimationDuration":1} -->
					<p><?php esc_html_e( 'Create stunning, hassle-free websites instantly - perfect for launching your ideas online with ease.', 'acai' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:spacer {"height":"var:preset|spacing|40"} -->
					<div style="height:var(--wp--preset--spacing--40)" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->

					<!-- wp:buttons {"acaiAnimationType":"fade-in","acaiAnimationDuration":1,"acaiAnimationDelay":0.6} -->
					<div class="wp-block-buttons">
						<!-- wp:button {"style":{"border":{"width":"1px"}},"borderColor":"accent-1"} -->
						<div class="wp-block-button"><a class="wp-block-button__link has-border-color has-accent-1-border-color wp-element-button" style="border-width:1px"><?php esc_html_e( 'Get Started', 'acai' ); ?></a></div>
						<!-- /wp:button -->

						<!-- wp:button {"textColor":"base","className":"is-style-outline","style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}}}} -->
						<div class="wp-block-button is-style-outline"><a class="wp-block-button__link has-base-color has-text-color has-link-color wp-element-button"><?php esc_html_e( 'Read More', 'acai' ); ?></a></div>
						<!-- /wp:button -->
					</div>
					<!-- /wp:buttons -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"verticalAlignment":"center","width":"50%"} -->
			<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:50%">
				<!-- wp:image {"linkDestination":"none","align":"center"} -->
				<figure class="wp-block-image aligncenter"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/style-book-hero.png') ); ?>" alt="" /></figure>
				<!-- /wp:image -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->

		<!-- wp:spacer {"height":"7vw"} -->
		<div style="height:7vw" aria-hidden="true" class="wp-block-spacer"></div>
		<!-- /wp:spacer -->
	</div>
</div>
<!-- /wp:cover -->
