<?php
/**
 * Title: Large Image with Ecommerce Features
 * Slug: acai/large-image-ecommerce
 * Categories: acai_images, acai_sections, featured
 */
?>
<!-- wp:group {"align":"full","style":{"background":{"backgroundImage":{"url":"<?php echo esc_url( get_theme_file_uri('assets/images/fashion.jpg') ); ?>","source":"file","title":""},"backgroundPosition":"50% 0"}},"backgroundColor":"base-2","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-base-2-background-color has-background">
	<!-- wp:spacer -->
	<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
	<!-- /wp:spacer -->

	<!-- wp:group {"align":"wide","style":{"spacing":{"padding":{"right":"0","left":"var:preset|spacing|30","top":"var:preset|spacing|20","bottom":"var:preset|spacing|20"}},"border":{"left":{"width":"4px"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"textColor":"base","layout":{"type":"default"},"acaiAnimationType":"fade-in-up"} -->
	<div class="wp-block-group alignwide has-base-color has-text-color has-link-color" style="border-left-width:4px;padding-top:var(--wp--preset--spacing--20);padding-right:0;padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--30)">
		<!-- wp:paragraph {"align":"left","placeholder":"Write title…","fontSize":"xx-large"} -->
		<p class="has-text-align-left has-xx-large-font-size"><?php echo wp_kses_post( __( '<strong>NEW</strong> COLLECTION', 'acai' ) );?></p>
		<!-- /wp:paragraph -->

		<!-- wp:paragraph {"fontSize":"large"} -->
		<p class="has-large-font-size"><?php echo wp_kses_post( __( 'FOR THIS <strong>SEASON</strong>', 'acai' ) );?></p>
		<!-- /wp:paragraph -->
	</div>
	<!-- /wp:group -->

	<!-- wp:spacer {"height":"2rem"} -->
	<div style="height:2rem" aria-hidden="true" class="wp-block-spacer"></div>
	<!-- /wp:spacer -->

	<!-- wp:group {"align":"wide","layout":{"type":"default"},"acaiAnimationType":"fade-in-up","acaiAnimationDelay":0.1} -->
	<div class="wp-block-group alignwide">
		<!-- wp:buttons -->
		<div class="wp-block-buttons">
			<!-- wp:button -->
			<div class="wp-block-button"><a class="wp-block-button__link wp-element-button"><?php esc_html_e( 'SHOP NOW', 'acai' );?></a></div>
			<!-- /wp:button -->
		</div>
		<!-- /wp:buttons -->

		<!-- wp:spacer -->
		<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
		<!-- /wp:spacer -->
	</div>
	<!-- /wp:group -->

	<!-- wp:group {"align":"wide","style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"},"margin":{"top":"0px"}},"border":{"radius":{"topLeft":"9px","topRight":"9px"}},"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}},"backgroundColor":"base-2","textColor":"contrast","layout":{"type":"constrained"},"acaiAnimationType":"fade-in-up","acaiAnimationDelay":0.2,"acaiAnimationOffset":6} -->
	<div class="wp-block-group alignwide has-contrast-color has-base-2-background-color has-text-color has-background has-link-color" style="border-top-left-radius:9px;border-top-right-radius:9px;margin-top:0px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
		<!-- wp:columns {"align":"wide"} -->
		<div class="wp-block-columns alignwide">
			<!-- wp:column {"acaiAnimationType":"fade-in-up","acaiAnimationDelay":0.2,"acaiAnimationOffset":6} -->
			<div class="wp-block-column">
				<!-- wp:image {"width":"64px","linkDestination":"none","align":"center"} -->
				<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/icon-truck.png') ); ?>" alt="" style="width:64px" /></figure>
				<!-- /wp:image -->

				<!-- wp:paragraph {"align":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"600"}}} -->
				<p class="has-text-align-center" style="font-style:normal;font-weight:600"><?php esc_html_e( 'FREE DELIVERY', 'acai' );?></p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast-3"}}}},"textColor":"contrast-3","fontSize":"small"} -->
				<p class="has-text-align-center has-contrast-3-color has-text-color has-link-color has-small-font-size"><?php esc_html_e( 'On all orders', 'acai' );?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"acaiAnimationType":"fade-in-up","acaiAnimationDelay":0.2,"acaiAnimationOffset":6} -->
			<div class="wp-block-column">
				<!-- wp:image {"width":"64px","linkDestination":"none","align":"center"} -->
				<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/icon-card.png') ); ?>" alt="" style="width:64px" /></figure>
				<!-- /wp:image -->

				<!-- wp:paragraph {"align":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"600"}}} -->
				<p class="has-text-align-center" style="font-style:normal;font-weight:600"><?php esc_html_e( 'SECURE PAYMENT', 'acai' );?></p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast-3"}}}},"textColor":"contrast-3","fontSize":"small"} -->
				<p class="has-text-align-center has-contrast-3-color has-text-color has-link-color has-small-font-size"><?php esc_html_e( 'Safe guarantee', 'acai' );?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"acaiAnimationType":"fade-in-up","acaiAnimationDelay":0.2,"acaiAnimationOffset":6} -->
			<div class="wp-block-column">
				<!-- wp:image {"width":"64px","linkDestination":"none","align":"center"} -->
				<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/icon-chat.png') ); ?>" alt="" style="width:64px" /></figure>
				<!-- /wp:image -->

				<!-- wp:paragraph {"align":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"600"}}} -->
				<p class="has-text-align-center" style="font-style:normal;font-weight:600"><?php esc_html_e( '24/7 SUPPORT', 'acai' );?></p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast-3"}}}},"textColor":"contrast-3","fontSize":"small"} -->
				<p class="has-text-align-center has-contrast-3-color has-text-color has-link-color has-small-font-size"><?php esc_html_e( 'Customer service', 'acai' );?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:group -->
</div>
<!-- /wp:group -->
