<?php
/**
 * Title: Call to Action with Contacts
 * Slug: acai/cta-contacts
 * Categories: acai_sections, acai_images, featured, call-to-action
 */
?>
<!-- wp:group {"metadata":{"name":"<?php esc_html_e( 'Call to Action with Contacts', 'acai' ); ?>"},"align":"full","style":{"spacing":{"margin":{"top":"0"},"padding":{"top":"0","bottom":"0"}}},"backgroundColor":"contrast-2","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-contrast-2-background-color has-background" style="margin-top:0;padding-top:0;padding-bottom:0">
	<!-- wp:media-text {"align":"wide","mediaLink":"<?php echo esc_url( get_theme_file_uri('assets/images/business.jpg') ); ?>","mediaType":"image","imageFill":true,"className":"alignwide is-stacked-on-mobile"} -->
	<div class="wp-block-media-text alignwide is-stacked-on-mobile is-image-fill-element">
		<figure class="wp-block-media-text__media"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/business.jpg') ); ?>" alt="" /></figure>
		<div class="wp-block-media-text__content">
			<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|40","padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
			<div class="wp-block-group" style="padding-top:var(--wp--preset--spacing--70);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--70);padding-left:var(--wp--preset--spacing--30)">
				<!-- wp:heading {"level":3,"style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"textColor":"base"} -->
				<h3 class="wp-block-heading has-base-color has-text-color has-link-color"><?php esc_html_e( 'Our Services', 'acai' ); ?></h3>
				<!-- /wp:heading -->

				<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap"}} -->
				<div class="wp-block-group">
					<!-- wp:image {"width":"24px","linkDestination":"none","style":{"color":{"duotone":["#03aaff","#ffffff"]}}} -->
					<figure class="wp-block-image is-resized"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/icon-clock.png') ); ?>" alt="" style="width:24px" /></figure>
					<!-- /wp:image -->

					<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|base-3"}}}},"textColor":"base-3"} -->
					<p class="has-base-3-color has-text-color has-link-color">Mon-Fri: <mark style="background-color:rgba(0, 0, 0, 0)" class="has-inline-color has-base-color">9am</mark> to <mark style="background-color:rgba(0, 0, 0, 0)" class="has-inline-color has-base-color">6pm</mark> | Sat: <mark style="background-color:rgba(0, 0, 0, 0)" class="has-inline-color has-base-color">9am</mark> to <mark style="background-color:rgba(0, 0, 0, 0)" class="has-inline-color has-base-color">1pm</mark></p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:group -->

				<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap"}} -->
				<div class="wp-block-group">
					<!-- wp:image {"width":"24px","linkDestination":"none","style":{"color":{"duotone":["#03aaff","#ffffff"]}}} -->
					<figure class="wp-block-image is-resized"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/icon-phone.png') ); ?>" alt="" style="width:24px" /></figure>
					<!-- /wp:image -->

					<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|base-3"}}}},"textColor":"base-3"} -->
					<p class="has-base-3-color has-text-color has-link-color">Call us <mark style="background-color:rgba(0, 0, 0, 0)" class="has-inline-color has-base-color"><strong><?php esc_html_e( '555-456-7890', 'acai' ); ?></strong></mark></p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:group -->

				<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap"}} -->
				<div class="wp-block-group">
					<!-- wp:image {"width":"24px","linkDestination":"none","style":{"color":{"duotone":["#03aaff","#ffffff"]}}} -->
					<figure class="wp-block-image is-resized"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/icon-circle-arrow.png') ); ?>" alt="" style="width:24px" /></figure>
					<!-- /wp:image -->

					<!-- wp:buttons -->
					<div class="wp-block-buttons">
						<!-- wp:button -->
						<div class="wp-block-button"><a class="wp-block-button__link wp-element-button">BOOK APPOINTMENT</a></div>
						<!-- /wp:button -->
					</div>
					<!-- /wp:buttons -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
	</div>
	<!-- /wp:media-text -->
</div>
<!-- /wp:group -->
