<?php
/**
 * Title: Call to Action
 * Slug: acai/call-to-action
 * Categories: acai_sections, acai_images, featured, call-to-action
 */
?>
<!-- wp:group {"metadata":{"name":"<?php esc_html_e( 'Call to Action', 'acai' ); ?>"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"0"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"textColor":"base","gradient":"dark-accent-2-dark","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-base-color has-dark-accent-2-dark-gradient-background has-text-color has-background has-link-color" style="padding-top:var(--wp--preset--spacing--60);padding-bottom:0">
	<!-- wp:columns {"verticalAlignment":null,"align":"wide"} -->
	<div class="wp-block-columns alignwide">
		<!-- wp:column {"verticalAlignment":"center"} -->
		<div class="wp-block-column is-vertically-aligned-center">
			<!-- wp:group {"style":{"spacing":{"blockGap":"0","padding":{"bottom":"var:preset|spacing|60"}}},"layout":{"type":"constrained"}} -->
			<div class="wp-block-group" style="padding-bottom:var(--wp--preset--spacing--60)">
				<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|base-2"}}},"typography":{"fontStyle":"normal","fontWeight":"700"}},"textColor":"base-2","fontSize":"x-large"} -->
				<p class="has-base-2-color has-text-color has-link-color has-x-large-font-size" style="font-style:normal;font-weight:700"><?php esc_html_e( 'TAKE YOUR BUSINESS', 'acai' ); ?></p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph {"className":"is-style-gradient-text-2","style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"typography":{"fontStyle":"italic","fontWeight":"700"}},"textColor":"base","fontSize":"x-large"} -->
				<p class="is-style-gradient-text-2 has-base-color has-text-color has-link-color has-x-large-font-size" style="font-style:italic;font-weight:700"><?php esc_html_e( 'FURTHER, FASTER', 'acai' ); ?></p>
				<!-- /wp:paragraph -->

				<!-- wp:spacer {"height":"var:preset|spacing|30"} -->
				<div style="height:var(--wp--preset--spacing--30)" aria-hidden="true" class="wp-block-spacer"></div>
				<!-- /wp:spacer -->

				<!-- wp:buttons -->
				<div class="wp-block-buttons">
					<!-- wp:button {"backgroundColor":"base-2","textColor":"contrast-2","className":"is-style-fill","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}},"typography":{"fontStyle":"normal","fontWeight":"700"}},"fontSize":"small"} -->
					<div class="wp-block-button is-style-fill"><a class="wp-block-button__link has-contrast-2-color has-base-2-background-color has-text-color has-background has-link-color has-small-font-size has-custom-font-size wp-element-button" style="font-style:normal;font-weight:700"><?php esc_html_e( 'GET IN TOUCH', 'acai' ); ?></a></div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"verticalAlignment":"bottom"} -->
		<div class="wp-block-column is-vertically-aligned-bottom">
			<!-- wp:image {"linkDestination":"none"} -->
			<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/phone.png') ); ?>" alt="" /></figure>
			<!-- /wp:image -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->
