<?php
/**
 * Title: About Us with List
 * Slug: acai/about-us-list
 * Categories: acai_sections, acai_images, featured
 */
?>
<!-- wp:group {"metadata":{"name":"<?php esc_html_e( 'About Us with List', 'acai' ); ?>"},"className":"alignfull has-contrast-color has-base-2-background-color has-text-color has-background has-link-color","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}},"heading":{"color":{"text":"var:preset|color|contrast"}}}},"textColor":"contrast"} -->
<div class="wp-block-group alignfull has-contrast-color has-base-2-background-color has-text-color has-background has-link-color">
	<!-- wp:media-text {"align":"wide","mediaLink":"<?php echo esc_url( get_theme_file_uri('assets/images/car.png') ); ?>","mediaType":"image"} -->
	<div class="wp-block-media-text alignwide is-stacked-on-mobile">
		<figure class="wp-block-media-text__media"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/car.png') ); ?>" alt="" /></figure>
		<div class="wp-block-media-text__content">
			<!-- wp:heading -->
			<h2 class="wp-block-heading"><?php esc_html_e( 'About Us', 'acai' ); ?></h2>
			<!-- /wp:heading -->

			<!-- wp:paragraph -->
			<p><?php esc_html_e( 'We are dedicated to providing top-quality auto repair and maintenance services to keep your vehicle running smoothly and safely. With a team of certified technicians and a commitment to customer satisfaction, we offer a wide range of services, from routine maintenance to complex repairs. Trust us to deliver reliable care and exceptional service every time.', 'acai' ); ?></p>
			<!-- /wp:paragraph -->

			<!-- wp:list {"className":"is-style-line"} -->
			<ul class="wp-block-list is-style-line">
				<!-- wp:list-item -->
				<li><?php esc_html_e( 'Certified and experienced technicians', 'acai' ); ?></li>
				<!-- /wp:list-item -->

				<!-- wp:list-item -->
				<li><?php esc_html_e( 'Comprehensive auto repair and maintenance services', 'acai' ); ?></li>
				<!-- /wp:list-item -->

				<!-- wp:list-item -->
				<li><?php esc_html_e( 'State-of-the-art diagnostic tools and equipment', 'acai' ); ?></li>
				<!-- /wp:list-item -->

				<!-- wp:list-item -->
				<li><?php esc_html_e( 'Fast, reliable service with transparent pricing', 'acai' ); ?></li>
				<!-- /wp:list-item -->

				<!-- wp:list-item -->
				<li><?php esc_html_e( 'Commitment to customer satisfaction and safety', 'acai' ); ?></li>
				<!-- /wp:list-item -->
			</ul>
			<!-- /wp:list -->
		</div>
	</div>
	<!-- /wp:media-text -->
</div>
<!-- /wp:group -->
