<?php

/**
 * Enqueue admin scripts and styles.
 */
function acai_admin_scripts_styles() {
	wp_enqueue_style( 'acai-admin-style', ACAI_TEMPLATE_DIR_URI . '/assets/css/admin.css', array(), ACAI_VERSION );
	wp_enqueue_script( 'acai-admin-script', ACAI_TEMPLATE_DIR_URI . '/assets/js/admin.js', array( 'wp-api-fetch' ), ACAI_VERSION, true );
	wp_localize_script( 'acai-admin-script', 'acai_text_strings',
		array(
			'acai_string_installing' => esc_html__( 'Installing...', 'acai' ),
			'acai_string_activating' => esc_html__( 'Activating...', 'acai' ),
		)
	);
	wp_add_inline_script( 'acai-admin-script', 'var acai_vars = ' . json_encode( array(
			'acai_nonce' => wp_create_nonce( 'acai-nonce' ),
			'acai_starter_sites_page' => esc_url( acai_starter_sites_admin_link() )
		) ), 'before'
	);
}
add_action( 'admin_enqueue_scripts', 'acai_admin_scripts_styles' );

/**
 * Add theme notice action.
 */
function acai_admin_notice() {
	$notice_dismissed = get_user_meta( get_current_user_id(), acai_get_theme_prefix() . '_admin_notice_dismiss', true );
	if ( '1' !== $notice_dismissed ) {
		acai_admin_notice_html();
	}
}
add_action( 'admin_notices', 'acai_admin_notice' );

/**
 * Dismiss theme notice.
 */
function acai_admin_notice_dismiss() {
	check_ajax_referer( 'acai-nonce', 'acai-nonce-name' );
	if ( ! current_user_can( 'edit_theme_options' ) ) {
		wp_die( -1 );
	}
	update_user_meta( get_current_user_id(), acai_get_theme_prefix() . '_admin_notice_dismiss', 1 );
	wp_die( 1 );
}
add_action( 'wp_ajax_acai_admin_notice_dismiss', 'acai_admin_notice_dismiss' );

/**
 * Print theme notice.
 */
function acai_admin_notice_html() {
	$screen = get_current_screen();
	if ( ! empty( $screen->base ) && ( 'appearance_page_acai' === $screen->base || str_contains($screen->base, 'starter-sites') ) ) {
		return false;
	}
	$plugin_active = is_plugin_active( 'starter-sites/starter-sites.php' );
	$starter_sites_link = acai_starter_sites_admin_link();
	if ( acai_is_starter_sites_pro() ) {
		$plugin_active = true;
		$starter_sites_link = $starter_sites_link . '-pro';
	}
	if ( $plugin_active ) {
		$button_link = $starter_sites_link;
	} else {
		$button_link = admin_url( 'themes.php?page=acai' );
	}
	?>
	<div class="notice notice-info is-dismissible acai-admin-notice">
		<div class="acai-admin-notice-wrapper">
			<div class="acai-page-inner-section is-style-flex">
				<div class="acai-page-description">
					<h2><?php
					printf(
						/* Translators: %s = theme name */
						esc_html__( 'Welcome to the %s theme.', 'acai' ),
						acai_theme_name()
					); ?></h2>
					<p><?php
					printf(
						/* Translators: %s = link to homepage design help section of theme page */
						esc_html__( 'Check out the %s where you can choose from a variety of style variations and also edit the styles, colors, layout, fonts, navigation menus, page templates and template parts including the header and footer.', 'acai' ),
						'<a href="' . esc_url( admin_url( 'themes.php?page=acai' ) ) . '"><strong>' . __( 'theme page', 'acai' ) . '</strong></a>'
					); ?></p>
					<p><?php printf( esc_html__( 'Unlock the power of effortless web design with our collection of ready-to-go %s and captivating website demos, all crafted with the revolutionary Full Site Editing block editor! Imagine building an entire website in just one click, complete with full pages of authentic, high-quality content that looks and feels real.', 'acai' ), '<a href="' . esc_url( $button_link ) . '"><strong>' . __( 'Starter Sites', 'acai' ) . '</strong></a>'); ?></p>
				</div>
				<div class="acai-page-image">
					<a href="<?php echo esc_url( $button_link ) ?>"><img style="max-width:240px;" src="<?php echo esc_url( ACAI_TEMPLATE_DIR_URI . '/assets/images/preview-starter-sites.png?ver=' . ACAI_VERSION ) ;?>"/></a>
				</div>
			</div>
		</div>
	</div>
	<?php
}

/**
 * Theme page in Appearance menu.
 */
function acai_appearance_menu() {
	add_theme_page(
		esc_html__( 'Theme Help', 'acai' ),
		esc_html__( 'Theme Help', 'acai' ),
		'edit_theme_options',
		'acai',
		'acai_theme_page_html'
	);
}
add_action( 'admin_menu', 'acai_appearance_menu' );

/**
 * Theme page.
 */
function acai_theme_page_html() {
	$plugin_installed = file_exists( WP_PLUGIN_DIR. '/starter-sites' );
	$plugin_active = is_plugin_active( 'starter-sites/starter-sites.php' );
	$page_title = __( 'Starter Sites', 'acai' );
	$starter_sites_link = acai_starter_sites_admin_link();
	if ( acai_is_starter_sites_pro() ) {
		$plugin_active = true;
		$page_title = __( 'Starter Sites Pro', 'acai' );
		$starter_sites_link = $starter_sites_link . '-pro';
	}
	?>
	<div class="acai-page-wrapper">
		<div class="acai-page-content">
			<div class="acai-page-header">
				<h1 class="acai-page-theme-name"><?php echo esc_html( acai_theme_name() ); ?></h1>
			</div>
			<div class="acai-page-inner-section is-style-flex">
				<div class="acai-page-description">
					<h2><?php echo esc_html( $page_title ); ?></h2>
				<?php
				if ( !$plugin_installed ) {
					?>
					<p><?php esc_html_e( 'Install the Starter Sites plugin and choose from our handpicked collection of websites, available to import right now.', 'acai' ); ?></p>
					<?php
				} elseif ( $plugin_installed && !$plugin_active ) {
					?>
					<p><?php esc_html_e( 'Activate the Starter Sites plugin and choose from our handpicked collection of websites, available to import right now.', 'acai' ); ?></p>
					<?php
				}
				?>

					<p><?php esc_html_e( 'We have an ever expanding range of sites available, including online stores, business websites, news sites, blogs and more.', 'acai' ); ?></p>
					<p><?php esc_html_e( 'Each starter site is ready to go, with full pages of real content and designed to integrate perfectly with this theme.', 'acai' ); ?></p>
				<?php
				if ( !$plugin_installed ) {
					?>
					<p><button class="button button-primary acai-install-wpss"><?php esc_html_e( 'Install Plugin', 'acai' ) ;?></button></p>
					<?php
				} elseif ( $plugin_installed && !$plugin_active ) {
					?>
					<p><button class="button button-primary acai-activate-wpss"><?php esc_html_e( 'Activate Plugin', 'acai' ) ;?></button></p>
					<?php
				} else {
					?>
					<p><a href="<?php echo esc_url( $starter_sites_link ) ?>" class="button button-primary"><?php esc_html_e( 'Browse Sites', 'acai' ) ;?></a></p>
					<?php
				}
				?>
				</div>
				<div class="acai-page-image">
				<?php
				if ( $plugin_active ) {
					?>
					<a href="<?php echo esc_url( $starter_sites_link ) ?>"><img src="<?php echo esc_url( ACAI_TEMPLATE_DIR_URI . '/assets/images/preview-starter-sites.png?ver=' . ACAI_VERSION ) ;?>"/></a>
					<?php
				} else {
					?>
					<img src="<?php echo esc_url( ACAI_TEMPLATE_DIR_URI . '/assets/images/preview-starter-sites.png?ver=' . ACAI_VERSION ) ;?>"/>
					<?php
				}
				?>
				</div>
			</div>

			<div class="acai-page-inner-section is-style-flex">
				<div class="acai-page-description">
					<h2 id="homepage"><?php esc_html_e( 'Quick Home Page Setup', 'acai' ); ?></h2>
						<p><?php esc_html_e( 'The Front Page template is used to display the home page of your new website.', 'acai' ); ?></p>
						<p><?php esc_html_e( 'You can edit it directly and change the content, layout and design.', 'acai' ); ?></p>
						<p><?php esc_html_e( 'The theme provides a variety of designs you can use to quickly change how your home page is presented.', 'acai' ); ?></p>
						<p><?php esc_html_e( 'A static home page is the default design, however if you prefer a more traditional blog home page, you can change this by editing the Front Page template and selecting Home Blog in the Design section of the right sidebar.', 'acai' ); ?></p>
						<p><?php esc_html_e( 'Alternatively, if you prefer to display the content from the page selected as your homepage in Settings > Reading, you can select the "Homepage (page content)" design.', 'acai' ); ?></p>
						<p><a href="<?php echo esc_url( admin_url( 'site-editor.php?p=/wp_template/acai//front-page&canvas=edit' ) ) ?>" class="button button-primary"><?php esc_html_e( 'Edit Front Page', 'acai' ) ;?></a></p>
				</div>
				<div>
					<h2><?php esc_html_e( 'Style Variations', 'acai' ); ?></h2>
					<p><?php esc_html_e( 'The theme comes loaded with a selection of style variations.', 'acai' ); ?></p>
					<p><?php esc_html_e( 'This allows you to preview  and activate different color schemes and font/typography settings.', 'acai' ); ?></p>
					<p><img src="<?php echo esc_url( ACAI_TEMPLATE_DIR_URI . '/assets/images/style-variations.jpg?ver=' . ACAI_VERSION ) ;?>"/></p>
					<p><a href="<?php echo esc_url( admin_url( 'site-editor.php?p=/styles&section=/variations' ) ) ?>" class="button button-primary"><?php esc_html_e( 'View Variations', 'acai' ) ;?></a></p>
				</div>
			</div>
			<div class="acai-page-inner-section is-style-flex is-section-links">
				<div class="acai-page-inner-left">
					<h2><?php esc_html_e( 'Quick Editor Links', 'acai' ); ?></h2>
					<div class="acai-editor-link">
						<p><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false"><path d="M12 4L4 7.9V20h16V7.9L12 4zm6.5 14.5H14V13h-4v5.5H5.5V8.8L12 5.7l6.5 3.1v9.7z"></path></svg></p>
						<p><a href="<?php echo esc_url( admin_url( 'site-editor.php' ) ) ?>"><?php esc_html_e( 'Site Editor', 'acai' ) ;?></a></p>
					</div>
					<div class="acai-editor-link">
						<p><svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" width="24" height="24" aria-hidden="true" focusable="false"><path d="M12 4c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8zm0 14.5c-3.6 0-6.5-2.9-6.5-6.5S8.4 5.5 12 5.5s6.5 2.9 6.5 6.5-2.9 6.5-6.5 6.5zM9 16l4.5-3L15 8.4l-4.5 3L9 16z"></path></svg></p>
						<p><a href="<?php echo esc_url( admin_url( 'site-editor.php?p=/navigation' ) ) ?>"><?php esc_html_e( 'Navigation Menus', 'acai' ) ;?></a></p>
					</div>
					<div class="acai-editor-link">
						<p><svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" width="24" height="24" aria-hidden="true" focusable="false"><path d="M12 4c-4.4 0-8 3.6-8 8v.1c0 4.1 3.2 7.5 7.2 7.9h.8c4.4 0 8-3.6 8-8s-3.6-8-8-8zm0 15V5c3.9 0 7 3.1 7 7s-3.1 7-7 7z"></path></svg></p>
						<p><a href="<?php echo esc_url( admin_url( 'site-editor.php?p=/styles' ) ) ?>"><?php esc_html_e( 'Styles', 'acai' ) ;?></a><br>
						<a href="<?php echo esc_url( admin_url( 'site-editor.php?p=/styles&section=/variations' ) ) ?>"><?php esc_html_e( 'Variations', 'acai' ) ;?></a><br>
						<a href="<?php echo esc_url( admin_url( 'site-editor.php?p=/styles&section=/typography' ) ) ?>"><?php esc_html_e( 'Typography', 'acai' ) ;?></a><br>
						<a href="<?php echo esc_url( admin_url( 'site-editor.php?p=/styles&section=/colors' ) ) ?>"><?php esc_html_e( 'Colors', 'acai' ) ;?></a><br>
						<a href="<?php echo esc_url( admin_url( 'site-editor.php?p=/styles&section=/layout' ) ) ?>"><?php esc_html_e( 'Layout', 'acai' ) ;?></a><br>
						<a href="<?php echo esc_url( admin_url( 'site-editor.php?p=/styles&section=/blocks' ) ) ?>"><?php esc_html_e( 'Blocks', 'acai' ) ;?></a><br>
						<a href="<?php echo esc_url( admin_url( 'site-editor.php?p=/styles&section=/css' ) ) ?>"><?php esc_html_e( 'Additional CSS', 'acai' ) ;?></a></p>
					</div>
					<div class="acai-editor-link">
						<p><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false"><path d="M18 5.5H6a.5.5 0 00-.5.5v3h13V6a.5.5 0 00-.5-.5zm.5 5H10v8h8a.5.5 0 00.5-.5v-7.5zm-10 0h-3V18a.5.5 0 00.5.5h2.5v-8zM6 4h12a2 2 0 012 2v12a2 2 0 01-2 2H6a2 2 0 01-2-2V6a2 2 0 012-2z"></path></svg></p>
						<p><a href="<?php echo esc_url( admin_url( 'site-editor.php?p=/template' ) ) ?>"><?php esc_html_e( 'Templates', 'acai' ) ;?></a></p>
					</div>
					<div class="acai-editor-link">
						<p><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false"><path d="M21.3 10.8l-5.6-5.6c-.7-.7-1.8-.7-2.5 0l-5.6 5.6c-.7.7-.7 1.8 0 2.5l5.6 5.6c.3.3.8.5 1.2.5s.9-.2 1.2-.5l5.6-5.6c.8-.7.8-1.9.1-2.5zm-17.6 1L10 5.5l-1-1-6.3 6.3c-.7.7-.7 1.8 0 2.5L9 19.5l1.1-1.1-6.3-6.3c-.2 0-.2-.2-.1-.3z"></path></svg></p>
						<p><a href="<?php echo esc_url( admin_url( 'site-editor.php?p=/pattern&postType=wp_template_part&categoryId=all-parts' ) ) ?>"><?php esc_html_e( 'Template Parts', 'acai' ) ;?></a></p>
					</div>
					<div class="acai-editor-link">
						<p><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false"><path d="M21.3 10.8l-5.6-5.6c-.7-.7-1.8-.7-2.5 0l-5.6 5.6c-.7.7-.7 1.8 0 2.5l5.6 5.6c.3.3.8.5 1.2.5s.9-.2 1.2-.5l5.6-5.6c.8-.7.8-1.9.1-2.5zm-1 1.4l-5.6 5.6c-.1.1-.3.1-.4 0l-5.6-5.6c-.1-.1-.1-.3 0-.4l5.6-5.6s.1-.1.2-.1.1 0 .2.1l5.6 5.6c.1.1.1.3 0 .4zm-16.6-.4L10 5.5l-1-1-6.3 6.3c-.7.7-.7 1.8 0 2.5L9 19.5l1.1-1.1-6.3-6.3c-.2 0-.2-.2-.1-.3z"></path></svg></p>
						<p><a href="<?php echo esc_url( admin_url( 'site-editor.php?p=/pattern&postType=wp_block&categoryId=all-patterns' ) ) ?>"><?php esc_html_e( 'Patterns', 'acai' ) ;?></a></p>
					</div>
				</div>
				<div class="acai-page-inner-right">
					<h2><?php esc_html_e( 'Theme Links', 'acai' ); ?></h2>
					<div class="acai-editor-link">
						<p><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false"><path d="M19.5 4.5h-7V6h4.44l-5.97 5.97 1.06 1.06L18 7.06v4.44h1.5v-7Zm-13 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2v-3H17v3a.5.5 0 0 1-.5.5h-10a.5.5 0 0 1-.5-.5v-10a.5.5 0 0 1 .5-.5h3V5.5h-3Z"></path></svg></p>
						<p><a target="_blank" href="<?php echo esc_url( 'https://wordpress.org/support/theme/' . get_option( 'stylesheet' ) . '/' ); ?>"><?php esc_html_e( 'Support', 'acai' ) ;?></a></p>
					</div>
					<div class="acai-editor-link">
						<p><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false"><path d="M19.5 4.5h-7V6h4.44l-5.97 5.97 1.06 1.06L18 7.06v4.44h1.5v-7Zm-13 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2v-3H17v3a.5.5 0 0 1-.5.5h-10a.5.5 0 0 1-.5-.5v-10a.5.5 0 0 1 .5-.5h3V5.5h-3Z"></path></svg></p>
						<p><a target="_blank" href="https://uxlthemes.com/theme/acai/"><?php esc_html_e( 'About', 'acai' ) ;?></a></p>
					</div>
					<div class="acai-editor-link">
						<p><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false"><path d="M19.5 4.5h-7V6h4.44l-5.97 5.97 1.06 1.06L18 7.06v4.44h1.5v-7Zm-13 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2v-3H17v3a.5.5 0 0 1-.5.5h-10a.5.5 0 0 1-.5-.5v-10a.5.5 0 0 1 .5-.5h3V5.5h-3Z"></path></svg></p>
						<p><a target="_blank" href="https://uxlthemes.com/demo/acai/"><?php esc_html_e( 'Demo', 'acai' ) ;?></a></p>
					</div>

					<p><?php esc_html_e( 'Enjoying Acai? We’d be super grateful if you could leave a quick review.', 'acai' ); ?> <span style="font-size:1.2em;">★★★★★</span></p>
					<p><?php esc_html_e( 'Your feedback helps us improve the theme and lets others know what they’re missing.', 'acai' ); ?></p>
					<p><a class="button button-primary" href="https://wordpress.org/support/theme/acai/reviews/#new-post" target="_blank"><?php esc_html_e( 'Leave a Review', 'acai' ); ?></a></p>
					<p><?php esc_html_e( 'Thanks for your support!', 'acai' ); ?></p>

				</div>
			</div>
		</div>
	</div>
	<?php
}

/**
 * Returns active theme name.
 */
function acai_theme_name() {
	return wp_get_theme()->get( 'Name' );
}

/**
 * Returns theme prefix from stylesheet slug
 */
function acai_get_theme_prefix() {
	$stylesheet = get_option( 'stylesheet' );
	$prefix = str_replace( '-', '_', $stylesheet );
	return $prefix;
}

/**
 * Returns link to the Starter Sites plugin page.
 */
function acai_starter_sites_admin_link() {
	$settings = get_option( 'starter_sites_settings' );
	if ( isset($settings['is_minimal']) && 'yes' === $settings['is_minimal'] ) {
		$link = 'options-general.php';
	} elseif ( isset($settings['menu_location']) ) {
		if ( 'appearance' === $settings['menu_location'] ) {
			$link = 'themes.php';
		} elseif ( 'tools' === $settings['menu_location'] ) {
			$link = 'tools.php';
		} else {
			$link = 'admin.php';
		}
	} else {
		$link = 'admin.php';
	}
	return admin_url( $link . '?page=starter-sites' );
}

/**
 * Is Starter Sites Pro active?
 * Returns true or false.
 */
function acai_is_starter_sites_pro() {
	if ( class_exists('Starter_Sites_Pro') ) {
		return true;
	} else {
		return false;
	}
}
