<?php
/**
 *
 * Adds custom non-core Block Styles to the editor.
 *
 * @link https://developer.wordpress.org/block-editor/reference-guides/block-api/block-styles/
 *
 * @package Acai
 */

/**
 * Array of WooCommerce block styles.
 */
if ( ! function_exists( 'acai_block_styles_woocommerce' ) ) {
	function acai_block_styles_woocommerce() {
		return array(
			'links-plain' => array(
				'label' => __( 'Links - plain', 'acai' ),
				'blocks' => 'product-title,breadcrumbs,product-summary'
			),
			'links-underline-on-hover' => array(
				'label' => __( 'Links - underline on hover', 'acai' ),
				'blocks' => 'product-title,breadcrumbs,product-summary'
			),
			'buttoned' => array(
				'label' => __( 'Buttoned', 'acai' ),
				'blocks' => 'breadcrumbs'
			),
			'icon-auto' => array(
				'label' => __( 'Icon', 'acai' ),
				'blocks' => 'product-button'
			),
			'fill-container' => array(
				'label' => __( 'Fill Width of Parent Container', 'acai' ),
				'blocks' => 'product-image-gallery'
			),
			'minimal' => array(
				'label' => __( 'Not Tabbed', 'acai' ),
				'blocks' => 'product-details'
			),
		);
	}
}

/**
 * Register the WooCommerce block styles.
 */
if ( ! function_exists( 'acai_register_block_styles_woocommerce' ) ) {
	function acai_register_block_styles_woocommerce() {
		$block_styles = acai_block_styles_woocommerce();
		foreach ( $block_styles as $block_style => $attrs ) {
			if ( isset($attrs['label']) && $attrs['label'] !== '' ) {
				$label = $attrs['label'];
			} else {
				$label = $block_style;
			}
			if ( isset($attrs['handle']) && $attrs['handle'] !== '' ) {
				$handle = $attrs['handle'];
			} else {
				$handle = 'acai-style';
			}
			if ( isset($attrs['style']) && $attrs['style'] !== '' ) {
				$style = $attrs['style'];
			} else {
				$style = '';
			}
			$blocks = explode( ',', $attrs['blocks'] );
			$block_count = 0;
			foreach ( $blocks as $block ) {
				$block_count++;
				if ( strpos( $block, '/' ) !== false ) {
					$block = $block;
				} else {
					$block = 'woocommerce/' . $block;
				}
				if ( $block_count > 1 ) {
					$style = '';
				}
				register_block_style(
					$block,
					array(
						'name' => $block_style,
						'label'	=> $label,
						'style_handle' => $handle,
						'inline_style' => $style
					)
				);
			}
		}
	}
}

/**
 * Enqueue the WooCommerce styles.
 */
if ( ! function_exists( 'acai_enqueue_styles_woocommerce' ) ) {
	function acai_enqueue_styles_woocommerce() {

		$files = glob( ACAI_TEMPLATE_DIR . '/assets/block-styles/woocommerce/*.min.css' );
		foreach ( $files as $file ) {
			$filename = basename( $file, '.min.css' );
			wp_enqueue_block_style(
				'woocommerce/' . $filename,
				array(
					'handle' => 'acai-wc-blocks-style-' . $filename,
					'src' => get_theme_file_uri( 'assets/block-styles/woocommerce/' . $filename . '.min.css' ),
					'path' => get_theme_file_path( 'assets/block-styles/woocommerce/' . $filename . '.min.css' ),
					'ver' => ACAI_VERSION
				)
			);
		}

	}
}

/**
 * Enqueue a general WooCommerce stylesheet.
 */
if ( ! function_exists( 'acai_woocommerce_stylesheet' ) ) {
	function acai_woocommerce_stylesheet() {
		wp_enqueue_style( 'acai-woocommerce', ACAI_TEMPLATE_DIR_URI . '/assets/css/woocommerce.min.css', array(), ACAI_VERSION );
	}
}

/**
 * Enqueue a general WooCommerce stylesheet in the editor.
 */
if ( ! function_exists( 'acai_woocommerce_stylesheet_editor' ) ) {
	function acai_woocommerce_stylesheet_editor() {
		add_editor_style( ACAI_TEMPLATE_DIR_URI . '/assets/css/woocommerce.min.css' );
	}
}

if ( ! function_exists( 'acai_product_extra_image' ) ) {
	function acai_product_extra_image( $block_content, $block ) {
		$content = $block_content;
		if ( isset( $block['attrs']['acaiExtraProductImg'] ) && $block['attrs']['acaiExtraProductImg'] === true ) {
			global $product;
			$gallery_images = $product->get_gallery_image_ids();
			if ( isset( $gallery_images[0] ) ) {
				$div_style = '';
				$div_class = 'extra-product-image hover-gallery';
				$div_class_inner = 'extra-product-gallery-image';
				if ( isset( $block['attrs']['acaiImgScroll'] ) && $block['attrs']['acaiImgScroll'] === true ) {
					$div_class .= ' acai-hover-scroll';
					$div_class_inner .= ' acai-hover-scroll';
				}
				if ( isset( $block['attrs']['style'] ) ) {
					$style = wp_style_engine_get_styles( $block['attrs']['style'] );
					$div_style = $style['css'];
					if ( isset( $style['classnames'] ) ) {
						$div_class .= ' ' . $style['classnames'];
						$div_class_inner .= ' ' . $style['classnames'];
					}
				}
				if ( isset($block['attrs']['imageSizing']) ) {
					$image_size = 'single' === $block['attrs']['imageSizing'] ? 'woocommerce_single' : 'woocommerce_thumbnail';
				} else {
					$image_size = 'full';
				}
				if ( isset( $block['attrs']['showProductLink'] ) && $block['attrs']['showProductLink'] !== true ) {
					$link_start = '';
					$link_end = '';
				} else {
					$link_start = '<a href="' . $product->get_permalink() . '" style="' . esc_attr( $div_style ) . '">';
					$link_end = '</a>';
				}
				$content = '<div class="' . esc_attr( $div_class ) . '" style="' . esc_attr( $div_style ) . '">';
				$content .= $block_content;
				$content .= '<div class="' . esc_attr( $div_class_inner ) . '" style="' . esc_attr( $div_style ) . '">' . $link_start . wp_get_attachment_image( $gallery_images[0], $image_size, '', ['class' => 'extra-attachment-image'] ) . $link_end . '</div>';
				$content .= '</div>';
			}
		}
		return $content;
	}
}

if ( ! function_exists( 'acai_wc_block_render' ) ) {
	function acai_wc_block_render( $block_content, $block ) {
		if ( $block['blockName'] === 'woocommerce/product-image' ) {
			$block_content = acai_product_extra_image( $block_content, $block );
		}
		return $block_content;
	}
}

if ( class_exists( 'WooCommerce' ) ) {
	add_action( 'init', 'acai_register_block_styles_woocommerce' );
	add_action( 'init', 'acai_enqueue_styles_woocommerce' );
	add_action( 'wp_enqueue_scripts', 'acai_woocommerce_stylesheet' );
	add_action( 'after_setup_theme', 'acai_woocommerce_stylesheet_editor' );
	add_filter( 'render_block', 'acai_wc_block_render', 10, 2 );
}
