<?php
/**
 *
 * Extra block pattern functionality in addition to /patterns directory.
 *
 * @package Acai
 */

/**
 * Register pattern categories.
 */
if ( ! function_exists( 'acai_pattern_categories' ) ) {
	function acai_pattern_categories() {

		register_block_pattern_category(
			'acai_images',
			array(
				'label'       => _x( 'Acai: Images', 'Block pattern category', 'acai' ),
				'description' => __( 'Patterns containing images.', 'acai' ),
			)
		);

		register_block_pattern_category(
			'acai_sections',
			array(
				'label'       => _x( 'Acai: Content Sections', 'Block pattern category', 'acai' ),
				'description' => __( 'Content sections that can be added to any page, post, or template.', 'acai' ),
			)
		);

		register_block_pattern_category(
			'acai_pages',
			array(
				'label'       => _x( 'Acai: Pages', 'Block pattern category', 'acai' ),
				'description' => __( 'Page designs that can be added to any template.', 'acai' ),
			)
		);

		register_block_pattern_category(
			'acai_parts',
			array(
				'label'       => _x( 'Acai: Template Parts', 'Block pattern category', 'acai' ),
				'description' => __( 'Designs for template parts such as Header, Footer, Sidebar, Comments.', 'acai' ),
			)
		);

		register_block_pattern_category(
			'acai_templates',
			array(
				'label'       => _x( 'Acai: Templates', 'Block pattern category', 'acai' ),
				'description' => __( 'Designs for templates such as Front Page, Pages, Single Posts, Archive, Index.', 'acai' ),
			)
		);

		register_block_pattern_category(
			'acai_shop',
			array(
				'label'       => _x( 'Acai: Shop', 'Block pattern category', 'acai' ),
				'description' => __( 'Patterns with products for use with WooCommerce plugin.', 'acai' ),
			)
		);

	}
}
add_action( 'init', 'acai_pattern_categories' );

/**
 * Non-core block patterns.
 */
require ACAI_TEMPLATE_DIR . '/inc/block-patterns-non-core.php';
