<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Academic_Hub
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area">
	<?php academic_hub_comments_before(); ?>
	<?php
	// You can start editing here -- including this comment!
	if ( have_comments() ) :
		?>
		<div class="col-md-12 col-xs-12 comment-box aurthor">
			<div class="row">
				<h3>
						<?php
						$academic_hub_comment_count = get_comments_number();
						if ( '1' === $academic_hub_comment_count ) {
							printf(
								/* translators: 1: title. */
								esc_html__( 'One thought on &ldquo;%1$s&rdquo;', 'academic-hub' ),
								'<span>' . get_the_title() . '</span>'
							);
						} else {
							printf( // WPCS: XSS OK.
								/* translators: 1: comment count number, 2: title. */
								esc_html( _nx( '%1$s thought on &ldquo;%2$s&rdquo;', '%1$s thoughts on &ldquo;%2$s&rdquo;', $academic_hub_comment_count, 'comments title', 'academic-hub' ) ),
								number_format_i18n( $academic_hub_comment_count ),
								'<span>' . get_the_title() . '</span>'
							);
						}
						?>
				</h3><!-- .comments-title -->

				<?php the_comments_navigation(); ?>
				<ul class="comment-list">
					<?php
					wp_list_comments( array(
						'style'      => 'ul',
						'short_ping' => true,
					) );
					?>
				</ul><!-- .comment-list -->
			</div>
		</div>

		<?php

			// If comments are closed and there are comments, let's leave a little note, shall we?
			if ( ! comments_open() ) :
				?>
				<p class="no-comments"><?php echo esc_html__( 'Comments are closed.', 'academic-hub' ); ?></p>
				<?php
			endif;

			endif; // Check for have_comments().

			comment_form();
		?>
	<?php academic_hub_comments_after(); ?>
</div><!-- #comments -->
