<?php
/**
 * The plugin bootstrap file
 *
 * @link              zypento.com
 * @since             1.0.0
 * @package           zypento
 *
 * @wordpress-plugin
 * Plugin Name:       Zypento Blocks
 * Plugin URI:
 * Description:       Gutenberg Blocks.
 * Version:           1.0.6
 * Author:            Zypento
 * Author URI:        http://zypento.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       zypento-blocks
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Autoloader
 */
require_once 'vendor/autoload.php';

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'ZYPENTO_BLOCKS_NAME', 'zypento' );
define( 'ZYPENTO_BLOCKS_VERSION', '1.0.0' );
define( 'ZYPENTO_BLOCKS_NAMESPACE', 'zypento-blocks/v1' );
define( 'ZYPENTO_BLOCKS_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'ZYPENTO_BLOCKS_PLUGIN_URL', plugins_url( '', __FILE__ ) );

$zypento_blocks_objects = array();

register_activation_hook(
	__FILE__,
	function() {
		\Zypento_Blocks\Plugin::activate();
	}
);
register_deactivation_hook(
	__FILE__,
	function() {
		\Zypento_Blocks\Plugin::deactivate();
	}
);

/**
 * Begins execution of the plugin.
 */
new \Zypento_Blocks\Plugin();

