<?php
/**
 * Auxilary class for REST.
 *
 * @link       http://sproutient.com
 * @since      1.0.0
 *
 * @package    zypento
 * @subpackage zypento/partials
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<div class="zypento-blocks-woocommerce-collection">

	<div class="zypento-blocks-woocommerce-collection-title">
		<h2><?php echo esc_html( $term_data['name'] ); ?></h2>
		<?php if ( '' !== $term_data['desc'] ) : ?>
		<p><?php echo esc_html( $term_data['desc'] ); ?></p>
		<?php endif; ?>

	</div>
	<div class="zypento-blocks-woocommerce-collection-one-selector">

		<span data-target="featured" data-type="active" data-type="featured"><?php esc_html_e( 'Featured', 'zypento-blocks' ); ?></span>
		<span data-target="sale" data-type="" data-type="sale"><?php esc_html_e( 'On Sale', 'zypento-blocks' ); ?></span>
		<span data-target="recent" data-type="" data-type="recent"><?php esc_html_e( 'Recent', 'zypento-blocks' ); ?></span>
		<span data-target="sold" data-type="" data-type="sold"><?php esc_html_e( 'Most Sold', 'zypento-blocks' ); ?></span>
		<span data-target="rated" data-type="" data-type="rated"><?php esc_html_e( 'Top Rated', 'zypento-blocks' ); ?></span>

	</div>
	<div class="zypento-blocks-woocommerce-collection-content">

		<div data-type="active" data-target="featured" class="zypento-blocks-woocommerce-collection-one-tab">
		<?php
		foreach ( $zypento_blocks_featured_products as $zypento_blocks_featured_product ) :
			$zypento_blocks_product_details = \Zypento_Blocks\Misc\Utilities::get_product_details( $zypento_blocks_featured_product );
			include ZYPENTO_BLOCKS_PLUGIN_PATH . 'partials/woocommerce/collection-one-item.php';
			endforeach;
		?>
		</div>

		<div data-target="sale" class="zypento-blocks-woocommerce-collection-one-tab">

		<?php
		foreach ( $on_sale_products as $zypento_blocks_featured_product ) :
			$zypento_blocks_product_details = \Zypento_Blocks\Misc\Utilities::get_product_details( $zypento_blocks_featured_product );
			include ZYPENTO_BLOCKS_PLUGIN_PATH . 'partials/woocommerce/collection-one-item.php';
			endforeach;
		?>

		</div>

		<div data-target="recent" class="zypento-blocks-woocommerce-collection-one-tab">

		<?php
		foreach ( $zypento_blocks_recent_products as $zypento_blocks_featured_product ) :
			$zypento_blocks_product_details = \Zypento_Blocks\Misc\Utilities::get_product_details( $zypento_blocks_featured_product );
			include ZYPENTO_BLOCKS_PLUGIN_PATH . 'partials/woocommerce/collection-one-item.php';
			endforeach;
		?>

		</div>

		<div data-target="sold" class="zypento-blocks-woocommerce-collection-one-tab">

		<?php
		foreach ( $zypento_blocks_most_sold_products as $zypento_blocks_featured_product ) :
			$zypento_blocks_product_details = \Zypento_Blocks\Misc\Utilities::get_product_details( $zypento_blocks_featured_product );
			include ZYPENTO_BLOCKS_PLUGIN_PATH . 'partials/woocommerce/collection-one-item.php';
			endforeach;
		?>

		</div>

		<div data-target="rated" class="zypento-blocks-woocommerce-collection-one-tab">

		<?php
		foreach ( $zypento_blocks_top_rated_products as $zypento_blocks_featured_product ) :
			$zypento_blocks_product_details = \Zypento_Blocks\Misc\Utilities::get_product_details( $zypento_blocks_featured_product );
			include ZYPENTO_BLOCKS_PLUGIN_PATH . 'partials/woocommerce/collection-one-item.php';
			endforeach;
		?>

		</div>

	</div>
	<div class="zypento-blocks-woocommerce-collection-link">
		<a href="<?php echo esc_html( $term_data['link'] ); ?>"><?php esc_html_e( 'View All', 'zypento-blocks' ); ?></a>
	</div>

</div>
