<?php
/**
 * Auxilary class for REST.
 *
 * @link       http://sproutient.com
 * @since      1.0.0
 *
 * @package    zypento
 * @subpackage zypento/partials
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$zypento_blocks_button_text = esc_html__( 'Add to cart', 'zypento-blocks' );
if ( 0 !== $zypento_blocks_product_details['cart_qty'] ) {
	$zypento_blocks_button_text = esc_html__( 'Update cart', 'zypento-blocks' );
}
if ( 0 === $zypento_blocks_product_details['cart_qty'] ) {
	$zypento_blocks_product_details['cart_qty'] = 1;
}
?>

			<div data-product="<?php echo esc_attr( $zypento_blocks_product_details['id'] ); ?>" class="zypento-blocks-woocommerce-collection-one-item">
				<?php if ( $zypento_blocks_product_details['on_sale'] ) : ?>
				<span class="zypento-woo-media-sale"><?php esc_html_e( 'On Sale', 'zypento-blocks' ); ?></span>
				<?php endif; ?>
				<span class="zypento-woo-media-actions">
					<?php do_action( 'zypento_blocks_woo_collection_one_actions' ); ?>
				</span>
				<div class="zypento-woo-media">
					<img src="<?php echo esc_html( $zypento_blocks_product_details['featured_image'] ); ?>" />
				</div>
				<div class="zypento-woo-content">
					<h4 class="zypento-woo-name"><?php echo esc_html( $zypento_blocks_product_details['name'] ); ?></h4>
					<div data-rating="<?php echo esc_attr( $zypento_blocks_product_details['rating'] ); ?>" class="zypento-woo-stars">
						<span data-type="1"></span>
						<span data-type="2"></span>
						<span data-type="3"></span>
						<span data-type="4"></span>
						<span data-type="5"></span>
					</div>
					<div class="zypento-woo-price">
					<?php if ( 'simple' === $zypento_blocks_product_details['type'] && $zypento_blocks_product_details['on_sale'] ) : ?>
						<p class="zypento-woo-price-sale">
							<span class="zypento-woo-price"><?php printf( '%1$s%2$s', esc_html( $currency_symbol ), esc_html( $zypento_blocks_product_details['regular_price'] ) ); ?></span>
							<span class="zypento-woo-sale"><?php printf( '%1$s%2$s', esc_html( $currency_symbol ), esc_html( $zypento_blocks_product_details['sale_price'] ) ); ?></span>
						</p>
						<?php elseif ( 'simple' === $zypento_blocks_product_details['type'] ) : ?>
						<p class="zypento-woo-price-sale">
							<span class="zypento-woo-sale"><?php printf( '%1$s%2$s', esc_html( $currency_symbol ), esc_html( $zypento_blocks_product_details['regular_price'] ) ); ?></span>
						</p>
						<?php endif; ?>
					</div>
					<?php if ( 'simple' === $zypento_blocks_product_details['type'] ) : ?>
					<div class="zypento-woo-cart">
						<span class="zypento-woo-cart-quantity">
							<span class="zypento-decrement"></span>
							<span class="zypento-input" contenteditable="true"><?php echo esc_html( $zypento_blocks_product_details['cart_qty'] ); ?></span>
							<span class="zypento-increment"></span>
						</span>
						<span data-type="" class="zypento-woo-cart-add"><?php echo esc_html( $zypento_blocks_button_text ); ?></span>
						<span data-type="hidden" class="zypento-woo-cart-add-processing"></span>
						<span data-type="hidden" class="zypento-woo-cart-add-success"></span>
						<span data-type="hidden" class="zypento-woo-cart-add-error"></span>
					</div>
					<?php else : ?>
					<div class="zypento-woo-cart">
						<a class="zypento-woo-cart-options"><?php esc_html_e( 'View Options', 'zypento-blocks' ); ?></a>
					</div>
					<?php endif; ?>
				<?php if ( '' !== $zypento_blocks_product_details['sku'] ) : ?>
					<div class="zypento-woo-sku">
					<?php printf( '<span>%1$s</span>: %2$s', esc_html__( 'SKU', 'zypento-blocks' ), esc_html( $zypento_blocks_product_details['sku'] ) ); ?>
					</div>
				<?php endif; ?>
				</div>
			</div>
