<?php
/**
 * Auxilary class for REST.
 *
 * @link       http://sproutient.com
 * @since      1.0.0
 *
 * @package    zypento
 * @subpackage zypento/partials
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<div class="zypento-blocks-simple-slide" style="<?php echo esc_attr( $slide_container_css ); ?>">

	<div class="zypento-blocks-simple-slide-content" style="<?php echo esc_attr( $slide_content_css ); ?>">

		<h3 style="<?php echo esc_attr( $slide_heading_css ); ?>"><?php echo esc_html( $slide_heading ); ?></h3>
		<p style="<?php echo esc_attr( $slide_text_css ); ?>"><?php echo esc_html( $slide_text ); ?></p>
		<p class="zypento-button">
			<?php if ( '' !== $slide_button_link ) : ?>
				<a href="<?php echo esc_url( $slide_button_link ); ?>" style="<?php echo esc_attr( $slide_button_css ); ?>">
					<?php echo esc_html( $slide_button_text ); ?>
				</a>
			<?php else : ?>
				<span  style="<?php echo esc_attr( $slide_button_css ); ?>">
					<?php echo esc_html( $slide_button_text ); ?>
				</span>
			<?php endif; ?>
		</p>
	</div>

</div>




