<?php
/**
 * The file that defines the stock notifier class
 *
 * @link       http://sproutient.com
 * @since      1.0.0
 *
 * @package    zypento
 * @subpackage zypento/includes
 */

namespace Zypento_Blocks\Features;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Zypento_Blocks\Misc\Utilities;

/**
 * The blocks class.
 *
 * @since      1.0.0
 * @package    zypento
 * @subpackage zypento/includes
 * @author     Sproutient <dev@sproutient.com>
 */
class Simple_Slider {

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {

		add_action( 'init', array( $this, 'register_blocks' ) );

	}

	/**
	 * Register testimonial blocks.
	 *
	 * @since  1.0.0
	 * @access public
	 */
	public function register_blocks() {

		register_block_type(
			ZYPENTO_BLOCKS_PLUGIN_PATH . 'assets/js/blocks/simple-slider',
			array(
				'render_callback' => array( $this, 'render_simple_slider' ),
			)
		);

	}

	/**
	 * Render the WooCommerce collection block.
	 *
	 * @since 1.0.0
	 * @access public
	 * @param array $atts Block attributes.
	 * @return string
	 */
	public function render_simple_slider( $atts ) {

		ob_start();
		$this->render_simple_slider_content( $atts );
		$content = ob_get_contents();
		ob_end_clean();
		return $content;

	}

	/**
	 * Render the content for the WooCommerce collection block.
	 *
	 * @since 1.0.0
	 * @access public
	 * @param array $atts Block attributes.
	 */
	public function render_simple_slider_content( $atts ) {

		if (
			! is_array( $atts ) ||
			! array_key_exists( 'slides', $atts ) ||
			! is_array( $atts['slides'] ) ||
            empty( $atts['slides'] )
		) {

            $atts           = array();
			$atts['slides'] = array(

				'54ue2' => array(
					'background'   => array(
						'color' => '#81b29a',
						'img'   => ZYPENTO_BLOCKS_PLUGIN_URL . '/assets/images/slides/03.jpg',
					),
					'padding'      => array(
						'container' => '',
						'content'   => '12%',
					),
					'width'        => array(
						'content' => '1460px',
					),
					'heading'      => esc_html__( 'End of Winter Season Sale', 'zypento-blocks' ),
					'headingColor' => '#ffffff',
					'text'         => esc_html__( 'Growing a business is about consistently delivering value, building strong relationships, and adapting quickly to changing needs and opportunities.', 'zypento-blocks' ),
					'textColor'    => '#ffffff',
					'button'       => array(
						'text'  => esc_html__( 'Shop Now', 'zypento-blocks' ),
						'link'  => '#',
						'color' => array(
							'bg'   => '',
							'text' => '',
						),
						'type'  => 'rounded',
					),
				),
				'54ue3' => array(
					'background'   => array(
						'color' => '#f1ab86',
						'img'   => ZYPENTO_BLOCKS_PLUGIN_URL . '/assets/images/slides/04.jpg',
					),
					'padding'      => array(
						'container' => '',
						'content'   => '12%',
					),
					'width'        => array(
						'content' => '1460px',
					),
					'heading'      => esc_html__( 'Start of Summer Season Sale', 'zypento-blocks' ),
					'headingColor' => '#ffffff',
					'text'         => esc_html__( 'Growing a business is about consistently delivering value, building strong relationships, and adapting quickly to changing needs and opportunities.', 'zypento-blocks' ),
					'textColor'    => '#ffffff',
					'button'       => array(
						'text'  => esc_html__( 'Shop Now', 'zypento-blocks' ),
						'link'  => '#',
						'color' => array(
							'bg'   => '',
							'text' => '',
						),
						'type'  => 'rounded',
					),
				),

			);

		}

		?>

		<div class="zypento-blocks-simple-slider">

			<div class="zypento-blocks-simple-slider-belt">

			<?php

			foreach ( $atts['slides'] as $slide ) {
				$slide_container_css = '';
				$slide_content_css   = '';
				$slide_heading       = '';
				$slide_heading_css   = '';
				$slide_text          = '';
				$slide_text_css      = '';
				$slide_button_text   = '';
				$slide_button_link   = '';
				$slide_button_css    = '';
				if (
					array_key_exists( 'background', $slide ) &&
					array_key_exists( 'color', $slide['background'] )
				) {
					$slide_container_css .= 'background:' . $slide['background']['color'] . ';';
				}
				if (
					array_key_exists( 'padding', $slide ) &&
					array_key_exists( 'container', $slide['padding'] )
				) {
					$slide_container_css .= 'padding:' . $slide['padding']['container'] . ' 0;';
				}
				if (
					array_key_exists( 'background', $slide ) &&
					array_key_exists( 'img', $slide['background'] )
				) {
					$slide_content_css .= 'background:url("' . $slide['background']['img'] . '") center right no-repeat;';
				}
				if (
					array_key_exists( 'padding', $slide ) &&
					array_key_exists( 'content', $slide['padding'] )
				) {
					$slide_content_css .= 'padding:' . $slide['padding']['content'] . ' 0;';
				}
				if (
					array_key_exists( 'width', $slide ) &&
					array_key_exists( 'content', $slide['width'] )
				) {
					$slide_content_css .= 'max-width:' . $slide['width']['content'] . ';';
				}
				if (
					array_key_exists( 'heading', $slide )
				) {
					$slide_heading .= $slide['heading'];
				}
				if (
					array_key_exists( 'headingColor', $slide )
				) {
					$slide_heading_css .= 'color:' . $slide['headingColor'] . ';';
				}
				if (
					array_key_exists( 'text', $slide )
				) {
					$slide_text .= $slide['text'];
				}
				if (
					array_key_exists( 'textColor', $slide )
				) {
					$slide_text_css .= 'color:' . $slide['textColor'] . ';';
				}
				if (
					array_key_exists( 'button', $slide ) &&
					array_key_exists( 'text', $slide['button'] )
				) {
					$slide_button_text .= $slide['button']['text'];
				}
				if (
					array_key_exists( 'button', $slide ) &&
					array_key_exists( 'link', $slide['button'] )
				) {
					$slide_button_link .= $slide['button']['link'];
				}
				if (
					array_key_exists( 'button', $slide ) &&
					array_key_exists( 'color', $slide['button'] ) &&
					array_key_exists( 'bg', $slide['button']['color'] )
				) {
					$slide_button_css .= 'background:' . $slide['button']['color']['bg'] . ';';
				}
				if (
					array_key_exists( 'button', $slide ) &&
					array_key_exists( 'color', $slide['button'] ) &&
					array_key_exists( 'text', $slide['button']['color'] )
				) {
					$slide_button_css .= 'color:' . $slide['button']['color']['text'] . ';';
				}
				if (
					array_key_exists( 'button', $slide ) &&
					array_key_exists( 'type', $slide['button'] ) &&
					'rounded' === $slide['button']['type']
				) {
					$slide_button_css .= 'border-radius:2em;';
				}
				include ZYPENTO_BLOCKS_PLUGIN_PATH . 'partials/simple-slide.php';
			}

			?>

			</div>

			<div class="zypento-blocks-simple-slider-navigation">


			</div>

		</div>

		<?php

	}

}
