<?php
/**
 * Frontend features.
 *
 * @link       http://sproutient.com
 * @since      1.0.0
 *
 * @package    zypento
 * @subpackage zypento/includes
 */

namespace Zypento_Blocks\Core;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Zypento_Blocks\Misc\Utilities;

/**
 * Frontend features.
 *
 * @since      1.0.0
 * @package    zypento
 * @subpackage zypento/includes
 * @author     Sproutient <dev@sproutient.com>
 */
class Frontend {

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {

		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_assets' ) );

	}

	/**
	 * Register the JavaScript/CSS for the frontend.
	 *
	 * @since    1.0.0
	 * @param    string $hook current page.
	 */
	public function enqueue_assets( $hook ) {

		$public_variables['userLoggedIn'] = false;
		$public_variables['nonce']        = '';
		$public_variables['wpRestNonce']  = '';
		$public_variables['api']          = array();

		$public_variables['labels'] = array();

		if ( is_user_logged_in() && current_user_can( 'administrator' ) ) {

			$public_variables['userLoggedIn'] = true;

		}

		$public_variables['nonce']       = esc_html( wp_create_nonce( 'zypento-blocks' ) );
		$public_variables['wpRestNonce'] = esc_html( wp_create_nonce( 'wp_rest' ) );

		$public_variables['features'] = array();

		$variables = apply_filters( 'zypento_blocks_js_variables', $public_variables );

		wp_enqueue_style( ZYPENTO_BLOCKS_NAME, ZYPENTO_BLOCKS_PLUGIN_URL . '/assets/css/public.css', array(), ZYPENTO_BLOCKS_VERSION, 'all' );
		wp_register_script( ZYPENTO_BLOCKS_NAME, ZYPENTO_BLOCKS_PLUGIN_URL . '/assets/js/public.js', array( 'jquery' ), ZYPENTO_BLOCKS_VERSION, true );
		wp_localize_script( ZYPENTO_BLOCKS_NAME, 'zypentoBlocksJsVariables', $variables );
		wp_enqueue_script( ZYPENTO_BLOCKS_NAME );

		$this->additional_assets();

	}

	/**
	 * Get user details.
	 */
	public function additional_assets() {

		$assets = apply_filters( 'zypento_blocks_frontend_enqueue', array() );

		if ( ! is_array( $assets ) ) {
			return;
		}

		foreach ( $assets as $asset ) {

			if ( ! is_array( $asset ) ) {
				return;
			}

			$required_keys = array( 'type', 'name', 'url', 'version', 'deps' );

			if ( count( array_intersect( array_keys( $asset ), $required_keys ) ) !== count( $required_keys ) ) {
				return;
			}

			$footer = true;
			if ( ! array_key_exists( 'footer', $asset ) ) {
				$footer = false;
			}

			if ( 'style' === $asset['type'] ) {
				wp_enqueue_style( ZYPENTO_BLOCKS__NAME . $asset['name'], $asset['url'], $asset['deps'], $asset['version'], 'all' );
			}

			if ( 'script' === $asset['type'] ) {
				wp_enqueue_script( ZYPENTO_BLOCKS__NAME . $asset['name'], $asset['url'], $asset['deps'], $asset['version'], $footer );
			}
		}

	}

}
