<?php
/**
 * The file that defines the stock notifier class
 *
 * @link       http://sproutient.com
 * @since      1.0.0
 *
 * @package    zypento
 * @subpackage zypento/includes
 */

namespace Zypento_Blocks\Core;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Zypento_Blocks\Misc\Utilities;

/**
 * The blocks class.
 *
 * @since      1.0.0
 * @package    zypento
 * @subpackage zypento/includes
 * @author     Sproutient <dev@sproutient.com>
 */
class Blocks {

	/**
	 * Data for admin page.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      array    $admin_variables    JS Variables.
	 */
	private $editor_variables;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {

		$this->editor_variables = array();

		add_action( 'enqueue_block_editor_assets', array( $this, 'admin_block_assets' ) );
		add_action( 'init', array( $this, 'register_blocks' ) );

	}

	/**
	 * Register the JavaScript/CSS for the block controls in editor.
	 *
	 * @since    1.0.0
	 */
	public function admin_block_assets() {

		$this->editor_variables['pluginUrl']  = esc_url( ZYPENTO_BLOCKS_PLUGIN_URL );
		$this->editor_variables['categories'] = Utilities::get_woo_terms();
		$this->editor_variables['tags']       = Utilities::get_woo_terms( 'tags' );

		wp_enqueue_style( ZYPENTO_BLOCKS_NAME . '-editor', ZYPENTO_BLOCKS_PLUGIN_URL . '/assets/css/blockeditor.css', array(), ZYPENTO_BLOCKS_VERSION, 'all' );

		wp_register_script( ZYPENTO_BLOCKS_NAME . '-editor', esc_url( ZYPENTO_BLOCKS_PLUGIN_URL ) . '/assets/js/blockeditor.js', array( 'jquery', 'wp-plugins', 'wp-blocks', 'wp-i18n', 'wp-element', 'wp-components', 'wp-edit-post' ), '1.0.0', true );
		wp_localize_script( ZYPENTO_BLOCKS_NAME . '-editor', 'zypentoBlocksEditorVariables', $this->editor_variables );
		wp_enqueue_script( ZYPENTO_BLOCKS_NAME . '-editor' );

	}

	/**
	 * Register testimonial blocks.
	 *
	 * @since  1.0.0
	 * @access public
	 */
	public function register_blocks() {

		register_block_type(
			ZYPENTO_BLOCKS_PLUGIN_PATH . 'assets/js/blocks/table-of-contents',
		);
		register_block_type(
			ZYPENTO_BLOCKS_PLUGIN_PATH . 'assets/js/blocks/simple-countdown',
		);

	}

}
