<?php
/**
 * The file that defines the core plugin class
 *
 * @link       http://sproutient.com
 * @since      1.0.0
 *
 * @package    zypento
 * @subpackage zypento/includes
 */

namespace Zypento_Blocks;

/**
 * The core plugin class.
 *
 * @since      1.0.0
 * @package    zypento
 * @subpackage zypento/includes
 * @author     Sproutient <dev@sproutient.com>
 */
class Plugin {

	/**
	 * Define the core functionality of the plugin.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		$this->loader();
	}

	/**
	 * Run on activation.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {

		if ( version_compare( PHP_VERSION, '7.4', '<' ) ) {
			die( esc_html__( 'This plugin requires PHP version 7.4 or greater.  Sorry about that.', 'zypento-blocks' ) );
		}

	}

	/**
	 * Run on deactivation.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate() {

	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function loader() {

		global $zypento_blocks_objects, $zypento_options, $zypento_features;

		$zypento_features = get_option( 'zypento_enabled_features', array() );

		$dir = ZYPENTO_BLOCKS_PLUGIN_PATH . 'includes';

		$iterator = new \RecursiveIteratorIterator( new \RecursiveDirectoryIterator( $dir ) );

		foreach ( $iterator as $file ) {
			if ( $file->isFile() && $file->getPath() !== $dir ) {
				$filename       = pathinfo( $file->getFilename(), PATHINFO_FILENAME );
				$class_name     = str_replace( 'class-', '', $filename );
				$class_name     = str_replace( '-', ' ', $class_name );
				$class_name_key = $class_name;
				$class_name     = ucwords( $class_name );
				$class_name     = str_replace( ' ', '_', $class_name );

				$class_name_key = str_replace( ' ', '_', $class_name_key );

				$namespace = str_replace( $dir . '/', '', $file->getPath() );
				$namespace = str_replace( '/', ' ', $namespace );
				$namespace = ucwords( $namespace );
				$namespace = str_replace( ' ', '\\', $namespace );
				$namespace = $namespace . '\\';

				$class_name = 'Zypento_Blocks\\' . $namespace . $class_name;

				if ( class_exists( $class_name ) ) {

					$zypento_blocks_objects[ $class_name_key ] = new $class_name();
				}
			}
		}

	}

}
