
const goTo = (idx, belt, dots, loop, total, setCurrent) => {
    if (idx < 0) {
        idx = loop ? total - 1 : 0;
    } else if (idx >= total) {
        idx = loop ? 0 : total - 1;
    }
    setCurrent(idx);
    belt.style.transform = 'translateX(' + (-100 * idx) + '%)';
    dots.forEach((d, i) => d.classList.toggle('active', i === idx));
}

const initZypentoSimpleSlider = (slider, loop = true) => {

    const belt = slider.querySelector('.zypento-blocks-simple-slider-belt');
    const slides = belt.querySelectorAll('.zypento-blocks-simple-slide');
    const nav = slider.querySelector('.zypento-blocks-simple-slider-navigation');
    let current = 0;
    const total = slides.length;
    function setCurrent(val) { current = val; }

    // Set slide width to match slider width
    const sliderWidth = slider.offsetWidth;
    slides.forEach(slide => {
        slide.style.width = sliderWidth + 'px';
    });

    // Option: auto-slide
    const autoSlide = slider.getAttribute('data-autoslide') !== 'false';
    const autoSlideInterval = parseInt(slider.getAttribute('data-autoslide-interval'), 10) || 10000;
    let autoSlideTimer = null;

    // Create a wrapper for dots and arrows
    nav.innerHTML = '';
    const navInner = document.createElement('div');
    navInner.className = 'zypento-blocks-simple-slider-nav-inner';

    // Create navigation dots
    for (let i = 0; i < total; i++) {
        const dot = document.createElement('span');
        dot.className = 'zypento-blocks-simple-slider-dot' + (i === 0 ? ' active' : '');
        dot.addEventListener('click', function() {
            goTo(i, belt, dots, loop, total, setCurrent);
            if (autoSlide) resetAutoSlide();
        });
        navInner.appendChild(dot);
    }
    // Add arrows beside dots
    const prevBtn = document.createElement('button');
    prevBtn.className = 'zypento-blocks-simple-slider-arrow prev';
    prevBtn.innerHTML = '&#8592;';
    prevBtn.addEventListener('click', function() {
        goTo(current - 1, belt, dots, loop, total, setCurrent);
        if (autoSlide) resetAutoSlide();
    });

    const nextBtn = document.createElement('button');
    nextBtn.className = 'zypento-blocks-simple-slider-arrow next';
    nextBtn.innerHTML = '&#8594;';
    nextBtn.addEventListener('click', function() {
        goTo(current + 1, belt, dots, loop, total, setCurrent);
        if (autoSlide) resetAutoSlide();
    });

    navInner.insertBefore(prevBtn, navInner.firstChild);
    navInner.appendChild(nextBtn);
    nav.appendChild(navInner);

    const dots = navInner.querySelectorAll('.zypento-blocks-simple-slider-dot');
    // Optional: swipe support
    let startX = null;
    belt.addEventListener('touchstart', function(e) {
        startX = e.touches[0].clientX;
    });
    belt.addEventListener('touchend', function(e) {
        if (startX === null) return;
        let endX = e.changedTouches[0].clientX;
        if (endX - startX > 50) goTo(current - 1, belt, dots, loop, total, setCurrent);
        else if (startX - endX > 50) goTo(current + 1, belt, dots, loop, total, setCurrent);
        if (autoSlide) resetAutoSlide();
        startX = null;
    });

    // Auto-slide logic
    function startAutoSlide() {
        if (!autoSlide) return;
        autoSlideTimer = setInterval(() => {
            goTo(current + 1, belt, dots, loop, total, setCurrent);
        }, autoSlideInterval);
    }
    function resetAutoSlide() {
        if (!autoSlide) return;
        clearInterval(autoSlideTimer);
        startAutoSlide();
    }
    function pauseAutoSlide() {
        if (!autoSlide) return;
        clearInterval(autoSlideTimer);
    }
    if (autoSlide) startAutoSlide();

    // Pause auto-slide on hover
    slider.addEventListener('mouseenter', pauseAutoSlide);
    slider.addEventListener('mouseleave', resetAutoSlide);
}

export default initZypentoSimpleSlider;
