const ajaxRequest = ( data, onSuccess, onFailure ) => {

    var nonce = '';
    var wpRestNonce = '';

    if ( 'undefined' !== typeof zypentoBlocksJsVariables ) {

        if ( Object.prototype.hasOwnProperty.call(zypentoBlocksJsVariables, 'nonce') ) {
            nonce = zypentoBlocksJsVariables.nonce;
        }

        if ( Object.prototype.hasOwnProperty.call(zypentoBlocksJsVariables, 'wpRestNonce') ) {
            wpRestNonce = zypentoBlocksJsVariables.wpRestNonce;
        }

    }

    data.sendData['nonce'] = nonce;

    jQuery.ajax({

        type: 'POST',
        url: data.url,
        data: data.sendData,
        beforeSend: function (xhr) {
            xhr.setRequestHeader('X-WP-Nonce', wpRestNonce);
        },
        timeout: data.timeout,
        success: function(jsonData) {

            onSuccess(jsonData);

        },
        error: function(xhr, status, error) {

            onFailure(xhr, status, error);

        },

    });

}

export default ajaxRequest;
