import ajaxRequest from "../../../general/ajaxRequest";

(function( $ ) {
	'use strict';

	$(function () {

        $('.zypento-blocks-woocommerce-collection-one-selector>span').on('click', function(e){

            e.stopPropagation();

            let el = $(this);
            let parent = el.closest('.zypento-blocks-woocommerce-collection');
            let target = el.attr('data-target');

            parent.find('.zypento-blocks-woocommerce-collection-one-selector>span').attr({'data-type':''});
            el.attr({'data-type':'active'});

            parent.find('.zypento-blocks-woocommerce-collection-content .zypento-blocks-woocommerce-collection-one-tab').attr({'data-type':''});

            parent.find('.zypento-blocks-woocommerce-collection-content .zypento-blocks-woocommerce-collection-one-tab[data-target="' + target + '"]').attr({'data-type':'active'});

        });

        $('.zypento-woo-cart-quantity>span').on('click', function(e){

            e.stopPropagation();

            let el = $(this);
            let parent = el.closest('.zypento-blocks-woocommerce-collection-one-item');
            let type = '';

            if (el.hasClass('zypento-decrement')) {
                type = 'decrement';
            } else if (el.hasClass('zypento-increment')) {
                type = 'increment';
            }

            // ... further logic for increment/decrement ...

            if ( '' === type ) {
                return;
            }

            let qtyInput = el.closest('.zypento-woo-cart-quantity').find('.zypento-input');
            let qty = parseInt(qtyInput.text(), 10) || 1;

            if (type === 'increment') {
                qty += 1;
            } else if (type === 'decrement') {
                qty = Math.max(1, qty - 1);
            }

            qtyInput.text(qty);

        });

        $('.zypento-woo-cart-add').on('click', function(e){

            e.stopPropagation();

            let el = $(this);
            let parent = el.closest('.zypento-blocks-woocommerce-collection-one-item');
            let product = parent.attr('data-product');
            let qty = parent.find('.zypento-input').text();
            let processingEl = parent.find('.zypento-woo-cart-add-processing');
            let successEl = parent.find('.zypento-woo-cart-add-success');
            let errorEl = parent.find('.zypento-woo-cart-add-error');

            let disabled = el.attr('data-type');

            if ( 'disabled' === disabled ) {
                return;
            }

            el.attr('data-type', 'disabled');

            processingEl.attr('data-type', 'hidden');
            successEl.attr('data-type', 'hidden');
            errorEl.attr('data-type', 'hidden');

            if ( null === product || undefined === product || '' === product ) {
                // Handle missing product (e.g., show error, return, etc.)
                errorEl.attr('data-type', '');
                return;
            }

            if ( null === qty || undefined === qty || '' === qty ) {
                // Handle missing product (e.g., show error, return, etc.)
                errorEl.attr('data-type', '');
                return;
            }

            if (
                'object' !== typeof zypentoBlocksJsVariables ||
                ! Object.prototype.hasOwnProperty.call(zypentoBlocksJsVariables, "api") ||
                ! Object.prototype.hasOwnProperty.call(zypentoBlocksJsVariables.api, "addToCart") ||
                '' === zypentoBlocksJsVariables.api.addToCart
            ) {
                errorEl.attr('data-type', '');
                return;
            }

            processingEl.attr('data-type', '');

            let sendData = {
                'url' : zypentoBlocksJsVariables.api.addToCart,
                'sendData' : {
                    'product' : product,
                    'qty' : qty
                }
            }

            ajaxRequest(
                sendData,
                function(jsonData){
            
                    if (
                        Object.prototype.hasOwnProperty.call(jsonData, "result") &&
                        jsonData.result
                    ) {
            
                        processingEl.attr('data-type', 'hidden');
                        successEl.attr('data-type', '');
                        el.attr('data-type', '');
            
                    } else {
            
                        processingEl.attr('data-type', 'hidden');
                        errorEl.attr('data-type', '');
                        el.attr('data-type', '');
            
                    }
            
                },
                function(){
                    processingEl.attr('data-type', 'hidden');
                    el.attr('data-type', '');
                    errorEl.attr('data-type', '');
                }
            );           

        });

    });

})( jQuery );