const { __ } = wp.i18n;
const { registerBlockCollection, registerBlockType, query } = wp.blocks;
const { RichText, InspectorControls, useBlockProps, InnerBlocks, BlockControls, PlainText, PanelColorSettings } = wp.blockEditor;
const { serverSideRender: ServerSideRender } = wp;
const { PanelBody, Icon, ColorPicker, GradientPicker, TextControl, SelectControl, ToggleControl } = wp.components;

import metadata from './block.json';

const Edit = ( { attributes, setAttributes } ) => {

    const categoryOptions = [
        { label: __('Select a category', 'zypento-blocks'), value: '' },
        ...Object.entries(zypentoBlocksEditorVariables.categories).map(([id, name]) => ({
            label: name,
            value: id
        }))
    ];

    const tagOptions = [
        { label: __('Select a Tag', 'zypento-blocks'), value: '' },
        ...Object.entries(zypentoBlocksEditorVariables.tags).map(([id, name]) => ({
            label: name,
            value: id
        }))
    ];

    const categoryLabel = __('Select a category', 'zypento-blocks');
    const tagLabel = __('Select a Tag', 'zypento-blocks');

    // Use a boolean for ToggleControl: true = category, false = tag
    const isCategory = attributes.type !== 'tag';

    return (

        <>
            <InspectorControls>

                <PanelBody
                    title={__('Woo Category/Tag', 'zypento-blocks')}
                    initialOpen={ false }
                >
                    <ToggleControl
                        label={ isCategory ? __('Category', 'zypento-blocks') : __('Tag', 'zypento-blocks') }
                        checked={ isCategory }
                        onChange={ ( checked ) => setAttributes( { type: checked ? 'category' : 'tag', term: '' } ) }
                        help={ isCategory ? __('Showing categories', 'zypento-blocks') : __('Showing tags', 'zypento-blocks') }
                    />
                    <SelectControl
                        label={ isCategory ? categoryLabel : tagLabel }
                        value={ attributes.term }
                        options={ isCategory ? categoryOptions : tagOptions }
                        onChange={ ( value ) => setAttributes( { term: value } ) }
                    />
                </PanelBody>

            </InspectorControls>
            <div { ...useBlockProps() }>
            <ServerSideRender
                        
                block="zypento-blocks/woo-collection"
                attributes={attributes}

            />
            </div>

        </>

    );
};
const save = () => { return null; };

registerBlockType( metadata.name, {
    edit: Edit,
    save: save,
} );
