var fseHeights = {};
var fseElementKey = '';

function fsePilotScroll() {
    
    //var target = element.attributes.id;
    var fseScrollLength = document.documentElement.scrollTop || document.body.scrollTop;

    if ( fseScrollLength ) {

        Object.keys(fseHeights).forEach(function(key) {

            if ( fseScrollLength > fseHeights[key]['start'] && ( fseScrollLength < fseHeights[key]['end'] || undefined === fseHeights[key]['end'] ) ) {
                document.querySelectorAll('.fse-toc-heading-links').forEach(b=>b.setAttribute('data-active', 'no'));
                var id = `fse-target-${key}`;
                document.getElementById(id).setAttribute("data-active","yes");
            }
          
        });

    }

};

document.addEventListener(
    'DOMContentLoaded',
    function() {

        var elements = [];

        var elementsHtml = '';


        var tocContainer = document.getElementById('zypento-blocks-toc');
        var contentSelector = tocContainer ? tocContainer.getAttribute('data-toc-content') : '';
        var contentEl = '' !== contentSelector && contentSelector.trim() ? contentSelector : '.wp-block-post-content';

        var contentNode = document.querySelector(contentEl);
        var content = contentNode ? contentNode.children : [];

        Array.from(content).forEach(child => {
            if ( 'H3' === child.tagName || 'H2' === child.tagName ) {
                var tempClass = 'zypento-blocks-toc-heading';
                var tempId = Math.random().toString(36).slice(2, 7);
                var text = child.innerText;
                if ( 'H3' === child.tagName ){
                    tempClass = 'zypento-blocks-toc-sub-heading';
                }
                child.setAttribute("id", tempId);
                var tempElement = {};
                tempElement['tag'] = child.tagName;
                tempElement['text'] = child.innerText;
                elements.push(tempElement);

                text = text.toLowerCase().replace(/(^\w{1})|(\s{1}\w{1})/g, match => match.toUpperCase());

                elementsHtml += `<p class="${tempClass}"><a class="fse-toc-heading-links" id="fse-target-${tempId}" data-active="no" href="#${tempId}">${text}</a></p>`;

                if ( '' !== fseElementKey  ) {
                    fseHeights[ fseElementKey ]['end'] = child.offsetTop;
                }
                fseElementKey = tempId;

                fseHeights[ tempId ] = {};
                fseHeights[ tempId ]['start'] = child.offsetTop;

            }

        });

        document.getElementById('zypento-blocks-toc').innerHTML = elementsHtml;

    }, 
    false
);

addEventListener("scroll", (event) => {fsePilotScroll()});


