const { __ } = wp.i18n;
const { registerBlockCollection, registerBlockType, query } = wp.blocks;
const { RichText, InspectorControls, useBlockProps, InnerBlocks, BlockControls, PlainText, PanelColorSettings } = wp.blockEditor;
const { serverSideRender: ServerSideRender } = wp;
const { PanelBody, Icon, ColorPicker, GradientPicker, TextControl, SelectControl, ToggleControl } = wp.components;

import metadata from './block.json';

const Edit = ( { attributes, setAttributes } ) => {

    return (

        <>
            <InspectorControls>

                <PanelBody
                    title={__('Zypento TOC Settings', 'zypento-blocks')}
                    initialOpen={ false }
                >
                    <TextControl
                        label={__('Select Heading', 'zypento-blocks')}
                        value={attributes.customHeading || ''}
                        onChange={ ( value ) => setAttributes( { customHeading: value } ) }
                        help={__('Enter a heading for the TOC block.', 'zypento-blocks')}
                    />
                    <TextControl
                        label={__('Select Element', 'zypento-blocks')}
                        value={attributes.elementIdentifier || ''}
                        onChange={ ( value ) => setAttributes( { elementIdentifier: value } ) }
                        help={__('Enter CSS class or ID of the container that has post content, else block will look for children of .wp-block-post-content which are headings', 'zypento-blocks')}
                    />
                    
                </PanelBody>

            </InspectorControls>
            <div { ...useBlockProps() }>
                <h4>
                { '' !== attributes.customHeading && attributes.customHeading.trim()
                    ? attributes.customHeading
                    : __( 'Table of Contents', 'zypento-blocks' ) }
                </h4>
                <div data-toc-content={attributes.elementIdentifier || ''} id="zypento-blocks-toc" class="zypento-blocks-toc">

                </div>
            </div>

        </>

    );

};

const save = ({ attributes }) => {
    return (
        <div { ...useBlockProps.save() }>
            <h4>
            { '' !== attributes.customHeading && attributes.customHeading.trim()
                ? attributes.customHeading
                : __( 'Table of Contents', 'zypento-blocks' ) }
            </h4>
            <div data-toc-content={attributes.elementIdentifier || ''} id="zypento-blocks-toc" class="zypento-blocks-toc">

            </div>
        </div>
    );
};

registerBlockType( metadata.name, {
    edit: Edit,
    save: save,
} );
